/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.crypto.provider;

import com.gbasedbt.crypto.provider.Padding;
import javax.crypto.ShortBufferException;

final class PKCS5Padding
implements Padding {
    private int blockSize;

    PKCS5Padding(int n) {
        this.blockSize = n;
    }

    @Override
    public void padWithLen(byte[] byArray, int n, int n2) throws ShortBufferException {
        if (byArray == null) {
            return;
        }
        if (n + n2 > byArray.length) {
            throw new ShortBufferException("Buffer too small to hold padding");
        }
        byte by = (byte)(n2 & 0xFF);
        for (int i = 0; i < n2; ++i) {
            byArray[i + n] = by;
        }
    }

    @Override
    public int unpad(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            return 0;
        }
        byte by = byArray[n + n2 - 1];
        int n3 = by & 0xFF;
        if (n3 < 1 || n3 > this.blockSize) {
            return -1;
        }
        int n4 = n + n2 - (by & 0xFF);
        if (n4 < n) {
            return -1;
        }
        for (int i = 0; i < (by & 0xFF); ++i) {
            if (byArray[n4 + i] == by) continue;
            return -1;
        }
        return n4;
    }

    @Override
    public int padLength(int n) {
        int n2 = this.blockSize - n % this.blockSize;
        return n2;
    }
}

