/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.csm.crypto;

import com.gbasedbt.csm.IfxCsm;
import com.gbasedbt.csm.IfxCsmBuffer;
import com.gbasedbt.csm.IfxCsmDescriptor;
import com.gbasedbt.csm.IfxCsmException;
import com.gbasedbt.csm.IfxCsmReadBuffer;
import com.gbasedbt.csm.crypto.IfxCryptoSession;
import com.gbasedbt.csm.crypto.IfxMsgHdr;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class IfxEncCsm
implements IfxCsm {
    private static final int ENC_CSM_FLAG_INITSTRING_PENDING = 1;
    private static final String ENC_CSM_CONTEXT_ID = "CSMENC";
    private static final int ENC_CSM_STATE_UNINITIALIZED = -1;
    private static final int ENC_CSM_STATE_INITIAL = 0;
    private static final int ENC_CSM_STATE_INITSTRING = 1;
    private static final int ENC_CSM_STATE_INITSTRINGDEFER = 2;
    private static final int ENC_CSM_STATE_INITSTRINGPENDING = 3;
    private static final int ENC_CSM_STATE_AUTHPENDING = 4;
    private static final int ENC_CSM_STATE_INITSTRING_SEND = 5;
    private static final int ENC_CSM_STATE_INITPW_SEND = 6;
    private static final int ENC_CSM_STATE_INITDONE = 7;
    private static final int ENC_CSM_STATE_ACTIVE = 8;
    private static final int ENC_CSM_STATE_MORE_INPUT_NEEDED = 9;
    private static final int ENC_CSM_STATE_MORE_OUTPUT_AVAILABLE = 10;
    private static final int ENC_CSM_STATE_SENDTOPEER_DONE = 11;
    private static final int ENC_CSM_STATE_RELEASE_CONTEXT = 12;
    private static final int ENC_CSM_STATE_READY = 13;
    private static final int ENC_CSM_STATE_ABORT = 14;
    private static final int ENC_CSM_STATE_ABORT_FINAL = 15;
    private static final int ENC_CSM_STATE_INIT_SEND = 20;
    private static final int ENC_CSM_MSG_TYPE_INITSTRING = 1;
    private static final int ENC_CSM_MSG_TYPE_AUTHENTICATION = 2;
    private static final int ENC_CSM_MSG_TYPE_DATA = 3;
    private static final int ENC_CSM_MSG_TYPE_RELEASE_CONTEXT = 4;
    private static final int ENC_CSM_MSG_TYPE_ABORT = 5;
    private static final int ENC_CSM_MSG_TYPE_PWD = 6;
    private static final int ENC_CSM_MSG_TYPE_ID = 7;
    private static final int ENC_CSM_PWD_REQD_FLAG = 1;
    private static final int ENC_CSM_PWD_NOT_GIVEN = 16;
    String csmContextId;
    int contextFlags;
    int state = -1;
    int csm_error;
    IfxCsmDescriptor csmDesc;
    IfxCsmBuffer savedBuffer;
    IfxCryptoSession cryptoSession;
    IfxCsmBuffer outHandshake;
    IfxCsmBuffer outPw;
    String csmString;

    public IfxEncCsm(IfxCsmDescriptor ifxCsmDescriptor) throws IfxCsmException {
        this.csmDesc = ifxCsmDescriptor;
        this.savedBuffer = new IfxCsmBuffer();
        this.state = -1;
        this.csmDesc.setLoadState(0);
        this.csmDesc.setLoadState(2);
        this.csmString = this.csmDesc.getInitString();
        this.csmDesc.setLoadState(1);
    }

    public IfxCsmDescriptor getDescriptor() {
        return this.csmDesc;
    }

    @Override
    public int ifxCsmInit(String string, long l, IfxCsm.Status status) throws IfxCsmException {
        int n = 0;
        status.reset();
        this.cryptoSession = new IfxCryptoSession();
        n = this.cryptoSession.csmCryptoInit(string, l);
        if (n != 0) {
            status.setCsmErr(-5006);
            status.setCsmString(IfxCryptoSession.csmCryptoErrDesc(n));
            return 1;
        }
        status.setCsmCode(1L);
        return 0;
    }

    @Override
    public int ifxCsmTerminate(IfxCsm.Status status) {
        int n = 0;
        return n;
    }

    @Override
    public long ifxCsmGetAttributeFlags(IfxCsm.Status status) {
        return 2L;
    }

    @Override
    public int ifxCsmCreateContext(IfxCsm.Credentials credentials, IfxCsmReadBuffer ifxCsmReadBuffer, IfxCsmBuffer ifxCsmBuffer, String string, IfxCsm.Status status) throws IfxCsmException {
        boolean bl = false;
        IfxCsmBuffer ifxCsmBuffer2 = new IfxCsmBuffer();
        IfxCsmBuffer ifxCsmBuffer3 = new IfxCsmBuffer();
        IfxCsmBuffer ifxCsmBuffer4 = new IfxCsmBuffer();
        IfxMsgHdr ifxMsgHdr = new IfxMsgHdr();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ifxCsmBuffer.reset();
        status.reset();
        if (this.state == -1) {
            this.encInitializeCsmContext();
            this.savedBuffer = new IfxCsmBuffer();
            this.contextFlags = n;
            this.outHandshake = new IfxCsmBuffer();
            n2 = this.cryptoSession.csmCryptoInitSession(1, ifxCsmBuffer2);
            if (n2 != 0) {
                this.encDestroyCsmContext();
                status.setCsmErr(-5010);
                status.setCsmString(IfxCryptoSession.csmCryptoErrDesc(n2));
                return this.err1IfxCsmCreateContext(ifxCsmBuffer, status);
            }
            n4 = 1;
            if (this.encPackBuffer(ifxCsmBuffer2, this.outHandshake, n4, status) == 1) {
                this.encDestroyCsmContext();
                status.setCsmErr(-5010);
                ifxCsmBuffer2.reset();
                return this.err1IfxCsmCreateContext(ifxCsmBuffer, status);
            }
            ifxCsmBuffer2.reset();
            if (ifxCsmReadBuffer != null && ifxCsmReadBuffer.available() > 0) {
                this.outHandshake.reset();
                this.outHandshake.write(ifxCsmBuffer.toByteArray());
                this.state = 3;
            } else {
                this.state = 1;
            }
        }
        if (this.state == 7) {
            return this.exitIfxCsmCreateContext(ifxCsmBuffer3, ifxCsmBuffer2, ifxCsmBuffer, status);
        }
        if (this.state == 14) {
            this.state = 15;
        } else if (ifxCsmReadBuffer != null && ifxCsmReadBuffer.available() > 0) {
            if (this.encSaveInBuffer(ifxCsmReadBuffer, status) == 1) {
                this.encDestroyCsmContext();
                status.setCsmErr(-5010);
                status.setCsmString("Failure attempting to combine buffers");
                throw IfxCryptoSession.getCsmErrException(-5010);
            }
            if (this.encProcessSavedBuffer(ifxMsgHdr, ifxCsmBuffer3, status) == 1) {
                status.setCsmErr(-5010);
                status.setCsmString("Unable to process a staged buffer");
                this.encDestroyCsmContext();
                throw IfxCryptoSession.getCsmErrException(-5010);
            }
            if (status.getCsmCode() == 5L) {
                return 0;
            }
            if (ifxMsgHdr.getType() == 5) {
                this.encGetAbortToken(ifxCsmBuffer3, status);
                this.state = 15;
                this.savedBuffer.reset();
                return this.exitIfxCsmCreateContext(ifxCsmBuffer3, ifxCsmBuffer2, ifxCsmBuffer, status);
            }
            if (ifxMsgHdr.getType() != 1) {
                status.setCsmErr(-5012);
                status.setCsmString("Received message type %d but expecting %d" + ifxMsgHdr.getType() + 1);
                this.encDestroyCsmContext();
                return this.err1IfxCsmCreateContext(ifxCsmBuffer, status);
            }
            n2 = this.cryptoSession.csmCryptoAcceptConnection(ifxCsmBuffer3);
            if (n2 != 0) {
                status.setCsmErr(-5010);
                status.setCsmString(IfxCryptoSession.csmCryptoErrDesc(n2));
                if (this.state == 14) {
                    return this.exitIfxCsmCreateContext(ifxCsmBuffer3, ifxCsmBuffer2, ifxCsmBuffer, status);
                }
                this.encDestroyCsmContext();
                throw IfxCryptoSession.getCsmErrException(-5010);
            }
            n3 = this.encBuildCredentialsBuffer(credentials, ifxCsmBuffer4);
            if (n3 != 0) {
                status.setCsmErr(n3);
                throw IfxCryptoSession.getCsmErrException(-5010);
            }
            n2 = this.cryptoSession.csmCryptoEncrypt(new IfxCsmReadBuffer(ifxCsmBuffer4), ifxCsmBuffer2);
            if (n2 != 0) {
                status.setCsmErr(-5010);
                status.setCsmString(IfxCryptoSession.csmCryptoErrDesc(n2));
                this.encDestroyCsmContext();
                ifxCsmBuffer2.reset();
                return this.err1IfxCsmCreateContext(ifxCsmBuffer, status);
            }
            this.outPw = new IfxCsmBuffer();
            n4 = 2;
            if (this.encPackBuffer(ifxCsmBuffer2, this.outPw, n4, status) == 1) {
                status.setCsmErr(-5010);
                status.setCsmString("Can not pack output buffer");
                this.encDestroyCsmContext();
                ifxCsmBuffer2.reset();
                return this.err1IfxCsmCreateContext(ifxCsmBuffer, status);
            }
            ifxCsmBuffer2.reset();
            if (this.state == 1) {
                this.state = 6;
            } else if (this.state == 3) {
                this.state = 5;
            }
        }
        return this.exitIfxCsmCreateContext(ifxCsmBuffer3, ifxCsmBuffer2, ifxCsmBuffer, status);
    }

    @Override
    public int ifxCsmProcessOutMessage(IfxCsmReadBuffer ifxCsmReadBuffer, IfxCsmBuffer ifxCsmBuffer, IfxCsm.Status status) throws IfxCsmException {
        status.reset();
        if (ifxCsmReadBuffer == null || ifxCsmReadBuffer.available() == 0) {
            status.setCsmCode(1L);
            return 0;
        }
        int n = 0;
        IfxCsmBuffer ifxCsmBuffer2 = new IfxCsmBuffer();
        n = this.cryptoSession.csmCryptoEncrypt(ifxCsmReadBuffer, ifxCsmBuffer2);
        if (n != 0) {
            status.setCsmErr(-5010);
            status.setCsmString(IfxCryptoSession.csmCryptoErrDesc(n));
            ifxCsmBuffer2 = null;
            this.encDestroyCsmContext();
            return 1;
        }
        int n2 = 3;
        if (this.encPackBuffer(ifxCsmBuffer2, ifxCsmBuffer, n2, status) == 1) {
            ifxCsmBuffer2 = null;
            return 1;
        }
        ifxCsmBuffer2 = null;
        status.setCsmCode(1L);
        return 0;
    }

    @Override
    public int ifxCsmProcessInMessage(IfxCsmReadBuffer ifxCsmReadBuffer, IfxCsmBuffer ifxCsmBuffer, IfxCsm.Status status) throws IfxCsmException {
        int n = 1;
        status.reset();
        if (this.state != 10 && (ifxCsmReadBuffer == null || ifxCsmReadBuffer.available() == 0)) {
            status.setCsmCode(5L);
            return 0;
        }
        if (this.state != 10 && this.encSaveInBuffer(ifxCsmReadBuffer, status) == 1) {
            return 1;
        }
        this.state = 13;
        IfxMsgHdr ifxMsgHdr = new IfxMsgHdr();
        if (ifxCsmBuffer.getCount() > 0) {
            IfxCsmBuffer ifxCsmBuffer2 = new IfxCsmBuffer();
            n = this.encProcessSavedBuffer(ifxMsgHdr, ifxCsmBuffer2, status);
            try {
                ifxCsmBuffer2.writeTo(ifxCsmBuffer);
            }
            catch (IOException iOException) {
                status.setCsmErr(-5010);
                return 1;
            }
        } else {
            n = this.encProcessSavedBuffer(ifxMsgHdr, ifxCsmBuffer, status);
        }
        if (ifxMsgHdr.MsgType == 5) {
            this.encGetAbortToken(ifxCsmBuffer, status);
            return 1;
        }
        return n;
    }

    private int encSaveInBuffer(IfxCsmReadBuffer ifxCsmReadBuffer, IfxCsm.Status status) throws IfxCsmException {
        if (ifxCsmReadBuffer == null || ifxCsmReadBuffer.available() == 0) {
            return 0;
        }
        IfxCsmBuffer ifxCsmBuffer = new IfxCsmBuffer();
        ifxCsmBuffer.initialize(ifxCsmReadBuffer);
        try {
            ifxCsmBuffer.writeTo(this.savedBuffer);
        }
        catch (IOException iOException) {
            status.setCsmErr(-5010);
            return 1;
        }
        return 0;
    }

    private int encProcessSavedBuffer(IfxMsgHdr ifxMsgHdr, IfxCsmBuffer ifxCsmBuffer, IfxCsm.Status status) throws IfxCsmException {
        int n = 1;
        if (this.savedBuffer.getCount() < 4) {
            status.setCsmCode(5L);
            return 0;
        }
        this.getMsgHdr(this.savedBuffer, ifxMsgHdr);
        if (this.savedBuffer.getCount() < ifxMsgHdr.MsgSize + 4) {
            status.setCsmCode(5L);
            return 0;
        }
        switch (ifxMsgHdr.MsgType) {
            case 4: {
                status.setCsmErr(-5008);
                this.state = 12;
                return 1;
            }
            case 5: {
                n = this.encProcessSavedBufferAbort(ifxCsmBuffer, status);
                if (n != 0) {
                    ifxCsmBuffer.reset();
                }
                return n;
            }
            case 2: 
            case 3: {
                return this.encProcessSavedBufferData(ifxCsmBuffer, status, true);
            }
            case 1: {
                return this.encProcessSavedBufferData(ifxCsmBuffer, status, false);
            }
        }
        status.setCsmErr(-5000);
        return 1;
    }

    private int encGetAbortToken(ByteArrayOutputStream byteArrayOutputStream, IfxCsm.Status status) {
        int n = 0;
        return n;
    }

    @Override
    public int ifxCsmAbortContext(Object object, IfxCsm.AbortInfo abortInfo, IfxCsm.Status status) {
        int n = 0;
        return n;
    }

    private void getMsgHdr(IfxCsmBuffer ifxCsmBuffer, IfxMsgHdr ifxMsgHdr) {
        byte[] byArray = new byte[4];
        ifxCsmBuffer.read(byArray, 0, 4);
        ifxMsgHdr.setMsgHdr(byArray);
    }

    private int encProcessSavedBufferAbort(ByteArrayOutputStream byteArrayOutputStream, IfxCsm.Status status) {
        return this.encGetTokenFromSavedBuffer(byteArrayOutputStream, status);
    }

    private int encGetTokenFromSavedBuffer(ByteArrayOutputStream byteArrayOutputStream, IfxCsm.Status status) {
        IfxMsgHdr ifxMsgHdr = new IfxMsgHdr();
        this.getMsgHdr(this.savedBuffer, ifxMsgHdr);
        byte[] byArray = new byte[ifxMsgHdr.MsgSize + 4];
        this.savedBuffer.readWithReset(byArray, 0, ifxMsgHdr.MsgSize + 4);
        byteArrayOutputStream.reset();
        byteArrayOutputStream.write(byArray, 4, ifxMsgHdr.MsgSize);
        if (this.savedBuffer.getCount() == 0) {
            this.savedBuffer.reset();
            status.setCsmCode(1L);
            return 0;
        }
        this.state = 10;
        status.setCsmCode(2L);
        return 0;
    }

    private int encProcessSavedBufferData(IfxCsmBuffer ifxCsmBuffer, IfxCsm.Status status, boolean bl) throws IfxCsmException {
        IfxCsmBuffer ifxCsmBuffer2 = new IfxCsmBuffer();
        if (this.encGetTokenFromSavedBuffer(ifxCsmBuffer2, status) == 1) {
            return 1;
        }
        if (bl) {
            int n = 0;
            n = this.cryptoSession.csmCryptoDecrypt(ifxCsmBuffer2, ifxCsmBuffer);
            if (n != 0) {
                ifxCsmBuffer.reset();
                status.setCsmErr(-5010);
                status.setCsmString(IfxCryptoSession.csmCryptoErrDesc(n));
                return 1;
            }
        } else {
            try {
                ifxCsmBuffer2.writeTo(ifxCsmBuffer);
            }
            catch (IOException iOException) {
                ifxCsmBuffer.reset();
                status.setCsmErr(-5010);
                return 1;
            }
        }
        return 0;
    }

    private void encDestroyCsmContext() {
    }

    private int encPackBuffer(IfxCsmBuffer ifxCsmBuffer, IfxCsmBuffer ifxCsmBuffer2, int n, IfxCsm.Status status) {
        int n2 = 0;
        if (ifxCsmBuffer != null) {
            n2 = ifxCsmBuffer.getCount();
        }
        IfxMsgHdr ifxMsgHdr = new IfxMsgHdr(n, n2);
        int n3 = ifxCsmBuffer2.size() + 4 + n2;
        IfxCsmBuffer ifxCsmBuffer3 = new IfxCsmBuffer(n3);
        try {
            if (ifxCsmBuffer2.size() > 0) {
                ifxCsmBuffer2.writeTo(ifxCsmBuffer3);
            }
            ifxCsmBuffer3.write(ifxMsgHdr.getCMsgHdr());
            if (n2 > 0) {
                ifxCsmBuffer.writeTo(ifxCsmBuffer3);
            }
        }
        catch (IOException iOException) {
            status.setCsmErr(-5010);
            return 1;
        }
        ifxCsmBuffer2.initialize(ifxCsmBuffer3);
        return 0;
    }

    private void encInitializeCsmContext() {
        this.state = 0;
        this.csmContextId = ENC_CSM_CONTEXT_ID;
        if (this.savedBuffer != null) {
            this.savedBuffer.reset();
        }
        this.outHandshake = null;
    }

    private int exitIfxCsmCreateContext(IfxCsmBuffer ifxCsmBuffer, IfxCsmBuffer ifxCsmBuffer2, IfxCsmBuffer ifxCsmBuffer3, IfxCsm.Status status) throws IfxCsmException {
        if (ifxCsmBuffer != null) {
            ifxCsmBuffer.reset();
        }
        switch (this.state) {
            case 7: {
                status.setCsmCode(1L);
                this.state = 13;
                return 0;
            }
            case 1: {
                ifxCsmBuffer3.reset();
                ifxCsmBuffer3.write(this.outHandshake.toByteArrayWithReset());
                status.setCsmCode(3L);
                return 0;
            }
            case 5: {
                ifxCsmBuffer3.reset();
                ifxCsmBuffer3.write(this.outHandshake.toByteArrayWithReset());
                status.setCsmCode(4L);
                this.state = 6;
                return 0;
            }
            case 6: {
                ifxCsmBuffer3.reset();
                ifxCsmBuffer3.write(this.outPw.toByteArrayWithReset());
                status.setCsmCode(4L);
                this.state = 7;
                return 0;
            }
            case 14: {
                if (ifxCsmBuffer3.size() > 0) {
                    ifxCsmBuffer3.reset();
                }
                ifxCsmBuffer2 = new IfxCsmBuffer();
                this.encMakeAbortToken(ifxCsmBuffer2, status);
                int n = 5;
                if (this.encPackBuffer(ifxCsmBuffer2, ifxCsmBuffer3, n, status) == 1) {
                    status.setCsmErr(-5010);
                    status.setCsmString("Can not pack output buffer");
                    this.encDestroyCsmContext();
                    return this.err1IfxCsmCreateContext(ifxCsmBuffer3, status);
                }
                status.setCsmCode(4L);
                status.setCsmErr(0);
                return 0;
            }
            case 15: {
                status.setCsmErr(-5000);
                status.setCsmString("CSM abort");
                this.encDestroyCsmContext();
                status.setCsmCode(1L);
                return 1;
            }
            case 13: {
                status.setCsmCode(1L);
                return 1;
            }
            case 0: {
                return 1;
            }
        }
        return 1;
    }

    private int err1IfxCsmCreateContext(ByteArrayOutputStream byteArrayOutputStream, IfxCsm.Status status) throws IfxCsmException {
        byteArrayOutputStream.reset();
        status.setCsmCode(1L);
        throw IfxCryptoSession.getCsmErrException(-5010);
    }

    private int encBuildCredentialsBuffer(IfxCsm.Credentials credentials, IfxCsmBuffer ifxCsmBuffer) {
        int n = 0;
        byte[] byArray = new byte[]{};
        IfxMsgHdr ifxMsgHdr = new IfxMsgHdr();
        if (credentials.getPwd() == null) {
            return n;
        }
        try {
            byte[] byArray2 = credentials.getPwd().getBytes("ASCII");
            byArray = new byte[byArray2.length + 1];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        ifxMsgHdr.setMsgType(6);
        ifxMsgHdr.setMsgSize(byArray.length);
        ifxCsmBuffer.reset();
        ifxCsmBuffer.write(ifxMsgHdr.getCMsgHdr());
        ifxCsmBuffer.write(byArray);
        return n;
    }

    private void encMakeAbortToken(IfxCsmBuffer ifxCsmBuffer, IfxCsm.Status status) {
    }

    @Override
    public int ifxCsmReleaseContext(IfxCsmReadBuffer ifxCsmReadBuffer, IfxCsmBuffer ifxCsmBuffer, IfxCsm.Status status) throws IfxCsmException {
        int n = 1;
        return n;
    }

    @Override
    public int ifxCsmAcceptContext(Object object, IfxCsm.Credentials credentials, IfxCsmReadBuffer ifxCsmReadBuffer, IfxCsmBuffer ifxCsmBuffer, String string, IfxCsm.Status status) throws IfxCsmException {
        int n = 1;
        return n;
    }
}

