/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.csm.crypto;

import com.gbasedbt.csm.crypto.IfxCryptoUtils;

class IfxGssMsgHdr {
    int MsgType;
    int MsgSize;
    public static final int GSS_CSM_HDR_TYPESIZE = 4;
    public static final int GSS_CSM_HDR_SIZESIZE = 4;
    public static final int GSS_CSM_HDRSIZE = 8;

    public IfxGssMsgHdr() {
    }

    public IfxGssMsgHdr(int n, int n2) {
        this.MsgType = n;
        this.MsgSize = n2;
    }

    int getType() {
        return this.MsgType;
    }

    int getMsgSize() {
        return this.MsgSize;
    }

    void setMsgHdr(byte[] byArray) {
        this.MsgType = IfxCryptoUtils.Ifx2ToJavaInt(byArray, 0);
        this.MsgSize = IfxCryptoUtils.Ifx2ToJavaInt(byArray, 4);
    }

    void setMsgHdr(int n, int n2) {
        this.setMsgType(n);
        this.setMsgSize(n2);
    }

    void setMsgType(int n) {
        this.MsgType = n;
    }

    void setMsgSize(int n) {
        this.MsgSize = n;
    }

    byte[] getCMsgHdr() {
        byte[] byArray = new byte[8];
        System.arraycopy(this.getCMsgType(), 0, byArray, 0, 4);
        System.arraycopy(this.getCMsgSize(), 0, byArray, 4, 4);
        return byArray;
    }

    byte[] getCMsgType() {
        return IfxCryptoUtils.JavaToIfx2Int(this.MsgType, 4);
    }

    byte[] getCMsgSize() {
        return IfxCryptoUtils.JavaToIfx2Int(this.MsgSize, 4);
    }
}

