/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.asf.JnsObject;
import com.gbasedbt.jdbc.Version;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import com.gbasedbt.util.dateUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class Driver
implements java.sql.Driver {
    private static Trace trace = null;
    private final String GBASEDBTSQLI = "gbasedbt-sqli";
    private final String GBASEDBTDIRECT = "gbasedbt-direct";
    private final String CONNECTIONCLASS = "CONNECTIONCLASS";
    private final String PROTOCOLCLASS = "PROTOCOLCLASS";
    private final String PROXY = "PROXY";
    private final String DEFAULTDIRECTCONN = "com.gbasedbt.jdbc.IfxDirectConnection";
    private final String DEFAULTDIRECTPROT = "com.gbasedbt.jdbc.IfxDirectProtocol";
    private final String DEFAULTSQLICONN = "com.gbasedbt.jdbc.IfxSqliConnect";
    private final String DEFAULTSQLIPROT = "com.gbasedbt.jdbc.IfxSqli";
    private String m_dbname = null;
    private String SubProtocol = null;
    private String Proxy = null;
    private String ClientLocale = null;
    private static String staticClientLocale = null;
    private static final String VER_RETAIN_JDBCRelVer = "4.10.J";
    protected static String jdkVersion;
    private static int VER_RETAIN_JDBC_SPEC_MAJOR_VERSION;
    private static int VER_RETAIN_JDBC_SPEC_MINOR_VERSION;
    private static int GBASE_JDBC_SPEC_MAJOR_VERSION;
    private static int GBASE_JDBC_SPEC_MINOR_VERSION;
    private static boolean ver_retain;

    private static void setJDKVersion() {
        try {
            jdkVersion = System.getProperty("java.version");
        }
        catch (Exception exception) {
            System.out.println(IfxErrMsg.getMessage(-79880, (String)null));
        }
    }

    protected static int compareJDKVersion(String string) {
        boolean bl = false;
        String string2 = null;
        if (jdkVersion != null && string != null) {
            int n = jdkVersion.length();
            int n2 = 0;
            while (!bl && n2 < n) {
                char c = jdkVersion.charAt(n2);
                if (c >= '0' && c <= '9') {
                    bl = true;
                    continue;
                }
                ++n2;
            }
            string2 = jdkVersion.substring(n2);
            return string2.compareTo(string);
        }
        throw new Error("Error In Comparing JDK Versions");
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        Object object;
        String string2;
        if (TraceFlag.compiletrace) {
            this.checkTracing(string, properties);
        }
        this.checkClientLocale(string, properties);
        String string3 = this.checkURL(string);
        Properties properties2 = new Properties();
        Connection connection = null;
        if (properties == null) {
            properties2.clear();
        } else {
            string2 = null;
            object = properties.propertyNames();
            while (object.hasMoreElements()) {
                string2 = object.nextElement().toString();
                properties2.put(string2.toUpperCase(), properties.getProperty(string2));
            }
            string2 = null;
        }
        properties2.put("USERURL", string);
        if (string3 == null && this.SubProtocol.equals("gbasedbt-direct")) {
            string3 = string;
        }
        this.getPropertiesFromUrl(string, properties2);
        string2 = properties2.getProperty("CONNECTIONCLASS");
        try {
            object = Class.forName(properties2.getProperty("CONNECTIONCLASS"));
            if (string2.equals("com.gbasedbt.jdbc.IfxSqliConnect")) {
                Class[] classArray = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String"), string.getClass(), properties2.getClass()};
                Object[] objectArray = new Object[]{properties2.getProperty("USER"), properties2.getProperty("PASSWORD"), string3, properties2};
                Constructor constructor = ((Class)object).getConstructor(classArray);
                connection = (Connection)constructor.newInstance(objectArray);
            } else {
                Class[] classArray = new Class[]{string.getClass(), properties2.getClass()};
                Object[] objectArray = new Object[]{string3, properties2};
                Constructor constructor = ((Class)object).getConstructor(classArray);
                connection = (Connection)constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception) {
            if (exception instanceof InvocationTargetException) {
                Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                throw (SQLException)throwable;
            }
            SQLException sQLException = IfxErrMsg.getLocSQLException(-79704, exception.toString(), this.ClientLocale);
            throw IfxErrMsg.setSQLExceptionCause(sQLException, exception);
        }
        return connection;
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        if (string == null || string.length() < 13 || !string.substring(0, 13).equalsIgnoreCase("jdbc:gbasedbt")) {
            return false;
        }
        return this.validateURL(string);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        Object object;
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[3];
        if (properties == null) {
            properties = new Properties();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/:=; \t\n\r\f", true);
        int n = 1;
        String string2 = "";
        Object object2 = "";
        String string3 = "";
        String string4 = "";
        if (stringTokenizer != null) {
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (n == 3) {
                    string2 = object;
                }
                if (n > 3 && string2.equalsIgnoreCase("gbasedbt-sqli")) {
                    if (n == 11) {
                        object2 = object;
                    } else if (n > 11) {
                        if (((String)object).equalsIgnoreCase("user")) {
                            object = stringTokenizer.nextToken();
                            string3 = stringTokenizer.nextToken();
                        }
                        if (((String)object).equalsIgnoreCase("password")) {
                            object = stringTokenizer.nextToken();
                            string4 = stringTokenizer.nextToken();
                        }
                    }
                }
                ++n;
                if (string2.length() <= 0 || ((String)object2).length() <= 0 || string3.length() <= 0 || string4.length() <= 0) continue;
                break;
            }
        }
        for (n = 0; n < 3; ++n) {
            object = null;
            if (n == 0) {
                object = new DriverPropertyInfo("DATABASE", (String)object2);
                ((DriverPropertyInfo)object).description = "Database for connection";
                ((DriverPropertyInfo)object).required = true;
            }
            if (n == 1) {
                if (string3.length() == 0 && (properties.contains("user") || properties.contains("USER")) && ((string3 = properties.getProperty("user")) == null || string3.length() == 0)) {
                    string3 = properties.getProperty("USER");
                }
                object = new DriverPropertyInfo("USER", string3);
                ((DriverPropertyInfo)object).description = "User name for connection ";
                ((DriverPropertyInfo)object).required = true;
            }
            if (n == 2) {
                if (string4.length() == 0 && (properties.contains("password") || properties.contains("PASSWORD")) && ((string3 = properties.getProperty("password")) == null || string3.length() == 0)) {
                    string3 = properties.getProperty("PASSWORD");
                }
                object = new DriverPropertyInfo("PASSWORD", string4);
                ((DriverPropertyInfo)object).description = "Password for connection ";
                ((DriverPropertyInfo)object).required = true;
            }
            driverPropertyInfoArray[n] = object;
        }
        return driverPropertyInfoArray;
    }

    @Override
    public int getMajorVersion() {
        try {
            return Driver.getJDBCMajorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    @Override
    public int getMinorVersion() {
        try {
            return Driver.getJDBCMinorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public static int getMajorMinorVersion() {
        try {
            int n = Driver.getJDBCMajorVersion() * 100;
            int n2 = Driver.getJDBCMinorVersion();
            return n + n2;
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    private synchronized String checkURL(String string) throws SQLException {
        boolean bl = true;
        this.m_dbname = null;
        this.SubProtocol = null;
        boolean bl2 = false;
        int n = -1;
        String string2 = null;
        if (TraceFlag.compiletrace) {
            if (trace == null) {
                trace = new Trace();
            }
            trace.writeTrace(1, "In Driver:checkURL(" + string + ")");
        }
        if (string.indexOf(58) == -1) {
            throw IfxErrMsg.getLocSQLException(-80004, ": '" + IfxErrMsg.getMinorMsg(-80035, this.ClientLocale) + " '" + string + "'" + IfxErrMsg.getMinorMsg(-80004, this.ClientLocale) + " ':''", this.ClientLocale);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";=", true);
        String string3 = stringTokenizer.nextToken();
        boolean bl3 = false;
        boolean bl4 = true;
        if (string3.charAt(string3.length() - 1) == ':') {
            bl3 = true;
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ":", true);
        String string4 = stringTokenizer2.nextToken();
        if (stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("=")) {
            bl4 = false;
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "  jdbc is " + string4);
        }
        if (!string4.equalsIgnoreCase("jdbc")) {
            String string5 = IfxErrMsg.getMinorMsg(-80035, this.ClientLocale) + " '" + string + "' " + IfxErrMsg.getMessage(-79756, this.ClientLocale);
            if (TraceFlag.compiletrace) {
                trace.writeTrace(2, "Driver:checkURL(): " + string5);
            }
            throw IfxErrMsg.getLocSQLException(-79756, string5, this.ClientLocale);
        }
        stringTokenizer2.nextToken();
        String string6 = stringTokenizer2.nextToken();
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "  addr: " + string6);
        }
        if (stringTokenizer2.hasMoreTokens()) {
            stringTokenizer2.nextToken();
        }
        if (string6 != null && string6.charAt(0) == '/' && string6.charAt(1) == '/') {
            string6 = string6.substring(2, string6.length());
        }
        if (string6.equals("gbasedbt-sqli")) {
            this.SubProtocol = new String("gbasedbt-sqli");
            if (stringTokenizer2.hasMoreTokens()) {
                string6 = stringTokenizer2.nextToken();
            }
            if (stringTokenizer2.hasMoreTokens()) {
                stringTokenizer2.nextToken();
            }
        } else if (string6.equals("gbasedbt-direct")) {
            this.SubProtocol = new String("gbasedbt-direct");
            bl = false;
            if (TraceFlag.compiletrace) {
                trace.writeTrace(1, "  check tok for more tokens" + stringTokenizer2);
            }
            if (stringTokenizer2.hasMoreTokens()) {
                string6 = stringTokenizer2.nextToken();
                if (TraceFlag.compiletrace) {
                    trace.writeTrace(1, "  has more " + string6);
                }
                if (!string6.equals(":") && stringTokenizer2.hasMoreTokens()) {
                    stringTokenizer2.nextToken();
                }
            } else {
                string6 = null;
            }
        } else {
            String string7 = IfxErrMsg.getMessage(-79757, this.ClientLocale) + ": '" + string6 + "'";
            if (TraceFlag.compiletrace) {
                trace.writeTrace(2, "Driver:checkURL(): " + string7);
            }
            throw IfxErrMsg.getLocSQLException(-79757, string7, this.ClientLocale);
        }
        if (string6 != null && string6.charAt(0) == '/' && string6.charAt(1) == '/') {
            string6 = string6.substring(2, string6.length());
            if (bl) {
                bl2 = true;
            }
        }
        if (!bl) {
            if (string6 != null && string6.length() > 0 && string6.charAt(0) == '/') {
                String string8 = string6;
                if (TraceFlag.compiletrace) {
                    trace.writeTrace(1, "  !checkSub " + string6);
                }
                StringTokenizer stringTokenizer3 = new StringTokenizer(string8, "/");
                String string9 = stringTokenizer3.nextToken();
                if (TraceFlag.compiletrace) {
                    trace.writeTrace(1, "  valid dbname? " + string9);
                }
                if (!this.validDatabaseIdentifier(string9)) {
                    String string10 = IfxErrMsg.getMessage(-79760, this.ClientLocale) + ": '" + string9 + "'";
                    if (TraceFlag.compiletrace) {
                        trace.writeTrace(2, "Driver:checkURL(): " + string10);
                    }
                    throw IfxErrMsg.getLocSQLException(-79760, string10, this.ClientLocale);
                }
                this.m_dbname = new String(string9);
                string2 = null;
            }
        } else {
            int n2;
            int n3 = stringTokenizer2.countTokens();
            int n4 = n2 = bl3 ? 3 : 4;
            if (bl2 && n3 <= n2) {
                bl2 = false;
            }
            if (bl2) {
                string6 = string6 + ":";
                while (n3 > n2) {
                    string6 = string6 + stringTokenizer2.nextToken();
                    --n3;
                }
                stringTokenizer2.nextToken();
            }
            StringTokenizer stringTokenizer4 = new StringTokenizer(string6, ".");
            String string11 = stringTokenizer4.nextToken();
            if (bl4 || stringTokenizer2.hasMoreTokens()) {
                if (string11.indexOf(47) == -1) {
                    if (!bl2 && this.isANum(string11)) {
                        if (stringTokenizer4.countTokens() != 3 || !this.isAIPNum(string11)) {
                            throw IfxErrMsg.getLocSQLException(-79758, ": '" + string6 + "'", this.ClientLocale);
                        }
                        while (stringTokenizer4.hasMoreTokens()) {
                            string11 = stringTokenizer4.nextToken();
                            if (this.isAIPNum(string11)) continue;
                            throw IfxErrMsg.getLocSQLException(-79758, ": '" + string6 + "'", this.ClientLocale);
                        }
                    } else {
                        while (!bl2 && stringTokenizer4.hasMoreTokens()) {
                            string11 = stringTokenizer4.nextToken();
                            if (!this.isANum(string11)) continue;
                            throw IfxErrMsg.getLocSQLException(-79758, ": '" + string6 + "'", this.ClientLocale);
                        }
                    }
                    if (!stringTokenizer2.hasMoreTokens()) {
                        throw IfxErrMsg.getLocSQLException(-79705, this.ClientLocale);
                    }
                    String string12 = stringTokenizer2.nextToken();
                    if (stringTokenizer2.hasMoreTokens()) {
                        stringTokenizer2.nextToken();
                    }
                    if (string12 != null && string12.indexOf(47) == -1) {
                        if (!this.isANum(string12)) {
                            n = JnsObject.getServiceByName(string12);
                            if (n == -1) {
                                throw IfxErrMsg.getLocSQLException(-79759, ": '" + string12 + "'", this.ClientLocale);
                            }
                            string2 = new String(string6 + ":" + n);
                        } else {
                            string2 = new String(string6 + ":" + string12);
                        }
                    } else if (string12 != null) {
                        StringTokenizer stringTokenizer5 = new StringTokenizer(string12, "/");
                        if (!this.isANum(string12 = stringTokenizer5.nextToken())) {
                            n = JnsObject.getServiceByName(string12);
                            if (n == -1) {
                                throw IfxErrMsg.getLocSQLException(-79759, ": '" + string12 + "'", this.ClientLocale);
                            }
                            string2 = new String(string6 + ":" + n);
                        } else {
                            string2 = new String(string6 + ":" + string12);
                        }
                        String string13 = stringTokenizer5.nextToken(":").substring(1);
                        if (string13 == null || string13.length() == 0) {
                            String string14 = IfxErrMsg.getMessage(-79760, this.ClientLocale) + ": '" + string13 + "'";
                            if (TraceFlag.compiletrace) {
                                trace.writeTrace(2, "Driver:checkURL(): " + string14);
                            }
                            throw IfxErrMsg.getLocSQLException(-79760, string14, this.ClientLocale);
                        }
                        if (!this.validDatabaseIdentifier(string13)) {
                            throw IfxErrMsg.getLocSQLException(-79760, ": '" + string13 + "'", this.ClientLocale);
                        }
                        this.m_dbname = new String(string13);
                    }
                } else {
                    this.m_dbname = string11.substring(1, string11.length());
                    string2 = null;
                }
            } else {
                string2 = null;
            }
        }
        return string2;
    }

    private boolean isAIPNum(String string) {
        try {
            int n = Integer.parseInt(string);
            return n >= 0 && n <= 255;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isANum(String string) {
        try {
            return Integer.valueOf(string) >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private synchronized void getPropertiesFromUrl(String string, Properties properties) throws SQLException {
        String string2;
        int n;
        int n2 = -1;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = null;
        StringTokenizer stringTokenizer2 = null;
        if (properties.get("DATABASE") == null && this.m_dbname != null) {
            properties.put("DATABASE", this.m_dbname);
        }
        if ((n = string.indexOf(61)) != -1) {
            int n3 = -1;
            while ((n3 = string.indexOf(58, (n2 = n3) + 1)) != -1 && n3 < n) {
            }
            if (n2 == -1) {
                return;
            }
        }
        if ((string3 = string.substring(n2 + 1)) != null) {
            stringTokenizer = new StringTokenizer(string3, ";");
        }
        if (string3 != null && string3.indexOf(61) != -1 && stringTokenizer.hasMoreTokens()) {
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken(";");
                stringTokenizer2 = new StringTokenizer(string4, "=");
                String string5 = stringTokenizer2.nextToken();
                String string6 = stringTokenizer2.nextToken(";").substring(1);
                if (TraceFlag.compiletrace) {
                    trace.writeTrace(3, "Driver:GetPropertiesfromUrl(): key = '" + string5 + "'  value = '" + string6 + "'");
                }
                if (string5.equalsIgnoreCase("VER_RETAIN")) {
                    properties.put("VER_RETAIN", string6);
                }
                if (string5.equalsIgnoreCase("CSM")) {
                    if (string6 == null || !string6.startsWith("(") || !string6.endsWith(")")) {
                        throw IfxErrMsg.getLocSQLException(-79705, this.ClientLocale);
                    }
                    String string7 = string6.substring(1, string6.length() - 1);
                    properties.put("CSM", string7);
                    continue;
                }
                properties.put(string5.toUpperCase(), string6);
            }
        }
        ver_retain = properties.get("VER_RETAIN") != null ? (string2 = (String)properties.get("VER_RETAIN")).trim().equals("Y") : false;
        if (this.SubProtocol.equals("gbasedbt-direct")) {
            if (properties.get("PROTOCOLCLASS") == null) {
                properties.put("PROTOCOLCLASS", "com.gbasedbt.jdbc.IfxDirectProtocol");
                if (TraceFlag.compiletrace) {
                    trace.writeTrace(3, "Driver:getPropertiesFromUrl(): PROTOCOLCLASS set to 'com.gbasedbt.jdbc.IfxDirectProtocol'");
                }
            }
            if (properties.get("CONNECTIONCLASS") == null) {
                properties.put("CONNECTIONCLASS", "com.gbasedbt.jdbc.IfxDirectConnection");
                if (TraceFlag.compiletrace) {
                    trace.writeTrace(3, "Driver:getPropertiesFromUrl(): CONNECTIONCLASS set to 'com.gbasedbt.jdbc.IfxDirectConnection'");
                }
            }
            if (TraceFlag.compiletrace) {
                trace.writeTrace(3, "Driver:database is " + properties.get("DATABASE"));
            }
        } else {
            if (properties.get("PROTOCOLCLASS") == null) {
                properties.put("PROTOCOLCLASS", "com.gbasedbt.jdbc.IfxSqli");
            }
            if (properties.get("CONNECTIONCLASS") == null) {
                properties.put("CONNECTIONCLASS", "com.gbasedbt.jdbc.IfxSqliConnect");
            }
            if (TraceFlag.compiletrace) {
                trace.writeTrace(3, "Driver:getPropertiesFromUrl(): PROTOCOLCLASS set to 'com.gbasedbt.jdbc.IfxSqli'");
                trace.writeTrace(3, "Driver:getPropertiesFromUrl(): CONNECTIONCLASS set to 'com.gbasedbt.jdbc.IfxSqliConnect'");
            }
        }
        if ((this.Proxy = properties.getProperty("PROXY")) != null) {
            this.formatProxy(this.Proxy);
            properties.put("PROXY", this.Proxy);
            if (TraceFlag.compiletrace) {
                trace.writeTrace(3, "Driver:getPropertiesFromUrl(): PROXY set to '" + this.Proxy + "'");
            }
        }
    }

    private void checkTracing(String string, Properties properties) {
        if (TraceFlag.compiletrace) {
            short s;
            int n;
            String string2 = properties.getProperty("TRACEFILE");
            String string3 = properties.getProperty("TRACE");
            if ((string2 == null || string3 == null) && (n = string.indexOf("trace")) != -1) {
                String string4 = null;
                string4 = string.substring(n, string.length());
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken(";");
                    if (string5.indexOf(61) == -1) continue;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string5, "=");
                    String string6 = stringTokenizer2.nextToken();
                    String string7 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : null;
                    if (string6.equals("tracefile")) {
                        string2 = string7;
                        continue;
                    }
                    if (!string6.equals("trace")) continue;
                    string3 = string7;
                }
            }
            try {
                Integer n2 = Integer.valueOf(string3);
                s = n2.shortValue();
            }
            catch (NumberFormatException numberFormatException) {
                s = 0;
            }
            if (string2 != null && s > 0) {
                trace.setNewTraceFile(s, string2);
            }
        }
    }

    private void checkClientLocale(String string, Properties properties) {
        int n;
        String string2 = properties.getProperty("CLIENT_LOCALE");
        if (string2 == null && (n = string.indexOf("CLIENT_LOCALE")) != -1) {
            String string3 = null;
            string3 = string.substring(n, string.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken(";");
                if (string4.indexOf(61) == -1) continue;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "=");
                String string5 = stringTokenizer2.nextToken();
                String string6 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : null;
                if (!string5.equals("CLIENT_LOCALE")) continue;
                string2 = string6;
            }
        }
        if (string2 != null) {
            this.ClientLocale = new String(string2);
            this.setStaticClientLocale(string2);
        }
    }

    private void setStaticClientLocale(String string) {
        staticClientLocale = string;
    }

    private boolean validDatabaseIdentifier(String string) {
        int n = 1;
        int n2 = 0;
        String string2 = null;
        n2 = string.lastIndexOf(47);
        string2 = n2 != -1 ? string.substring(n2 + 1) : string;
        int n3 = string2.length();
        char c = string2.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        for (n = 1; n < n3; ++n) {
            c = string2.charAt(n);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '#') continue;
            return false;
        }
        return true;
    }

    private static String calcReleaseNum() {
        long l = 2455827L;
        String string = null;
        String string2 = "2022-08-30";
        long l2 = dateUtil.gregToJulian(string2);
        int n = (int)(l2 - l);
        string = n < 0 ? "000" : (n < 10 ? "00" + n : (n < 100 ? "0" + n : (n > 999 ? "999" : "" + n)));
        return string;
    }

    public static String getJDBCVersion() throws SQLException {
        if (!ver_retain) {
            return Version.GBASE_JDBC_RELEASE_VERSION;
        }
        return "4.10.JC4G1";
    }

    static int getJDBCMajorVersion() throws SQLException {
        if (!ver_retain) {
            return GBASE_JDBC_SPEC_MAJOR_VERSION;
        }
        return VER_RETAIN_JDBC_SPEC_MAJOR_VERSION;
    }

    static int extractMajorVersion(String string) throws SQLException {
        Integer n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        try {
            n = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (TraceFlag.compiletrace) {
                trace.writeTrace(2, "Driver:getMajorVersion(): caught exception: " + numberFormatException.toString());
            }
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        return n;
    }

    static int extractMinorVersion(String string) throws SQLException {
        Integer n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (!stringTokenizer.hasMoreTokens()) {
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        String string2 = stringTokenizer.nextToken();
        try {
            n = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            if (TraceFlag.compiletrace) {
                trace.writeTrace(2, "Driver:getMinorVersion(): caught exception: " + numberFormatException.toString());
            }
            throw IfxErrMsg.getLocSQLException(-79716, staticClientLocale);
        }
        return n;
    }

    static int getJDBCMinorVersion() throws SQLException {
        if (!ver_retain) {
            return GBASE_JDBC_SPEC_MINOR_VERSION;
        }
        return VER_RETAIN_JDBC_SPEC_MINOR_VERSION;
    }

    private boolean formatProxy(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        StringBuffer stringBuffer = new StringBuffer("http://");
        int n = string.indexOf(63);
        if (n != -1) {
            string3 = string.substring(0, n);
            string4 = string.substring(n, string.length());
        } else {
            string3 = string;
        }
        try {
            string5 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.toUpperCase().indexOf("HTTP") != -1 || string2.toUpperCase().indexOf("SERVLET") != -1 || string2.toUpperCase().indexOf("JDBCPROXY") != -1) continue;
            string5 = string2;
        }
        stringBuffer.append(string5);
        stringBuffer.append("/servlet/IfxJDBCProxy");
        if (string4 != null) {
            stringBuffer.append(string4);
        }
        this.Proxy = new String(stringBuffer.toString());
        return true;
    }

    private boolean validateURL(String string) throws SQLException {
        boolean bl = true;
        String string2 = null;
        boolean bl2 = false;
        int n = -1;
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "In Driver:checkURL(" + string + ")");
        }
        if (string.indexOf(58) == -1) {
            throw IfxErrMsg.getLocSQLException(-80004, ": '" + IfxErrMsg.getMinorMsg(-80035, string2) + " '" + string + "'" + IfxErrMsg.getMinorMsg(-80004, string2) + " ':''", string2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";=", true);
        String string3 = stringTokenizer.nextToken();
        boolean bl3 = false;
        boolean bl4 = true;
        if (string3.charAt(string3.length() - 1) == ':') {
            bl3 = true;
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ":", true);
        String string4 = stringTokenizer2.nextToken();
        if (stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("=")) {
            bl4 = false;
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "  jdbc is " + string4);
        }
        if (!string4.equalsIgnoreCase("jdbc")) {
            String string5 = IfxErrMsg.getMinorMsg(-80035, string2) + " '" + string + "' " + IfxErrMsg.getMessage(-79756, string2);
            if (TraceFlag.compiletrace) {
                trace.writeTrace(2, "Driver:checkURL(): " + string5);
            }
            throw IfxErrMsg.getLocSQLException(-79756, string5, string2);
        }
        stringTokenizer2.nextToken();
        String string6 = stringTokenizer2.nextToken();
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "  addr: " + string6);
        }
        if (stringTokenizer2.hasMoreTokens()) {
            stringTokenizer2.nextToken();
        }
        if (string6 != null && string6.charAt(0) == '/' && string6.charAt(1) == '/') {
            string6 = string6.substring(2, string6.length());
        }
        if (string6.equals("gbasedbt-sqli")) {
            if (stringTokenizer2.hasMoreTokens()) {
                string6 = stringTokenizer2.nextToken();
            }
            if (stringTokenizer2.hasMoreTokens()) {
                stringTokenizer2.nextToken();
            }
        } else if (string6.equals("gbasedbt-direct")) {
            bl = false;
            if (TraceFlag.compiletrace) {
                trace.writeTrace(1, "  check tok for more tokens" + stringTokenizer2);
            }
            if (stringTokenizer2.hasMoreTokens()) {
                string6 = stringTokenizer2.nextToken();
                if (TraceFlag.compiletrace) {
                    trace.writeTrace(1, "  has more " + string6);
                }
                if (!string6.equals(":") && stringTokenizer2.hasMoreTokens()) {
                    stringTokenizer2.nextToken();
                }
            } else {
                string6 = null;
            }
        } else {
            String string7 = IfxErrMsg.getMessage(-79757, string2) + ": '" + string6 + "'";
            if (TraceFlag.compiletrace) {
                trace.writeTrace(2, "Driver:checkURL(): " + string7);
            }
            throw IfxErrMsg.getLocSQLException(-79757, string7, string2);
        }
        if (string6 != null && string6.charAt(0) == '/' && string6.charAt(1) == '/') {
            string6 = string6.substring(2, string6.length());
            if (bl) {
                bl2 = true;
            }
        }
        if (!bl) {
            if (string6 != null && string6.length() > 0 && string6.charAt(0) == '/') {
                String string8 = string6;
                if (TraceFlag.compiletrace) {
                    trace.writeTrace(1, "  !checkSub " + string6);
                }
                StringTokenizer stringTokenizer3 = new StringTokenizer(string8, "/");
                String string9 = stringTokenizer3.nextToken();
                if (TraceFlag.compiletrace) {
                    trace.writeTrace(1, "  valid dbname? " + string9);
                }
                if (!this.validDatabaseIdentifier(string9)) {
                    String string10 = IfxErrMsg.getMessage(-79760, string2) + ": '" + string9 + "'";
                    if (TraceFlag.compiletrace) {
                        trace.writeTrace(2, "Driver:checkURL(): " + string10);
                    }
                    throw IfxErrMsg.getLocSQLException(-79760, string10, string2);
                }
            }
        } else {
            int n2;
            int n3 = stringTokenizer2.countTokens();
            int n4 = n2 = bl3 ? 3 : 4;
            if (bl2 && n3 <= n2) {
                bl2 = false;
            }
            if (bl2) {
                string6 = string6 + ":";
                while (n3 > n2) {
                    string6 = string6 + stringTokenizer2.nextToken();
                    --n3;
                }
                stringTokenizer2.nextToken();
            }
            StringTokenizer stringTokenizer4 = new StringTokenizer(string6, ".");
            String string11 = stringTokenizer4.nextToken();
            if ((bl4 || stringTokenizer2.hasMoreTokens()) && string11.indexOf(47) == -1) {
                if (!bl2 && this.isANum(string11)) {
                    if (stringTokenizer4.countTokens() != 3 || !this.isAIPNum(string11)) {
                        throw IfxErrMsg.getLocSQLException(-79758, ": '" + string6 + "'", string2);
                    }
                    while (stringTokenizer4.hasMoreTokens()) {
                        string11 = stringTokenizer4.nextToken();
                        if (this.isAIPNum(string11)) continue;
                        throw IfxErrMsg.getLocSQLException(-79758, ": '" + string6 + "'", string2);
                    }
                } else {
                    while (!bl2 && stringTokenizer4.hasMoreTokens()) {
                        string11 = stringTokenizer4.nextToken();
                        if (!this.isANum(string11)) continue;
                        throw IfxErrMsg.getLocSQLException(-79758, ": '" + string6 + "'", string2);
                    }
                }
                if (!stringTokenizer2.hasMoreTokens()) {
                    throw IfxErrMsg.getLocSQLException(-79705, string2);
                }
                String string12 = stringTokenizer2.nextToken();
                if (stringTokenizer2.hasMoreTokens()) {
                    stringTokenizer2.nextToken();
                }
                if (string12 != null && string12.indexOf(47) == -1) {
                    if (!this.isANum(string12) && (n = JnsObject.getServiceByName(string12)) == -1) {
                        throw IfxErrMsg.getLocSQLException(-79759, ": '" + string12 + "'", string2);
                    }
                } else if (string12 != null) {
                    StringTokenizer stringTokenizer5 = new StringTokenizer(string12, "/");
                    if (!this.isANum(string12 = stringTokenizer5.nextToken()) && (n = JnsObject.getServiceByName(string12)) == -1) {
                        throw IfxErrMsg.getLocSQLException(-79759, ": '" + string12 + "'", string2);
                    }
                    String string13 = stringTokenizer5.nextToken(":").substring(1);
                    if (string13 == null || string13.length() == 0) {
                        String string14 = IfxErrMsg.getMessage(-79760, string2) + ": '" + string13 + "'";
                        if (TraceFlag.compiletrace) {
                            trace.writeTrace(2, "Driver:checkURL(): " + string14);
                        }
                        throw IfxErrMsg.getLocSQLException(-79760, string14, string2);
                    }
                    if (!this.validDatabaseIdentifier(string13)) {
                        throw IfxErrMsg.getLocSQLException(-79760, ": '" + string13 + "'", string2);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        VER_RETAIN_JDBC_SPEC_MAJOR_VERSION = 3;
        VER_RETAIN_JDBC_SPEC_MINOR_VERSION = 2;
        GBASE_JDBC_SPEC_MAJOR_VERSION = 3;
        GBASE_JDBC_SPEC_MINOR_VERSION = 2;
        ver_retain = false;
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sQLException) {
            System.out.println(IfxErrMsg.getMinorMsg(-80034, (String)null) + " " + -79704 + "\n" + IfxErrMsg.getMessage(-79704, (String)null));
        }
        if (TraceFlag.compiletrace) {
            trace = new Trace();
        }
        Driver.setJDKVersion();
    }
}

