/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.Driver;
import com.gbasedbt.jdbc.IfxClientResultSet;
import com.gbasedbt.jdbc.IfxColumnInfo;
import com.gbasedbt.jdbc.IfxComplexInput;
import com.gbasedbt.jdbc.IfxComplexOutput;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxDateTime;
import com.gbasedbt.jdbc.IfxResultSetMetaData;
import com.gbasedbt.jdbc.IfxUDTInfo;
import com.gbasedbt.lang.IfxTypes;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;

public class IfxArray
implements java.sql.Array {
    private Map typeMap = null;
    private IfxComplexInput inputStream = null;
    private IfxComplexOutput outputStream = null;
    private IfxConnection conn = null;
    private Trace trace = null;
    private IfxColumnInfo elementInfo = null;
    private Vector elementInfoVector = null;
    private int JDBCType = 0;
    private int IfxType = 0;
    private boolean typeMappingNeeded = false;
    private int elementCount = -1;
    Object value;

    IfxArray(byte[] byArray, Vector vector, IfxConnection ifxConnection) throws SQLException {
        this.inputStream = new IfxComplexInput(byArray, 0, byArray.length, vector, false, ifxConnection);
        this.outputStream = new IfxComplexOutput(false, false);
        this.outputStream.setConnection(ifxConnection);
        this.setConnection(ifxConnection);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray() constructor entered/exited");
        }
        Vector vector2 = ((IfxColumnInfo)vector.get((int)0)).child;
        this.elementInfo = (IfxColumnInfo)vector2.get(0);
        this.IfxType = this.elementInfo.SQLtype;
        if (IfxTypes.isUDT(this.IfxType)) {
            if (this.elementInfo.ExtendedId == 1) {
                this.IfxType = 43;
                this.JDBCType = -1;
            } else if (this.elementInfo.ExtendedId == 10) {
                this.IfxType = 102;
                this.JDBCType = 2004;
            } else if (this.elementInfo.ExtendedId == 11) {
                this.IfxType = 101;
                this.JDBCType = 2005;
            } else if (this.elementInfo.ExtendedId == 5) {
                this.IfxType = 45;
                this.JDBCType = Driver.compareJDKVersion("1.4") < 0 ? 1111 : 16;
            } else {
                this.JDBCType = 2000;
            }
        } else if (this.IfxType == 14) {
            this.JDBCType = 1111;
        } else if (this.IfxType == 10) {
            byte by = IfxDateTime.getStartCode((short)this.elementInfo.ColLength);
            this.JDBCType = by >= 6 ? 92 : 93;
        } else {
            this.JDBCType = IfxTypes.FromIfxToJDBC2Type(this.IfxType);
            if (this.IfxType == 4 && !ifxConnection.getMapReal()) {
                this.JDBCType = 6;
            }
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxArray() constructor IfxType: " + this.IfxType);
            this.trace.writeTrace(2, "IfxArray() constructor JDBCType: " + this.JDBCType);
        }
        this.setTypeMappingNeeded(vector2);
    }

    IfxArray(Object object, IfxConnection ifxConnection) throws SQLException {
        this.value = object;
        if (!object.getClass().isArray()) {
            throw IfxErrMsg.getSQLException(-79716, ": IfxArray(Object, Connection) object isn't an array", ifxConnection);
        }
        this.setConnection(ifxConnection);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray(Object, Connection) entered");
        }
        Class<?> clazz = object.getClass().getComponentType();
        String string = null;
        if (clazz.isPrimitive()) {
            string = clazz.getName();
            if (string.equals("short")) {
                this.JDBCType = 5;
                this.IfxType = 1;
            } else if (string.equals("int")) {
                this.JDBCType = 4;
                this.IfxType = 2;
            } else if (string.equals("float")) {
                this.JDBCType = 6;
                this.IfxType = 4;
            } else if (string.equals("double")) {
                this.JDBCType = 8;
                this.IfxType = 3;
            } else if (string.equals("boolean")) {
                this.JDBCType = Driver.compareJDKVersion("1.4") < 0 ? 1111 : 16;
                this.IfxType = 45;
            } else if (string.equals("long")) {
                this.JDBCType = -5;
                if (!ifxConnection.getIsBigInt() && !ifxConnection.getIsBigSerial()) {
                    this.IfxType = 17;
                } else if (ifxConnection.getIsBigInt() && !ifxConnection.getIsBigSerial()) {
                    this.IfxType = 52;
                } else if (!ifxConnection.getIsBigInt() && ifxConnection.getIsBigSerial()) {
                    this.IfxType = 53;
                }
            }
        } else {
            string = clazz.getName();
            if (string.equals("java.lang.timestamp")) {
                this.JDBCType = 93;
                this.IfxType = 10;
            } else if (string.equals("java.lang.time")) {
                this.JDBCType = 92;
                this.IfxType = 10;
            } else if (string.equals("boolean")) {
                this.JDBCType = Driver.compareJDKVersion("1.4") < 0 ? 1111 : 16;
                this.IfxType = 45;
            } else {
                this.IfxType = IfxTypes.FromJavaToIfxType(string);
                if (this.IfxType == 49) {
                    if (((Object[])object).length > 0) {
                        IfxUDTInfo ifxUDTInfo;
                        Object object2 = ((Object[])object)[0];
                        if (object2 != null && object2 instanceof SQLData && (ifxUDTInfo = ifxConnection.getUDTInfo((IfxColumnInfo)null, object2.getClass().getName())) != null) {
                            this.JDBCType = ifxUDTInfo.JDBCtype;
                            if (this.JDBCType == 2002) {
                                this.IfxType = 22;
                            } else if (this.JDBCType == 2000) {
                                this.IfxType = 40;
                            } else if (this.JDBCType == 2001) {
                                this.IfxType = ifxUDTInfo.source;
                            }
                        }
                    } else {
                        this.IfxType = 40;
                        this.JDBCType = 2000;
                    }
                } else {
                    this.JDBCType = IfxTypes.FromIfxToJDBC2Type(this.IfxType);
                    if (this.IfxType == 4 && !ifxConnection.getMapReal()) {
                        this.JDBCType = 6;
                    }
                }
            }
        }
        this.typeMappingNeeded = false;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxArray() component: " + clazz.getName());
            this.trace.writeTrace(2, "IfxArray() IfxType: " + this.IfxType);
            this.trace.writeTrace(2, "IfxArray() JDBCType: " + this.JDBCType);
            this.trace.writeTrace(1, "IfxArray(Object, Connection) exiting");
        }
    }

    void setTypeMappingNeeded(Vector vector) {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray(). setTypeMappingNeeded entered");
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)vector.get(i);
            int n2 = IfxTypes.FromIfxToJDBCType(ifxColumnInfo.SQLtype);
            if (ifxColumnInfo.SQLtype == 4 && !this.conn.getMapReal()) {
                n2 = 6;
            }
            if (n2 == 2003 || n2 == 2001 || n2 == 2000 || n2 == 2001 || n2 == 1111 || n2 == 2002) {
                this.typeMappingNeeded = true;
                return;
            }
            if (ifxColumnInfo.child == null) continue;
            this.setTypeMappingNeeded(ifxColumnInfo.child);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray(). setTypeMappingNeeded exited");
        }
    }

    private void clear() {
        this.value = null;
        this.elementCount = -1;
        this.outputStream.reset();
    }

    void setConnection(IfxConnection ifxConnection) throws SQLException {
        this.conn = ifxConnection;
        if (ifxConnection == null) {
            throw IfxErrMsg.getSQLException(-79716, ifxConnection);
        }
        if (TraceFlag.compiletrace) {
            this.trace = ifxConnection.getTrace();
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray.getBaseTypeName() called");
            this.trace.writeTrace(2, "   getBaseTypeName() IfxType: " + this.IfxType);
        }
        String string = null;
        if (this.IfxType != 40 && this.IfxType != 41) {
            string = IfxTypes.IfxTypeToName(this.IfxType);
        } else {
            Class clazz;
            string = new String("unknown");
            if (this.typeMap != null && this.elementInfo != null && this.elementInfo.ExtendedName != null && (clazz = (Class)this.typeMap.get(this.elementInfo.ExtendedName)) != null) {
                string = clazz.getName();
            }
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxArray.getBaseTypeName() = " + string);
        }
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        return string;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.JDBCType;
    }

    @Override
    public Object getArray() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray.getArray(void) called");
        }
        return this.getArray((Map)this.conn.getTypeMap());
    }

    public Object getArray(Map map) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray.getArray(Map) called");
        }
        if (this.value != null && (!this.typeMappingNeeded || this.typeMappingNeeded && this.typeMap == map)) {
            return this.value;
        }
        this.typeMap = map;
        this.inputStream.setTypeMap(this.typeMap);
        this.inputStream.reset();
        this.value = this.inputStream.readArrayElements(this.JDBCType);
        this.elementCount = -1;
        return this.value;
    }

    @Override
    public Object getArray(long l, int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray.getArray(long, int) called");
        }
        return this.getArray(l, n, (Map)this.conn.getTypeMap());
    }

    public Object getArray(long l, int n, Map map) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray.getArray(long, int, Map) called");
        }
        if (this.value != null && (!this.typeMappingNeeded || this.typeMappingNeeded && this.typeMap == map)) {
            return this.getSubArray(l, n);
        }
        this.getArray(map);
        return this.getSubArray(l, n);
    }

    private Object getSubArray(long l, int n) throws SQLException {
        Object object;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray.getSubArray(long, int) called");
        }
        this.verifyIndexCount(l, n);
        --l;
        try {
            object = Array.newInstance(this.value.getClass().getComponentType(), n);
            System.arraycopy(this.value, (int)l, object, 0, n);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray.getSubArray(long, exited) called");
        }
        return object;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray.getResultSet(void) called");
        }
        return this.getResultSet((Map)this.conn.getTypeMap());
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray.getResultSet(Map) called");
        }
        Object object = this.getArray(map);
        return this.setResultSet(object);
    }

    @Override
    public ResultSet getResultSet(long l, int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray.getResultSet(long, int) called");
        }
        return this.getResultSet(l, n, (Map)this.conn.getTypeMap());
    }

    public ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray.getResultSet(long, int, Map) called");
        }
        Object object = this.getArray(l, n, map);
        return this.setResultSet(object);
    }

    private ResultSet setResultSet(Object object) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray.setResultSet(Object) entered");
        }
        IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(2, this.conn);
        ifxResultSetMetaData.setEncodedLength(1, 8);
        ifxResultSetMetaData.setNullable(1, 0);
        ifxResultSetMetaData.setMaxWidth(1, 8);
        ifxResultSetMetaData.setColtitle(1, "Index");
        ifxResultSetMetaData.setColumnName(1, "Index");
        ifxResultSetMetaData.setIfxColumnType(1, 17);
        ifxResultSetMetaData.setEncodedLength(2, this.elementInfo.ColLength);
        ifxResultSetMetaData.setNullable(2, this.elementInfo.Nullable);
        ifxResultSetMetaData.setMaxWidth(2, this.elementInfo.MaxWidth);
        ifxResultSetMetaData.setColtitle(2, this.elementInfo.Coltitle);
        ifxResultSetMetaData.setColumnName(2, this.elementInfo.ColName);
        ifxResultSetMetaData.setRightDecimal(2, this.elementInfo.RightDecimal);
        ifxResultSetMetaData.setIfxColumnType(2, this.elementInfo.SQLtype);
        ifxResultSetMetaData.setColumnExtendedId(2, this.elementInfo.ExtendedId);
        ifxResultSetMetaData.setDistinct(2, this.elementInfo.IsDistinct);
        IfxClientResultSet ifxClientResultSet = new IfxClientResultSet(this.conn, ifxResultSetMetaData);
        this.loadResultSet(ifxClientResultSet, object);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray.getResultSet(Object) exited");
        }
        return ifxClientResultSet;
    }

    private void loadResultSet(IfxClientResultSet ifxClientResultSet, Object object) throws SQLException {
        long l;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray.loadResults(crs, Object called");
        }
        long l2 = l = object == null ? 0L : (long)Array.getLength(object);
        if (l > 0L) {
            ifxClientResultSet.newRow((int)l);
            int n = 0;
            while ((long)n < l) {
                ifxClientResultSet.updateLong(n + 1, 1, (long)(n + 1));
                ifxClientResultSet.updateObject(n + 1, 2, Array.get(object, n));
                ++n;
            }
        }
        ifxClientResultSet.beforeFirst();
        ifxClientResultSet.setType(1003);
        ifxClientResultSet.setFetchDirection(1000);
        ifxClientResultSet.setConcurrency(1007);
    }

    private void verifyIndexCount(long l, int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxArray.verifyIndexCount(long, int) called");
        }
        if (this.elementCount == -1) {
            if (!this.value.getClass().getComponentType().isPrimitive()) {
                this.elementCount = ((Object[])this.value).length;
            } else {
                switch (this.IfxType) {
                    case 2: {
                        this.elementCount = ((int[])this.value).length;
                        break;
                    }
                    case 1: {
                        this.elementCount = ((short[])this.value).length;
                        break;
                    }
                    case 17: 
                    case 52: 
                    case 53: {
                        this.elementCount = ((long[])this.value).length;
                        break;
                    }
                    case 4: {
                        this.elementCount = ((float[])this.value).length;
                        break;
                    }
                    case 3: {
                        this.elementCount = ((double[])this.value).length;
                        break;
                    }
                    case 45: {
                        this.elementCount = ((boolean[])this.value).length;
                        break;
                    }
                    default: {
                        this.elementCount = ((Object[])this.value).length;
                    }
                }
            }
        }
        if (l < 1L || l + (long)n > (long)(this.elementCount + 1)) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxArray.verifyIndexCount():");
                this.trace.writeTrace(2, "    index = " + l);
                this.trace.writeTrace(2, "    count = " + n);
                this.trace.writeTrace(2, "    elementCount = " + this.elementCount);
            }
            throw IfxErrMsg.getSQLException(-79781, this.conn);
        }
    }

    @Override
    public void free() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxArray:free()not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxArray:free()", this.conn);
    }
}

