/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.jdbc.IfxUDTInput;
import com.gbasedbt.jdbc.IfxUDTOutput;
import com.gbasedbt.lang.IfxToJavaType;
import com.gbasedbt.lang.JavaToIfxType;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.TraceFlag;
import java.io.ByteArrayOutputStream;
import java.sql.SQLException;

abstract class IfxBaseType
extends IfxObject {
    protected static final int UDT_FLAG_SIZE = 1;
    protected static final int UDT_LENGTH_SIZE = 4;
    protected IfxUDTInput inputStream = null;
    protected IfxUDTOutput outputStream = new IfxUDTOutput();

    IfxBaseType() {
    }

    @Override
    public void setConnection(IfxConnection ifxConnection) throws SQLException {
        super.setConnection(ifxConnection);
        this.outputStream.setConnection(ifxConnection);
    }

    @Override
    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n;
        if (byArray[n3] == 1) {
            this.nullify();
        } else {
            try {
                byte[] byArray2 = new byte[4];
                System.arraycopy(byArray, ++n3, byArray2, 0, 4);
                n3 += 4;
                int n4 = IfxToJavaType.IfxToJavaInt(byArray2);
                if (TraceFlag.compiletrace) {
                    this.writeTrace(2, "IfxBaseType: fromIfx.length = " + n4);
                    this.writeTrace(2, "IfxBaseType: fromIfx.index = " + n3);
                }
                this.inputStream = new IfxUDTInput(this.conn, byArray, n3, n4);
                this.unnullify();
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
    }

    @Override
    public byte[] toIfx() throws SQLException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        if (this.isNull()) {
            byArray = new byte[]{1};
            byteArrayOutputStream.write(byArray, n++, byArray.length);
            this.outputStream.reset();
        }
        byArray = JavaToIfxType.JavaToIfxInt(this.outputStream.length());
        byteArrayOutputStream.write(byArray, n, byArray.length);
        byteArrayOutputStream.write(this.outputStream.toByteArray(), 0, this.outputStream.length());
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[]{this.isNull() ? (byte)1 : 0};
        byteArrayOutputStream.write(byArray, 0, 1);
        byte[] byArray2 = JavaToIfxType.JavaToIfxInt(this.outputStream.length());
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(this.outputStream.toByteArray(), 0, this.outputStream.length());
        return byteArrayOutputStream.toByteArray();
    }
}

