/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxArray;
import com.gbasedbt.jdbc.IfxComplex;
import com.gbasedbt.jdbc.IfxComplexOutput;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.TraceFlag;
import java.sql.Array;
import java.sql.SQLException;
import java.util.Collection;

public class IfxCollection
extends IfxComplex {
    public IfxCollection() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxCollection() constructor called");
        }
        this.outputStream = new IfxComplexOutput(false, false);
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxCollection() constructor exited");
        }
    }

    @Override
    public void fromObject(Object object) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxCollection.fromObject(Object) called");
        }
        if (this.outputStream == null) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        this.outputStream.reset();
        this.outputStream.setConnection(this.conn);
        if (object == null) {
            if (TraceFlag.compiletrace) {
                this.writeTrace(2, "    data is null");
            }
            this.nullify();
        } else {
            Object object2;
            this.outputStream.setTypeMap(this.typeMap);
            if (object.getClass().isArray()) {
                object = object2 = new IfxArray(object, this.conn);
            }
            if (object instanceof Array) {
                if (TraceFlag.compiletrace) {
                    this.writeTrace(2, "    data is instance of java.sql.Array");
                }
                this.outputStream.writeCollection((Array)object);
                this.unnullify();
            } else if (object instanceof Collection) {
                if (TraceFlag.compiletrace) {
                    this.writeTrace(2, "    data is instance of java.util.Collection");
                }
                this.outputStream.writeCollection((Collection)object);
                this.unnullify();
            } else {
                if (TraceFlag.compiletrace) {
                    this.writeTrace(2, "    fromObject(Object) object unknown");
                    if (object == null) {
                        this.writeTrace(2, "    object is null");
                    } else {
                        this.writeTrace(2, "    object: " + object.getClass().getName());
                    }
                }
                throw IfxErrMsg.getSQLException(-79728, this.conn);
            }
            object2 = this.outputStream.getExtendedName();
            super.setExtendedTypeName((String)object2);
        }
        this.setIfxType(44);
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxCollection.fromObject(Object) exited");
        }
    }

    @Override
    public void fromObject(Object object, String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxCollection.fromObject(Object, String) called");
        }
        this.outputStream = new IfxComplexOutput(false, string, this.conn);
        this.fromObject(object);
    }

    @Override
    public Object toObject() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxCollection.toObject() entered");
        }
        if (this.isNull()) {
            return null;
        }
        this.inputStream.setTypeMap(this.typeMap);
        Object object = this.inputStream.readCollection();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxCollection.toObject() exited");
        }
        return object;
    }

    public Array toArray() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxCollection.toArray() entered");
        }
        if (this.isNull()) {
            return null;
        }
        IfxArray ifxArray = this.inputStream.readIfxArray();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxCollection.toArray() exited");
        }
        return ifxArray;
    }
}

