/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfmxComplexSQLOutput;
import com.gbasedbt.jdbc.IfxArray;
import com.gbasedbt.jdbc.IfxColumnInfo;
import com.gbasedbt.jdbc.IfxComplex;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxDateTime;
import com.gbasedbt.jdbc.IfxDecimal;
import com.gbasedbt.jdbc.IfxDistinctOutput;
import com.gbasedbt.jdbc.IfxFloat;
import com.gbasedbt.jdbc.IfxIntervalDF;
import com.gbasedbt.jdbc.IfxIntervalYM;
import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.jdbc.IfxResultSetMetaData;
import com.gbasedbt.jdbc.IfxSQLOutput;
import com.gbasedbt.jdbc.IfxSmBlob;
import com.gbasedbt.jdbc.IfxSmallFloat;
import com.gbasedbt.jdbc.IfxUDTInfo;
import com.gbasedbt.jdbc.IfxUDTOutput;
import com.gbasedbt.jdbc.IfxValue;
import com.gbasedbt.lang.IfxTypes;
import com.gbasedbt.lang.Interval;
import com.gbasedbt.lang.IntervalDF;
import com.gbasedbt.lang.IntervalYM;
import com.gbasedbt.lang.JavaToIfxType;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import com.gbasedbt.util.stringUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxComplexOutput
extends IfxSQLOutput
implements IfmxComplexSQLOutput {
    private Map typeMap = null;
    private boolean isRow = false;
    private boolean isNested = false;
    private Vector typeInfoVector = null;
    private Vector parentTypeInfoVector = null;
    private Vector elementOffsetVector = new Vector();
    private int typeInfoCount = 0;
    private String extendedName = "";
    private boolean isNull = true;
    private short identsize = 0;
    private int currentIfxType = 49;
    private int currentIfxLength = 0;
    private int currentExtendedId = 0;
    private int typeIndex = -1;
    private int typeChildIndex = 0;
    private boolean isTyped = false;
    private boolean atNextType = false;
    private static final short NESTED_COLLHDRSIZE = 16;
    private static final short COLL_ALIGN = 8;
    private static final short COLL_FLAGHASH_SIZE = 8;
    private static final String T_COMMA = ",";
    private static String T_LPAREN = "(";
    private static String T_RPAREN = ")";
    private static String T_SPACE = " ";
    private static final int CT_TYPE = 1;
    private static final int TYPE = 2;
    private static final int LENGTH = 3;
    private static final int NEXTELEMENT = 4;
    private static final int LPAREN = 5;
    private static final int RPAREN = 6;
    private static final int FIELDNAME = 7;
    private static final int NOTNULL = 8;
    private static final int CTEND = 9;
    private String currentToken = null;
    private boolean advanceToken = true;
    private int previousState = -1;

    IfxComplexOutput(boolean bl, boolean bl2) throws SQLException {
        super.setRandomAccess(false);
        this.isRow = bl;
        this.isNested = bl2;
        this.typeInfoVector = new Vector();
    }

    IfxComplexOutput(boolean bl, boolean bl2, IfxConnection ifxConnection) throws SQLException {
        super(ifxConnection);
        super.setRandomAccess(false);
        this.isRow = bl;
        this.isNested = bl2;
        this.typeInfoVector = new Vector();
    }

    IfxComplexOutput(boolean bl, boolean bl2, Object object, IfxConnection ifxConnection) throws SQLException {
        super(ifxConnection);
        super.setRandomAccess(false);
        this.isRow = bl;
        this.isNested = bl2;
        if (object == null || !(object instanceof IfxColumnInfo)) {
            throw IfxErrMsg.getSQLException(-79716, ": IfxComplexOutput(boolean, boolean, Vector, Connection)", ifxConnection);
        }
        Vector<Object> vector = new Vector<Object>();
        vector.add(object);
        this.setTypeInfoVector(vector);
    }

    IfxComplexOutput(boolean bl, boolean bl2, String string, IfxConnection ifxConnection) throws SQLException {
        super(ifxConnection);
        super.setRandomAccess(false);
        this.isRow = bl;
        this.isNested = bl2;
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79716, ": IfxComplexOutput(boolean, boolean, String, Connection)", ifxConnection);
        }
        Vector vector = this.getTypeInfoVector(string);
        this.setTypeInfoVector(vector);
    }

    IfxComplexOutput(boolean bl, String string, IfxConnection ifxConnection) throws SQLException {
        super(ifxConnection);
        super.setRandomAccess(false);
        this.isRow = bl;
        this.isNested = false;
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79716, ": IfxComplexOutput(boolean, boolean, String, Connection)", ifxConnection);
        }
        Vector vector = this.getTypeInfoVector(string);
        this.setTypeInfoVector(vector);
    }

    boolean isNull() {
        return this.isNull;
    }

    void clear() {
        this.elementOffsetVector = new Vector();
        this.extendedName = "";
        this.isNull = true;
        this.reset();
    }

    private void clearTypeInfo() {
        this.parentTypeInfoVector = null;
        this.typeInfoVector = null;
        this.typeInfoCount = 0;
    }

    void setTypeMap(Map map) {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): setTypeMap called");
        }
        this.typeMap = map;
    }

    @Override
    void setConnection(IfxConnection ifxConnection) throws SQLException {
        super.setConnection(ifxConnection);
        this.identsize = ifxConnection.isLongID() ? (short)128 : (short)18;
    }

    private void addTypeAndOffsetInfo(int n, int n2, String string) throws SQLException {
        IfxColumnInfo ifxColumnInfo = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): addTypeAndOffsetInfo() entered");
            this.trace.writeTrace(2, "    addTypeAndOffsetInfo() isTyped: " + this.isTyped);
        }
        this.isNull = false;
        if (this.isTyped) {
            this.getNextType(n, n2, string, 0);
            n = this.currentIfxType;
        } else {
            if (this.isRow) {
                throw IfxErrMsg.getSQLException(-79716, ": addTypeAndOffsetInfo() it's a row", this.conn);
            }
            if (this.typeInfoVector.size() == 0) {
                ifxColumnInfo = new IfxColumnInfo();
                ifxColumnInfo.SQLtype = n;
                ifxColumnInfo.Nullable = 0;
                ifxColumnInfo.ColLength = (short)n2;
                if (string != null) {
                    ifxColumnInfo.ExtendedName = string;
                    if (n == 22) {
                        ifxColumnInfo.IsNamedRow = true;
                    } else if (n == 40) {
                        if (string.compareToIgnoreCase("blob") == 0) {
                            ifxColumnInfo.ExtendedId = 10;
                        } else if (string.compareToIgnoreCase("clob") == 0) {
                            ifxColumnInfo.ExtendedId = 11;
                        }
                    }
                }
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(2, "    Added ifxType: " + n);
                    this.trace.writeTrace(2, "    Added name: " + string);
                    this.trace.writeTrace(2, "    Added colLength: " + ifxColumnInfo.ColLength);
                }
                this.typeInfoVector.addElement(ifxColumnInfo);
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(2, "    typeInfo has # elements: " + this.typeInfoVector.size());
                }
            } else if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, " dump from addTypeAndOffsetInfo(): ");
                this.trace.writeTrace(2, " ****** begin typeInfoVector information *****");
                IfxComplex.dumpTypeInfoVector(this.typeInfoVector, this.trace, 4);
                this.trace.writeTrace(2, " ****** end typeInfoVector information *****");
            }
        }
        this.addElementOffset(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): addTypeAndOffsetInfo() exited");
        }
    }

    private void addElementOffset(int n) {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): addElementOffset(int) entered");
            this.trace.writeTrace(2, "    addElementOffset(int) ifxType:" + n);
            this.trace.writeTrace(2, "    addElementOffset(int) isNested:" + this.isNested);
            this.trace.writeTrace(2, "    addElementOffset(int) isRow:" + this.isRow);
            this.trace.writeTrace(2, "    addElementOffset(int) bStream.size():" + this.bStream.size());
        }
        int n2 = this.bStream.size();
        if (this.isRow || IfxTypes.isUDT(n) || IfxTypes.isComplexType(n)) {
            Integer n3 = n2;
            Integer n4 = null;
            boolean bl = true;
            if (this.elementOffsetVector.size() > 0) {
                n4 = (Integer)this.elementOffsetVector.lastElement();
            }
            if (n4 != null && n4.intValue() == n3.intValue()) {
                bl = false;
            }
            if (bl) {
                this.elementOffsetVector.addElement(n3);
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(2, "    Added offset: " + n2);
                    this.trace.writeTrace(2, "    offset has # elements: " + this.elementOffsetVector.size());
                }
            }
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): addElementOffset(int) exited");
        }
    }

    @Override
    public void writeInt(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeInt() entered");
            this.trace.writeTrace(2, "    writeInt() x = " + n);
        }
        if (!this.isRow && n == Integer.MIN_VALUE) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(2, 4, null);
        try {
            this.os.writeInt(n);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeInt() exited");
        }
    }

    @Override
    public void writeString(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeString() entered");
            this.trace.writeTrace(2, "    writeString(String) x = " + string);
        }
        if (!this.isRow && string == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        try {
            if (this.isTyped) {
                this.writeStringWithLength(string);
            } else {
                this.addTypeAndOffsetInfo(43, this.conn.getMaxLvarcharSize(), null);
                if (string == null) {
                    int n = 1;
                    this.os.write(n);
                } else {
                    int n = 0;
                    this.os.write(n);
                    byte[] byArray = JavaToIfxType.JavaToIfxInt(string.length());
                    this.os.write(byArray, 0, byArray.length);
                    byArray = stringUtil.getBytes(string, this.conn);
                    this.os.write(byArray, 0, byArray.length);
                }
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeString() exited");
        }
    }

    private void writeStringWithLength(String string) throws SQLException {
        String string2 = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeStringWithLength(String) entered");
            this.trace.writeTrace(2, "    x = " + string);
            this.trace.writeTrace(2, "    bStream.size() = " + this.bStream.size());
        }
        if (this.conn != null) {
            string2 = this.conn.getclLocale();
        }
        this.isNull = false;
        this.getNextType(49, 0, null, 0);
        if (!IfxTypes.isString(this.currentIfxType)) {
            IfxComplex.badTypeException(this.currentIfxType, (short)0, this.trace, string2);
        }
        this.addElementOffset(this.currentIfxType);
        int n = this.currentIfxLength;
        try {
            if (this.currentIfxType == 13 || this.currentIfxType == 16) {
                if (string == null && n < 2) {
                    n = 0;
                    string = "";
                }
                if (string == null) {
                    byte[] byArray = new byte[]{0, 1, 0};
                    this.os.write(byArray, 0, byArray.length);
                    String string3 = stringUtil.fixLength(string, n - 2, ' ');
                    byArray = stringUtil.getBytes(string3, this.conn);
                    this.os.write(byArray, 0, byArray.length);
                } else if (n == 0) {
                    byte[] byArray = new byte[]{0, 0};
                    this.os.write(byArray, 0, byArray.length);
                } else {
                    if (string.length() > 32765) {
                        n = 32765;
                    }
                    byte[] byArray = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
                    this.os.write(byArray, 0, byArray.length);
                    String string4 = stringUtil.fixLength(string, n, ' ');
                    byArray = stringUtil.getBytes(string4, this.conn);
                    this.os.write(byArray, 0, byArray.length);
                }
            } else if (this.currentIfxType == 0 || this.currentIfxType == 15) {
                String string5 = stringUtil.fixLength(string, n, ' ');
                byte[] byArray = stringUtil.getBytes(string5, this.conn);
                if (string == null) {
                    byArray[0] = 0;
                }
                this.os.write(byArray, 0, byArray.length);
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(2, "    string written: = " + string5);
                    this.trace.writeTrace(2, "    s.length = " + string5.length());
                }
            } else if (string == null) {
                int n2 = 1;
                this.os.write(n2);
            } else {
                int n3 = 0;
                this.os.write(n3);
                byte[] byArray = JavaToIfxType.JavaToIfxInt(string.length());
                this.os.write(byArray, 0, byArray.length);
                byArray = stringUtil.getBytes(string, this.conn);
                this.os.write(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeStringWitLength() exited");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeObject(SQLData sQLData) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeObject(SQLData) entered");
        }
        if (!this.isRow && sQLData == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        IfxColumnInfo ifxColumnInfo = null;
        ifxColumnInfo = this.isTyped ? (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex + 1) : (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex);
        if (ifxColumnInfo.SQLtype == 40 || ifxColumnInfo.SQLtype == 41) {
            this.writeUDT(sQLData);
        } else if (ifxColumnInfo.IsDistinct) {
            this.writeDistinct(sQLData);
        } else if (ifxColumnInfo.SQLtype == 22) {
            if (sQLData == null || sQLData instanceof Struct) {
                this.writeStruct((Struct)((Object)sQLData));
            } else {
                if (!(sQLData instanceof SQLData)) throw IfxErrMsg.getSQLException(-79777, this.conn);
                this.writeNestedRow(sQLData);
            }
        } else {
            if (sQLData != null) throw IfxErrMsg.getSQLException(-79777, this.conn);
            this.writeElement(sQLData, ifxColumnInfo.SQLtype);
        }
        if (!TraceFlag.compiletrace) return;
        this.trace.writeTrace(1, "IfxComplexOutput(): writeObject(SQLData) exited");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeObject(Object object) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeObject(Object) entered");
        }
        if (!this.isRow && object == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        IfxColumnInfo ifxColumnInfo = null;
        ifxColumnInfo = this.isTyped ? (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex + 1) : (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex);
        if (IfxTypes.isCollection(ifxColumnInfo.SQLtype)) {
            if (object == null || object instanceof Collection) {
                this.writeNestedCollection((Collection)object);
            } else {
                if (!(object instanceof Array)) throw IfxErrMsg.getSQLException(-79777, this.conn);
                this.writeArray((Array)object);
            }
        } else {
            if (ifxColumnInfo.SQLtype != 14) throw IfxErrMsg.getSQLException(-79777, this.conn);
            if (object == null || object instanceof IntervalDF) {
                this.writeIntervalDF((IntervalDF)object);
            }
            if (!(object instanceof IntervalYM)) throw IfxErrMsg.getSQLException(-79777, this.conn);
            this.writeIntervalYM((IntervalYM)object);
        }
        if (!TraceFlag.compiletrace) return;
        this.trace.writeTrace(1, "IfxComplexOutput(): writeObject(Object) exited");
    }

    @Override
    public void writeStruct(Struct struct) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeStruct(Struct) entered");
            this.trace.writeTrace(1, "    writeStruct(Struct) isTyped: " + this.isTyped);
            this.trace.writeTrace(1, "    writeStruct(Struct) typeIndex: " + this.typeIndex);
        }
        IfxComplexOutput ifxComplexOutput = null;
        if (this.isTyped) {
            this.getNextType(22, 0, null, 0);
        }
        this.addElementOffset(22);
        if (struct == null && !this.isRow) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        if (struct != null) {
            Map<String, Class<?>> map = this.conn.getTypeMap();
            Object[] objectArray = struct.getAttributes(map);
            String string = struct.getSQLTypeName();
            if (string == null) {
                throw IfxErrMsg.getSQLException(-79770, this.conn);
            }
            if (objectArray.length == 0) {
                throw IfxErrMsg.getSQLException(-79792, this.conn);
            }
            ifxComplexOutput = this.isTyped ? new IfxComplexOutput(true, true, this.typeInfoVector.get(this.typeIndex), this.conn) : new IfxComplexOutput(true, true, string, this.conn);
            if (!this.isTyped && this.typeInfoVector.size() == 0) {
                IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)ifxComplexOutput.getTypeInfoVector().get(0);
                ifxColumnInfo.Nullable = 0;
                this.typeInfoVector.add(ifxColumnInfo);
            }
            for (int i = 0; i < objectArray.length; ++i) {
                int n;
                this.isNull = false;
                if (objectArray[i] == null) {
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, "  writeStruct() obj[" + i + "] is null");
                    }
                    this.atNextType = this.getNextType(49, 0, null, i);
                    n = this.currentIfxType;
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, "  writeStruct() type of null: " + n);
                    }
                } else {
                    n = this.getIfxType(objectArray[i], ifxComplexOutput.getIsTyped());
                }
                ifxComplexOutput.writeElement(objectArray[i], n);
            }
        } else {
            ifxComplexOutput = new IfxComplexOutput(true, true, this.conn);
            if (!this.isTyped && this.typeInfoVector.size() == 0) {
                IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)ifxComplexOutput.getTypeInfoVector().get(0);
                ifxColumnInfo.Nullable = 0;
                this.typeInfoVector.add(ifxColumnInfo);
            }
        }
        ifxComplexOutput.writeElementOffset();
        this.writeNestedData(ifxComplexOutput);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "    writeStruct(Struct) isTyped: " + this.isTyped);
            this.trace.writeTrace(3, "    writeStruct(Struct) typeIndex: " + this.typeIndex);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "    writeStruct(Struct) isNull: " + this.isNull);
            this.trace.writeTrace(1, "IfxComplexOutput(): writeStruct(Struct) exited");
        }
    }

    private void writeNestedRow(SQLData sQLData) throws SQLException {
        Object object;
        IfxComplexOutput ifxComplexOutput = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeNestedRow(SQLData) entered");
            this.trace.writeTrace(2, "  writeNestedRow(SQLData) isTyped: " + this.isTyped);
        }
        if (this.isTyped) {
            this.getNextType(22, 0, null, 0);
        }
        this.addElementOffset(this.currentIfxType);
        if (sQLData == null) {
            if (!this.isRow) {
                throw IfxErrMsg.getSQLException(-1225, this.conn);
            }
            this.isNull = true;
            return;
        }
        if (this.isTyped) {
            ifxComplexOutput = new IfxComplexOutput(true, true, this.typeInfoVector.get(this.typeIndex), this.conn);
        } else {
            object = sQLData.getSQLTypeName();
            if (object == null) {
                throw IfxErrMsg.getSQLException(-79770, this.conn);
            }
            ifxComplexOutput = new IfxComplexOutput(true, true, (String)object, this.conn);
        }
        this.addElementOffset(22);
        this.isNull = false;
        ifxComplexOutput.writeRow(sQLData);
        this.writeNestedData(ifxComplexOutput);
        if (!this.isTyped && this.typeInfoVector.size() == 0) {
            object = (IfxColumnInfo)ifxComplexOutput.getTypeInfoVector().get(0);
            ((IfxColumnInfo)object).Nullable = 0;
            this.typeInfoVector.add(object);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, " dump from writeNestedRow(SQLData): ");
            this.trace.writeTrace(2, " ****** begin typeInfoVector information *****");
            IfxComplex.dumpTypeInfoVector(this.typeInfoVector, this.trace, 4);
            this.trace.writeTrace(2, " ****** end typeInfoVector information *****");
            this.trace.writeTrace(1, "IfxComplexOutput(): writeNestedRow(SQLData) exited");
        }
    }

    private void writeNestedCollection(Collection collection) throws SQLException {
        Object object;
        Object object2;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeNestedCollection(Collection) entered");
            this.trace.writeTrace(2, "    writeNestedCollection() class: " + collection.getClass().getName());
        }
        if (!this.isRow && collection == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        if (collection == null) {
            this.addTypeAndOffsetInfo(20, 0, null);
        } else {
            this.addTypeAndOffsetInfo(this.getOverrideIfxType(collection), 0, null);
        }
        IfxComplexOutput ifxComplexOutput = null;
        ifxComplexOutput = this.isTyped ? new IfxComplexOutput(false, true, this.typeInfoVector.get(this.typeIndex), this.conn) : new IfxComplexOutput(false, true, this.conn);
        if (collection == null) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "************ NULL COLLECTION **********");
            }
            this.addElementOffset(this.currentIfxType);
            this.writeNestedData(ifxComplexOutput);
            return;
        }
        this.isNull = false;
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            ifxComplexOutput.isNull = false;
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    writeNestedCollection(Collection x)EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(49, 0, null);
        } else {
            object2 = iterator.next();
            object = object2.getClass();
            int n = this.getIfxType(object2, ifxComplexOutput.getIsTyped());
            while (true) {
                this.addElementOffset(n);
                ifxComplexOutput.writeElement(object2, n);
                if (!iterator.hasNext()) break;
                object2 = iterator.next();
            }
        }
        ifxComplexOutput.writeElementOffset();
        this.writeNestedData(ifxComplexOutput);
        if (!this.isTyped) {
            object2 = (IfxColumnInfo)this.typeInfoVector.lastElement();
            if (((IfxColumnInfo)object2).child != null) {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(1, "   writeNestedCollection(Collection) last element already has a child element");
                }
                if (this.isUnknownType((IfxColumnInfo)((IfxColumnInfo)object2).child.get(0))) {
                    ((IfxColumnInfo)object2).child = ifxComplexOutput.getTypeInfoVector();
                }
            } else {
                ((IfxColumnInfo)object2).child = ifxComplexOutput.getTypeInfoVector();
            }
            object = (IfxColumnInfo)((IfxColumnInfo)object2).child.get(0);
            ((IfxColumnInfo)object).Nullable = 0;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeNestedCollection(Collection) exited");
        }
    }

    private void writeUDT(Object object) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeUDT(Object) entered");
        }
        if (object == null) {
            if (!this.isRow) {
                throw IfxErrMsg.getSQLException(-1225, this.conn);
            }
            IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex);
            this.addTypeAndOffsetInfo(40, 0, ifxColumnInfo.ExtendedName);
            IfxObject ifxObject = IfxValue.makeInstance(this.conn, ifxColumnInfo);
            byte[] byArray = ifxObject.toIfx();
            try {
                this.os.write(byArray);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        if (!(object instanceof SQLData)) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        SQLData sQLData = (SQLData)object;
        IfxUDTOutput ifxUDTOutput = new IfxUDTOutput(this.conn);
        sQLData.writeSQL(ifxUDTOutput);
        String string = ((SQLData)object).getSQLTypeName();
        if (string == null || string == "") {
            throw IfxErrMsg.getSQLException(-79770, this.conn);
        }
        this.addTypeAndOffsetInfo(40, ifxUDTOutput.length(), string);
        try {
            this.os.writeByte(0);
            byte[] byArray = JavaToIfxType.JavaToIfxInt(ifxUDTOutput.length());
            this.os.write(byArray);
            byArray = ifxUDTOutput.toByteArray();
            this.os.write(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        ifxUDTOutput.reset();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeUDT(Object) exited");
        }
    }

    private void writeDistinct(Object object) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeDistinct(Object) entered");
        }
        if (!this.isRow && object == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        if (!(object instanceof SQLData)) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        IfxDistinctOutput ifxDistinctOutput = new IfxDistinctOutput(null, this.conn);
        SQLData sQLData = (SQLData)object;
        String string = sQLData.getSQLTypeName();
        if (string == null || string == "") {
            throw IfxErrMsg.getSQLException(-79770, this.conn);
        }
        this.addTypeAndOffsetInfo(40, 0, string);
        sQLData.writeSQL(ifxDistinctOutput);
        try {
            byte[] byArray = new byte[]{0};
            this.os.write(byArray, 0, 1);
            byte[] byArray2 = JavaToIfxType.JavaToIfxInt(ifxDistinctOutput.length());
            this.os.write(byArray2, 0, byArray2.length);
            byArray2 = ifxDistinctOutput.toByteArray();
            this.os.write(byArray2, 0, byArray2.length);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        ifxDistinctOutput.reset();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeDistinct(Object) exited");
        }
    }

    void writeRow(SQLData sQLData) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeRow(SQLData) entered");
        }
        this.extendedName = sQLData.getSQLTypeName();
        if (this.extendedName == null || this.extendedName == "") {
            throw IfxErrMsg.getSQLException(-79770, this.conn);
        }
        if (!this.isTyped) {
            Vector vector = this.getTypeInfoVector(this.extendedName);
            this.setTypeInfoVector(vector);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "    writeRow(SQLData) typeInfo dump");
            this.trace.writeTrace(2, " ****** begin typeInfoVector information *****");
            IfxComplex.dumpTypeInfoVector(this.typeInfoVector, this.trace, 4);
            this.trace.writeTrace(2, " ****** end typeInfoVector information *****");
        }
        sQLData.writeSQL(this);
        this.writeElementOffset();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeRow(SQLData) exited");
        }
    }

    void writeRow(Struct struct) throws SQLException {
        Object object;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeRow(Struct) entered");
        }
        this.isNull = false;
        String string = struct.getSQLTypeName();
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79770, this.conn);
        }
        if (!this.isTyped) {
            object = this.getTypeInfoVector(string);
            this.setTypeInfoVector((Vector)object);
        }
        if (((Object[])(object = struct.getAttributes())).length == 0) {
            throw IfxErrMsg.getSQLException(-79792, this.conn);
        }
        for (int i = 0; i < ((Object[])object).length; ++i) {
            int n;
            if (object[i] == null) {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(1, "  writeRow() obj[" + i + "] is null");
                }
                this.atNextType = this.getNextType(49, 0, null, i);
                n = this.currentIfxType;
            } else {
                n = this.getIfxType(object[i], this.isTyped);
            }
            this.writeElement(object[i], n);
        }
        this.writeElementOffset();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, " dump from writeRow(Struct): ");
            this.trace.writeTrace(2, " ****** begin parentTypeInfoVector information *****");
            IfxComplex.dumpTypeInfoVector(this.parentTypeInfoVector, this.trace, 4);
            this.trace.writeTrace(2, " ****** end parentTypeInfoVector information *****");
            this.trace.writeTrace(1, "IfxComplexOutput(): writeRow(Struct) exited");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeCollection(Collection collection) throws SQLException {
        int n;
        block10: {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(1, "IfxComplexOutput(): writeCollection(Collection) entered");
                if (collection != null) {
                    this.trace.writeTrace(2, "    writeCollection(Collection) class: " + collection.getClass().getName());
                }
            }
            if (collection == null) {
                this.addParentTypeInfoHeader(20, "");
                this.isNull = true;
                return;
            }
            n = this.getOverrideIfxType(collection);
            this.isNull = false;
            Iterator iterator = collection.iterator();
            if (!iterator.hasNext()) {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(2, "    writeCollection(Collection) EMPTY COLLECTION");
                }
                this.addTypeAndOffsetInfo(49, 0, null);
            } else {
                Object e = iterator.next();
                if (e == null) {
                    throw IfxErrMsg.getSQLException(-1225, this.conn);
                }
                Class<?> clazz = e.getClass();
                int n2 = this.getIfxType(e, this.isTyped);
                do {
                    if (e.getClass() != clazz) {
                        throw IfxErrMsg.getSQLException(-79780, this.conn);
                    }
                    this.writeElement(e, n2);
                    if (!iterator.hasNext()) break block10;
                } while ((e = iterator.next()) != null);
                throw IfxErrMsg.getSQLException(-1225, this.conn);
            }
        }
        this.addParentTypeInfoHeader(n, "");
        this.writeElementOffset();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, " dump from writeCollection(Collection): ");
            this.trace.writeTrace(2, " ****** begin dump parentTypeInfoVector information *****");
            IfxComplex.dumpTypeInfoVector(this.parentTypeInfoVector, this.trace, 4);
            this.trace.writeTrace(2, " ****** end dump parentTypeInfoVector information *****");
            this.trace.writeTrace(2, "");
            this.trace.writeTrace(1, "IfxComplexOutput(): writeCollection(Collection) exited");
        }
    }

    void writeCollection(Array array) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeCollection(Array) entered");
        }
        if (array == null) {
            this.addParentTypeInfoHeader(20, "");
            this.isNull = true;
            return;
        }
        Object object = array.getArray(this.typeMap);
        if (object != null) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "  baseType: " + array.getBaseType());
                this.trace.writeTrace(2, "  baseTypeName: " + array.getBaseTypeName());
            }
            Class<?> clazz = object.getClass().getComponentType();
            int n = array.getBaseType();
            switch (n) {
                case 16: 
                case 1111: {
                    if (clazz.equals(Boolean.TYPE)) {
                        this.writePrimitiveArray((boolean[])object);
                        break;
                    }
                    this.writeArray((Object[])object, n);
                    break;
                }
                case 4: {
                    if (!clazz.equals(Integer.TYPE)) {
                        throw IfxErrMsg.getSQLException(-79793, this.conn);
                    }
                    this.writePrimitiveArray((int[])object);
                    break;
                }
                case 5: {
                    if (!clazz.equals(Short.TYPE)) {
                        throw IfxErrMsg.getSQLException(-79793, this.conn);
                    }
                    this.writePrimitiveArray((short[])object);
                    break;
                }
                case -5: {
                    if (!clazz.equals(Long.TYPE)) {
                        throw IfxErrMsg.getSQLException(-79793, this.conn);
                    }
                    this.writePrimitiveArray((long[])object);
                    break;
                }
                case 6: {
                    if (!clazz.equals(Float.TYPE)) {
                        throw IfxErrMsg.getSQLException(-79793, this.conn);
                    }
                    this.writePrimitiveArray((float[])object);
                    break;
                }
                case 8: {
                    if (!clazz.equals(Double.TYPE)) {
                        throw IfxErrMsg.getSQLException(-79793, this.conn);
                    }
                    this.writePrimitiveArray((double[])object);
                    break;
                }
                default: {
                    this.writeArray((Object[])object, n);
                    break;
                }
            }
        } else {
            this.isNull = true;
        }
        this.addParentTypeInfoHeader(this.getOverrideIfxType(array), "");
        this.writeElementOffset();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, " dump from writeCollection(Array): ");
            this.trace.writeTrace(2, " ****** begin dump parentTypeInfoVector information *****");
            IfxComplex.dumpTypeInfoVector(this.parentTypeInfoVector, this.trace, 4);
            this.trace.writeTrace(2, " ****** end dump parentTypeInfoVector information *****");
            this.trace.writeTrace(2, "");
            this.trace.writeTrace(1, "IfxComplexOutput(): writeCollection(Array) exited");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeArray(Array array) throws SQLException {
        Object object;
        IfxComplexOutput ifxComplexOutput;
        block22: {
            Object object2;
            block21: {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(1, "IfxComplexOutput(): writeArray(Array) entered");
                }
                if (!this.isRow && array == null) {
                    throw IfxErrMsg.getSQLException(-1225, this.conn);
                }
                if (array != null) {
                    this.addTypeAndOffsetInfo(this.getOverrideIfxType(array), 0, null);
                } else {
                    this.addTypeAndOffsetInfo(20, 0, null);
                }
                ifxComplexOutput = null;
                ifxComplexOutput = this.isTyped ? new IfxComplexOutput(false, true, this.typeInfoVector.get(this.typeIndex), this.conn) : new IfxComplexOutput(false, true, this.conn);
                Map<String, Class<?>> map = this.conn.getTypeMap();
                object2 = array.getArray(map);
                if (object2 == null) {
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(2, "************ NULL COLLECTION **********");
                    }
                    this.addElementOffset(this.currentIfxType);
                    this.writeNestedData(ifxComplexOutput);
                    return;
                }
                this.isNull = false;
                Class<?> clazz = object2.getClass().getComponentType();
                if (!clazz.isPrimitive()) break block21;
                switch (array.getBaseType()) {
                    case 16: 
                    case 1111: {
                        if (!clazz.equals(Boolean.TYPE)) throw IfxErrMsg.getSQLException(-79728, this.conn);
                        ifxComplexOutput.writePrimitiveArray((boolean[])object2);
                        break block22;
                    }
                    case 5: {
                        ifxComplexOutput.writePrimitiveArray((short[])object2);
                        break block22;
                    }
                    case 4: {
                        ifxComplexOutput.writePrimitiveArray((int[])object2);
                        break block22;
                    }
                    case -5: {
                        ifxComplexOutput.writePrimitiveArray((long[])object2);
                        break block22;
                    }
                    case 6: {
                        ifxComplexOutput.writePrimitiveArray((float[])object2);
                        break block22;
                    }
                    case 8: {
                        ifxComplexOutput.writePrimitiveArray((double[])object2);
                        break block22;
                    }
                    default: {
                        throw IfxErrMsg.getSQLException(-79728, this.conn);
                    }
                }
            }
            Object[] objectArray = (Object[])object2;
            object = objectArray[0].getClass();
            int n = this.getIfxType(objectArray[0], ifxComplexOutput.getIsTyped());
            for (int i = 0; i < objectArray.length; ++i) {
                if (object != objectArray[i].getClass()) {
                    throw IfxErrMsg.getSQLException(-79780, this.conn);
                }
                this.addElementOffset(n);
                ifxComplexOutput.writeElement(objectArray[i], n);
            }
        }
        ifxComplexOutput.writeElementOffset();
        this.writeNestedData(ifxComplexOutput);
        if (!this.isTyped) {
            IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)this.typeInfoVector.lastElement();
            if (ifxColumnInfo.child != null) {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(1, "   writeNestedCollection(Collection) last element already has a child element");
                }
                if (this.isUnknownType((IfxColumnInfo)ifxColumnInfo.child.get(0))) {
                    ifxColumnInfo.child = ifxComplexOutput.getTypeInfoVector();
                }
            } else {
                ifxColumnInfo.child = ifxComplexOutput.getTypeInfoVector();
            }
            object = (IfxColumnInfo)ifxColumnInfo.child.get(0);
            ((IfxColumnInfo)object).Nullable = 0;
        }
        if (!TraceFlag.compiletrace) return;
        this.trace.writeTrace(1, "IfxComplexOutput(): writeArray(Array) exited");
    }

    private void writeArray(Object[] objectArray, int n) throws SQLException {
        int n2 = 0;
        int n3 = 49;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeArray(Object[], int) entered");
            this.trace.writeTrace(2, "    baseType: " + n);
        }
        if (objectArray == null) {
            return;
        }
        n2 = objectArray.length;
        if (n2 == 0) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    writeArray(Object [] x) EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(0, 1, null);
            return;
        }
        if (objectArray[0] == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "    size = " + n2);
        }
        Class<?> clazz = objectArray[0].getClass();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "    writeArray() class[0]: " + clazz.getName());
        }
        n3 = this.getIfxType(objectArray[0], this.isTyped);
        for (int i = 0; i < n2; ++i) {
            if (objectArray[i] == null) {
                throw IfxErrMsg.getSQLException(-1225, this.conn);
            }
            if (objectArray[i].getClass() != clazz) {
                throw IfxErrMsg.getSQLException(-79780, this.conn);
            }
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    writeArray() x[i].class: " + objectArray[i].getClass().getName());
                this.trace.writeTrace(2, "    writeArray() ifxType: " + n3);
            }
            this.writeElement(objectArray[i], n3);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeArray(Object[], int) exited");
        }
    }

    private void writeElement(Object object, int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeElement(Object, int) entered");
            if (object != null) {
                this.trace.writeTrace(1, "  writeElement(): Class: " + object.getClass());
            }
            this.trace.writeTrace(1, "  writeElement(): ifxType: " + n);
        }
        switch (n) {
            case 0: 
            case 13: 
            case 15: 
            case 16: 
            case 43: {
                this.writeString((String)object);
                break;
            }
            case 1: {
                if (object == null) {
                    this.writeShort((short)Short.MIN_VALUE);
                    break;
                }
                this.writeShort((Short)object);
                break;
            }
            case 2: 
            case 6: {
                if (object == null) {
                    this.writeInt(Integer.MIN_VALUE);
                    break;
                }
                this.writeInt((Integer)object);
                break;
            }
            case 3: {
                if (object == null) {
                    this.writeDoubleNull();
                    break;
                }
                this.writeDouble((Double)object);
                break;
            }
            case 4: {
                if (object == null) {
                    this.writeFloat(IfxSmallFloat.getIfxNull());
                    break;
                }
                this.writeFloat(((Float)object).floatValue());
                break;
            }
            case 5: 
            case 8: {
                this.writeBigDecimal((BigDecimal)object);
                break;
            }
            case 7: {
                this.writeDate((Date)object);
                break;
            }
            case 10: {
                if (object instanceof Time) {
                    this.writeTime((Time)object);
                    break;
                }
                this.writeTimestamp((Timestamp)object);
                break;
            }
            case 14: {
                if (object instanceof String) {
                    this.writeString((String)object);
                    break;
                }
                if (object == null || object instanceof IntervalDF) {
                    this.writeIntervalDF((IntervalDF)object);
                    break;
                }
                this.writeIntervalYM((IntervalYM)object);
                break;
            }
            case 17: 
            case 18: {
                if (object == null) {
                    this.writeLong(Long.MIN_VALUE);
                    break;
                }
                this.writeLong((Long)object);
                break;
            }
            case 52: {
                if (object == null) {
                    this.writeLongBigint(Long.MIN_VALUE, 52);
                    break;
                }
                this.writeLongBigint((Long)object, 52);
                break;
            }
            case 53: {
                if (object == null) {
                    this.writeLongBigint(Long.MIN_VALUE, 53);
                } else {
                    this.writeLongBigint((Long)object, 53);
                }
            }
            case 102: {
                this.writeBlob((Blob)object);
                break;
            }
            case 101: {
                this.writeClob((Clob)object);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                if (object == null || object instanceof Collection) {
                    this.writeNestedCollection((Collection)object);
                    break;
                }
                Array array = null;
                array = object.getClass().isArray() ? new IfxArray(object, this.conn) : (Array)object;
                this.writeArray(array);
                break;
            }
            case 22: {
                if (object == null || object instanceof Struct) {
                    this.writeStruct((Struct)object);
                    break;
                }
                if (!(object instanceof SQLData)) break;
                this.writeNestedRow((SQLData)object);
                break;
            }
            case 40: 
            case 41: 
            case 44: {
                this.writeUDT(object);
                break;
            }
            case 45: {
                if (object == null) {
                    this.writeBoolean((byte)-1);
                    break;
                }
                this.writeBoolean((Boolean)object);
                break;
            }
            default: {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(2, "writeElement() bad type in switch");
                }
                throw IfxErrMsg.getSQLException(-79777, this.conn);
            }
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeElement() exited");
        }
    }

    private int getIfxType(Object object, boolean bl) throws SQLException {
        int n = 49;
        Class<?> clazz = object.getClass();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): getIfxType(Object) entered");
            this.trace.writeTrace(1, "    getIfxType() isTyped: " + bl);
        }
        if (object instanceof Clob) {
            n = 101;
        } else if (object instanceof Blob) {
            n = 102;
        } else if (object instanceof Struct) {
            n = 22;
        } else if (object instanceof Array) {
            n = this.getOverrideIfxType(object);
        } else {
            try {
                n = IfxTypes.FromJavaToIfxType(clazz.getName());
                if (n == 49 && clazz.isArray()) {
                    n = 20;
                }
                if (IfxTypes.isCollection(n)) {
                    int n2 = n;
                    n = this.getOverrideIfxType(object);
                    if (n == 49) {
                        n = n2;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "    getIfxType(Object, boolean) ifxType: " + n);
        }
        if (n == 49) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    getIfxType(Object, boolean) type is unknown");
            }
            if (object instanceof SQLData) {
                String string = ((SQLData)object).getSQLTypeName();
                if (string == null || string == "") {
                    throw IfxErrMsg.getSQLException(-79770, this.conn);
                }
                IfxUDTInfo ifxUDTInfo = this.conn.getUDTInfo((IfxColumnInfo)null, string);
                if (ifxUDTInfo == null) {
                    throw IfxErrMsg.getSQLException(-79770, this.conn);
                }
                if (ifxUDTInfo.JDBCtype == 2002) {
                    IfxResultSetMetaData ifxResultSetMetaData;
                    n = 22;
                    if (!bl && (ifxResultSetMetaData = ifxUDTInfo.structInfo) != null) {
                        this.typeInfoVector = ifxResultSetMetaData.getColumnInfoVector();
                    }
                } else {
                    n = 40;
                }
            } else {
                throw IfxErrMsg.getSQLException(-79728, this.conn);
            }
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "    IfxType = " + n);
            this.trace.writeTrace(1, "IfxComplexOutput(): getIfxType(Object, boolean) exited");
        }
        return n;
    }

    void writePrimitiveArray(boolean[] blArray) throws SQLException {
        int n = blArray.length;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writePrimitiveArray(boolean[]) entered");
        }
        if (n == 0) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    writePrimitiveArray(boolean [] arr) EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(45, 1, null);
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.writeBoolean(blArray[i]);
        }
        this.writeElementOffset();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writePrimitiveArray(boolean[]) exited");
        }
    }

    void writePrimitiveArray(int[] nArray) throws SQLException {
        int n = nArray.length;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writePrimitiveArray(int[]) entered");
        }
        if (n == 0) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    writePrimitiveArray(int [] arr) EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(2, 4, null);
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.writeInt(nArray[i]);
        }
        this.writeElementOffset();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writePrimitiveArray(int[]) exited");
        }
    }

    void writePrimitiveArray(short[] sArray) throws SQLException {
        int n = sArray.length;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writePrimitiveArray(short[]) entered");
        }
        if (n == 0) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    writePrimitiveArray(short [] arr) EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(1, 2, null);
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.writeShort(sArray[i]);
        }
        this.writeElementOffset();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writePrimitiveArray(short[]) exited");
        }
    }

    void writePrimitiveArray(long[] lArray) throws SQLException {
        int n = lArray.length;
        int n2 = 0;
        int n3 = 0;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writePrimitiveArray(long[]) entered");
        }
        if (!this.conn.getIsBigInt() && !this.conn.getIsBigSerial()) {
            n2 = 17;
            n3 = 10;
        } else if (this.conn.getIsBigInt() && !this.conn.getIsBigSerial()) {
            n2 = 52;
            n3 = 8;
        } else if (!this.conn.getIsBigInt() && this.conn.getIsBigSerial()) {
            n2 = 53;
            n3 = 8;
        }
        if (n == 0) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    writePrimitiveArray(long [] arr) EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(n2, n3, null);
            return;
        }
        for (int i = 0; i < n; ++i) {
            if (n2 == 17) {
                this.writeLong(lArray[i]);
                continue;
            }
            this.writeLongBigint(lArray[i], n2);
        }
        this.writeElementOffset();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writePrimitiveArray(long[]) exited");
        }
    }

    void writePrimitiveArray(float[] fArray) throws SQLException {
        int n = fArray.length;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writePrimitiveArray(float[]) entered");
        }
        if (n == 0) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    writePrimitiveArray(float [] arr) EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(4, 4, null);
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.writeFloat(fArray[i]);
        }
        this.writeElementOffset();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writePrimitiveArray(float[]) exited");
        }
    }

    void writePrimitiveArray(double[] dArray) throws SQLException {
        int n = dArray.length;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writePrimitiveArray(double[]) entered");
        }
        if (n == 0) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    writePrimitiveArray(double [] arr) EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(3, 8, null);
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.writeDouble(dArray[i]);
        }
        this.writeElementOffset();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writePrimitiveArray(double[]) exited");
        }
    }

    byte[] getSerializedTypeInfo() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): getSerializedTypeInfo() entered");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.parentTypeInfoVector == null) {
            throw IfxErrMsg.getSQLException(-79716, "getSerializedTypeInfo())", this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "");
            this.trace.writeTrace(99, "***** begin serialized type info *****");
        }
        this.typeInfoCount = 0;
        this.serializeTypeInfo(byteArrayOutputStream, this.parentTypeInfoVector, (short)0, (short)0, false);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "***** end serialized type info *****");
            this.trace.writeTrace(99, "");
            this.trace.writeTrace(99, "    bTypeStream.size(): " + byteArrayOutputStream.size());
            this.trace.writeTrace(1, "IfxComplexOutput(): getSerializedTypeInfo() exited");
        }
        return byteArrayOutputStream.toByteArray();
    }

    private short serializeTypeInfo(ByteArrayOutputStream byteArrayOutputStream, Vector vector, short s, short s2, boolean bl) throws SQLException {
        short s3 = s;
        int n = vector.size();
        IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)vector.get(0);
        s = (short)(s + 1);
        short s4 = bl ? (short)1 : 0;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "");
            this.trace.writeTrace(99, "    serializeTypeInfo isRow: " + bl);
        }
        for (int i = 0; i < n; ++i) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(99, "");
                this.trace.writeTrace(99, "    serializeTypeInfo(). i = " + i);
            }
            ++this.typeInfoCount;
            ifxColumnInfo = (IfxColumnInfo)vector.get(i);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(99, "    seqno: " + s);
            }
            byte[] byArray = JavaToIfxType.JavaToIfxSmallInt(s);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(99, "    levelno:  " + s2);
            }
            byArray = JavaToIfxType.JavaToIfxSmallInt(s2);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(99, "    parentno: " + s3);
            }
            byArray = JavaToIfxType.JavaToIfxSmallInt(s3);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(99, "    ColName: " + ifxColumnInfo.ColName);
            }
            this.serializeString(ifxColumnInfo.ColName, this.identsize, byteArrayOutputStream);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(99, "    fieldno: " + s4);
            }
            byArray = JavaToIfxType.JavaToIfxSmallInt(s4);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            short s5 = (short)ifxColumnInfo.SQLtype;
            if (ifxColumnInfo.Nullable == 0) {
                s5 = (short)(s5 | 0x100);
            }
            if (ifxColumnInfo.IsNamedRow) {
                s5 = (short)(s5 | 0x1000);
            }
            if (ifxColumnInfo.IsDistinct) {
                s5 = (short)(s5 | 0x800);
            }
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(99, "    SQLtype: " + s5 + "  name: " + IfxTypes.IfxTypeToName(ifxColumnInfo.SQLtype));
            }
            byArray = JavaToIfxType.JavaToIfxSmallInt(s5);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(99, "    ColLength: " + ifxColumnInfo.ColLength);
            }
            byArray = JavaToIfxType.JavaToIfxSmallInt((short)ifxColumnInfo.ColLength);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(99, "    ExtendedId: " + ifxColumnInfo.ExtendedId);
            }
            byArray = JavaToIfxType.JavaToIfxInt(ifxColumnInfo.ExtendedId);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(99, "    Flags: 0");
            }
            byArray = JavaToIfxType.JavaToIfxSmallInt((short)0);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(99, "    ExtendedName: " + ifxColumnInfo.ExtendedName);
            }
            this.serializeString(ifxColumnInfo.ExtendedName, this.identsize, byteArrayOutputStream);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(99, "    ExtendedOwner: " + ifxColumnInfo.ExtendedOwner);
            }
            this.serializeString(ifxColumnInfo.ExtendedOwner, this.identsize, byteArrayOutputStream);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(99, "    Alignment: " + ifxColumnInfo.Alignment);
            }
            byArray = JavaToIfxType.JavaToIfxSmallInt(ifxColumnInfo.Alignment);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(99, "    SourceType: " + ifxColumnInfo.SourceType);
            }
            byArray = JavaToIfxType.JavaToIfxInt(ifxColumnInfo.SourceType);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            if (ifxColumnInfo.child != null) {
                s = this.serializeTypeInfo(byteArrayOutputStream, ifxColumnInfo.child, s, (short)(s2 + 1), (ifxColumnInfo.SQLtype & 0xFF) == 22);
            }
            if (i + 1 != n) {
                s = (short)(s + 1);
            }
            if (!bl) continue;
            s4 = (short)(s4 + 1);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): serializeTypeInfo() exited");
        }
        return s;
    }

    private void serializeString(String string, short s, ByteArrayOutputStream byteArrayOutputStream) throws SQLException {
        short s2 = 0;
        s2 = string == null ? (short)0 : (short)string.length();
        byte[] byArray = JavaToIfxType.JavaToIfxSmallInt(s2);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        String string2 = stringUtil.fixLength(string, s, ' ');
        try {
            byArray = stringUtil.getBytes(string2, this.conn);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        byteArrayOutputStream.write(byArray, 0, byArray.length);
    }

    int getTypeCount() {
        return this.typeInfoCount;
    }

    private int getElementOffsetCount() {
        int n = 0;
        if (this.elementOffsetVector != null && !this.elementOffsetVector.isEmpty()) {
            n = this.elementOffsetVector.size() + 1;
        }
        return n;
    }

    private Vector getTypeInfoVector() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): getTypeInfoVector() called");
            this.trace.writeTrace(3, "   isTyped: " + this.isTyped);
            this.trace.writeTrace(3, "   isNull: " + this.isNull);
            if (this.parentTypeInfoVector == null) {
                this.trace.writeTrace(3, "   parentTypeInfoVector is null");
            } else {
                this.trace.writeTrace(3, "   parentTypeInfoVector is NOT null");
            }
            if (this.typeInfoVector == null) {
                this.trace.writeTrace(3, "   typeInfoVector is null");
            } else {
                this.trace.writeTrace(3, "   typeInfoVector is NOT null");
            }
        }
        Vector vector = null;
        if (this.parentTypeInfoVector != null) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, " getTypeInfoVector() returns parentVector");
            }
            vector = this.parentTypeInfoVector;
        } else if (this.isTyped) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, " getTypeInfoVector() throwing exception");
            }
            throw IfxErrMsg.getSQLException(-79716, "getTypeInfoVector() parentTypeInfo is null", this.conn);
        }
        if (this.typeInfoVector.size() == 0) {
            if (!this.isTyped) {
                if (!this.isNull) {
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(1, "    getTypeInfoVector() EMPTY COLL");
                    }
                    this.addTypeAndOffsetInfo(49, 0, null);
                    if (this.parentTypeInfoVector != null) {
                        IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)this.parentTypeInfoVector.get(0);
                        ifxColumnInfo.child = this.typeInfoVector;
                    }
                }
            } else {
                throw IfxErrMsg.getSQLException(-79716, "getTypeInfoVector() typeInfoVector is null", this.conn);
            }
        }
        if (vector == null) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(1, "  getTypeInfoVector() returning typeInfoVector");
            }
            vector = this.typeInfoVector;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, " dump from getTypeInfoVector(): ");
            this.trace.writeTrace(2, " ****** begin dump (v) type information *****");
            IfxComplex.dumpTypeInfoVector(vector, this.trace, 4);
            this.trace.writeTrace(2, " ****** end dump (v) type information *****");
            this.trace.writeTrace(1, "IfxComplexOutput(): getTypeInfoVector() exited");
        }
        return vector;
    }

    private void setTypeInfoVector(Vector vector) {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): setTypeInfoVector() called");
        }
        if (this.isTyped) {
            return;
        }
        this.parentTypeInfoVector = vector;
        this.typeInfoVector = ((IfxColumnInfo)vector.get((int)0)).child;
        if (TraceFlag.compiletrace) {
            if (this.parentTypeInfoVector == null) {
                this.trace.writeTrace(3, "   setTypeInfoVector() parentTypeInfoVector is null");
            }
            if (this.typeInfoVector == null) {
                this.trace.writeTrace(3, "   setTypeInfoVector() typeInfoVector is null");
            }
        }
        this.isTyped = true;
    }

    private void addParentTypeInfoHeader(int n, String string) {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): addParentTypeInfoHeader() called");
            this.trace.writeTrace(2, "addTypeInfoHeader() ifxType: " + n);
            this.trace.writeTrace(2, "addTypeInfoHeader() name: " + string);
            this.trace.writeTrace(2, "addTypeInfoHeader() isRow: " + this.isRow);
            this.trace.writeTrace(2, "addTypeInfoHeader() isNull: " + this.isNull);
            if (this.typeInfoVector == null) {
                this.trace.writeTrace(2, "addTypeInfoHeader() typeInfoVector is null");
            } else {
                this.trace.writeTrace(2, " dump from addTypeAndOffsetInfo(): ");
                this.trace.writeTrace(2, " ****** begin dump typeInfoVector *****");
                IfxComplex.dumpTypeInfoVector(this.typeInfoVector, this.trace, 4);
                this.trace.writeTrace(2, " ****** end dump typeInfoVector *****");
            }
        }
        if (this.isRow) {
            return;
        }
        IfxColumnInfo ifxColumnInfo = new IfxColumnInfo();
        ifxColumnInfo.SQLtype = n;
        ifxColumnInfo.ExtendedName = string;
        if (!this.isNull) {
            ifxColumnInfo.child = this.typeInfoVector;
            if (IfxTypes.isCollection(n)) {
                ((IfxColumnInfo)this.typeInfoVector.get((int)0)).Nullable = 0;
            }
        }
        Vector<IfxColumnInfo> vector = new Vector<IfxColumnInfo>(1);
        vector.addElement(ifxColumnInfo);
        this.parentTypeInfoVector = vector;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, " dump from addParentTypeInfoHeader(): ");
            this.trace.writeTrace(2, " ****** begin dump parentTypeInfoVector *****");
            IfxComplex.dumpTypeInfoVector(this.parentTypeInfoVector, this.trace, 4);
            this.trace.writeTrace(2, " ****** end dump parentTypeInfoVector *****");
            this.trace.writeTrace(1, "IfxComplexOutput(): addParentTypeInfoHeader() exited");
        }
    }

    private void writeNestedData(IfxComplexOutput ifxComplexOutput) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeNestedData() entered");
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "  writeNestedData() isNull: " + ifxComplexOutput.isNull());
        }
        byte[] byArray = null;
        try {
            byArray = this.getNestedHeader(this.bStream.size(), ifxComplexOutput.length(), ifxComplexOutput.isNull);
            this.os.write(byArray, 0, byArray.length);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "writeNestedData().headersize " + byArray.length);
            }
            if (!ifxComplexOutput.isNull) {
                byArray = ifxComplexOutput.toByteArray();
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(2, "writeNestedData().data size " + byArray.length);
                }
                this.os.write(byArray, 0, byArray.length);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeNestedData() exited");
        }
    }

    private boolean isUnknownType(IfxColumnInfo ifxColumnInfo) {
        if (ifxColumnInfo.SQLtype == 49) {
            return true;
        }
        if (ifxColumnInfo.child != null) {
            return this.isUnknownType((IfxColumnInfo)ifxColumnInfo.child.get(0));
        }
        return false;
    }

    @Override
    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        BigDecimal bigDecimal2 = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeBigDecimal() entered");
            this.trace.writeTrace(2, "    writeBigDecimal() x = " + bigDecimal);
            this.trace.writeTrace(2, "    writeBigDecimal() isRow = " + this.isRow);
        }
        if (!this.isRow && bigDecimal == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        if (this.isTyped) {
            byte[] byArray;
            this.addTypeAndOffsetInfo(5, this.currentIfxLength, null);
            int n = IfxDecimal.precDec(this.currentIfxLength);
            int n2 = IfxDecimal.precTot(this.currentIfxLength);
            if (n == 255) {
                n = n2;
            }
            if (bigDecimal != null) {
                bigDecimal2 = bigDecimal.setScale(n, 4);
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(2, "    writeBigDecimal() tmpBD = " + bigDecimal2);
                    this.trace.writeTrace(2, "    writeBigDecimal() currentIfxLength = " + this.currentIfxLength);
                }
                IfxDecimal ifxDecimal = new IfxDecimal();
                ifxDecimal.setConnection(this.conn);
                ifxDecimal.fromDecimal(bigDecimal2, n, (short)this.currentIfxLength);
                byArray = ifxDecimal.toIfx();
            } else {
                byArray = JavaToIfxType.JavaToIfxDecimalNull((short)this.currentIfxLength);
            }
            try {
                this.os.write(byArray, 2, byArray.length - 2);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            String string = bigDecimal.toString();
            this.writeString(string);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeBigDecimal() exited");
        }
    }

    @Override
    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeBinaryStream(InputStream).", this.conn);
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        IfxObject ifxObject = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeBlob() entered");
        }
        if (!this.isRow && blob == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(41, 72, "blob");
        ifxObject = IfxValue.makeInstanceFromIfxType(this.conn, 102);
        if (!((IfxSmBlob)ifxObject).LOB_ELEMENT_COLL) {
            ((IfxSmBlob)ifxObject).LOB_ELEMENT_COLL = true;
        }
        ifxObject.fromBlob(blob);
        byte[] byArray = ifxObject.toIfxTuple();
        try {
            this.os.write(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeBlob() exited");
        }
    }

    private void writeBoolean(byte by) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeBoolean(byte) entered");
            this.trace.writeTrace(2, "    writeBoolean() x = " + by);
        }
        try {
            this.addTypeAndOffsetInfo(45, 1, null);
            if (by == -1) {
                this.os.writeByte(1);
                this.os.writeInt(0);
            } else {
                this.os.writeByte(0);
                this.os.writeInt(1);
                this.os.writeByte(by);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeBoolean() exited");
        }
    }

    @Override
    public void writeBoolean(boolean bl) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeBoolean(boolean) entered");
            this.trace.writeTrace(2, "    writeBoolean() x = " + bl);
        }
        byte by = bl ? (byte)1 : 0;
        this.writeBoolean(by);
    }

    @Override
    public void writeByte(byte by) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeByte(byte).", this.conn);
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        IfxObject ifxObject = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeClob() entered");
        }
        if (!this.isRow && clob == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(41, 72, "clob");
        ifxObject = IfxValue.makeInstanceFromIfxType(this.conn, 101);
        if (!((IfxSmBlob)ifxObject).LOB_ELEMENT_COLL) {
            ((IfxSmBlob)ifxObject).LOB_ELEMENT_COLL = true;
        }
        ifxObject.fromClob(clob);
        byte[] byArray = ifxObject.toIfxTuple();
        try {
            this.os.write(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeClob() exited");
        }
    }

    @Override
    public void writeDate(Date date) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeDate() entered");
            this.trace.writeTrace(2, "    writeDate() x = " + date);
        }
        if (!this.isRow && date == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(7, 4, null);
        if (date == null) {
            try {
                this.os.writeInt(Integer.MIN_VALUE);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        } else {
            super.writeDate(date);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeDate() exited");
        }
    }

    public void writeDoubleNull() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeDoubleNull() entered");
        }
        if (!this.isRow) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(3, 8, null);
        try {
            byte[] byArray = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
            this.os.write(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeDoubleNull() exited");
        }
    }

    @Override
    public void writeDouble(double d) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeDouble() entered");
            this.trace.writeTrace(2, "    writeDouble() x = " + d);
        }
        if (!this.isRow && IfxFloat.isIfxNull(d)) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(3, 8, null);
        super.writeDouble(d);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeDouble() exited");
        }
    }

    @Override
    public void writeFloat(float f) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeFloat() entered");
            this.trace.writeTrace(2, "    writeFloat() x = " + f);
        }
        if (!this.isRow && IfxSmallFloat.isIfxNull(f)) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(4, 4, null);
        try {
            this.os.writeReal(f);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeFloat() exited");
        }
    }

    @Override
    public void writeLong(long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeLong() entered");
            this.trace.writeTrace(2, "    writeLong() x = " + l);
        }
        this.addTypeAndOffsetInfo(17, 10, null);
        try {
            this.os.writeLongInt(l);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeLong() exited");
        }
    }

    @Override
    public void writeShort(short s) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeShort() entered");
            this.trace.writeTrace(2, "    writeShort() x = " + s);
        }
        this.addTypeAndOffsetInfo(1, 2, null);
        try {
            this.os.writeSmallInt(s);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeShort() exited");
        }
    }

    @Override
    public void writeTime(Time time) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writetime() entered");
            this.trace.writeTrace(2, "    writeTime() x = " + time);
        }
        IfxDateTime ifxDateTime = new IfxDateTime(time);
        this.addTypeAndOffsetInfo(10, ifxDateTime.getEncodedLength(), null);
        try {
            byte[] byArray = null;
            byArray = time == null ? JavaToIfxType.JavaToIfxDecimalNull(ifxDateTime.getEncodedLength()) : ifxDateTime.toIfx();
            this.os.write(byArray, 2, byArray.length - 2);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeTime() exited");
        }
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeTimestamp() entered");
            this.trace.writeTrace(2, "    writeTimestamp() x = " + timestamp);
        }
        IfxDateTime ifxDateTime = new IfxDateTime(timestamp);
        this.addTypeAndOffsetInfo(10, ifxDateTime.getEncodedLength(), null);
        try {
            byte[] byArray = null;
            byArray = timestamp == null ? JavaToIfxType.JavaToIfxDecimalNull(ifxDateTime.getEncodedLength()) : ifxDateTime.toIfx();
            this.os.write(byArray, 2, byArray.length - 2);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeTimestamp() exited");
        }
    }

    @Override
    public void writeInterval(Interval interval) throws SQLException {
        if (interval == null || interval instanceof IntervalDF) {
            this.writeIntervalDF((IntervalDF)interval);
        } else if (interval instanceof IntervalYM) {
            this.writeIntervalYM((IntervalYM)interval);
        } else {
            throw IfxErrMsg.getSQLException(-79714, this.conn);
        }
    }

    void writeIntervalDF(IntervalDF intervalDF) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeIntervalDF() entered");
            this.trace.writeTrace(2, "    writeIntervalDF() x = " + intervalDF);
        }
        short s = 0;
        if (intervalDF != null) {
            s = intervalDF.getQualifier();
        }
        this.addTypeAndOffsetInfo(14, s, null);
        IfxIntervalDF ifxIntervalDF = new IfxIntervalDF(intervalDF);
        ifxIntervalDF.setConnection(this.conn);
        if (intervalDF == null && this.isTyped) {
            ifxIntervalDF.setEncodedLength(this.currentIfxLength);
        }
        try {
            byte[] byArray = ifxIntervalDF.toIfxTuple();
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    writeIntervalDF() toIfxTuple() data");
                this.trace.writeTrace(2, byArray, 'H');
            }
            this.os.write(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeIntervalDF() exited");
        }
    }

    void writeIntervalYM(IntervalYM intervalYM) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeIntervalYM() entered");
            this.trace.writeTrace(2, "    writeIntervalYM() x = " + intervalYM);
        }
        short s = 0;
        if (intervalYM != null) {
            s = intervalYM.getQualifier();
        }
        this.addTypeAndOffsetInfo(14, s, null);
        IfxIntervalYM ifxIntervalYM = new IfxIntervalYM(intervalYM);
        ifxIntervalYM.setConnection(this.conn);
        if (intervalYM == null && this.isTyped) {
            ifxIntervalYM.setEncodedLength(this.currentIfxLength);
        }
        try {
            byte[] byArray = ifxIntervalYM.toIfxTuple();
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    writeIntervalYM() toIfxTuple() data");
                this.trace.writeTrace(2, byArray, 'H');
            }
            this.os.write(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeIntervalYM() exited");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getNextType(int n, int n2, String string, int n3) throws SQLException {
        boolean bl = true;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput.getNextType(type: " + n + " len " + n2 + " name " + string + ") entered");
            this.trace.writeTrace(2, "    getNextType isRow: " + this.isRow);
            this.trace.writeTrace(2, "    getNextType typeIndex: " + this.typeIndex);
            this.trace.writeTrace(2, "    getNextType atNextType: " + this.atNextType);
        }
        if (!this.isRow && this.typeIndex >= 0 && n3 == 0) {
            return bl;
        }
        if (this.atNextType && n3 == 0) {
            this.atNextType = false;
            return bl;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "    getNextType type: " + n);
            this.trace.writeTrace(2, "    getNextType name: " + string);
            this.trace.writeTrace(2, "    getNextType typeIndex: " + this.typeIndex);
            this.trace.writeTrace(2, "    getNextType typeInfoVector.size(): " + this.typeInfoVector.size());
        }
        ++this.typeIndex;
        this.typeChildIndex = n3;
        if (this.typeIndex < this.typeInfoVector.size()) {
            IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex);
            if (ifxColumnInfo.SQLtype == 22 && ifxColumnInfo.child != null && ifxColumnInfo.child.size() >= n3) {
                ifxColumnInfo = (IfxColumnInfo)ifxColumnInfo.child.get(this.typeChildIndex++);
                bl = false;
            }
            this.currentIfxType = ifxColumnInfo.SQLtype;
            this.currentExtendedId = ifxColumnInfo.ExtendedId;
            this.currentIfxLength = ifxColumnInfo.ColLength;
        } else {
            if (this.typeIndex != this.typeInfoVector.size()) throw IfxErrMsg.getSQLException(-79772, this.conn);
            IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)this.typeInfoVector.get(this.typeIndex - 1);
            if (ifxColumnInfo.SQLtype != 22 || ifxColumnInfo.child == null || ifxColumnInfo.child.size() < n3) throw IfxErrMsg.getSQLException(-79772, this.conn);
            ifxColumnInfo = (IfxColumnInfo)ifxColumnInfo.child.get(this.typeChildIndex++);
            --this.typeIndex;
            bl = false;
            this.currentIfxType = ifxColumnInfo.SQLtype;
            this.currentExtendedId = ifxColumnInfo.ExtendedId;
            this.currentIfxLength = ifxColumnInfo.ColLength;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "    getNextType new type: " + this.currentIfxType);
            this.trace.writeTrace(2, "    getNextType new length: " + this.currentIfxLength);
            this.trace.writeTrace(2, "    getNextType new extendedId: " + this.currentExtendedId);
        }
        if (n != 49) {
            this.verifyType(n, n2, string);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "    getNextType new index: " + this.typeIndex);
        }
        if (!TraceFlag.compiletrace) return bl;
        this.trace.writeTrace(1, "IfxComplexOutput.getNextType(void) exited");
        return bl;
    }

    private void verifyType(int n, int n2, String string) throws SQLException {
        String string2 = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "   verifyType() currentIfxType: " + this.currentIfxType);
            this.trace.writeTrace(3, "   verifyType() type: " + n);
        }
        if (this.conn != null) {
            string2 = this.conn.getclLocale();
        }
        if (this.currentIfxType != n) {
            if (IfxTypes.isCollection(this.currentIfxType) && IfxTypes.isCollection(n)) {
                return;
            }
            if (n == 40 && this.currentIfxType == 41 || n == 41 && this.currentIfxType == 40) {
                return;
            }
            if ((this.currentIfxType == 101 || this.currentIfxType == 102) && n == 41) {
                return;
            }
            if (n == 5 && this.currentIfxType == 8) {
                return;
            }
            if (!(n != 22 && n != 20 && n != 19 || this.currentIfxType == 49 && this.currentIfxType == 22 && this.currentIfxType == 20 && this.currentIfxType == 19)) {
                return;
            }
            IfxComplex.badTypeException(this.currentIfxType, (short)n, this.trace, string2);
        }
        if (string != null && string != "") {
            Object object;
            int n3 = 0;
            if (string.compareToIgnoreCase("blob") == 0) {
                n3 = 10;
            } else if (string.compareToIgnoreCase("clob") == 0) {
                n3 = 11;
            } else {
                object = this.conn.getUDTInfo((IfxColumnInfo)null, string);
                if (object == null) {
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(2, "    verifyType() bad name: " + string);
                    }
                    String string3 = IfxErrMsg.getMessage(-79796, string, this.conn);
                    throw new SQLException(string3);
                }
                n3 = ((IfxUDTInfo)object).xid;
            }
            if (this.currentExtendedId != n3) {
                object = Integer.toString(n3);
                String string4 = Integer.toString(this.currentExtendedId);
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(2, "    verifyType() source xid: " + (String)object);
                    this.trace.writeTrace(2, "    verifyType() target xid: " + string4);
                }
                String string5 = IfxErrMsg.getMessage(-79794, (String)object, string4, this.conn);
                throw new SQLException(string5);
            }
        }
    }

    protected String getExtendedName() throws SQLException {
        String string = null;
        if (this.extendedName == "" && !this.isNull) {
            string = this.parentTypeInfoVector != null ? IfxComplex.getExtendedName(this.parentTypeInfoVector, this.trace, this.conn.getclLocale()) : IfxComplex.getExtendedName(this.typeInfoVector, this.trace, this.conn.getclLocale());
        } else {
            string = this.conn != null ? IfxComplex.getExtendedName(this.typeInfoVector, this.trace, this.conn.getclLocale()) : IfxComplex.getExtendedName(this.typeInfoVector, this.trace, null);
            string = this.extendedName;
        }
        return string;
    }

    private Vector getTypeInfoVector(String string) throws SQLException {
        Vector vector;
        block11: {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(1, "IfxComplexOutput.getTypeInfoVector(string) entered");
                this.trace.writeTrace(3, "   getTypeInfoVector(string) name: " + string);
            }
            if (string == null) {
                throw IfxErrMsg.getSQLException(-79790, this.conn);
            }
            vector = null;
            try {
                String string2 = T_SPACE + T_COMMA + T_LPAREN + T_RPAREN;
                string = string.trim();
                StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
                vector = this.constructTypeInfo(stringTokenizer, 1, null, 0);
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(2, " ****** begin dump constructed type information *****");
                    IfxComplex.dumpTypeInfoVector(vector, this.trace, 4);
                    this.trace.writeTrace(2, " ****** end dump constructed type information *****");
                }
            }
            catch (Exception exception) {
                IfxUDTInfo ifxUDTInfo;
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(1, "   getTypeInfoVector(string) constructTypeInfo() threw an exception");
                }
                if ((ifxUDTInfo = this.conn.getUDTInfo((IfxColumnInfo)null, string)) == null) {
                    throw IfxErrMsg.getSQLException(-79770, this.conn);
                }
                IfxResultSetMetaData ifxResultSetMetaData = ifxUDTInfo.structInfo;
                if (ifxResultSetMetaData == null) break block11;
                vector = ifxResultSetMetaData.getColumnInfoVector();
            }
        }
        if (TraceFlag.compiletrace) {
            if (vector == null) {
                this.trace.writeTrace(1, "   getTypeInfoVector(string) v is null");
            } else if (((IfxColumnInfo)vector.get((int)0)).child == null) {
                this.trace.writeTrace(1, "   getTypeInfoVector(string) child is null");
            }
        }
        this.extendedName = string;
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Vector constructTypeInfo(StringTokenizer stringTokenizer, int n, Boolean bl, int n2) throws SQLException {
        Vector<IfxColumnInfo> vector = new Vector<IfxColumnInfo>();
        int n3 = -1;
        IfxColumnInfo ifxColumnInfo = null;
        boolean bl2 = false;
        String string = "";
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput.constructTypeInfo() entered");
            string = stringUtil.fixLength("", n2, ' ');
        }
        block10: while (!bl2) {
            block61: {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "");
                    this.trace.writeTrace(3, "");
                    this.trace.writeTrace(3, string + "advanceToken: " + this.advanceToken);
                    this.trace.writeTrace(3, string + "token count: " + stringTokenizer.countTokens());
                }
                if (this.advanceToken) {
                    if (stringTokenizer.hasMoreTokens()) {
                        this.currentToken = this.getNextToken(stringTokenizer);
                        break block61;
                    } else {
                        if (this.currentToken.equals(T_RPAREN)) break;
                        if (TraceFlag.compiletrace) {
                            this.trace.writeTrace(3, "  constructTypeInfo() missing ')'");
                        }
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                }
                this.advanceToken = true;
            }
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, string + "currentToken: " + this.currentToken);
                this.trace.writeTrace(3, string + "previousState: " + this.getState(this.previousState));
                this.trace.writeTrace(3, string + "stateWanted: " + this.getState(n));
            }
            switch (n) {
                case 1: {
                    n3 = IfxTypes.FromIfxNameToIfxType(this.currentToken);
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, string + "In case for CT_TYPE");
                        this.trace.writeTrace(3, string + "CT_TYPE ifxType: " + n3);
                    }
                    if (!IfxTypes.isComplexType(n3)) {
                        if (TraceFlag.compiletrace) {
                            this.trace.writeTrace(3, string + "constructTypeInfo() not a complex type");
                        }
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                    if (ifxColumnInfo == null) {
                        ifxColumnInfo = new IfxColumnInfo();
                    }
                    if (n3 == 102) {
                        n3 = 40;
                        ifxColumnInfo.ExtendedName = "blob";
                        ifxColumnInfo.ExtendedId = 10;
                        if (TraceFlag.compiletrace) {
                            this.trace.writeTrace(3, string + "CT_TYPE ifxType changed to IFX_TYPE_UDTVAR, IFX_XID_BLOB");
                        }
                    } else if (n3 == 101) {
                        n3 = 40;
                        ifxColumnInfo.ExtendedName = "clob";
                        ifxColumnInfo.ExtendedId = 11;
                        if (TraceFlag.compiletrace) {
                            this.trace.writeTrace(3, string + "CT_TYPE ifxType changed to IFX_TYPE_UDTVAR, IFX_XID_CLOB");
                        }
                    }
                    ifxColumnInfo.SQLtype = n3;
                    Boolean bl3 = null;
                    bl3 = n3 == 22 ? new Boolean(true) : new Boolean(false);
                    if (bl == null) {
                        bl = bl3;
                    }
                    vector.addElement(ifxColumnInfo);
                    ifxColumnInfo.Fieldno = 1;
                    this.previousState = n;
                    n = 5;
                    ifxColumnInfo.child = this.constructTypeInfo(stringTokenizer, n, bl3, n2 + 4);
                    if (this.previousState != 9) {
                        if (TraceFlag.compiletrace) {
                            this.trace.writeTrace(3, "  constructTypeInfo() previous state != CTEND");
                        }
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, "  constructTypeInfo() CT_TYPE setting stateWanted to NOTNULL");
                    }
                    n = 8;
                    continue block10;
                }
                case 7: {
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, string + "In case for FIELDNAME");
                    }
                    if (ifxColumnInfo == null) {
                        ifxColumnInfo = new IfxColumnInfo();
                    }
                    ifxColumnInfo.ColName = this.currentToken;
                    this.previousState = n;
                    n = 2;
                    continue block10;
                }
                case 2: {
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, string + "In case for TYPE");
                    }
                    if (ifxColumnInfo == null) {
                        ifxColumnInfo = new IfxColumnInfo();
                    }
                    n = this.parseFieldType(this.currentToken, ifxColumnInfo, string);
                    continue block10;
                }
                case 4: {
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, string + "In case for NEXTELEMENT");
                    }
                    if (this.currentToken.equals(T_COMMA)) {
                        if (ifxColumnInfo.Fieldno != 1) {
                            vector.addElement(ifxColumnInfo);
                            ifxColumnInfo.Fieldno = 1;
                        }
                        ifxColumnInfo = null;
                        this.previousState = n;
                        n = 7;
                        continue block10;
                    }
                    if (this.currentToken.equals(")")) {
                        if (ifxColumnInfo.Fieldno != 1) {
                            vector.addElement(ifxColumnInfo);
                            ifxColumnInfo.Fieldno = 1;
                        }
                        ifxColumnInfo = null;
                    }
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, string + "DONE ... DONE");
                    }
                    this.previousState = 9;
                    bl2 = true;
                    continue block10;
                }
                case 5: {
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, string + "In case for LPAREN");
                    }
                    if (this.previousState == 1) {
                        this.previousState = n;
                        if (bl.booleanValue()) {
                            n = 7;
                            continue block10;
                        }
                        n = 2;
                        continue block10;
                    }
                    this.previousState = n;
                    n = 3;
                    continue block10;
                }
                case 3: {
                    int n4;
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, string + "In case for LENGTH");
                    }
                    ifxColumnInfo.ColLength = n4 = this.getLength(stringTokenizer, ifxColumnInfo.SQLtype);
                    n = 8;
                    continue block10;
                }
                case 6: {
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, string + "In case for RPAREN");
                    }
                    if (!this.currentToken.equals(")")) {
                        if (TraceFlag.compiletrace) {
                            this.trace.writeTrace(3, "  constructTypeInfo() missing a ')'");
                        }
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                    if (!bl.booleanValue()) {
                        if (ifxColumnInfo.Fieldno != 1) {
                            vector.addElement(ifxColumnInfo);
                            ifxColumnInfo.Fieldno = 1;
                        }
                        ifxColumnInfo = null;
                        this.previousState = 9;
                        bl2 = true;
                        continue block10;
                    }
                    this.previousState = n;
                    n = 8;
                    continue block10;
                }
                case 8: {
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, string + "In case for NOTNULL");
                    }
                    if (!this.currentToken.equalsIgnoreCase("not")) {
                        if (!bl.booleanValue()) {
                            if (TraceFlag.compiletrace) {
                                this.trace.writeTrace(3, "  constructTypeInfo() missing not null");
                            }
                            throw IfxErrMsg.getSQLException(-79790, this.conn);
                        }
                        this.advanceToken = false;
                        n = 4;
                        continue block10;
                    }
                    this.currentToken = this.getNextToken(stringTokenizer);
                    if (this.currentToken.equalsIgnoreCase("null")) {
                        ifxColumnInfo.Nullable = 0;
                        if (this.previousState == 9 && !stringTokenizer.hasMoreTokens()) {
                            bl2 = true;
                            continue block10;
                        }
                    } else {
                        if (TraceFlag.compiletrace) {
                            this.trace.writeTrace(3, "  constructTypeInfo() missing 'null'");
                        }
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                    this.previousState = n;
                    if (bl.booleanValue()) {
                        n = 4;
                        continue block10;
                    }
                    n = 6;
                    continue block10;
                }
            }
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "  constructTypeInfo() unknown state");
            }
            throw IfxErrMsg.getSQLException(-79790, this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput.constructTypeInfo() exited");
        }
        return vector;
    }

    private int parseFieldType(String string, IfxColumnInfo ifxColumnInfo, String string2) throws SQLException {
        int n = 49;
        int n2 = 0;
        int n3 = 0;
        String string3 = null;
        String string4 = null;
        if (string.startsWith("'")) {
            n3 = string.indexOf(39, 1);
            if (n3 > 0) {
                string3 = string.substring(1, n3);
                ++n3;
            } else {
                throw IfxErrMsg.getSQLException(-79790, this.conn);
            }
        }
        if ((n3 = string.indexOf(46, n3)) <= 0 && string3 != null) {
            throw IfxErrMsg.getSQLException(-79790, this.conn);
        }
        if (string3 != null) {
            ifxColumnInfo.ExtendedOwner = string3;
            ++n3;
        } else if (n3 > 0) {
            ifxColumnInfo.ExtendedOwner = string3 = string.substring(0, n3);
            ++n3;
        } else {
            n3 = 0;
        }
        string4 = string.substring(n3, string.length());
        n = IfxTypes.FromIfxNameToIfxType(string4);
        if (IfxTypes.isComplexType(n)) {
            n2 = 1;
            this.advanceToken = false;
        } else {
            if (n == 1111) {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "Type = OTHER");
                }
                this.getOther(ifxColumnInfo, string4, string3);
                n = ifxColumnInfo.SQLtype;
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "Other name = " + ifxColumnInfo.ColName);
                    this.trace.writeTrace(3, "Other type = " + ifxColumnInfo.SQLtype);
                }
            }
            if (n == 102) {
                n = 40;
                ifxColumnInfo.ExtendedName = "blob";
                ifxColumnInfo.ExtendedId = 10;
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, string2 + "TYPE ifxType changed to IFX_TYPE_UDTVAR, IFX_XID_BLOB");
                }
            } else if (n == 101) {
                n = 40;
                ifxColumnInfo.ExtendedName = "clob";
                ifxColumnInfo.ExtendedId = 11;
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, string2 + "TYPE ifxType changed to IFX_TYPE_UDTVAR, IFX_XID_CLOB");
                }
            }
            ifxColumnInfo.SQLtype = n;
            this.previousState = n2;
            n2 = 3;
        }
        return n2;
    }

    private void getOther(IfxColumnInfo ifxColumnInfo, String string, String string2) throws SQLException {
        IfxUDTInfo ifxUDTInfo = null;
        ifxUDTInfo = string2 != null ? this.conn.getUDTInfo(string, string2) : this.conn.getUDTInfo((IfxColumnInfo)null, string);
        if (ifxUDTInfo == null) {
            throw IfxErrMsg.getSQLException(-79770, this.conn);
        }
        ifxColumnInfo.ExtendedName = ifxUDTInfo.name;
        if (ifxUDTInfo.owner != null && string2 != null) {
            ifxColumnInfo.ExtendedOwner = ifxUDTInfo.owner;
        }
        ifxColumnInfo.ExtendedId = ifxUDTInfo.xid;
        ifxColumnInfo.SQLtype = ifxUDTInfo.SQLtype;
        if (ifxUDTInfo.JDBCtype == 2002) {
            IfxColumnInfo ifxColumnInfo2 = null;
            IfxResultSetMetaData ifxResultSetMetaData = ifxUDTInfo.structInfo;
            ifxColumnInfo2 = (IfxColumnInfo)ifxResultSetMetaData.getColumnInfoVector().get(0);
            String string3 = ifxColumnInfo.ColName;
            ifxColumnInfo2.copy(ifxColumnInfo);
            ifxColumnInfo.ColName = string3;
        } else if (ifxUDTInfo.JDBCtype == 2001) {
            ifxColumnInfo.SourceType = ifxUDTInfo.source;
        }
    }

    private String getState(int n) {
        switch (n) {
            case 1: {
                return "CT_TYPE";
            }
            case 2: {
                return "TYPE";
            }
            case 3: {
                return "LENGTH";
            }
            case 4: {
                return "NEXTELEMENT";
            }
            case 5: {
                return "LPAREN";
            }
            case 6: {
                return "RPAREN";
            }
            case 7: {
                return "FIELDNAME";
            }
            case 8: {
                return "NOTNULL";
            }
        }
        return "";
    }

    private int getLength(StringTokenizer stringTokenizer, int n) throws SQLException {
        int n2 = -1;
        if (n == 0 || n == 15 || n == 13 || n == 16) {
            if (!this.currentToken.equals(T_LPAREN)) {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "  getLength() char length");
                }
                throw IfxErrMsg.getSQLException(-79790, this.conn);
            }
            this.currentToken = this.getNextToken(stringTokenizer);
            n2 = Integer.valueOf(this.currentToken);
            this.currentToken = this.getNextToken(stringTokenizer);
            if (!this.currentToken.equals(")")) {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "  getLength() missing ')'");
                }
                throw IfxErrMsg.getSQLException(-79790, this.conn);
            }
        } else if (n == 8 || n == 5) {
            int n3 = 16;
            int n4 = this.conn.isANSI() ? 0 : 255;
            if (!this.currentToken.equals(T_LPAREN)) {
                if (n == 8) {
                    n4 = 2;
                }
                n2 = ((byte)n3 << 8) + n4;
                this.advanceToken = false;
            } else {
                this.currentToken = this.getNextToken(stringTokenizer);
                n3 = Integer.valueOf(this.currentToken);
                this.currentToken = this.getNextToken(stringTokenizer);
                if (this.currentToken.equals(T_COMMA)) {
                    this.currentToken = this.getNextToken(stringTokenizer);
                    n4 = Integer.valueOf(this.currentToken);
                    this.currentToken = this.getNextToken(stringTokenizer);
                }
                if (!this.currentToken.equals(T_RPAREN)) {
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, "  getLength() missing ')'");
                    }
                    throw IfxErrMsg.getSQLException(-79790, this.conn);
                }
                n2 = ((byte)n3 << 8) + n4;
            }
        } else if (n == 10 || n == 14) {
            n2 = n == 10 ? this.getQualifier(stringTokenizer, false) : this.getQualifier(stringTokenizer, true);
        } else {
            this.advanceToken = false;
            switch (n) {
                case 1: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 6: 
                case 7: {
                    n2 = 4;
                    break;
                }
                case 3: {
                    n2 = 8;
                    break;
                }
                case 4: {
                    n2 = 4;
                    break;
                }
                case 17: 
                case 18: {
                    n2 = 10;
                    break;
                }
                case 52: 
                case 53: {
                    n2 = 8;
                    break;
                }
                case 45: {
                    n2 = 1;
                    break;
                }
                case 43: {
                    if (this.conn.isLvcGtThan2kSupported() && this.currentToken.equals(T_LPAREN)) {
                        this.advanceToken = true;
                        this.currentToken = this.getNextToken(stringTokenizer);
                        n2 = Integer.valueOf(this.currentToken);
                        this.currentToken = this.getNextToken(stringTokenizer);
                        if (this.currentToken.equals(T_RPAREN)) break;
                        if (TraceFlag.compiletrace) {
                            this.trace.writeTrace(3, "  getLength() missing ')'");
                        }
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                    n2 = 2048;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
        }
        if (n2 == -1) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "  getLength() ifxLength == -1");
            }
            throw IfxErrMsg.getSQLException(-79790, this.conn);
        }
        return n2;
    }

    private String getNextToken(StringTokenizer stringTokenizer) throws SQLException {
        String string = null;
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.equals(T_SPACE)) continue;
            return string;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "  getNextToken() no more tokens");
        }
        throw IfxErrMsg.getSQLException(-79790, this.conn);
    }

    private int getQualifier(StringTokenizer stringTokenizer, boolean bl) throws SQLException {
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        int n = 0;
        by = this.fieldNametoDatetimeMacro(stringTokenizer);
        this.currentToken = this.getNextToken(stringTokenizer);
        if (this.currentToken.equals(T_LPAREN)) {
            if (bl) {
                this.currentToken = this.getNextToken(stringTokenizer);
                by3 = (byte)Integer.valueOf(this.currentToken).intValue();
                this.currentToken = this.getNextToken(stringTokenizer);
                if (!this.currentToken.equals(T_RPAREN)) {
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, "  getQual() missing ')'");
                    }
                    throw IfxErrMsg.getSQLException(-79717, this.conn);
                }
                this.currentToken = this.getNextToken(stringTokenizer);
            } else {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "  getQual() '(' and it a datetime");
                }
                throw IfxErrMsg.getSQLException(-79707, this.conn);
            }
        }
        if (this.currentToken.equalsIgnoreCase("to")) {
            this.currentToken = this.getNextToken(stringTokenizer);
            by2 = this.fieldNametoDatetimeMacro(stringTokenizer);
            n = bl ? (int)Interval.getQualifier(by3, by, by2) : (int)IfxDateTime.getQualifier(by, by2);
        }
        return n;
    }

    private byte fieldNametoDatetimeMacro(StringTokenizer stringTokenizer) throws SQLException {
        int n = -1;
        this.currentToken.trim();
        if (this.currentToken.equalsIgnoreCase("year")) {
            n = 0;
        } else if (this.currentToken.equalsIgnoreCase("month")) {
            n = 2;
        } else if (this.currentToken.equalsIgnoreCase("day")) {
            n = 4;
        } else if (this.currentToken.equalsIgnoreCase("hour")) {
            n = 6;
        } else if (this.currentToken.equalsIgnoreCase("minute")) {
            n = 8;
        } else if (this.currentToken.equalsIgnoreCase("second")) {
            n = 10;
        } else if (this.currentToken.equalsIgnoreCase("fraction")) {
            this.currentToken = this.getNextToken(stringTokenizer);
            if (this.currentToken.equals(T_LPAREN)) {
                this.currentToken = this.getNextToken(stringTokenizer);
                int n2 = Integer.valueOf(this.currentToken);
                this.currentToken = this.getNextToken(stringTokenizer);
                if (this.currentToken.equals(T_RPAREN)) {
                    if (n2 == 1) {
                        n = 11;
                    } else if (n2 == 2) {
                        n = 12;
                    } else if (n2 == 3) {
                        n = 13;
                    } else if (n2 == 4) {
                        n = 14;
                    } else if (n2 == 5) {
                        n = 15;
                    }
                }
            } else {
                this.advanceToken = false;
                n = 12;
            }
        }
        if (n == -1) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "  fieldNametoDatetimeMacro() cod == -1");
            }
            throw IfxErrMsg.getSQLException(-79707, this.conn);
        }
        return (byte)n;
    }

    private byte[] getNestedHeader(int n, int n2, boolean bl) throws SQLException {
        byte[] byArray;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): getNestedHeader() entered");
        }
        int n3 = 0;
        int n4 = 0;
        if (bl) {
            n4 = 3;
            byArray = new byte[n4];
            for (int i = 0; i < n4; ++i) {
                byArray[i] = 0;
            }
            byte[] byArray2 = JavaToIfxType.JavaToIfxSmallInt((short)1);
            System.arraycopy(byArray2, 0, byArray, 0, 2);
            byArray[2] = 1;
        } else {
            int n5;
            n3 = IfxComplexOutput.getUDToffset(n, this.trace);
            n4 = n3 + 8;
            byArray = new byte[n4];
            for (n5 = 0; n5 < n4; ++n5) {
                byArray[n5] = 0;
            }
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "getNestedHeader() calculated offset: " + n3);
                this.trace.writeTrace(2, "getNestedHeader() header size: " + n4);
            }
            if ((n5 = n2 + n3 + 8 - 2) > Short.MAX_VALUE) {
                throw IfxErrMsg.getSQLException(-1214, this.conn);
            }
            short s = (short)n5;
            byte[] byArray3 = JavaToIfxType.JavaToIfxSmallInt(s);
            System.arraycopy(byArray3, 0, byArray, 0, 2);
            int n6 = 1;
            byte[] byArray4 = JavaToIfxType.JavaToIfxInt(n6);
            System.arraycopy(byArray4, 0, byArray, n3, 4);
            n3 += 4;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): getNestedHeader() exited");
        }
        return byArray;
    }

    public static int getUDToffset(int n, Trace trace) {
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "IfxComplexOutput(): getUDToffset() called");
            trace.writeTrace(2, "   getUDToffset() dataStart: " + n);
        }
        int n2 = (n + 3) % 8 == 0 ? 3 : 11 - (n + 3) % 8;
        return n2;
    }

    private void writeElementOffset() throws SQLException {
        byte[] byArray;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeElementOffset() entered");
            if (this.elementOffsetVector == null) {
                this.trace.writeTrace(2, "  writeElementOffset() elementOffsetVector is null");
            } else {
                this.trace.writeTrace(2, "  writeElementOffset() elementOffsetVector.size(): " + this.elementOffsetVector.size());
            }
        }
        if ((byArray = this.getElementOffset(this.elementOffsetVector)) != null) {
            try {
                this.os.write(byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
    }

    byte[] getElementOffset(Vector vector) throws SQLException {
        int n = this.elementOffsetVector.size();
        byte[] byArray = new byte[4 * (n + 1)];
        int n2 = 0;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): getElementOffset() entered");
            this.trace.writeTrace(2, "    getElementOffset(): count: " + n);
        }
        if (n < 1) {
            return null;
        }
        byte[] byArray2 = JavaToIfxType.JavaToIfxInt(-1);
        System.arraycopy(byArray2, 0, byArray, 0, 4);
        n2 += 4;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "  size before loop: " + n);
        }
        for (int i = n - 1; i >= 0; --i) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "  i in loop: " + i);
            }
            Integer n3 = (Integer)vector.elementAt(i);
            byArray2 = JavaToIfxType.JavaToIfxInt(n3);
            System.arraycopy(byArray2, 0, byArray, n2, 4);
            n2 += 4;
        }
        this.elementOffsetVector.clear();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): getElementOffset() exited");
        }
        return byArray;
    }

    private int getOverrideIfxType(Object object) throws SQLException {
        int n = 49;
        boolean bl = false;
        Class<?> clazz = null;
        Map<String, Class<?>> map = this.conn.getTypeMap();
        if (map == null) {
            return n;
        }
        clazz = map.get("set");
        if (clazz != null && clazz == object.getClass()) {
            return 19;
        }
        clazz = map.get("list");
        if (clazz != null && clazz == object.getClass()) {
            return 21;
        }
        clazz = map.get("multiset");
        if (clazz != null && clazz == object.getClass()) {
            return 20;
        }
        if (object instanceof List) {
            return 21;
        }
        if (object instanceof Collection || object instanceof Array) {
            return 20;
        }
        return n;
    }

    boolean getIsTyped() {
        return this.isTyped;
    }

    @Override
    public void writeURL(URL uRL) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxComplexOutput:writeURL()not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeURL()", this.conn);
    }

    public void writeLongBigint(long l, int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeLongBigint() entered");
            this.trace.writeTrace(2, "    writeLongBigint() x = " + l);
        }
        this.addTypeAndOffsetInfo(n, 8, null);
        try {
            this.os.writeLongBigint(l);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplexOutput(): writeLong() exited");
        }
    }

    @Override
    public void writeNClob(NClob nClob) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxComplexOutput:writeNClob(NClob)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeNClob(NClob)", this.conn);
    }

    @Override
    public void writeNString(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxComplexOutput:writeNString(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeNString(String)", this.conn);
    }

    @Override
    public void writeRowId(RowId rowId) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxComplexOutput:writeRowId(RowId)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeRowId(RowId)", this.conn);
    }

    @Override
    public void writeSQLXML(SQLXML sQLXML) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxComplexOutput:writeSQLXML(SQLXML)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeSQLXML(SQLXML)", this.conn);
    }
}

