/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.Driver;
import com.gbasedbt.jdbc.IfxCallableStatement;
import com.gbasedbt.jdbc.IfxClientResultSet;
import com.gbasedbt.jdbc.IfxColumnInfo;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxDateTime;
import com.gbasedbt.jdbc.IfxParameterMetaData;
import com.gbasedbt.jdbc.IfxProtocol;
import com.gbasedbt.jdbc.IfxResultSet;
import com.gbasedbt.jdbc.IfxResultSetMetaData;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.jdbc.IfxStatement;
import com.gbasedbt.jdbc.IfxUDTInfo;
import com.gbasedbt.jdbc.RowInfo;
import com.gbasedbt.jdbc.Version;
import com.gbasedbt.jdbc.mdinfo;
import com.gbasedbt.lang.IfxTypes;
import com.gbasedbt.lang.Interval;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import com.gbasedbt.util.stringUtil;
import java.lang.reflect.Constructor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxDatabaseMetaData
implements DatabaseMetaData {
    private IfxConnection conn;
    private Trace trace = null;
    private Stack stmtStack = null;
    private static int nextTempTableId;
    private static int nMdInfoRows;
    private static int nStdRowTypes;
    private static int nXtdRowTypes;
    private static int nXtdRowTypesSupported;
    private static mdinfo[] lmd;
    static RowInfo[] lrow;
    private static RowInfo[] lrowgeneric;
    private static RowInfo[] lrowLvc32k;
    private boolean isFirstCallProcedureMethod = true;
    private String procTypeWhere = "";

    private synchronized String nextTempTableName() {
        String string = "dbmd" + nextTempTableId;
        ++nextTempTableId;
        return string;
    }

    IfxDatabaseMetaData(IfxConnection ifxConnection) throws SQLException {
        this.conn = ifxConnection;
        lrow = this.conn != null && this.conn.isLvcGtThan2kSupported() ? lrowLvc32k : lrowgeneric;
        if (this.conn != null) {
            this.trace = this.conn.getTrace();
        }
    }

    int getMaxLvarcharSize() {
        int n = 0;
        for (n = 0; n < lrow.length && !IfxDatabaseMetaData.lrow[n].tname.equalsIgnoreCase("lvarchar"); ++n) {
        }
        return IfxDatabaseMetaData.lrow[n].precision;
    }

    public RowInfo[] getLrow() {
        return lrow;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getURL(): call IfxConnection:getURL()");
        }
        if (this.conn != null) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxDatabaseMetaData:getURL(): call IfxConnection:getURL()");
            }
            return this.conn.getURL();
        }
        return null;
    }

    @Override
    public String getUserName() throws SQLException {
        if (this.conn != null) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxDatabaseMetaData:getUserName(): call IfxConnection:getUserName()");
            }
            return this.conn.getUserName();
        }
        return null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.conn != null) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxDatabaseMetaData:isReadOnly(): call IfxConnection:isReadOnly()");
            }
            return this.conn.isReadOnly();
        }
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        if (this.conn != null) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxDatabaseMetaData:getDatabaseProductName(): call IfxConnection:getDbVersion()");
            }
            return this.conn.getDbProductName();
        }
        throw IfxErrMsg.getSQLException(-79730, null);
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        if (this.conn != null) {
            if (!this.conn.isVer_Retain()) {
                return Version.GBASE_SERVER_VERSION;
            }
            return Version.VER_RETAIN_SERVER_VERSION;
        }
        throw IfxErrMsg.getSQLException(-79730, null);
    }

    @Override
    public String getDriverName() throws SQLException {
        if (!this.conn.isVer_Retain()) {
            return "GBase 8s JDBC Driver";
        }
        return "IBM Informix JDBC Driver for IBM Informix Dynamic Server";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getDriverVersion(): call Driver:getJDBCVersion()");
        }
        return Driver.getJDBCVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        try {
            String string = Driver.getJDBCVersion();
            return Driver.extractMajorVersion(string);
        }
        catch (SQLException sQLException) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxDatabaseMetaData:getDriverMajorVersion(): caught exception: " + sQLException.toString());
            }
            return 0;
        }
    }

    @Override
    public int getDriverMinorVersion() {
        try {
            String string = Driver.getJDBCVersion();
            return Driver.extractMinorVersion(string);
        }
        catch (SQLException sQLException) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxDatabaseMetaData:getDriverMinorVersion(): caught exception: " + sQLException.toString());
            }
            return 0;
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return !this.conn.isOnLine();
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return !this.conn.isOnLine();
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        if (this.conn == null) {
            return false;
        }
        return this.conn.isDelimIdentSet();
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        if (this.conn == null) {
            return true;
        }
        return !this.conn.isDelimIdentSet();
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        if (this.conn == null) {
            return false;
        }
        return this.conn.isDelimIdentSet();
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        if (this.conn == null || !this.conn.isDelimIdentSet()) {
            return " ";
        }
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        String string = null;
        string = this.conn.isUSVER() ? new String("after,ansi,append,attach,audit,before,bitmap,boolean,buffered,byte,cache,call,cluster,clustersize,codeset,database,datafiles,dataskip,datetime,dba,dbdate,dbmoney,debug,define,delimiter,deluxe,detach,dirty,distributions,document,each,elif,exclusive,exit,explain,express,expression,extend,extent,file,fillfactor,foreach,format,fraction,fragment,gk,hash,high,hold,hybrid,if,index,init,labeleq,labelge,labelgt,labelle,labellt,let,listing,lock,log,low,matches,maxerrors,medium,mode,modify,money,mounting,new,nvarchar,off,old,operational,optical,optimization,page,pdqpriority,pload,private,raise,range,raw,recordend,recover,referencing,rejectfile,release,remainder,rename,reserve,resolution,resource,resume,return,returning,returns,ridlist,robin,rollforward,round,row,rowids,sameas,samples,schedule,scratch,serial,share,skall,skinhibit,skshow,smallfloat,stability,standard,start,static,statistics,stdev,step,sync,synonym,system,temp,text,timeout,trace,trigger,units,unlock,variance,wait,while,xload,xunload") : new String("after,ansi,append,attach,audit,before,bitmap,buffered,byte,cache,call,cluster,clustersize,codeset,database,datafiles,dataskip,datetime,dba,dbdate,dbmoney,debug,define,delimiter,deluxe,detach,dirty,distributions,document,each,elif,exclusive,exit,explain,express,expression,extend,extent,file,fillfactor,foreach,format,fraction,fragment,gk,hash,high,hold,hybrid,if,index,init,labeleq,labelge,labelgt,labelle,labellt,let,listing,lock,log,low,matches,maxerrors,medium,mode,modify,money,mounting,new,nvarchar,off,old,operational,optical,optimization,page,pdqpriority,pload,private,raise,range,raw,recordend,recover,referencing,rejectfile,release,remainder,rename,reserve,resolution,resource,resume,return,returning,returns,ridlist,robin,rollforward,round,row,rowids,sameas,samples,schedule,scratch,serial,share,skall,skinhibit,skshow,smallfloat,stability,standard,start,static,statistics,stdev,step,sync,synonym,system,temp,text,timeout,trace,trigger,units,unlock,variance,wait,while,xload,xunload");
        return string;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "abs,mod,pow,root,round,sqrt,exp,logn,log10,cos,sin,tan,asin,acos,atan,atan2";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "trunc,length";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "avg,max,min,sum,count,range,stdev,variance,trim,hex,filetoblob,filetoclob,lotofile,lotocopy";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "date,day,month,weekday,year,extend,mdy";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        if (this.conn == null) {
            return "";
        }
        if (this.conn.isLongID()) {
            return "$";
        }
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return !((IfxSqliConnect)this.conn).isCTSCompliant();
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "user";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "function";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    private String getTmpTableTerm() {
        if (this.conn.isXPS()) {
            return "scratch";
        }
        return "temp";
    }

    private String getNoLogTerm() {
        if (this.conn.isXPS()) {
            return "";
        }
        return "with no log";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ":";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 256;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 255;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        if (((IfxSqliConnect)this.conn).isRemove64KLimitSupported()) {
            return Integer.MAX_VALUE;
        }
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 32;
        }
        return 8;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        int n;
        if (this.conn == null) {
            return 0;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getDefaultTransactionIsolation(): call IfxConnection:getDatabaseType()");
        }
        if ((n = this.conn.getDatabaseType()) == 1) {
            return 4;
        }
        if (n == 2) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        if (this.conn == null) {
            return false;
        }
        return this.conn.getDatabaseType() != 3;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        int n2;
        if (this.conn == null) {
            return false;
        }
        if (!(n == 1 || n == 2 || n == 4 || n == 8 || n == 0 || n == 5 && this.conn.IsLastCommittedSupported())) {
            return false;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:supportsTransactionIsolationLevel(): call IfxConnection:getDatabaseType()");
        }
        if (((n2 = this.conn.getDatabaseType()) == 1 || n2 == 2) && n != 0) {
            return true;
        }
        return n2 == 3 && (n == 1 || n == 0);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        IfxClientResultSet ifxClientResultSet;
        IfxStatement ifxStatement;
        boolean bl = false;
        Object var15_5 = null;
        if (this.conn == null) {
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getProcedures() : call IfxConnection:isDbOpen()");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string2 = this.toSchemaCaseLikeServer(string2);
            string3 = string3.toLowerCase();
        }
        try {
            int n;
            int n2;
            int n3;
            int n4;
            IfxStatement ifxStatement2 = (IfxStatement)this.conn.createStatement();
            IfxStatement ifxStatement3 = (IfxStatement)this.conn.createStatement();
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            ifxStatement3.setAutoFree(true);
            String string4 = this.getMetaDbName(string);
            this.checkTypeColumnForProcedure(string4);
            String string5 = "select unique '" + string4 + "', owner, procname, '' as RESERVED1, '' as RESERVED2, '' as RESERVED3, '' as REMARKS, isproc, specificname  from " + string4 + ":gbasedbt.sysprocedures where procname like '" + string3 + "' and owner like '" + string2 + "'" + this.procTypeWhere + "order by 2, 3";
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxDatabaseMetaData:getProcedures() : call IfxStatement:executeQuery(" + string5 + ")");
            }
            ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(9, this.conn);
            if (this.conn.isOnLine()) {
                n4 = 129;
                n3 = 0;
                n2 = 1;
                n = n4;
                ifxResultSetMetaData.setColumnName(n2, this.conn.retCapName("PROCEDURE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PROCEDURE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PROCEDURE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("RESERVED1"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("RESERVED2"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("RESERVED3"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("REMARKS"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PROCEDURE_TYPE"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("SPECIFIC_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ++n2;
            } else {
                n4 = 0;
                n3 = 1;
                n = n2 = 18;
                ifxResultSetMetaData.setColumnName(n3, this.conn.retCapName("PROCEDURE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PROCEDURE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PROCEDURE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = 40;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("RESERVED1"));
                ifxResultSetMetaData.setIfxColumnType(n3, 13);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("RESERVED2"));
                ifxResultSetMetaData.setIfxColumnType(n3, 13);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("RESERVED3"));
                ifxResultSetMetaData.setIfxColumnType(n3, 13);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("REMARKS"));
                ifxResultSetMetaData.setIfxColumnType(n3, 13);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PROCEDURE_TYPE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 13);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("SPECIFIC_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ++n3;
            }
            resultSetMetaData = ifxResultSetMetaData;
            IfxClientResultSet ifxClientResultSet2 = new IfxClientResultSet(this.conn, resultSetMetaData);
            n3 = resultSetMetaData.getColumnCount();
            Object object = null;
            ifxClientResultSet2.moveToInsertRow();
            while (resultSet.next()) {
                for (n = 1; n <= n3; ++n) {
                    String string6;
                    if (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PROCEDURE_CAT")) {
                        object = resultSet.getString(1);
                    } else if (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PROCEDURE_SCHEM")) {
                        object = resultSet.getString(2).trim();
                    } else if (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PROCEDURE_NAME")) {
                        object = resultSet.getString(3);
                    } else if (resultSetMetaData.getColumnName(n).equalsIgnoreCase("RESERVED1")) {
                        object = "null";
                    } else if (resultSetMetaData.getColumnName(n).equalsIgnoreCase("RESERVED2")) {
                        object = "null";
                    } else if (resultSetMetaData.getColumnName(n).equalsIgnoreCase("RESERVED3")) {
                        object = "null";
                    } else if (resultSetMetaData.getColumnName(n).equalsIgnoreCase("REMARKS")) {
                        object = resultSet.getString(7);
                    } else if (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PROCEDURE_TYPE")) {
                        object = 0;
                        string6 = resultSet.getString(8);
                        if (string6.equals("t")) {
                            object = 1;
                        } else if (string6.equals("f")) {
                            object = 2;
                        }
                    } else if (resultSetMetaData.getColumnName(n).equalsIgnoreCase("SPECIFIC_NAME")) {
                        string6 = resultSet.getString(9);
                        if (string6 == null) {
                            string6 = "null";
                            object = "null";
                        } else {
                            object = resultSet.getString(9).trim();
                        }
                    } else {
                        object = resultSet.getObject(1);
                    }
                    ifxClientResultSet2.updateObject(n, object);
                }
                if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && resultSet.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                ifxClientResultSet2.insertRow();
            }
            ifxClientResultSet2.beforeFirst();
            ifxClientResultSet2.setType(1003);
            ifxClientResultSet2.setFetchDirection(1000);
            ifxClientResultSet2.setConcurrency(1007);
            ifxClientResultSet = ifxClientResultSet2;
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ifxStatement.close();
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return ifxClientResultSet;
    }

    private void checkTypeColumnForProcedure(String string) throws SQLException {
        if (this.isFirstCallProcedureMethod) {
            IfxStatement ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string2 = "SELECT c.colname FROM " + string + ":gbasedbt.systables t," + string + ":gbasedbt.syscolumns c where tabname ='sysprocedures' and t.tabid=c.tabid and colname='type'";
            boolean bl = false;
            bl = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string2, true).next() : ifxStatement.executeQuery(string2, false).next();
            this.isFirstCallProcedureMethod = false;
            if (bl) {
                this.procTypeWhere = " and type = 0 ";
            }
            ifxStatement.close();
        }
    }

    private void processProcName(String string, String string2, String string3, String string4) throws SQLException {
        Statement statement = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        String string12 = null;
        boolean bl2 = false;
        Vector vector = null;
        boolean bl3 = false;
        IfxStatement ifxStatement = (IfxStatement)this.conn.createStatement();
        IfxStatement ifxStatement2 = (IfxStatement)this.conn.createStatement();
        ifxStatement.setAutoFree(true);
        ifxStatement2.setAutoFree(true);
        this.checkTypeColumnForProcedure(string3);
        String string13 = "select  procid from " + string3 + ":gbasedbt.sysprocedures where procname like '" + string + "' and owner like '" + string2 + "' " + this.procTypeWhere;
        ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string13, true) : ifxStatement.executeQuery(string13, false);
        while (resultSet.next()) {
            n = 0;
            n2 = 0;
            bl2 = false;
            if (!bl) {
                bl = true;
                statement = this.conn.prepareStatement("insert into " + string4 + "(PROCEDURE_CAT, PROCEDURE_SCHEM,PROCEDURE_NAME, COLUMN_NAME, COLUMN_TYPE, DATA_TYPE, TYPE_NAME,PRECISION, LENGTH, SCALE, RADIX,NULLABLE, REMARKS,COLUMN_DEF, SQL_DATA_TYPE, SQL_DATETIME_SUB,CHAR_OCTET_LENGTH, ORDINAL_POSITION,IS_NULLABLE, SPECIFIC_NAME )values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);");
            }
            int n3 = resultSet.getInt(1);
            string13 = " select  trim(p.owner) ,  p.procname ,  p.isproc ,  pc.paramname ,  pc.paramattr , " + string3 + ":gbasedbt.get_data_type(pc.paramtype, pc.paramxid, 0) , " + string3 + ":gbasedbt.schema_coltypename(pc.paramtype,pc.paramxid) , " + string3 + ":gbasedbt.schema_precision(pc.paramtype,pc.paramxid,pc.paramlen) , " + string3 + ":gbasedbt.schema_bufflen(pc.paramtype,pc.paramlen) , " + string3 + ":gbasedbt.schema_numscale(pc.paramtype,pc.paramlen) , " + string3 + ":gbasedbt.schema_numprecradix(pc.paramtype) , " + string3 + ":gbasedbt.schema_isnullable(pc.paramtype)::SMALLINT ,  pc.paramtype , " + string3 + ":gbasedbt.schema_datetype(pc.paramtype, pc.paramlen) , " + string3 + ":gbasedbt.schema_charlen(pc.paramtype,pc.paramxid,pc.paramlen) ,  pc.paramid , " + string3 + ":gbasedbt.schema_nullable(pc.paramtype)::VARCHAR(3) , " + string3 + ":gbasedbt.ifx_param_types(" + n3 + ")," + string3 + ":gbasedbt.ifx_ret_types(" + n3 + "),  p.specificname,  pc.paramxid from " + string3 + ":gbasedbt.sysprocedures p, " + string3 + ":gbasedbt.sysprocbody b, " + string3 + ":gbasedbt.sysproccolumns pc  where p.procid = " + n3 + " and p.procid=b.procid and p.procid=pc.procid and b.datakey='T' and b.seqno=1 and p.langid = 2  order by 1,2,3,16; ";
            ResultSet resultSet2 = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement2.executeQuery(string13, true) : ifxStatement2.executeQuery(string13, false);
            while (resultSet2.next()) {
                string12 = null;
                string6 = resultSet2.getString(2);
                string9 = resultSet2.getString(3);
                string10 = string9.equals("t") ? "create procedure " : "create function ";
                string10 = string10 + string5 + "." + string6.trim() + "(";
                string11 = string9.equals("t") ? "execute procedure " : "execute function ";
                string11 = string11 + string5 + "." + string6.trim() + "(";
                string7 = resultSet2.getString(18);
                string8 = resultSet2.getString(19);
                vector = this.parseTypes(string8);
                if (!string8.equals("")) {
                    string10 = !string7.equals("") ? string10 + string7 + ") returning " + string8 + ";" : string10 + ") returning " + string8 + ";";
                    if (n2 < vector.size()) {
                        string12 = (String)vector.elementAt(n2);
                    }
                }
                if (n2 > vector.size() || n2 == vector.size() || vector.size() == 0) {
                    bl2 = true;
                }
                if (!string7.equals("")) {
                    if (string8.equals("")) {
                        string10 = string10 + string7 + ")";
                    }
                    if (bl2 && n < (vector = this.parseTypes(string7)).size()) {
                        int n4 = ((String)vector.elementAt(n)).indexOf(32);
                        String[] stringArray = ((String)vector.elementAt(n)).split(" ");
                        if (stringArray.length > 0 && (stringArray[0].equalsIgnoreCase("datetime") || stringArray[0].equalsIgnoreCase("interval")) && stringArray.length > 1 && stringArray[2].equalsIgnoreCase("to")) {
                            n4 = 0;
                        }
                        string12 = n4 > 0 ? ((String)vector.elementAt(n)).substring(n4 + 1) : (String)vector.elementAt(n);
                    }
                }
                if (string7.equals("") && string8.equals("")) {
                    string10 = string10 + ")";
                    string12 = "null";
                }
                statement.setString(1, string3);
                statement.setString(2, resultSet2.getString(1).trim());
                statement.setString(3, resultSet2.getString(2));
                String string14 = resultSet2.getString(4);
                if (string14 == null) {
                    string14 = "null";
                }
                statement.setString(4, string14);
                statement.setString(5, resultSet2.getString(5));
                if (resultSet2.getInt(6) == 93) {
                    int n5 = resultSet2.getInt(8);
                    int n6 = n5 >> 4 & 0xF;
                    int n7 = n5 & 0xF;
                    if (n6 >= 6 && n7 <= 15) {
                        statement.setString(6, String.valueOf(92));
                    } else {
                        statement.setString(6, String.valueOf(93));
                    }
                } else {
                    statement.setString(6, resultSet2.getString(6));
                }
                try {
                    short s = (short)(resultSet2.getInt(15) & 0xFF);
                    if (s == 41 || s == 40) {
                        IfxUDTInfo ifxUDTInfo = this.conn.getUDTInfo(resultSet2.getInt(21));
                        if (ifxUDTInfo != null && ifxUDTInfo.getName().length() > 0) {
                            statement.setString(7, ifxUDTInfo.getName().toUpperCase());
                        }
                    } else {
                        statement.setString(7, string12.trim());
                    }
                }
                catch (Exception exception) {
                    statement.setString(7, string12.trim());
                }
                statement.setString(8, resultSet2.getString(8));
                statement.setString(9, resultSet2.getString(9));
                statement.setString(10, resultSet2.getString(10));
                statement.setString(11, resultSet2.getString(11));
                statement.setString(12, resultSet2.getString(12));
                statement.setString(13, string10);
                statement.setString(14, "null");
                statement.setString(15, resultSet2.getString(13));
                statement.setString(16, resultSet2.getString(14));
                statement.setString(17, resultSet2.getString(15));
                statement.setString(18, resultSet2.getString(16));
                statement.setString(19, resultSet2.getString(17));
                statement.setString(20, resultSet2.getString(20));
                statement.executeUpdate();
                if (bl2) {
                    ++n;
                }
                ++n2;
            }
        }
        if (statement != null) {
            statement.close();
        }
        ifxStatement.close();
        ifxStatement2.close();
        if (!bl) {
            throw IfxErrMsg.getSQLException(-9753, this.conn);
        }
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        String string5 = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getProcedureColumns() entered");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        if (this.conn.isUSVER()) {
            ((IfxSqliConnect)this.conn).startMetaDataQuery();
            if (string2 == null || string2.length() == 0) {
                string2 = "%";
            }
            if (string3 == null || string3.length() == 0) {
                string3 = "%";
            }
            if (string4 == null || string4.length() == 0) {
                string4 = "%";
            }
            if (!this.conn.isDelimIdentSet()) {
                string2 = this.toSchemaCaseLikeServer(string2);
                string3 = string3.toLowerCase();
            }
            String string6 = this.getMetaDbName(string);
            try {
                int n;
                ifxStatement = (IfxStatement)this.conn.createStatement();
                ifxStatement.setAutoFree(true);
                ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string5 + "(   PROCEDURE_CAT    varchar(129),   PROCEDURE_SCHEM  varchar(129),   PROCEDURE_NAME   varchar(129),   COLUMN_NAME varchar(129),   COLUMN_TYPE int,  DATA_TYPE   int,  TYPE_NAME   varchar(100),  PRECISION   int,  LENGTH\t int,  SCALE       int,  RADIX       int,  NULLABLE    int,  REMARKS     lvarchar,  COLUMN_DEF  varchar(129),  SQL_DATA_TYPE     int,  SQL_DATETIME_SUB     int,  CHAR_OCTET_LENGTH     int,  ORDINAL_POSITION     int,  IS_NULLABLE     varchar(129),  SPECIFIC_NAME     varchar(129),  ser\t serial\t) " + this.getNoLogTerm() + ";");
                ifxStatement.close();
                if (string3.equals("%") && string2.equals("%")) {
                    ifxStatement2 = (IfxStatement)this.conn.createStatement();
                    boolean bl = false;
                    if (this.conn.isANSI() && this.conn.getAutoCommit()) {
                        bl = true;
                    }
                    ResultSet resultSet = ifxStatement2.executeQuery("select unique procname from gbasedbt.sysprocedures", bl);
                    while (resultSet.next()) {
                        string3 = resultSet.getString(1);
                        this.processProcName(string3, string2, string6, string5);
                    }
                    ifxStatement2.close();
                } else {
                    this.processProcName(string3, string2, string6, string5);
                }
                String string7 = null;
                string7 = this.supportsNamedParameters() ? "select * from " + string5 + " where COLUMN_NAME like  '" + string4 + "'  order by 2, 3, 21" : "select * from " + string5 + " order by 2, 3, 21 ";
                IfxStatement ifxStatement3 = (IfxStatement)this.conn.createStatement();
                ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement3.executeQuery(string7, true) : ifxStatement3.executeQuery(string7, false);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(20, this.conn);
                if (this.conn.isOnLine()) {
                    n = 129;
                    if (this.conn.getdbEncoding() == "UTF8") {
                        n = 85;
                    }
                    int n2 = 0;
                    int n3 = 1;
                    int n4 = n;
                    ifxResultSetMetaData.setColumnName(n3, this.conn.retCapName("PROCEDURE_CAT"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 13);
                    n4 = n;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4 + 1;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PROCEDURE_SCHEM"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 13);
                    n4 = n;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4 + 1;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PROCEDURE_NAME"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 13);
                    n4 = n;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4 + 1;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("COLUMN_NAME"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 13);
                    n4 = n;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4 + 1;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("COLUMN_TYPE"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 1);
                    n4 = 2;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("DATA_TYPE"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 1);
                    n4 = 2;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("TYPE_NAME"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 13);
                    n4 = n;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4 + 1;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PRECISION"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 2);
                    n4 = 4;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("LENGTH"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 1);
                    n4 = 2;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("SCALE"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 2);
                    n4 = 4;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("RADIX"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 2);
                    n4 = 4;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("NULLABLE"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 2);
                    n4 = 4;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("REMARKS"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 0);
                    n4 = 18;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("COLUMN_DEF"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 13);
                    n4 = 255;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4 + 1;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("SQL_DATA_TYPE"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 2);
                    n4 = 4;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("SQL_DATETIME_SUB"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 2);
                    n4 = 4;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("CHAR_OCTET_LENGTH"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 2);
                    n4 = 4;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("ORDINAL_POSITION"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 2);
                    n4 = 4;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("IS_NULLABLE"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 0);
                    n4 = 3;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4;
                    ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("SPECIFIC_NAME"));
                    ifxResultSetMetaData.setIfxColumnType(n3, 13);
                    n4 = 255;
                    ifxResultSetMetaData.setEncodedLength(n3, n4);
                    ifxResultSetMetaData.setTableName(n3, "");
                    ifxResultSetMetaData.setColtitle(n3, null);
                    ifxResultSetMetaData.setColumnStartPosition(n3, n2);
                    n2 += n4 + 1;
                    ++n3;
                } else {
                    int n5;
                    n = 0;
                    int n6 = 1;
                    int n7 = n5 = 50;
                    ifxResultSetMetaData.setColumnName(n6, this.conn.retCapName("PROCEDURE_CAT"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 0);
                    n7 = n5;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7 + 1;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("PROCEDURE_SCHEM"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 0);
                    n7 = n5;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7 + 1;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("PROCEDURE_NAME"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 0);
                    n7 = n5;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7 + 1;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("COLUMN_NAME"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 0);
                    n7 = n5;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7 + 1;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("COLUMN_TYPE"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 1);
                    n7 = 2;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("DATA_TYPE"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 1);
                    n7 = 2;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("TYPE_NAME"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 0);
                    n7 = n5;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7 + 1;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("PRECISION"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 2);
                    n7 = 4;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("LENGTH"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 1);
                    n7 = 2;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("SCALE"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 2);
                    n7 = 4;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("RADIX"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 2);
                    n7 = 4;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("NULLABLE"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 2);
                    n7 = 4;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("REMARKS"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 0);
                    n7 = 18;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("COLUMN_DEF"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 0);
                    n7 = 255;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7 + 1;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("SQL_DATA_TYPE"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 2);
                    n7 = 4;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("SQL_DATETIME_SUB"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 2);
                    n7 = 4;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("CHAR_OCTET_LENGTH"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 2);
                    n7 = 4;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("ORDINAL_POSITION"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 2);
                    n7 = 4;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("IS_NULLABLE"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 0);
                    n7 = 3;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7;
                    ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("SPECIFIC_NAME"));
                    ifxResultSetMetaData.setIfxColumnType(n6, 0);
                    n7 = 255;
                    ifxResultSetMetaData.setEncodedLength(n6, n7);
                    ifxResultSetMetaData.setTableName(n6, "");
                    ifxResultSetMetaData.setColtitle(n6, null);
                    ifxResultSetMetaData.setColumnStartPosition(n6, n);
                    n += n7 + 1;
                    ++n6;
                }
                resultSetMetaData = ifxResultSetMetaData;
                ResultSet resultSet2 = this.populateClientResultSet(resultSet, resultSetMetaData);
                ifxStatement3.close();
                this.dropTempTable(string5);
                ((IfxSqliConnect)this.conn).endMetaDataQuery();
                return resultSet2;
            }
            catch (SQLException sQLException) {
                ((IfxSqliConnect)this.conn).endMetaDataQuery();
                if (sQLException.getErrorCode() == -329) {
                    IfxStatement ifxStatement4 = (IfxStatement)this.conn.createStatement();
                    IfxResultSet ifxResultSet = new IfxResultSet(ifxStatement4, this.conn, ifxStatement4.prot);
                    return ifxResultSet;
                }
                throw sQLException;
            }
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getProcedureColumns() exited");
        }
        return null;
    }

    private Vector parseTypes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>(20);
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector;
    }

    private Vector parseIds(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(,)");
        boolean bl = true;
        Vector<Integer> vector = new Vector<Integer>(20);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (bl) {
                int n2 = Integer.valueOf(string2.trim());
                n = IfxTypes.FromIfxToJDBC2Type(n2);
                if (n2 == 4 && !this.conn.getMapReal()) {
                    n = 6;
                }
                vector.add(n);
                bl = false;
                continue;
            }
            bl = true;
        }
        return vector;
    }

    Vector parseParameterNames(String string, Vector vector, String string2, int n) throws SQLException {
        int n2;
        Object object;
        String string3 = "";
        Vector<String> vector2 = null;
        int n3 = vector.size();
        if (!this.supportsNamedParameters()) {
            vector2 = new Vector<String>(n3);
            for (int i = 0; i < n3; ++i) {
                vector2.add("null");
            }
            return vector2;
        }
        for (int i = 0; i < n3; ++i) {
            object = (String)vector.elementAt(i);
            n2 = ((String)object).lastIndexOf(46) + 1;
            if (n2 == 0) {
                n2 = ((String)object).lastIndexOf(32) + 1;
            }
            String[] stringArray = ((String)object).split(" ");
            stringArray[0] = stringArray[0].substring(1);
            String string4 = (stringArray[0].equalsIgnoreCase("datetime") || stringArray[0].equalsIgnoreCase("interval")) && stringArray[2].equalsIgnoreCase("to") ? stringArray[0] : ((String)object).substring(n2);
            string3 = string4.equalsIgnoreCase("datetime") || string4.equalsIgnoreCase("interval") ? string3 + (i == 0 ? "?" : ",?") : string3 + (i == 0 ? "?::" : ",?::") + string4;
        }
        try {
            CallableStatement callableStatement = this.conn.prepareCall(string + string3 + ");");
            object = callableStatement.getParameterMetaData();
            n2 = object.getParameterCount();
            vector2 = new Vector(n2);
            for (int i = 1; i <= n2; ++i) {
                if (((IfxParameterMetaData)object).getArgumentName(i).length() >= 4) {
                    if (((IfxParameterMetaData)object).getArgumentName(i).substring(0, 4).equals("arg[")) {
                        vector2.add("null");
                        continue;
                    }
                    vector2.add(((IfxParameterMetaData)object).getArgumentName(i));
                    continue;
                }
                vector2.add(((IfxParameterMetaData)object).getArgumentName(i));
            }
            if (n > 0 && ((IfxCallableStatement)callableStatement).rsmd != null) {
                Vector vector3 = ((IfxCallableStatement)callableStatement).rsmd.getColumnInfoVector();
                Statement statement = this.conn.createStatement();
                for (int i = 1; i <= n; ++i) {
                    IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)vector3.get(i - 1);
                    if (ifxColumnInfo.ColName.equals("(expression)")) continue;
                    String string5 = "update " + string2 + " set COLUMN_NAME='" + ifxColumnInfo.ColName + "' where ser=" + i;
                    statement.executeUpdate(string5);
                }
                statement.close();
            }
            callableStatement.close();
            return vector2;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == -201 || sQLException.getErrorCode() == -9963 || sQLException.getErrorCode() == -9628 || sQLException.getErrorCode() == -674) {
                vector2 = new Vector(n3);
                for (int i = 0; i < n3; ++i) {
                    vector2.add("null");
                }
                return vector2;
            }
            throw sQLException;
        }
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        IfxClientResultSet ifxClientResultSet;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        boolean bl5 = false;
        if (this.conn == null) {
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getTables() : call IfxConnection:isDbOpen()");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
                if (stringArray[i].trim().equalsIgnoreCase("SYSTEM TABLE")) {
                    bl5 = true;
                    ++n;
                }
                if (stringArray[i].trim().equalsIgnoreCase("TABLE")) {
                    bl = true;
                    ++n;
                    continue;
                }
                if (stringArray[i].trim().equalsIgnoreCase("VIEW")) {
                    bl2 = true;
                    ++n;
                    continue;
                }
                if (stringArray[i].trim().equalsIgnoreCase("SYNONYM") && this.conn.isANSI()) {
                    bl4 = true;
                    ++n;
                    continue;
                }
                if (!stringArray[i].trim().equalsIgnoreCase("SYNONYM")) continue;
                bl4 = true;
                ++n;
                bl3 = true;
                ++n;
            }
        }
        String string4 = this.getMetaDbName(string);
        IfxStatement ifxStatement = null;
        try {
            int n2;
            int n3;
            int n4;
            boolean bl6;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string5 = null;
            String string6 = " CASE WHEN tabtype = 'T' AND tabid <= 99 THEN 'SYSTEM TABLE' WHEN tabtype = 'T' AND tabid > 99 THEN 'TABLE' WHEN tabtype = 'V' THEN 'VIEW' WHEN tabtype = 'S' OR tabtype = 'P' THEN 'SYNONYM' WHEN tabtype = 'L' THEN 'LOG' WHEN tabtype = 'E' THEN 'TABLE' ELSE 'UNKNOWN' END ";
            String string7 = "TABLE_TYPE ";
            string5 = this.conn.isOnLine() ? "select tabname," + string6 + string7 + ", owner from " + string4 + ":gbasedbt.systables " : "select tabname," + string6 + string7 + ", owner from gbasedbt.systables ";
            int n5 = n;
            if (n > 0) {
                string5 = string5 + "where " + string6 + " in (";
            }
            if (bl5) {
                string5 = string5 + "'SYSTEM TABLE'";
                if (--n > 0) {
                    string5 = string5 + ",";
                }
            }
            if (bl) {
                string5 = string5 + "'TABLE'";
                if (--n > 0) {
                    string5 = string5 + ",";
                }
            }
            if (bl2) {
                string5 = string5 + "'VIEW'";
                if (--n > 0) {
                    string5 = string5 + ",";
                }
            }
            if (bl3) {
                string5 = string5 + "'SYNONYM'";
                if (--n > 0) {
                    string5 = string5 + ",";
                }
            }
            if (bl4) {
                string5 = string5 + "'SYNONYM'";
            }
            if (n5 > 0) {
                string5 = string5 + ")";
            }
            boolean bl7 = bl6 = n5 > 0;
            if (string3 != null) {
                if (bl6) {
                    string5 = string5 + " and tabname like '" + string3 + "'";
                } else {
                    bl6 = true;
                    string5 = string5 + " where tabname like '" + string3 + "'";
                }
            }
            if (string2 != null) {
                string5 = bl6 ? string5 + " and owner like '" + string2 + "'" : string5 + " where owner like '" + string2 + "'";
            }
            string5 = string5 + " order by 2, 3, 1";
            ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(10, this.conn);
            IfxResultSetMetaData ifxResultSetMetaData2 = (IfxResultSetMetaData)resultSet.getMetaData();
            if (this.conn.isOnLine()) {
                n4 = 129;
                if (this.conn.getdbEncoding() == "UTF8") {
                    n4 = 85;
                }
                n3 = 1;
                n2 = 0;
                ifxResultSetMetaData.setColInfo(1, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("TABLE_CAT"), ifxResultSetMetaData2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n4, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), ifxResultSetMetaData2.isNullable(1), ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(1, null);
                ifxResultSetMetaData.setColumnStartPosition(1, n2);
                ifxResultSetMetaData.setColInfo(2, ifxResultSetMetaData2.getColumnInfo((int)3).MaxWidth, this.conn.retCapName("TABLE_SCHEM"), ifxResultSetMetaData2.getTableName(3), 13, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(3), n4, ifxResultSetMetaData2.getColumnExtendedId(3), ifxResultSetMetaData2.getExtendedName(3), ifxResultSetMetaData2.getExtendedOwnerName(3), ifxResultSetMetaData2.isNullable(3), ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(2, null);
                ifxResultSetMetaData.setColumnStartPosition(2, n2 += n4 + 1);
                ifxResultSetMetaData.setColInfo(3, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("TABLE_NAME"), ifxResultSetMetaData2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n4, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), ifxResultSetMetaData2.isNullable(1), ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(3, null);
                ifxResultSetMetaData.setColumnStartPosition(3, n2 += n4 + 1);
                ifxResultSetMetaData.setColInfo(4, ifxResultSetMetaData2.getColumnInfo((int)2).MaxWidth, this.conn.retCapName("TABLE_TYPE"), ifxResultSetMetaData2.getTableName(2), 13, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(2), n4, ifxResultSetMetaData2.getColumnExtendedId(2), ifxResultSetMetaData2.getExtendedName(2), ifxResultSetMetaData2.getExtendedOwnerName(2), ifxResultSetMetaData2.isNullable(2), ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(4, null);
                ifxResultSetMetaData.setColumnStartPosition(4, n2 += n4 + 1);
                ifxResultSetMetaData.setColInfo(5, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("REMARKS"), ifxResultSetMetaData2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n4, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), n3, ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(5, null);
                ifxResultSetMetaData.setColumnStartPosition(5, n2 += n4 + 1);
                ifxResultSetMetaData.setColInfo(6, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("TYPE_CAT"), ifxResultSetMetaData2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n4, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), n3, ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(6, null);
                ifxResultSetMetaData.setColumnStartPosition(6, n2 += n4 + 1);
                ifxResultSetMetaData.setColInfo(7, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("TYPE_SCHEM"), ifxResultSetMetaData2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n4, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), n3, ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(7, null);
                ifxResultSetMetaData.setColumnStartPosition(7, n2 += n4 + 1);
                ifxResultSetMetaData.setColInfo(8, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("TYPE_NAME"), ifxResultSetMetaData2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n4, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), n3, ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(8, null);
                ifxResultSetMetaData.setColumnStartPosition(8, n2 += n4 + 1);
                ifxResultSetMetaData.setColInfo(9, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("SELF_REFERENCING_COL_NAME"), ifxResultSetMetaData2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n4, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), n3, ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(9, null);
                ifxResultSetMetaData.setColumnStartPosition(9, n2 += n4 + 1);
                ifxResultSetMetaData.setColInfo(10, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("REF_GENERATION"), ifxResultSetMetaData2.getTableName(1), 13, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n4, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), n3, ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(10, null);
                ifxResultSetMetaData.setColumnStartPosition(10, n2 += n4 + 1);
                n2 += n4 + 1;
            } else {
                n4 = 1;
                n3 = 0;
                n2 = 18;
                ifxResultSetMetaData.setColInfo(1, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("TABLE_CAT"), ifxResultSetMetaData2.getTableName(1), 0, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n2, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), ifxResultSetMetaData2.isNullable(1), ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(1, null);
                ifxResultSetMetaData.setColumnStartPosition(1, n3);
                n3 += n2 + 1;
                n2 = 18;
                ifxResultSetMetaData.setColInfo(2, ifxResultSetMetaData2.getColumnInfo((int)3).MaxWidth, this.conn.retCapName("TABLE_SCHEM"), ifxResultSetMetaData2.getTableName(3), 0, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(3), n2, ifxResultSetMetaData2.getColumnExtendedId(3), ifxResultSetMetaData2.getExtendedName(3), ifxResultSetMetaData2.getExtendedOwnerName(3), ifxResultSetMetaData2.isNullable(3), ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(2, null);
                ifxResultSetMetaData.setColumnStartPosition(2, n3);
                n3 += n2 + 1;
                n2 = 40;
                ifxResultSetMetaData.setColInfo(3, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("TABLE_NAME"), ifxResultSetMetaData2.getTableName(1), 0, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n2, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), ifxResultSetMetaData2.isNullable(1), ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(3, null);
                ifxResultSetMetaData.setColumnStartPosition(3, n3);
                n3 += n2 + 1;
                n2 = 18;
                ifxResultSetMetaData.setColInfo(4, ifxResultSetMetaData2.getColumnInfo((int)2).MaxWidth, this.conn.retCapName("TABLE_TYPE"), ifxResultSetMetaData2.getTableName(2), 0, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(2), n2, ifxResultSetMetaData2.getColumnExtendedId(2), ifxResultSetMetaData2.getExtendedName(2), ifxResultSetMetaData2.getExtendedOwnerName(2), ifxResultSetMetaData2.isNullable(2), ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(4, null);
                ifxResultSetMetaData.setColumnStartPosition(4, n3);
                n3 += n2 + 1;
                n2 = 18;
                ifxResultSetMetaData.setColInfo(5, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("REMARKS"), ifxResultSetMetaData2.getTableName(1), 0, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n2, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), n4, ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(5, null);
                ifxResultSetMetaData.setColumnStartPosition(5, n3);
                n3 += n2 + 1;
                n2 = 18;
                ifxResultSetMetaData.setColInfo(6, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("TYPE_CAT"), ifxResultSetMetaData2.getTableName(1), 0, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n2, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), n4, ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(6, null);
                ifxResultSetMetaData.setColumnStartPosition(6, n3);
                n3 += n2 + 1;
                n2 = 18;
                ifxResultSetMetaData.setColInfo(7, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("TYPE_SCHEM"), ifxResultSetMetaData2.getTableName(3), 0, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n2, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), n4, ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(7, null);
                ifxResultSetMetaData.setColumnStartPosition(7, n3);
                n3 += n2 + 1;
                n2 = 40;
                ifxResultSetMetaData.setColInfo(8, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("TYPE_NAME"), ifxResultSetMetaData2.getTableName(1), 0, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n2, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), n4, ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(8, null);
                ifxResultSetMetaData.setColumnStartPosition(8, n3);
                n3 += n2 + 1;
                n2 = 18;
                ifxResultSetMetaData.setColInfo(9, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("SELF_REFERENCING_COL_NAME"), ifxResultSetMetaData2.getTableName(2), 0, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n2, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), n4, ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(9, null);
                ifxResultSetMetaData.setColumnStartPosition(9, n3);
                n3 += n2 + 1;
                n2 = 18;
                ifxResultSetMetaData.setColInfo(10, ifxResultSetMetaData2.getColumnInfo((int)1).MaxWidth, this.conn.retCapName("REF_GENERATION"), ifxResultSetMetaData2.getTableName(1), 0, IfxTypes.IfxTypeToName(13), ifxResultSetMetaData2.getSourceType(1), n2, ifxResultSetMetaData2.getColumnExtendedId(1), ifxResultSetMetaData2.getExtendedName(1), ifxResultSetMetaData2.getExtendedOwnerName(1), n4, ifxResultSetMetaData2.getDelimIdent() ? 1 : 0);
                ifxResultSetMetaData.setColtitle(10, null);
                ifxResultSetMetaData.setColumnStartPosition(10, n3);
                n3 += n2 + 1;
                n2 = 18;
            }
            resultSetMetaData = ifxResultSetMetaData;
            IfxClientResultSet ifxClientResultSet2 = new IfxClientResultSet(this.conn, resultSetMetaData);
            n3 = resultSetMetaData.getColumnCount();
            Object object = null;
            ifxClientResultSet2.moveToInsertRow();
            while (resultSet.next()) {
                for (int i = 1; i <= n3; ++i) {
                    object = resultSetMetaData.getColumnName(i).equalsIgnoreCase("TABLE_CAT") ? string4 : (resultSetMetaData.getColumnName(i).equalsIgnoreCase("TABLE_SCHEM") ? resultSet.getString(3).trim() : (resultSetMetaData.getColumnName(i).equalsIgnoreCase("TABLE_NAME") ? resultSet.getObject(1) : (resultSetMetaData.getColumnName(i).equalsIgnoreCase("TABLE_TYPE") ? resultSet.getString(2).trim() : (resultSetMetaData.getColumnName(i).equalsIgnoreCase("REMARKS") ? null : (resultSetMetaData.getColumnName(i).equalsIgnoreCase("TYPE_CAT") ? null : (resultSetMetaData.getColumnName(i).equalsIgnoreCase("TYPE_SCHEM") ? null : (resultSetMetaData.getColumnName(i).equalsIgnoreCase("TYPE_NAME") ? null : (resultSetMetaData.getColumnName(i).equalsIgnoreCase("SELF_REFERENCING_COL_NAME") ? null : (resultSetMetaData.getColumnName(i).equalsIgnoreCase("REF_GENERATION") ? null : resultSet.getObject(i))))))))));
                    ifxClientResultSet2.updateObject(i, object);
                }
                if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && resultSet.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                ifxClientResultSet2.insertRow();
            }
            ifxClientResultSet2.beforeFirst();
            ifxClientResultSet2.setType(1003);
            ifxClientResultSet2.setFetchDirection(1000);
            ifxClientResultSet2.setConcurrency(1007);
            ifxClientResultSet = ifxClientResultSet2;
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ifxStatement.close();
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return ifxClientResultSet;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        IfxClientResultSet ifxClientResultSet;
        IfxStatement ifxStatement;
        if (this.conn == null) {
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getSchemas() : call IfxConnection:isDbOpen()");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        try {
            int n;
            int n2;
            int n3;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string = this.getMetaDbName(null);
            String string2 = "select unique owner,'" + string + "' from gbasedbt.systables where tabtype != '' order by 1";
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxDatabaseMetaData:getSchemas() : call IfxStatement:executeQuery(" + string2 + ")");
            }
            ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string2, true) : ifxStatement.executeQuery(string2, false);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(2, this.conn);
            if (this.conn.isOnLine()) {
                n3 = 0;
                n2 = 1;
                ifxResultSetMetaData.setColumnName(n2, this.conn.retCapName("TABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = 85;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("TABLE_CATALOG"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = 85;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ++n2;
            } else {
                n3 = 0;
                n2 = 1;
                ifxResultSetMetaData.setColumnName(n2, this.conn.retCapName("TABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n2, 0);
                n = 18;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("TABLE_CATALOG"));
                ifxResultSetMetaData.setIfxColumnType(n2, 0);
                n = 18;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ++n2;
            }
            resultSetMetaData = ifxResultSetMetaData;
            IfxClientResultSet ifxClientResultSet2 = new IfxClientResultSet(this.conn, resultSetMetaData);
            n2 = resultSetMetaData.getColumnCount();
            Object object = null;
            ifxClientResultSet2.moveToInsertRow();
            while (resultSet.next()) {
                for (int i = 1; i <= n2; ++i) {
                    object = resultSetMetaData.getColumnName(i).equalsIgnoreCase("TABLE_SCHEM") ? resultSet.getString(1).trim() : (resultSetMetaData.getColumnName(i).equalsIgnoreCase("TABLE_CATALOG") ? resultSet.getString(2) : resultSet.getObject(1));
                    ifxClientResultSet2.updateObject(i, object);
                }
                if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && resultSet.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                ifxClientResultSet2.insertRow();
            }
            ifxClientResultSet2.beforeFirst();
            ifxClientResultSet2.setType(1003);
            ifxClientResultSet2.setFetchDirection(1000);
            ifxClientResultSet2.setConcurrency(1007);
            ifxClientResultSet = ifxClientResultSet2;
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ifxStatement.close();
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return ifxClientResultSet;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        IfxClientResultSet ifxClientResultSet;
        IfxProtocol ifxProtocol;
        int n = 0;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "getCatalogs called");
        }
        if (this.conn == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(this.conn.getProtoClassName());
            Class<?> clazz2 = Class.forName(this.conn.getConnClassName());
            Class[] classArray = new Class[]{clazz2};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.conn};
            ifxProtocol = (IfxProtocol)constructor.newInstance(objectArray);
            if (ifxProtocol == null) {
                throw IfxErrMsg.getSQLException(-79736, this.conn);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79735, exception.toString(), this.conn);
        }
        try {
            ifxProtocol.executeGetDBList();
            IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(1, this.conn);
            ifxResultSetMetaData.setEncodedLength(1, 128);
            ifxResultSetMetaData.setNullable(1, 0);
            ifxResultSetMetaData.setMaxWidth(1, 128);
            ifxResultSetMetaData.setColtitle(1, "DB Name");
            ifxResultSetMetaData.setColumnName(1, this.conn.retCapName("TABLE_CAT"));
            ifxResultSetMetaData.setIfxColumnType(1, 0);
            ifxClientResultSet = new IfxClientResultSet(this.conn, ifxResultSetMetaData);
            Vector vector = ifxProtocol.getDBList();
            n = vector.size();
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "Number of databases is " + n);
            }
            if (n > 0) {
                ifxClientResultSet.newRow(n);
                for (int i = 0; i < n; ++i) {
                    ifxClientResultSet.updateString(i + 1, 1, (String)vector.elementAt(i) != null ? stringUtil.trimTrailings((String)vector.elementAt(i)) : null);
                    if (!TraceFlag.compiletrace) continue;
                    this.trace.writeTrace(3, "dbname put in resultset " + (String)vector.elementAt(i));
                }
                ifxClientResultSet.beforeFirst();
                ifxClientResultSet.setFetchDirection(1000);
                ifxClientResultSet.setConcurrency(1007);
                ifxClientResultSet.setType(1003);
            }
        }
        catch (SQLException sQLException) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "Error in accessing vector of db names");
            }
            throw sQLException;
        }
        ifxProtocol.clear();
        ifxProtocol = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, " getCatalogs exitted ");
        }
        return ifxClientResultSet;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        int n;
        ResultSet resultSet;
        IfxStatement ifxStatement;
        if (this.conn == null) {
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getTableTypes() : call IfxConnection:isDbOpen()");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string = this.conn.getDatabaseType() == 1 ? "select unique trim('SYNONYM') as TABLE_TYPE from gbasedbt.systables where tabtype = 'P'" : "select unique trim('PRIVATE_SYNONYM') as TABLE_TYPE from gbasedbt.systables where tabtype = 'P'";
            String string2 = "select unique trim('TABLE') as TABLE_TYPE from gbasedbt.systables where tabtype = 'T' union select unique trim('SYSTEM TABLE') as TABLE_TYPE from gbasedbt.systables where tabtype = 'T' and tabid <= 99 union select unique trim('VIEW') as TABLE_TYPE from gbasedbt.systables where tabtype = 'V' union select unique trim('SYNONYM') as TABLE_TYPE from gbasedbt.systables where tabtype = 'S' union " + string;
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxDatabaseMetaData:getTableTypes() : call IfxStatement:executeQuery(" + string2 + ")");
            }
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string2, true) : ifxStatement.executeQuery(string2, false);
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(1, this.conn);
        if (this.conn.isOnLine()) {
            n = 129;
            if (this.conn.getdbEncoding() == "UTF8") {
                n = 85;
            }
            int n2 = 0;
            int n3 = 1;
            int n4 = n;
            ifxResultSetMetaData.setColumnName(n3, this.conn.retCapName("TABLE_TYPE"));
            ifxResultSetMetaData.setIfxColumnType(n3, 13);
            n4 = n;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4 + 1;
            ++n3;
        } else {
            int n5;
            n = 0;
            int n6 = 1;
            int n7 = n5 = 50;
            ifxResultSetMetaData.setColumnName(n6, this.conn.retCapName("TABLE_TYPE"));
            ifxResultSetMetaData.setIfxColumnType(n6, 13);
            n7 = n5;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7 + 1;
            ++n6;
        }
        resultSetMetaData = ifxResultSetMetaData;
        ResultSet resultSet2 = this.populateClientResultSet(resultSet, resultSetMetaData);
        ifxStatement.close();
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return resultSet2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVirtualColumnText(String string, int n, int n2) {
        String string2 = "";
        String string3 = "select default from " + string + ":sysdefaultsexpr where tabid=" + n + " and colno=" + n2 + " and type='T' order by seqno;";
        if (this.conn == null) {
            return "";
        }
        IfxStatement ifxStatement = null;
        ResultSet resultSet = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            resultSet = ifxStatement.executeQuery(string3);
            while (resultSet.next()) {
                string2 = string2 + resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
            String string4 = string2;
            return string4;
        }
        finally {
            try {
                resultSet.close();
                ifxStatement.close();
            }
            catch (SQLException sQLException) {
                return string2;
            }
        }
        return string2.trim();
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        IfxClientResultSet ifxClientResultSet;
        if (this.conn == null) {
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getColumns() : call IfxConnection:isDbOpen()");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "%";
        }
        IfxStatement ifxStatement = null;
        try {
            int n;
            int n2;
            int n3;
            int n4;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string5 = this.getMetaDbName(string);
            boolean bl = false;
            if (this.conn.isUSVER()) {
                bl = true;
            }
            if (!this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
            }
            string3 = string3.trim();
            if (!bl) {
                string3 = this.checkSynonym(string3, string5);
            }
            if (!this.conn.isDelimIdentSet()) {
                string4 = string4.toLowerCase();
            }
            string4 = string4.trim();
            if (!this.conn.isDelimIdentSet()) {
                string2 = this.toSchemaCaseLikeServer(string2);
            }
            String string6 = null;
            if (bl) {
                string6 = "SELECT trim(t.owner)::VARCHAR(128), t.tabname::VARCHAR(128), c.colname::VARCHAR(128)," + string5 + ":gbasedbt.get_data_type(c.coltype, c.extended_id, 0)::SMALLINT, " + string5 + ":gbasedbt.schema_coltypename(c.coltype,c.extended_id)::VARCHAR(128)," + string5 + ":gbasedbt.schema_precision(c.coltype, c.extended_id, c.collength)::INTEGER, 0::INTEGER," + string5 + ":gbasedbt.schema_numscale(c.coltype, c.collength)::INTEGER, " + string5 + ":gbasedbt.schema_numprecradix(c.coltype)::INTEGER," + string5 + ":gbasedbt.schema_isnullable(c.coltype)::INTEGER, NULL::VARCHAR(254),CASE d.type   WHEN 'L' THEN " + string5 + ":gbasedbt.get_default_value(c.coltype, c.extended_id, c.collength, d.default::lvarchar(256))::VARCHAR(254)   WHEN 'C' THEN 'current'::VARCHAR(254)   WHEN 'S' THEN 'dbservername'::VARCHAR(254)   WHEN 'U' THEN 'user'::VARCHAR(254)   WHEN 'T' THEN 'today'::VARCHAR(254)  ELSE    NULL::VARCHAR(254) END,c.coltype::INTEGER, " + string5 + ":gbasedbt.schema_datetype(c.coltype, c.collength)::INTEGER, " + string5 + ":gbasedbt.schema_charlen(c.coltype, c.extended_id, c.collength)::INTEGER,c.colno::INTEGER colno, " + string5 + ":gbasedbt.schema_nullable(c.coltype)::VARCHAR(3), NULL::VARCHAR(128), NULL::VARCHAR(128), NULL::VARCHAR(128), NULL::smallint, " + string5 + ":gbasedbt.schema_isautoincr(c.coltype)::VARCHAR(3),c.extended_id::INTEGER, c.colattr::INTEGER, t.tabid FROM " + string5 + ":gbasedbt.systables t,    OUTER " + string5 + ":gbasedbt.sysdefaults d, " + string5 + ":gbasedbt.syscolumns c     WHERE t.tabid = c.tabid and d.tabid = t.tabid      AND c.colno = d.colno      AND (t.tabtype not in ('P', 'S'))      AND (d.class in ('T'))      AND t.tabname like '" + string3 + "'     AND t.owner like '" + string2 + "'";
                if (string4.length() > 0) {
                    string6 = string6 + " and c.colname like '" + string4 + "'";
                }
                string6 = string6 + " union SELECT    trim(st.owner)::VARCHAR(128),    st.tabname::VARCHAR(128),    c.colname::VARCHAR(128)," + string5 + ":gbasedbt.get_data_type(c.coltype,c.extended_id, 0)::SMALLINT, " + string5 + ":gbasedbt.schema_coltypename(c.coltype,c.extended_id)::VARCHAR(128)," + string5 + ":gbasedbt.schema_precision(c.coltype, c.extended_id, c.collength)::INTEGER,   0::INTEGER," + string5 + ":gbasedbt.schema_numscale(c.coltype, c.collength)::INTEGER, " + string5 + ":gbasedbt.schema_numprecradix(c.coltype)::INTEGER," + string5 + ":gbasedbt.schema_isnullable(c.coltype)::INTEGER,    NULL::VARCHAR(254),   CASE d.type      WHEN 'L' THEN " + string5 + ":gbasedbt.get_default_value(c.coltype, c.extended_id, c.collength, d.default::lvarchar(256))::VARCHAR(254)      WHEN 'C' THEN 'current'::VARCHAR(254) WHEN 'S' THEN 'dbservername'::VARCHAR(254) WHEN 'U' THEN 'user'::VARCHAR(254)      WHEN 'T' THEN 'today'::VARCHAR(254)      ELSE        NULL::VARCHAR(254)    END,   c.coltype::INTEGER, " + string5 + ":gbasedbt.schema_datetype(c.coltype, c.collength)::INTEGER, " + string5 + ":gbasedbt.schema_charlen(c.coltype, c.extended_id, c.collength)::INTEGER,   c.colno::INTEGER colno, " + string5 + ":gbasedbt.schema_nullable(c.coltype)::VARCHAR(3),    NULL::VARCHAR(128),    NULL::VARCHAR(128),    NULL::VARCHAR(128),    NULL::smallint, " + string5 + ":gbasedbt.schema_isautoincr(c.coltype)::VARCHAR(3), c.extended_id::INTEGER, c.colattr::INTEGER, t.tabid    FROM " + string5 + ":gbasedbt.systables st," + string5 + ":gbasedbt.syssyntable s, " + string5 + ":gbasedbt.systables t,     OUTER  " + string5 + ":gbasedbt.sysdefaults d,  " + string5 + ":gbasedbt.syscolumns c       WHERE st.tabid = s.tabid       AND s.btabid = t.tabid       AND t.tabid = c.tabid       AND d.tabid = t.tabid       AND c.colno = d.colno       AND (st.tabtype in ('P', 'S'))       AND (d.class in ('T'))       AND st.tabname LIKE '" + string3 + "'      AND st.owner LIKE '" + string2 + "'";
                if (string4.length() > 0) {
                    string6 = string6 + " AND c.colname LIKE '" + string4 + "'";
                }
                string6 = string6 + " order by 1,2,16 ";
            } else {
                string6 = this.conn.isOnLine() ? "select st.tabname, sc.colname,  sc.colno, sc.coltype, sc.collength,  sc.colmin, sc.colmax, st.owner,   sdf.type, sdf.default from " + string5 + ":gbasedbt.systables st, " + string5 + ":gbasedbt.syscolumns sc,    outer " + string5 + ":gbasedbt.sysdefaults sdf where st.tabname like '" + string3 + "' and st.owner like '" + string2 + "' and st.tabid = sc.tabid   and st.tabid = sdf.tabid   and sc.colno = sdf.colno " : "select st.tabname, sc.colname,  sc.colno, sc.coltype, sc.collength, st.owner,   sdf.type, sdf.default from gbasedbt.systables st, gbasedbt.syscolumns sc,   outer gbasedbt.sysdefaults sdf where st.tabname like '" + string3 + "' and st.owner like '" + string2 + "' and st.tabid = sc.tabid   and st.tabid = sdf.tabid   and sc.colno = sdf.colno ";
            }
            if (!bl) {
                if (string4.length() > 0) {
                    string6 = string6 + " and sc.colname like '" + string4 + "'";
                }
                int n5 = this.conn.isOnLine() ? 8 : 6;
                string6 = string6 + " order by " + n5 + ",1,3";
            }
            ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string6, true) : ifxStatement.executeQuery(string6, false);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(23, this.conn);
            if (this.conn.isOnLine()) {
                n4 = 129;
                if (this.conn.getdbEncoding() == "UTF8") {
                    n4 = 85;
                }
                n3 = 0;
                n2 = 1;
                n = n4;
                ifxResultSetMetaData.setColumnName(n2, this.conn.retCapName("TABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("TABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("TABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("COLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("DATA_TYPE"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("TYPE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("COLUMN_SIZE"));
                ifxResultSetMetaData.setIfxColumnType(n2, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("BUFFER_LENGTH"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("DECIMAL_DIGITS"));
                ifxResultSetMetaData.setIfxColumnType(n2, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("NUM_PREC_RADIX"));
                ifxResultSetMetaData.setIfxColumnType(n2, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("NULLABLE"));
                ifxResultSetMetaData.setIfxColumnType(n2, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("REMARKS"));
                ifxResultSetMetaData.setIfxColumnType(n2, 0);
                n = 18;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("COLUMN_DEF"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = 255;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("SQL_DATA_TYPE"));
                ifxResultSetMetaData.setIfxColumnType(n2, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("SQL_DATETIME_SUB"));
                ifxResultSetMetaData.setIfxColumnType(n2, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("CHAR_OCTET_LENGTH"));
                ifxResultSetMetaData.setIfxColumnType(n2, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("ORDINAL_POSITION"));
                ifxResultSetMetaData.setIfxColumnType(n2, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("IS_NULLABLE"));
                ifxResultSetMetaData.setIfxColumnType(n2, 0);
                n = 3;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("SCOPE_CATALOG"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = 255;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("SCOPE_SCHEMA"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = 255;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("SCOPE_TABLE"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = 255;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("SOURCE_DATA_TYPE"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("IS_AUTOINCREMENT"));
                ifxResultSetMetaData.setIfxColumnType(n2, 0);
                n = 3;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ++n2;
            } else {
                n4 = 0;
                n3 = 1;
                n = n2 = 50;
                ifxResultSetMetaData.setColumnName(n3, this.conn.retCapName("TABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("TABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("TABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("COLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("DATA_TYPE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("TYPE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("COLUMN_SIZE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("BUFFER_LENGTH"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("DECIMAL_DIGITS"));
                ifxResultSetMetaData.setIfxColumnType(n3, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("NUM_PREC_RADIX"));
                ifxResultSetMetaData.setIfxColumnType(n3, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("NULLABLE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("REMARKS"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = 18;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("COLUMN_DEF"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = 255;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("SQL_DATA_TYPE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("SQL_DATETIME_SUB"));
                ifxResultSetMetaData.setIfxColumnType(n3, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("CHAR_OCTET_LENGTH"));
                ifxResultSetMetaData.setIfxColumnType(n3, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("ORDINAL_POSITION"));
                ifxResultSetMetaData.setIfxColumnType(n3, 2);
                n = 4;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("IS_NULLABLE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = 3;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("SCOPE_CATALOG"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("SCOPE_SCHEMA"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("SCOPE_TABLE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("SOURCE_DATA_TYPE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("IS_AUTOINCREMENT"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = 3;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ++n3;
            }
            resultSetMetaData = ifxResultSetMetaData;
            IfxClientResultSet ifxClientResultSet2 = new IfxClientResultSet(this.conn, resultSetMetaData);
            n3 = resultSetMetaData.getColumnCount();
            Object object = null;
            ifxClientResultSet2.moveToInsertRow();
            if (bl) {
                while (resultSet.next()) {
                    short s = (short)(resultSet.getInt(13) & 0xFF);
                    String string7 = IfxTypes.IfxTypeToName(s);
                    n = resultSet.getInt(23);
                    IfxUDTInfo ifxUDTInfo = this.conn.getUDTInfo(n);
                    boolean bl2 = false;
                    int n6 = resultSet.getInt(4);
                    boolean bl3 = false;
                    if (s == 41 || s == 40 || n > 0) {
                        bl2 = true;
                        ifxUDTInfo = this.conn.getUDTInfo(n);
                        if (ifxUDTInfo != null && ifxUDTInfo.JDBCtype == 2001) {
                            bl3 = true;
                        }
                    }
                    for (int i = 1; i <= n3; ++i) {
                        int n7;
                        int n8;
                        int n9;
                        int n10;
                        if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("TABLE_CAT")) {
                            object = string5;
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("TABLE_SCHEM")) {
                            object = resultSet.getString(1).trim();
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("TABLE_NAME")) {
                            object = resultSet.getString(2);
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("COLUMN_NAME")) {
                            object = resultSet.getString(3);
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("DATA_TYPE")) {
                            n10 = resultSet.getInt(24) & 0x100;
                            n9 = resultSet.getInt(24) & 0x2F6;
                            if (n10 > 0 && n9 <= 0) {
                                object = null;
                            } else if (bl3) {
                                object = ifxUDTInfo.JDBCtype;
                            } else if (n6 == 93) {
                                n8 = resultSet.getInt(6);
                                n7 = n8 >> 4 & 0xF;
                                int n11 = n8 & 0xF;
                                object = n7 >= 6 && n11 <= 15 ? Integer.valueOf(92) : Integer.valueOf(93);
                            } else {
                                object = n6;
                            }
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("TYPE_NAME")) {
                            n10 = resultSet.getInt(24) & 0x100;
                            n9 = resultSet.getInt(24) & 0x2F6;
                            if (n10 > 0 && n9 <= 0) {
                                object = null;
                            } else {
                                object = resultSet.getString(5);
                                try {
                                    if (bl2 && ifxUDTInfo != null && ifxUDTInfo.getName().length() > 0) {
                                        object = ifxUDTInfo.getName().toUpperCase();
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("COLUMN_SIZE")) {
                            if (resultSet.getInt(4) == 92 || resultSet.getInt(4) == 93) {
                                n10 = resultSet.getInt(6);
                                n9 = n10 >> 8 & 0xFF;
                                n8 = n10 >> 4 & 0xF;
                                n7 = n10 & 0xF;
                                n10 = n9 + ((n7 > 10 ? 12 : n7) - n8) / 2 + (n8 == 12 ? 1 : 0);
                                object = n10;
                            } else {
                                object = resultSet.getInt(6);
                            }
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("BUFFER_LENGTH")) {
                            object = resultSet.getInt(7);
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("DECIMAL_DIGITS")) {
                            object = resultSet.getInt(8);
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("NUM_PREC_RADIX")) {
                            object = resultSet.getInt(9);
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("NULLABLE")) {
                            object = resultSet.getInt(10);
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("REMARKS")) {
                            object = resultSet.getString(11);
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("COLUMN_DEF")) {
                            n10 = resultSet.getInt(24) & 0x100;
                            object = n10 > 0 ? this.getVirtualColumnText(string5, resultSet.getInt(25), resultSet.getInt("colno")) : resultSet.getString(12);
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("SQL_DATA_TYPE")) {
                            object = bl3 ? Integer.valueOf(ifxUDTInfo.SQLtype) : Integer.valueOf(IfxTypes.FromJDBCToIfxType(resultSet.getInt(4)));
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("SQL_DATETIME_SUB")) {
                            object = 0;
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("CHAR_OCTET_LENGTH")) {
                            object = resultSet.getInt(15);
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("ORDINAL_POSITION")) {
                            object = resultSet.getInt(16);
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("IS_NULLABLE")) {
                            object = resultSet.getString(17);
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("SCOPE_CATALOG")) {
                            object = resultSet.getString(18);
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("SCOPE_SCHEMA")) {
                            object = resultSet.getString(19);
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("SCOPE_TABLE")) {
                            object = resultSet.getString(20);
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("SOURCE_DATA_TYPE")) {
                            if (bl3) {
                                if (resultSet.getInt(4) == 93) {
                                    n10 = resultSet.getInt(6);
                                    n9 = n10 >> 4 & 0xF;
                                    n8 = n10 & 0xF;
                                    object = n9 >= 6 && n8 <= 15 ? Integer.valueOf(92) : Integer.valueOf(93);
                                } else if (ifxUDTInfo != null) {
                                    if (ifxUDTInfo.JDBCtype == 2001 && ifxUDTInfo.SQLtype == 41) {
                                        switch (ifxUDTInfo.source) {
                                            case 10: {
                                                object = 2004;
                                                break;
                                            }
                                            case 11: {
                                                object = 2005;
                                                break;
                                            }
                                            case 5: {
                                                object = 16;
                                                break;
                                            }
                                            default: {
                                                object = IfxTypes.FromIfxToJDBCType(ifxUDTInfo.SQLtype);
                                                break;
                                            }
                                        }
                                    } else {
                                        object = IfxTypes.FromIfxToJDBCType(ifxUDTInfo.SQLtype);
                                    }
                                } else {
                                    object = resultSet.getShort(21);
                                }
                            } else {
                                object = null;
                            }
                        } else if (resultSetMetaData.getColumnName(i).equalsIgnoreCase("IS_AUTOINCREMENT")) {
                            object = resultSet.getString(22);
                        }
                        ifxClientResultSet2.updateObject(i, object);
                    }
                    if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && resultSet.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                    ifxClientResultSet2.insertRow();
                }
            } else {
                while (resultSet.next()) {
                    byte by;
                    short s = resultSet.getShort(4);
                    short s2 = (short)(s & 0xFF);
                    short s3 = resultSet.getShort(5);
                    short s4 = 0;
                    if (this.conn.isUSVER()) {
                        s4 = resultSet.getShort(10);
                    }
                    int n12 = IfxDatabaseMetaData.getJDBCColumnSize(s2, s4, s3);
                    String string8 = this.conn.isUSVER() ? resultSet.getString(11) : (this.conn.isOnLine() ? resultSet.getString(9) : resultSet.getString(7));
                    String string9 = string8 == null ? null : (string8.equals("N") ? null : (string8.equals("C") ? "current" : (string8.equals("T") ? "today" : (string8.equals("U") ? "user" : (string8.equals("S") ? "dbservername" : (string8.equals("L") ? (this.conn.isUSVER() ? resultSet.getString(12) : (this.conn.isOnLine() ? resultSet.getString(10) : resultSet.getString(8))) : null))))));
                    String string10 = IfxTypes.IfxTypeToName(s2);
                    if (this.conn.isUSVER()) {
                        if ((s2 == 41 || s2 == 40) && (string10 = resultSet.getString(9)) == null) {
                            IfxUDTInfo ifxUDTInfo = this.conn.getUDTInfo(resultSet.getInt(10));
                            if (ifxUDTInfo == null) {
                                throw IfxErrMsg.getSQLException(-79770, this.conn);
                            }
                            string10 = ifxUDTInfo.getName();
                        }
                        if ((s & 0x800) == 2048) {
                            string10 = resultSet.getString(9);
                        }
                    }
                    string10 = string10.trim();
                    short s5 = (short)IfxTypes.FromIfxToJDBCType(s2);
                    if (s2 == 4 && !this.conn.getMapReal()) {
                        s5 = 6;
                    }
                    if (this.conn.isUSVER()) {
                        if ((s & 0x800) == 2048) {
                            s5 = 2001;
                        }
                        if (string10.equals("boolean")) {
                            s5 = Driver.compareJDKVersion("1.4") < 0 ? (short)1111 : 16;
                        } else if (string10.equals("lvarchar")) {
                            s5 = -1;
                        } else if (string10.equals("blob")) {
                            s5 = 2004;
                        } else if (string10.equals("clob")) {
                            s5 = 2005;
                        }
                    }
                    if (s2 == 10) {
                        n = IfxDateTime.getStartCode(s3);
                        by = IfxDateTime.getEndCode(s3);
                        string10 = Interval.getIfxTypeName(10, s3);
                        s5 = n >= 6 && by <= 10 ? (short)92 : 93;
                    }
                    if (s2 == 14) {
                        n = Interval.getStartCode(s3);
                        by = Interval.getEndCode(s3);
                        string10 = Interval.getIfxTypeName(14, s3);
                    }
                    int n13 = 0;
                    int n14 = 0;
                    if (s2 == 1 || s2 == 2 || s2 == 6) {
                        n13 = 10;
                    } else if (this.conn.isUSVER() && (s2 == 17 || s2 == 18)) {
                        n13 = 10;
                    } else if (s2 == 5 || s2 == 8) {
                        n14 = s3 - s3 / 256 * 256;
                        n13 = 10;
                    } else if (s2 == 3) {
                        n13 = 10;
                    } else if (s2 == 4) {
                        n13 = 10;
                    } else if (this.conn.isUSVER() && s2 == 41 && (string10.equals("boolean") || (s & 0x4000) == 16384)) {
                        n13 = 2;
                    }
                    int n15 = 1;
                    String string11 = "YES";
                    if ((s & 0x100) == 256) {
                        n15 = 0;
                        string11 = "NO";
                    }
                    short s6 = 0;
                    if (s2 == 0) {
                        s6 = s3;
                    }
                    if (string9 != null) {
                        if (!(string9.equals("") || !string8.equals("L") || string10.equals("char") || string10.equals("nchar") || string10.equals("nvarchar") || string10.equals("varchar") || string10.equals("lvarchar") || string10.equals("boolean"))) {
                            n = string9.indexOf(32);
                            if (TraceFlag.compiletrace) {
                                this.trace.writeTrace(3, "idx = " + n);
                            }
                            while (string9.charAt(n + 1) == ' ' && string9.length() != ++n + 1) {
                            }
                            string9 = string9.substring(n + 1);
                            if (TraceFlag.compiletrace) {
                                this.trace.writeTrace(3, "defvalue = '" + string9 + "'");
                            }
                        }
                        string9 = string9.trim();
                    }
                    for (n = 1; n <= n3; ++n) {
                        object = resultSetMetaData.getColumnName(n).equalsIgnoreCase("TABLE_CAT") ? string5 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("TABLE_SCHEM") ? (this.conn.isOnLine() ? resultSet.getString(8).trim() : resultSet.getString(6).trim()) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("TABLE_NAME") ? resultSet.getString(1) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("COLUMN_NAME") ? resultSet.getString(2) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("DATA_TYPE") ? new Short(s5) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("TYPE_NAME") ? string10 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("COLUMN_SIZE") ? Integer.valueOf(n12) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("BUFFER_LENGTH") ? Integer.valueOf(0) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("DECIMAL_DIGITS") ? Integer.valueOf(n14) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("NUM_PREC_RADIX") ? Integer.valueOf(n13) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("NULLABLE") ? Integer.valueOf(n15) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("REMARKS") ? null : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("COLUMN_DEF") ? string9 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("SQL_DATA_TYPE") ? Integer.valueOf(0) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("SQL_DATETIME_SUB") ? Integer.valueOf(0) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("CHAR_OCTET_LENGTH") ? Integer.valueOf(s6) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("ORDINAL_POSITION") ? new Short(resultSet.getShort(3)) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("IS_NULLABLE") ? string11 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("SCOPE_CATLOG") ? null : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("SCOPE_SCHEMA") ? null : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("SCOPE_TABLE") ? null : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("SOURCE_DATA_TYPE") ? new Short(0) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("IS_AUTOINCREMENT") ? string11 : resultSet.getObject(1)))))))))))))))))))))));
                        ifxClientResultSet2.updateObject(n, object);
                    }
                    if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && resultSet.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                    ifxClientResultSet2.insertRow();
                }
            }
            ifxClientResultSet2.beforeFirst();
            ifxClientResultSet2.setType(1003);
            ifxClientResultSet2.setFetchDirection(1000);
            ifxClientResultSet2.setConcurrency(1007);
            ifxClientResultSet = ifxClientResultSet2;
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ifxStatement.close();
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return ifxClientResultSet;
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        int n;
        ResultSet resultSet;
        Object object;
        String string5;
        String string6 = this.nextTempTableName();
        String string7 = "NO";
        if (this.conn == null) {
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getColumnPrivileges() : call IfxConnection:isDbOpen()");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            string5 = this.getMetaDbName(string);
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string6 + "(   TABLE_CAT     varchar(129),   TABLE_SCHEM   varchar(129),   TABLE_NAME    varchar(129),   COLUMN_NAME   varchar(129),   GRANTOR       varchar(129),   GRANTEE       varchar(129),   PRIVILEGE     varchar(20),   IS_GRANTABLE  varchar(3) ) " + this.getNoLogTerm());
            } else {
                ifxStatement.executeUpdate("create temp table " + string6 + "(   TABLE_CAT     char(50),   TABLE_SCHEM   char(50),   TABLE_NAME    char(50),   COLUMN_NAME   char(18),   GRANTOR       char(18),   GRANTEE       char(18),   PRIVILEGE     char(20),   IS_GRANTABLE  char(3) )");
            }
            if (string3 != null && !this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
            }
            if (string4 != null && !this.conn.isDelimIdentSet()) {
                string4 = string4.toLowerCase();
            }
            if (string2 != null && !this.conn.isDelimIdentSet()) {
                string2 = this.toSchemaCaseLikeServer(string2);
            }
            boolean bl = false;
            if (this.conn.isANSI() && this.conn.getAutoCommit()) {
                bl = true;
            }
            object = null;
            object = this.conn.isOnLine() ? "select sc.colname, sa.grantor, sa.grantee, sa.colauth, st.tabname, st.owner from " + string5 + ":gbasedbt.systables st, " + string5 + ":gbasedbt.syscolumns sc, " + string5 + ":gbasedbt.syscolauth sa  where  st.tabname = '" + string3 + "' and  st.tabid = sa.tabid and  sc.tabid = st.tabid and  sc.colname like '" + string4 + "' and  sc.colno = sa.colno and  st.owner like '" + string2 + "'union  select sc.colname, sa.grantor, sa.grantee, sa.tabauth, st.tabname, st.owner from " + string5 + ":gbasedbt.systables st, " + string5 + ":gbasedbt.syscolumns sc, " + string5 + ":gbasedbt.systabauth sa  where  st.tabname = '" + string3 + "' and  st.tabid = sa.tabid and  sc.tabid = st.tabid and  sc.colname like '" + string4 + "' and  st.owner like '" + string2 + "' order by 1" : "select sc.colname, sa.grantor, sa.grantee, sa.colauth, st.tabname, st.owner from gbasedbt.systables st, gbasedbt.syscolumns sc, gbasedbt.syscolauth sa where st.tabname = '" + string3 + "' and st.tabid = sa.tabid and sc.tabid = st.tabid and sc.colname like '" + string4 + "' and sc.colno = sa.colno and st.owner like '" + string2 + "'union select sc.colname, sa.grantor, sa.grantee, sa.tabauth, st.tabname, st.owner from gbasedbt.systables st, gbasedbt.syscolumns sc, gbasedbt.systabauth sa where st.tabname = '" + string3 + "' and st.tabid = sa.tabid and sc.tabid = st.tabid and sc.colname like '" + string4 + "' and st.owner like '" + string2 + "' order by 1";
            resultSet = ifxStatement.executeQuery((String)object, bl);
            String string8 = "";
            String string9 = "";
            while (resultSet.next()) {
                String string10 = string8;
                string8 = resultSet.getString(1);
                String string11 = resultSet.getString(4);
                if (string8 != null) {
                    string8 = string8.trim();
                }
                if (string11 != null) {
                    string11 = string11.trim();
                }
                if (!string8.equals(string10)) {
                    string9 = "";
                }
                for (int i = 0; i < string11.length(); ++i) {
                    String string12 = null;
                    n = string11.charAt(i);
                    switch (n) {
                        case 82: 
                        case 114: {
                            if (string9.indexOf(n) != -1) break;
                            string9 = string9 + "r";
                            string12 = "REFERENCES";
                            break;
                        }
                        case 83: 
                        case 115: {
                            if (string9.indexOf(n) != -1) break;
                            string9 = string9 + "s";
                            string12 = "SELECT";
                            break;
                        }
                        case 85: 
                        case 117: {
                            if (string9.indexOf(n) != -1) break;
                            string9 = string9 + "u";
                            string12 = "UPDATE";
                        }
                    }
                    if (string12 == null) continue;
                    string7 = Character.isUpperCase((char)n) ? "YES" : "NO";
                    String string13 = resultSet.getString(2).trim();
                    string13 = resultSet.wasNull() || string13 == null ? "null" : "'" + string13 + "'";
                    ifxStatement2.executeUpdate("insert into " + string6 + " values( '" + string5 + "', '" + resultSet.getString(6).trim() + "', '" + resultSet.getString(5) + "', '" + resultSet.getString(1) + "', " + string13 + ", '" + resultSet.getString(3).trim() + "', '" + string12 + "', '" + string7 + "' )");
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        string5 = "select * from " + string6 + " order by 4, 7";
        resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
        Object object2 = resultSet.getMetaData();
        object = new IfxResultSetMetaData(8, this.conn);
        if (this.conn.isOnLine()) {
            n = 129;
            if (this.conn.getdbEncoding() == "UTF8") {
                n = 85;
            }
            int n2 = 0;
            int n3 = 1;
            int n4 = n;
            ((IfxResultSetMetaData)object).setColumnName(n3, this.conn.retCapName("TABLE_CAT"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n3, 13);
            n4 = n;
            ((IfxResultSetMetaData)object).setEncodedLength(n3, n4);
            ((IfxResultSetMetaData)object).setTableName(n3, "");
            ((IfxResultSetMetaData)object).setColtitle(n3, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n3, n2);
            n2 += n4 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n3, this.conn.retCapName("TABLE_SCHEM"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n3, 13);
            n4 = n;
            ((IfxResultSetMetaData)object).setEncodedLength(n3, n4);
            ((IfxResultSetMetaData)object).setTableName(n3, "");
            ((IfxResultSetMetaData)object).setColtitle(n3, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n3, n2);
            n2 += n4 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n3, this.conn.retCapName("TABLE_NAME"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n3, 13);
            n4 = n;
            ((IfxResultSetMetaData)object).setEncodedLength(n3, n4);
            ((IfxResultSetMetaData)object).setTableName(n3, "");
            ((IfxResultSetMetaData)object).setColtitle(n3, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n3, n2);
            n2 += n4 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n3, this.conn.retCapName("COLUMN_NAME"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n3, 13);
            n4 = n;
            ((IfxResultSetMetaData)object).setEncodedLength(n3, n4);
            ((IfxResultSetMetaData)object).setTableName(n3, "");
            ((IfxResultSetMetaData)object).setColtitle(n3, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n3, n2);
            n2 += n4 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n3, this.conn.retCapName("GRANTOR"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n3, 13);
            n4 = n;
            ((IfxResultSetMetaData)object).setEncodedLength(n3, n4);
            ((IfxResultSetMetaData)object).setTableName(n3, "");
            ((IfxResultSetMetaData)object).setColtitle(n3, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n3, n2);
            n2 += n4;
            ((IfxResultSetMetaData)object).setColumnName(++n3, this.conn.retCapName("GRANTEE"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n3, 13);
            n4 = n;
            ((IfxResultSetMetaData)object).setEncodedLength(n3, n4);
            ((IfxResultSetMetaData)object).setTableName(n3, "");
            ((IfxResultSetMetaData)object).setColtitle(n3, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n3, n2);
            n2 += n4 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n3, this.conn.retCapName("PRIVELEGE"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n3, 13);
            n4 = n;
            ((IfxResultSetMetaData)object).setEncodedLength(n3, n4);
            ((IfxResultSetMetaData)object).setTableName(n3, "");
            ((IfxResultSetMetaData)object).setColtitle(n3, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n3, n2);
            n2 += n4;
            ((IfxResultSetMetaData)object).setColumnName(++n3, this.conn.retCapName("IS_GRANTABLE"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n3, 0);
            n4 = 3;
            ((IfxResultSetMetaData)object).setEncodedLength(n3, n4);
            ((IfxResultSetMetaData)object).setTableName(n3, "");
            ((IfxResultSetMetaData)object).setColtitle(n3, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n3, n2);
            n2 += n4;
            ++n3;
        } else {
            int n5;
            n = 0;
            int n6 = 1;
            int n7 = n5 = 50;
            ((IfxResultSetMetaData)object).setColumnName(n6, this.conn.retCapName("TABLE_CAT"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n6, 0);
            n7 = n5;
            ((IfxResultSetMetaData)object).setEncodedLength(n6, n7);
            ((IfxResultSetMetaData)object).setTableName(n6, "");
            ((IfxResultSetMetaData)object).setColtitle(n6, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n6, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n6, this.conn.retCapName("TABLE_SCHEM"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n6, 0);
            n7 = n5;
            ((IfxResultSetMetaData)object).setEncodedLength(n6, n7);
            ((IfxResultSetMetaData)object).setTableName(n6, "");
            ((IfxResultSetMetaData)object).setColtitle(n6, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n6, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n6, this.conn.retCapName("TABLE_NAME"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n6, 0);
            n7 = n5;
            ((IfxResultSetMetaData)object).setEncodedLength(n6, n7);
            ((IfxResultSetMetaData)object).setTableName(n6, "");
            ((IfxResultSetMetaData)object).setColtitle(n6, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n6, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n6, this.conn.retCapName("COLUMN_NAME"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n6, 0);
            n7 = n5;
            ((IfxResultSetMetaData)object).setEncodedLength(n6, n7);
            ((IfxResultSetMetaData)object).setTableName(n6, "");
            ((IfxResultSetMetaData)object).setColtitle(n6, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n6, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n6, this.conn.retCapName("GRANTOR"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n6, 0);
            n7 = n5;
            ((IfxResultSetMetaData)object).setEncodedLength(n6, n7);
            ((IfxResultSetMetaData)object).setTableName(n6, "");
            ((IfxResultSetMetaData)object).setColtitle(n6, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n6, n);
            n += n7;
            ((IfxResultSetMetaData)object).setColumnName(++n6, this.conn.retCapName("GRANTEE"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n6, 0);
            n7 = n5;
            ((IfxResultSetMetaData)object).setEncodedLength(n6, n7);
            ((IfxResultSetMetaData)object).setTableName(n6, "");
            ((IfxResultSetMetaData)object).setColtitle(n6, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n6, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n6, this.conn.retCapName("PRIVELEGE"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n6, 0);
            n7 = n5;
            ((IfxResultSetMetaData)object).setEncodedLength(n6, n7);
            ((IfxResultSetMetaData)object).setTableName(n6, "");
            ((IfxResultSetMetaData)object).setColtitle(n6, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n6, n);
            n += n7;
            ((IfxResultSetMetaData)object).setColumnName(++n6, this.conn.retCapName("IS_GRANTABLE"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n6, 0);
            n7 = 3;
            ((IfxResultSetMetaData)object).setEncodedLength(n6, n7);
            ((IfxResultSetMetaData)object).setTableName(n6, "");
            ((IfxResultSetMetaData)object).setColtitle(n6, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n6, n);
            n += n7;
            ++n6;
        }
        object2 = object;
        ResultSet resultSet2 = this.populateClientResultSet(resultSet, (ResultSetMetaData)object2);
        ifxStatement.close();
        ifxStatement2.close();
        this.dropTempTable(string6);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return resultSet2;
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        int n;
        ResultSet resultSet;
        Object object;
        String string4;
        String string5 = this.nextTempTableName();
        String string6 = "NO";
        if (this.conn == null) {
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getTablePrivileges() : call IfxConnection:isDbOpen()");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            string4 = this.getMetaDbName(string);
            if (!this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
            }
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string5 + "(   TABLE_CAT     varchar(129),   TABLE_SCHEM   varchar(129),   TABLE_NAME    varchar(129),   GRANTOR       varchar(129),   GRANTEE       varchar(129),   PRIVILEGE     varchar(20),   IS_GRANTABLE  varchar(3) ) " + this.getNoLogTerm());
            } else {
                ifxStatement.executeUpdate("create temp table " + string5 + "(   TABLE_CAT     char(18),   TABLE_SCHEM   char(18),   TABLE_NAME    char(40),   GRANTOR       char(18),   GRANTEE       char(18),   PRIVILEGE     char(20),   IS_GRANTABLE  char(3) )");
            }
            object = null;
            object = this.conn.isOnLine() ? "select st.tabname, sa.grantor, sa.grantee, sa.tabauth, st.owner from " + string4 + ":gbasedbt.systables st, " + string4 + ":gbasedbt.systabauth sa  where   st.tabname like '" + string3 + "' and st.tabid = sa.tabid and st.owner like '" + string2 + "'" : "select st.tabname, sa.grantor, sa.grantee, sa.tabauth, st.owner from  gbasedbt.systables st,  gbasedbt.systabauth sa  where  st.tabname like '" + string3 + "' and st.tabid = sa.tabid and st.owner like '" + string2 + "'";
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery((String)object, true) : ifxStatement.executeQuery((String)object, false);
            while (resultSet.next()) {
                String string7 = resultSet.getString(1);
                String string8 = resultSet.getString(3);
                String string9 = resultSet.getString(3);
                String string10 = resultSet.getString(4);
                for (int i = 0; i < string10.length(); ++i) {
                    String string11 = null;
                    char c = string10.charAt(i);
                    switch (c) {
                        case 'S': 
                        case 's': {
                            string11 = "SELECT";
                            break;
                        }
                        case 'U': 
                        case 'u': {
                            string11 = "UPDATE";
                            break;
                        }
                        case 'I': 
                        case 'i': {
                            string11 = "INSERT";
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            string11 = "DELETE";
                            break;
                        }
                        case 'X': 
                        case 'x': {
                            string11 = "INDEX";
                            break;
                        }
                        case 'A': 
                        case 'a': {
                            string11 = "ALTER";
                            break;
                        }
                        case 'R': 
                        case 'r': {
                            string11 = "REFERENCES";
                            break;
                        }
                        case 'N': 
                        case 'n': {
                            string11 = "UNDER";
                        }
                    }
                    if (string11 == null) continue;
                    string6 = Character.isUpperCase(c) ? "YES" : "NO";
                    ifxStatement2.executeUpdate("insert into " + string5 + " values( '" + string4 + "', '" + resultSet.getString(5).trim() + "', '" + string7 + "', '" + string8.trim() + "', '" + string9.trim() + "', '" + string11 + "', '" + string6 + "' )");
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ifxStatement2.close();
        string4 = "select * from " + string5 + " order by 3, 6, 4, 5, 7";
        resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        object = resultSet.getMetaData();
        IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(7, this.conn);
        if (this.conn.isOnLine()) {
            n = 129;
            if (this.conn.getdbEncoding() == "UTF8") {
                n = 85;
            }
            int n2 = 0;
            int n3 = 1;
            int n4 = n;
            ifxResultSetMetaData.setColumnName(n3, this.conn.retCapName("TABLE_CAT"));
            ifxResultSetMetaData.setIfxColumnType(n3, 13);
            n4 = n;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4 + 1;
            ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("TABLE_SCHEM"));
            ifxResultSetMetaData.setIfxColumnType(n3, 13);
            n4 = n;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4 + 1;
            ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("TABLE_NAME"));
            ifxResultSetMetaData.setIfxColumnType(n3, 13);
            n4 = n;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4 + 1;
            ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("GRANTOR"));
            ifxResultSetMetaData.setIfxColumnType(n3, 13);
            n4 = n;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4;
            ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("GRANTEE"));
            ifxResultSetMetaData.setIfxColumnType(n3, 13);
            n4 = n;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4 + 1;
            ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PRIVELEGE"));
            ifxResultSetMetaData.setIfxColumnType(n3, 13);
            n4 = n;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4;
            ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("IS_GRANTABLE"));
            ifxResultSetMetaData.setIfxColumnType(n3, 0);
            n4 = 3;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4;
            ++n3;
        } else {
            int n5;
            n = 0;
            int n6 = 1;
            int n7 = n5 = 50;
            ifxResultSetMetaData.setColumnName(n6, this.conn.retCapName("TABLE_CAT"));
            ifxResultSetMetaData.setIfxColumnType(n6, 0);
            n7 = n5;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7 + 1;
            ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("TABLE_SCHEM"));
            ifxResultSetMetaData.setIfxColumnType(n6, 0);
            n7 = n5;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7 + 1;
            ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("TABLE_NAME"));
            ifxResultSetMetaData.setIfxColumnType(n6, 0);
            n7 = n5;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7 + 1;
            ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("GRANTOR"));
            ifxResultSetMetaData.setIfxColumnType(n6, 0);
            n7 = n5;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7;
            ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("GRANTEE"));
            ifxResultSetMetaData.setIfxColumnType(n6, 0);
            n7 = n5;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7 + 1;
            ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("PRIVELEGE"));
            ifxResultSetMetaData.setIfxColumnType(n6, 0);
            n7 = n5;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7;
            ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("IS_GRANTABLE"));
            ifxResultSetMetaData.setIfxColumnType(n6, 0);
            n7 = 3;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7;
            ++n6;
        }
        object = ifxResultSetMetaData;
        ResultSet resultSet2 = this.populateClientResultSet(resultSet, (ResultSetMetaData)object);
        ifxStatement.close();
        this.dropTempTable(string5);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return resultSet2;
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        IfxClientResultSet ifxClientResultSet;
        if (this.conn == null) {
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getBestRowIdentifier() : call IfxConnection:isDbOpen()");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        String string4 = this.getMetaDbName(string);
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        IfxStatement ifxStatement = null;
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            String string5;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            if (!this.conn.isDelimIdentSet()) {
                string5 = string3.toLowerCase();
                string2 = this.toSchemaCaseLikeServer(string2);
            } else {
                string5 = string3;
            }
            String string6 = "SELECT sc.colname, sc.colno, sc.coltype, sc.collength  FROM " + string4 + ":gbasedbt.systables st, " + string4 + ":gbasedbt.sysconstraints so, " + string4 + ":gbasedbt.sysindexes si, " + string4 + ":gbasedbt.syscolumns sc  WHERE (st.tabname LIKE '" + string3 + "' OR st.tabname LIKE '" + string5 + "' ) AND  st.tabid = so.tabid AND so.constrtype = 'P' AND so.idxname = si.idxname AND sc.tabid = st.tabid AND st.owner LIKE '" + string2 + "' AND   (sc.colno = si.part1 OR    sc.colno = si.part2 OR    sc.colno = si.part3 OR    sc.colno = si.part4 OR    sc.colno = si.part5 OR    sc.colno = si.part6 OR    sc.colno = si.part7 OR    sc.colno = si.part8 ";
            if (this.conn.isOnLine()) {
                string6 = string6 + " or sc.colno = si.part9 OR     sc.colno = si.part10 OR     sc.colno = si.part11 OR     sc.colno = si.part12 OR     sc.colno = si.part13 OR     sc.colno = si.part14 OR     sc.colno = si.part15 OR     sc.colno = si.part16 ";
            }
            string6 = string6 + ")";
            string6 = string6 + " order by 2";
            ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string6, true) : ifxStatement.executeQuery(string6, false);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(8, this.conn);
            if (this.conn.isOnLine()) {
                n5 = 129;
                n4 = 0;
                n3 = 1;
                n2 = n5;
                ifxResultSetMetaData.setColumnName(n3, this.conn.retCapName("SCOPE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n2 = n5;
                ifxResultSetMetaData.setEncodedLength(n3, n2);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n2 + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("COLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 13);
                n2 = n5;
                ifxResultSetMetaData.setEncodedLength(n3, n2);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n2 + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("DATA_TYPE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n2 = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n2);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n2;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("TYPE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 13);
                n2 = n5;
                ifxResultSetMetaData.setEncodedLength(n3, n2);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n2 + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("COLUMN_SIZE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 2);
                n2 = 4;
                ifxResultSetMetaData.setEncodedLength(n3, n2);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n2;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("BUFFER_LENGTH"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n2 = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n2);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n2;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("DECIMAL_DIGITS"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n2 = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n2);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n2;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PSEUDO_COLUMN"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n2 = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n2);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n2;
                ++n3;
            } else {
                n5 = 0;
                n4 = 1;
                n2 = n3 = 18;
                ifxResultSetMetaData.setColumnName(n4, this.conn.retCapName("SCOPE"));
                ifxResultSetMetaData.setIfxColumnType(n4, 1);
                n2 = n3;
                ifxResultSetMetaData.setEncodedLength(n4, n2);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n5);
                n5 += n2 + 1;
                ifxResultSetMetaData.setColumnName(++n4, this.conn.retCapName("COLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n4, 0);
                n2 = n3;
                ifxResultSetMetaData.setEncodedLength(n4, n2);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n5);
                n5 += n2 + 1;
                ifxResultSetMetaData.setColumnName(++n4, this.conn.retCapName("DATA_TYPE"));
                ifxResultSetMetaData.setIfxColumnType(n4, 1);
                n2 = 2;
                ifxResultSetMetaData.setEncodedLength(n4, n2);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n5);
                n5 += n2;
                ifxResultSetMetaData.setColumnName(++n4, this.conn.retCapName("TYPE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n4, 0);
                n2 = n3;
                ifxResultSetMetaData.setEncodedLength(n4, n2);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n5);
                n5 += n2 + 1;
                ifxResultSetMetaData.setColumnName(++n4, this.conn.retCapName("COLUMN_SIZE"));
                ifxResultSetMetaData.setIfxColumnType(n4, 2);
                n2 = 4;
                ifxResultSetMetaData.setEncodedLength(n4, n2);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n5);
                n5 += n2;
                ifxResultSetMetaData.setColumnName(++n4, this.conn.retCapName("BUFFER_LENGTH"));
                ifxResultSetMetaData.setIfxColumnType(n4, 1);
                n2 = 2;
                ifxResultSetMetaData.setEncodedLength(n4, n2);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n5);
                n5 += n2;
                ifxResultSetMetaData.setColumnName(++n4, this.conn.retCapName("DECIMAL_DIGITS"));
                ifxResultSetMetaData.setIfxColumnType(n4, 1);
                n2 = 4;
                ifxResultSetMetaData.setEncodedLength(n4, n2);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n5);
                n5 += n2;
                ifxResultSetMetaData.setColumnName(++n4, this.conn.retCapName("PSEUDO_COLUMN"));
                ifxResultSetMetaData.setIfxColumnType(n4, 1);
                n2 = 2;
                ifxResultSetMetaData.setEncodedLength(n4, n2);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n5);
                n5 += n2;
                ++n4;
            }
            resultSetMetaData = ifxResultSetMetaData;
            IfxClientResultSet ifxClientResultSet2 = new IfxClientResultSet(this.conn, resultSetMetaData);
            n4 = resultSetMetaData.getColumnCount();
            Object object = null;
            ifxClientResultSet2.moveToInsertRow();
            while (resultSet.next()) {
                String string7 = resultSet.getString(1);
                short s = resultSet.getShort(3);
                short s2 = (short)(s & 0xFF);
                s2 = (short)(s & 0xFF);
                short s3 = (short)IfxTypes.FromIfxToJDBCType(s2);
                if (s2 == 4 && !this.conn.getMapReal()) {
                    s3 = 6;
                }
                for (n2 = 1; n2 <= n4; ++n2) {
                    object = resultSetMetaData.getColumnName(n2).equalsIgnoreCase("scope") ? new Short(2) : (resultSetMetaData.getColumnName(n2).equalsIgnoreCase("COLUMN_NAME") ? resultSet.getString(1) : (resultSetMetaData.getColumnName(n2).equalsIgnoreCase("DATA_TYPE") ? new Short(s3) : (resultSetMetaData.getColumnName(n2).equalsIgnoreCase("TYPE_NAME") ? IfxTypes.IfxTypeToName(s2) : (resultSetMetaData.getColumnName(n2).equalsIgnoreCase("COLUMN_SIZE") ? Integer.valueOf(resultSet.getShort(4)) : (resultSetMetaData.getColumnName(n2).equalsIgnoreCase("BUFFER_LENGTH") ? Integer.valueOf(0) : (resultSetMetaData.getColumnName(n2).equalsIgnoreCase("DECIMAL_DIGITS") ? new Short(0) : (resultSetMetaData.getColumnName(n2).equalsIgnoreCase("PSEUDO_COLUMN") ? new Short(1) : resultSet.getObject(n2))))))));
                    ifxClientResultSet2.updateObject(n2, object);
                }
                if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && resultSet.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                ifxClientResultSet2.insertRow();
            }
            ifxClientResultSet2.beforeFirst();
            ifxClientResultSet2.setType(1003);
            ifxClientResultSet2.setFetchDirection(1000);
            ifxClientResultSet2.setConcurrency(1007);
            ifxClientResultSet = ifxClientResultSet2;
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ifxStatement.close();
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return ifxClientResultSet;
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        int n;
        ResultSet resultSet;
        IfxStatement ifxStatement;
        if (this.conn == null) {
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getVersionColumns() : call IfxConnection:isDbOpen()");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        String string4 = this.getMetaDbName(string);
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        }
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string5 = this.conn.isOnLine() ? "select 0 as SCOPE, c.colname as COLUMN_NAME, c.coltype as DATA_TYPE, '' as TYPE_NAME, 0 as COLUMN_SIZE, c.collength as BUFFER_LENGTH, 0 as DECIMAL_DIGITS, 1 as PSEUDO_COLUMN from " + string4 + ":gbasedbt.systables t, " + string4 + ":gbasedbt.syscolumns c where t.tabid = c.tabid and t.owner like '" + string2 + "' and t.tabname like '" + string3 + "' and mod(c.coltype,256) = 6" : "select '' as SCOPE, c.colname as COLUMN_NAME, c.coltype as DATA_TYPE, '' as TYPE_NAME, '' as COLUMN_SIZE, c.collength as BUFFER_LENGTH, 0 as DECIMAL_DIGITS, 1 as PSEUDO_COLUMN from gbasedbt.systables t, gbasedbt.syscolumns c where t.tabid = c.tabid and t.owner like '" + string2 + "' and t.tabname like '" + string3 + "' and mod(c.coltype,256) = 6";
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxDatabaseMetaData:getVersionColumns() : call IfxStatement:executeQuery(" + string5 + ")");
            }
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(8, this.conn);
        if (this.conn.isOnLine()) {
            n = 129;
            if (this.conn.getdbEncoding() == "UTF8") {
                n = 85;
            }
            int n2 = 0;
            int n3 = 1;
            int n4 = n;
            ifxResultSetMetaData.setColumnName(n3, this.conn.retCapName("SCOPE"));
            ifxResultSetMetaData.setIfxColumnType(n3, 1);
            n4 = 2;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4 + 1;
            ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("COLUMN_NAME"));
            ifxResultSetMetaData.setIfxColumnType(n3, 13);
            n4 = n;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4 + 1;
            ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("DATA_TYPE"));
            ifxResultSetMetaData.setIfxColumnType(n3, 2);
            n4 = 4;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4 + 1;
            ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("TYPE_NAME"));
            ifxResultSetMetaData.setIfxColumnType(n3, 13);
            n4 = n;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4 + 1;
            ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("COLUMN_SIZE"));
            ifxResultSetMetaData.setIfxColumnType(n3, 2);
            n4 = 4;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4;
            ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("BUFFER_LENGTH"));
            ifxResultSetMetaData.setIfxColumnType(n3, 1);
            n4 = 2;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4;
            ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("DECIMAL_DIGITS"));
            ifxResultSetMetaData.setIfxColumnType(n3, 2);
            n4 = 4;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4;
            ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PSEUDO_COLUMN"));
            ifxResultSetMetaData.setIfxColumnType(n3, 1);
            n4 = 2;
            ifxResultSetMetaData.setEncodedLength(n3, n4);
            ifxResultSetMetaData.setTableName(n3, "");
            ifxResultSetMetaData.setColtitle(n3, null);
            ifxResultSetMetaData.setColumnStartPosition(n3, n2);
            n2 += n4;
            ++n3;
        } else {
            int n5;
            n = 0;
            int n6 = 1;
            int n7 = n5 = 50;
            ifxResultSetMetaData.setColumnName(n6, this.conn.retCapName("SCOPE"));
            ifxResultSetMetaData.setIfxColumnType(n6, 1);
            n7 = 2;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7 + 1;
            ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("COLUMN_NAME"));
            ifxResultSetMetaData.setIfxColumnType(n6, 13);
            n7 = n5;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7 + 1;
            ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("DATA_TYPE"));
            ifxResultSetMetaData.setIfxColumnType(n6, 2);
            n7 = 4;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7 + 1;
            ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("TYPE_NAME"));
            ifxResultSetMetaData.setIfxColumnType(n6, 13);
            n7 = n5;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7 + 1;
            ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("COLUMN_SIZE"));
            ifxResultSetMetaData.setIfxColumnType(n6, 2);
            n7 = 4;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7;
            ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("BUFFER_LENGTH"));
            ifxResultSetMetaData.setIfxColumnType(n6, 1);
            n7 = 2;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7;
            ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("DECIMAL_DIGITS"));
            ifxResultSetMetaData.setIfxColumnType(n6, 2);
            n7 = 4;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7;
            ifxResultSetMetaData.setColumnName(++n6, this.conn.retCapName("PSEUDO_COLUMN"));
            ifxResultSetMetaData.setIfxColumnType(n6, 1);
            n7 = 2;
            ifxResultSetMetaData.setEncodedLength(n6, n7);
            ifxResultSetMetaData.setTableName(n6, "");
            ifxResultSetMetaData.setColtitle(n6, null);
            ifxResultSetMetaData.setColumnStartPosition(n6, n);
            n += n7;
            ++n6;
        }
        resultSetMetaData = ifxResultSetMetaData;
        ResultSet resultSet2 = this.populateClientResultSet(resultSet, resultSetMetaData);
        ifxStatement.close();
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return resultSet2;
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        IfxClientResultSet ifxClientResultSet;
        String string4 = null;
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string4 = string3.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        } else {
            string4 = string3;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getPrimaryKeys() : call IfxConnection:isDbOpen()");
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        IfxStatement ifxStatement = null;
        try {
            int n;
            int n2;
            int n3;
            int n4;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string5 = this.getMetaDbName(string);
            String string6 = "  select   sc.colname,  so.constrname,   st.tabname,   st.owner,   sc.colno,   ABS(si.part1),ABS(si.part2),ABS(si.part3),ABS(si.part4),  ABS(si.part5),ABS(si.part6),ABS(si.part7),ABS(si.part8) " + (this.conn.isOnLine() ? " ,ABS(si.part9),ABS(si.part10),ABS(si.part11),ABS(si.part12), ABS(si.part13),ABS(si.part14),ABS(si.part15),ABS(si.part16) " : " ") + " from " + string5 + ":gbasedbt.systables st," + string5 + ":gbasedbt.sysconstraints so," + string5 + ":gbasedbt.sysindexes si," + string5 + ":gbasedbt.syscolumns sc   where   ( st.tabname like '" + string3 + "' or   st.tabname like '" + string4 + "' ) and  st.tabid = so.tabid and  so.constrtype = 'P' and  so.idxname = si.idxname and  sc.tabid = st.tabid and  st.owner like '" + string2 + "' and  (sc.colno = ABS(si.part1) or    sc.colno = ABS(si.part2) or    sc.colno = ABS(si.part3) or    sc.colno = ABS(si.part4) or    sc.colno = ABS(si.part5) or    sc.colno = ABS(si.part6) or    sc.colno = ABS(si.part7) or    sc.colno = ABS(si.part8) ";
            if (this.conn.isOnLine()) {
                string6 = string6 + " or sc.colno = ABS(si.part9) or     sc.colno = ABS(si.part10) or     sc.colno = ABS(si.part11) or     sc.colno = ABS(si.part12) or     sc.colno = ABS(si.part13) or     sc.colno = ABS(si.part14) or     sc.colno = ABS(si.part15) or     sc.colno = ABS(si.part16) ";
            }
            string6 = string6 + ") order by 1";
            ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string6, true) : ifxStatement.executeQuery(string6, false);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(6, this.conn);
            if (this.conn.isOnLine()) {
                n4 = 129;
                n3 = 0;
                n2 = 1;
                n = n4;
                ifxResultSetMetaData.setColumnName(n2, this.conn.retCapName("TABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("TABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("TABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("COLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("KEY_SEQ"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PK_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ++n2;
            } else {
                n4 = 0;
                n3 = 1;
                n = n2 = 18;
                ifxResultSetMetaData.setColumnName(n3, this.conn.retCapName("TABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("TABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("TABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("COLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("KEY_SEQ"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PK_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ++n3;
            }
            resultSetMetaData = ifxResultSetMetaData;
            IfxClientResultSet ifxClientResultSet2 = new IfxClientResultSet(this.conn, resultSetMetaData);
            n3 = resultSetMetaData.getColumnCount();
            Object object = null;
            ifxClientResultSet2.moveToInsertRow();
            int n5 = n = this.conn.isOnLine() ? 16 : 8;
            while (resultSet.next()) {
                int n6;
                String string7 = resultSet.getString(1);
                String string8 = resultSet.getString(2);
                String string9 = resultSet.getString(3);
                String string10 = resultSet.getString(4);
                if (string7 != null) {
                    string7 = string7.trim();
                }
                if (string8 != null) {
                    string8 = string8.trim();
                }
                if (string9 != null) {
                    string9 = string9.trim();
                }
                if (string10 != null) {
                    string10 = string10.trim();
                }
                int n7 = resultSet.getInt(5);
                short s = 0;
                for (n6 = 0; n6 < n; ++n6) {
                    if (n7 != resultSet.getInt(6 + n6)) continue;
                    s = (short)(n6 + 1);
                    break;
                }
                for (n6 = 1; n6 <= n3; ++n6) {
                    object = resultSetMetaData.getColumnName(n6).equalsIgnoreCase("TABLE_CAT") ? string5 : (resultSetMetaData.getColumnName(n6).equalsIgnoreCase("TABLE_SCHEM") ? string10 : (resultSetMetaData.getColumnName(n6).equalsIgnoreCase("TABLE_NAME") ? string9 : (resultSetMetaData.getColumnName(n6).equalsIgnoreCase("COLUMN_NAME") ? string7 : (resultSetMetaData.getColumnName(n6).equalsIgnoreCase("KEY_SEQ") ? new Short(s) : (resultSetMetaData.getColumnName(n6).equalsIgnoreCase("PK_NAME") ? string8 : resultSet.getObject(n6))))));
                    ifxClientResultSet2.updateObject(n6, object);
                }
                if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && resultSet.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                ifxClientResultSet2.insertRow();
            }
            ifxClientResultSet2.beforeFirst();
            ifxClientResultSet2.setType(1003);
            ifxClientResultSet2.setFetchDirection(1000);
            ifxClientResultSet2.setConcurrency(1007);
            ifxClientResultSet = ifxClientResultSet2;
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ifxStatement.close();
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return ifxClientResultSet;
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        IfxClientResultSet ifxClientResultSet;
        short s = 0;
        if (this.conn == null) {
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getImportedKeys() : call IfxConnection:isDbOpen()");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            int n;
            int n2;
            int n3;
            int n4;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string4 = this.getMetaDbName(string);
            if (!this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
                string2 = this.toSchemaCaseLikeServer(string2);
            }
            String string5 = "select pt.tabname, pc.colname, ft.owner, ft.tabname, fc.colname, fk.constrname, pk.constrname, r.delrule, pt.owner, fc.colno,   ABS(fi.part1),ABS(fi.part2),ABS(fi.part3),ABS(fi.part4),ABS(fi.part5),ABS(fi.part6),ABS(fi.part7),ABS(fi.part8) " + (this.conn.isOnLine() ? ",ABS(fi.part9),ABS(fi.part10),ABS(fi.part11),ABS(fi.part12),ABS(fi.part13),ABS(fi.part14),ABS(fi.part15),ABS(fi.part16)" : " ") + ", CASE WHEN fc.colno=ABS(fi.part1) THEN 1  WHEN fc.colno=ABS(fi.part2) THEN 2  WHEN fc.colno=ABS(fi.part3) THEN 3  WHEN fc.colno=ABS(fi.part4) THEN 4  WHEN fc.colno=ABS(fi.part5) THEN 5  WHEN fc.colno=ABS(fi.part6) THEN 6  WHEN fc.colno=ABS(fi.part7) THEN 7  WHEN fc.colno=ABS(fi.part8) THEN 8 " + (this.conn.isOnLine() ? " WHEN fc.colno=ABS(fi.part9) THEN 9  WHEN fc.colno=ABS(fi.part10) THEN 10  WHEN fc.colno=ABS(fi.part11) THEN 11  WHEN fc.colno=ABS(fi.part12) THEN 12  WHEN fc.colno=ABS(fi.part13) THEN 13  WHEN fc.colno=ABS(fi.part14) THEN 14  WHEN fc.colno=ABS(fi.part15) THEN 15  WHEN fc.colno=ABS(fi.part16) THEN 16 " : " ") + "END AS KeySeq, '" + string4 + "' AS DBName  from " + string4 + ":gbasedbt.systables pt, " + string4 + ":gbasedbt.syscolumns pc, " + string4 + ":gbasedbt.sysindexes pi, " + string4 + ":gbasedbt.sysconstraints pk, " + string4 + ":gbasedbt.systables ft, " + string4 + ":gbasedbt.syscolumns fc, " + string4 + ":gbasedbt.sysindexes fi, " + string4 + ":gbasedbt.sysconstraints fk, " + string4 + ":gbasedbt.sysreferences r where pt.tabid=pc.tabid and pc.tabid=pi.tabid and pt.tabid=pk.tabid and pk.constrid=r.primary and r.constrid=fk.constrid and pi.idxname=pk.idxname and fi.idxname=fk.idxname and ft.tabid=fc.tabid and fc.tabid=fi.tabid and ft.tabid=fk.tabid and pt.owner like '" + string2 + "' and (pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1) or pc.colno=ABS(pi.part2) and fc.colno=ABS(fi.part2) or pc.colno=ABS(pi.part3) and fc.colno=ABS(fi.part3) or pc.colno=ABS(pi.part4) and fc.colno=ABS(fi.part4) or pc.colno=ABS(pi.part5) and fc.colno=ABS(fi.part5) or pc.colno=ABS(pi.part6) and fc.colno=ABS(fi.part6) or pc.colno=ABS(pi.part7) and fc.colno=ABS(fi.part7) or pc.colno=ABS(pi.part8) and fc.colno=ABS(fi.part8)";
            if (this.conn.isOnLine()) {
                string5 = string5 + "or pc.colno=ABS(pi.part9) and fc.colno=ABS(fi.part9) or pc.colno=ABS(pi.part10) and fc.colno=ABS(fi.part10) or pc.colno=ABS(pi.part11) and fc.colno=ABS(fi.part11) or pc.colno=ABS(pi.part12) and fc.colno=ABS(fi.part12) or pc.colno=ABS(pi.part13) and fc.colno=ABS(fi.part13) or pc.colno=ABS(pi.part14) and fc.colno=ABS(fi.part14) or pc.colno=ABS(pi.part15) and fc.colno=ABS(fi.part15) or pc.colno=ABS(pi.part16) and fc.colno=ABS(fi.part16)) ";
            }
            string5 = string5 + "and ft.owner like '" + string2 + "' and ft.tabname like '" + string3 + "' order by DBName ,pt.owner, pt.tabname, KeySeq;";
            ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(14, this.conn);
            if (this.conn.isOnLine()) {
                n4 = 129;
                n3 = 0;
                n2 = 1;
                n = n4;
                ifxResultSetMetaData.setColumnName(n2, this.conn.retCapName("PKTABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PKTABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PKTABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PKCOLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("FKTABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("FKTABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("FKTABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("FKCOLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("KEY_SEQ"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("UPDATE_RULE"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("DELETE_RULE"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("FK_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PK_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("DEFERRABILITY"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ++n2;
            } else {
                n4 = 0;
                n3 = 1;
                n = n2 = 18;
                ifxResultSetMetaData.setColumnName(n3, this.conn.retCapName("PKTABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PKTABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PKTABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PKCOLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("FKTABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("FKTABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("FKTABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("FKCOLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("KEY_SEQ"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("UPDATE_RULE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("DELETE_RULE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("FK_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PK_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("DEFERRABILITY"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ++n3;
            }
            resultSetMetaData = ifxResultSetMetaData;
            IfxClientResultSet ifxClientResultSet2 = new IfxClientResultSet(this.conn, resultSetMetaData);
            n3 = resultSetMetaData.getColumnCount();
            Object object = null;
            ifxClientResultSet2.moveToInsertRow();
            while (resultSet.next()) {
                String string6 = resultSet.getString(1).trim();
                String string7 = resultSet.getString(2).trim();
                String string8 = resultSet.getString(3).trim();
                String string9 = resultSet.getString(4).trim();
                String string10 = resultSet.getString(5).trim();
                String string11 = resultSet.getString(6).trim();
                String string12 = resultSet.getString(7).trim();
                String string13 = resultSet.getString(8);
                String string14 = resultSet.getString(9).trim();
                int n5 = resultSet.getInt(10);
                s = this.conn.isOnLine() ? resultSet.getShort(27) : resultSet.getShort(19);
                short s2 = string13.equals("C") ? (short)0 : 1;
                for (n = 1; n <= n3; ++n) {
                    object = resultSetMetaData.getColumnName(n).equalsIgnoreCase("PKTABLE_CAT") ? string4 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PKTABLE_SCHEM") ? string14 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PKTABLE_NAME") ? string6 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PKCOLUMN_NAME") ? string7 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("FKTABLE_CAT") ? string4 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("FKTABLE_SCHEM") ? string8 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("FKTABLE_NAME") ? string9 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("FKCOLUMN_NAME") ? string10 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("KEY_SEQ") ? new Short(s) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("UPDATE_RULE") ? new Short(1) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("DELETE_RULE") ? new Short(s2) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("FK_NAME") ? string11 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PK_NAME") ? string12 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("DEFERRABILITY") ? new Short(7) : resultSet.getObject(n))))))))))))));
                    ifxClientResultSet2.updateObject(n, object);
                }
                if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && resultSet.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                ifxClientResultSet2.insertRow();
            }
            ifxClientResultSet2.beforeFirst();
            ifxClientResultSet2.setType(1003);
            ifxClientResultSet2.setFetchDirection(1000);
            ifxClientResultSet2.setConcurrency(1007);
            ifxClientResultSet = ifxClientResultSet2;
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ifxStatement2.close();
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return ifxClientResultSet;
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        IfxClientResultSet ifxClientResultSet;
        short s = 0;
        if (this.conn == null) {
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getImportedKeys() : call IfxConnection:isDbOpen()");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            int n;
            int n2;
            int n3;
            int n4;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string4 = this.getMetaDbName(string);
            if (!this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
                string2 = this.toSchemaCaseLikeServer(string2);
            }
            String string5 = "select pt.tabname, pc.colname, ft.owner, ft.tabname, fc.colname, fk.constrname, pk.constrname, r.delrule, pt.owner, fc.colno, ABS(fi.part1),ABS(fi.part2),ABS(fi.part3),ABS(fi.part4),ABS(fi.part5),ABS(fi.part6),ABS(fi.part7),ABS(fi.part8) " + (this.conn.isOnLine() ? ",ABS(fi.part9),ABS(fi.part10),ABS(fi.part11),ABS(fi.part12),ABS(fi.part13),ABS(fi.part14),ABS(fi.part15),ABS(fi.part16) " : " ") + ", CASE WHEN fc.colno=ABS(fi.part1) THEN 1  WHEN fc.colno=ABS(fi.part2) THEN 2  WHEN fc.colno=ABS(fi.part3) THEN 3  WHEN fc.colno=ABS(fi.part4) THEN 4  WHEN fc.colno=ABS(fi.part5) THEN 5  WHEN fc.colno=ABS(fi.part6) THEN 6  WHEN fc.colno=ABS(fi.part7) THEN 7  WHEN fc.colno=ABS(fi.part8) THEN 8 " + (this.conn.isOnLine() ? " WHEN fc.colno=ABS(fi.part9) THEN 9  WHEN fc.colno=ABS(fi.part10) THEN 10  WHEN fc.colno=ABS(fi.part11) THEN 11  WHEN fc.colno=ABS(fi.part12) THEN 12  WHEN fc.colno=ABS(fi.part13) THEN 13  WHEN fc.colno=ABS(fi.part14) THEN 14  WHEN fc.colno=ABS(fi.part15) THEN 15  WHEN fc.colno=ABS(fi.part16) THEN 16 " : " ") + "END AS KeySeq, '" + string4 + "' AS DBName  from " + string4 + ":gbasedbt.systables pt, " + string4 + ":gbasedbt.syscolumns pc, " + string4 + ":gbasedbt.sysindexes pi, " + string4 + ":gbasedbt.sysconstraints pk, " + string4 + ":gbasedbt.systables ft, " + string4 + ":gbasedbt.syscolumns fc, " + string4 + ":gbasedbt.sysindexes fi, " + string4 + ":gbasedbt.sysconstraints fk, " + string4 + ":gbasedbt.sysreferences r where pt.tabid=pc.tabid and pc.tabid=pi.tabid and pt.tabid=pk.tabid and pk.constrid=r.primary and r.constrid=fk.constrid and pi.idxname=pk.idxname and fi.idxname=fk.idxname and ft.tabid=fc.tabid and fc.tabid=fi.tabid and ft.tabid=fk.tabid and (pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1) or pc.colno=ABS(pi.part2) and fc.colno=ABS(fi.part2) or pc.colno=ABS(pi.part3) and fc.colno=ABS(fi.part3) or pc.colno=ABS(pi.part4) and fc.colno=ABS(fi.part4) or pc.colno=ABS(pi.part5) and fc.colno=ABS(fi.part5) or pc.colno=ABS(pi.part6) and fc.colno=ABS(fi.part6) or pc.colno=ABS(pi.part7) and fc.colno=ABS(fi.part7) or pc.colno=ABS(pi.part8) and fc.colno=ABS(fi.part8) ";
            if (this.conn.isOnLine()) {
                string5 = string5 + "or pc.colno=ABS(pi.part9) and fc.colno=ABS(fi.part9) or pc.colno=ABS(pi.part10) and fc.colno=ABS(fi.part10) or pc.colno=ABS(pi.part11) and fc.colno=ABS(fi.part11) or pc.colno=ABS(pi.part12) and fc.colno=ABS(fi.part12) or pc.colno=ABS(pi.part13) and fc.colno=ABS(fi.part13) or pc.colno=ABS(pi.part14) and fc.colno=ABS(fi.part14) or pc.colno=ABS(pi.part15) and fc.colno=ABS(fi.part15) or pc.colno=ABS(pi.part16) and fc.colno=ABS(fi.part16)) ";
            }
            string5 = string5 + "and pt.owner like '" + string2 + "' and pt.tabname like '" + string3 + "' order by DBName, ft.owner, ft.tabname, KeySeq;";
            ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(14, this.conn);
            if (this.conn.isOnLine()) {
                n4 = 129;
                n3 = 0;
                n2 = 1;
                n = n4;
                ifxResultSetMetaData.setColumnName(n2, this.conn.retCapName("PKTABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PKTABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PKTABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PKCOLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("FKTABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("FKTABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("FKTABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("FKCOLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("KEY_SEQ"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("UPDATE_RULE"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("DELETE_RULE"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("FK_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PK_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("DEFERRABILITY"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ++n2;
            } else {
                n4 = 0;
                n3 = 1;
                n = n2 = 18;
                ifxResultSetMetaData.setColumnName(n3, this.conn.retCapName("PKTABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PKTABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PKTABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PKCOLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("FKTABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("FKTABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("FKTABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("FKCOLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("KEY_SEQ"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("UPDATE_RULE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("DELETE_RULE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("FK_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PK_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("DEFERRABILITY"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ++n3;
            }
            resultSetMetaData = ifxResultSetMetaData;
            IfxClientResultSet ifxClientResultSet2 = new IfxClientResultSet(this.conn, resultSetMetaData);
            n3 = resultSetMetaData.getColumnCount();
            Object object = null;
            ifxClientResultSet2.moveToInsertRow();
            while (resultSet.next()) {
                String string6 = resultSet.getString(1);
                String string7 = resultSet.getString(2);
                String string8 = resultSet.getString(3).trim();
                String string9 = resultSet.getString(4);
                String string10 = resultSet.getString(5);
                String string11 = resultSet.getString(6);
                String string12 = resultSet.getString(7);
                String string13 = resultSet.getString(8);
                String string14 = resultSet.getString(9).trim();
                int n5 = resultSet.getInt(10);
                s = this.conn.isOnLine() ? resultSet.getShort(27) : resultSet.getShort(19);
                short s2 = string13.equals("C") ? (short)0 : 1;
                for (n = 1; n <= n3; ++n) {
                    object = resultSetMetaData.getColumnName(n).equalsIgnoreCase("PKTABLE_CAT") ? string4 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PKTABLE_SCHEM") ? string14 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PKTABLE_NAME") ? string6 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PKCOLUMN_NAME") ? string7 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("FKTABLE_CAT") ? string4 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("FKTABLE_SCHEM") ? string8 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("FKTABLE_NAME") ? string9 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("FKCOLUMN_NAME") ? string10 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("KEY_SEQ") ? new Short(s) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("UPDATE_RULE") ? new Short(1) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("DELETE_RULE") ? new Short(s2) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("FK_NAME") ? string11 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PK_NAME") ? string12 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("DEFERRABILITY") ? new Short(7) : resultSet.getObject(n))))))))))))));
                    ifxClientResultSet2.updateObject(n, object);
                }
                if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && resultSet.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                ifxClientResultSet2.insertRow();
            }
            ifxClientResultSet2.beforeFirst();
            ifxClientResultSet2.setType(1003);
            ifxClientResultSet2.setFetchDirection(1000);
            ifxClientResultSet2.setConcurrency(1007);
            ifxClientResultSet = ifxClientResultSet2;
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ifxStatement2.close();
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return ifxClientResultSet;
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        IfxClientResultSet ifxClientResultSet;
        short s = 0;
        if (this.conn == null) {
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getImportedKeys() : call IfxConnection:isDbOpen()");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string5 == null || string5.length() == 0) {
            string5 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw IfxErrMsg.getSQLException(-79708, this.conn);
        }
        if (string6 == null || string6.length() == 0) {
            string6 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            int n;
            int n2;
            int n3;
            int n4;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string7 = this.getMetaDbName(string);
            if (!this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
                string6 = string6.toLowerCase();
                string2 = this.toSchemaCaseLikeServer(string2);
                string5 = this.toSchemaCaseLikeServer(string5);
            }
            String string8 = "select pt.tabname, pc.colname, ft.owner, ft.tabname, fc.colname, fk.constrname, pk.constrname, r.delrule, pt.owner, fc.colno,  ABS(fi.part1),ABS(fi.part2),ABS(fi.part3),ABS(fi.part4),ABS(fi.part5),ABS(fi.part6),ABS(fi.part7),ABS(fi.part8) " + (this.conn.isOnLine() ? ",ABS(fi.part9),ABS(fi.part10),ABS(fi.part11),ABS(fi.part12),ABS(fi.part13),ABS(fi.part14),ABS(fi.part15),ABS(fi.part16) " : " ") + ", CASE WHEN fc.colno=ABS(fi.part1) THEN 1  WHEN fc.colno=ABS(fi.part2) THEN 2  WHEN fc.colno=ABS(fi.part3) THEN 3  WHEN fc.colno=ABS(fi.part4) THEN 4  WHEN fc.colno=ABS(fi.part5) THEN 5  WHEN fc.colno=ABS(fi.part6) THEN 6  WHEN fc.colno=ABS(fi.part7) THEN 7  WHEN fc.colno=ABS(fi.part8) THEN 8 " + (this.conn.isOnLine() ? " WHEN fc.colno=ABS(fi.part9) THEN 9  WHEN fc.colno=ABS(fi.part10) THEN 10  WHEN fc.colno=ABS(fi.part11) THEN 11  WHEN fc.colno=ABS(fi.part12) THEN 12  WHEN fc.colno=ABS(fi.part13) THEN 13  WHEN fc.colno=ABS(fi.part14) THEN 14  WHEN fc.colno=ABS(fi.part15) THEN 15  WHEN fc.colno=ABS(fi.part16) THEN 16 " : " ") + "END AS KeySeq, '" + string7 + "' AS DBName  from " + string7 + ":gbasedbt.systables pt, " + string7 + ":gbasedbt.syscolumns pc, " + string7 + ":gbasedbt.sysindexes pi, " + string7 + ":gbasedbt.sysconstraints pk, " + string7 + ":gbasedbt.systables ft, " + string7 + ":gbasedbt.syscolumns fc, " + string7 + ":gbasedbt.sysindexes fi, " + string7 + ":gbasedbt.sysconstraints fk, " + string7 + ":gbasedbt.sysreferences r where pt.tabid=pc.tabid and pc.tabid=pi.tabid and pt.tabid=pk.tabid and pk.constrid=r.primary and r.constrid=fk.constrid and pi.idxname=pk.idxname and fi.idxname=fk.idxname and ft.tabid=fc.tabid and fc.tabid=fi.tabid and ft.tabid=fk.tabid and ((pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1)) or  (pc.colno=ABS(pi.part2) and fc.colno=ABS(fi.part2)) or  (pc.colno=ABS(pi.part3) and fc.colno=ABS(fi.part3)) or  (pc.colno=ABS(pi.part4) and fc.colno=ABS(fi.part4)) or  (pc.colno=ABS(pi.part5) and fc.colno=ABS(fi.part5)) or  (pc.colno=ABS(pi.part6) and fc.colno=ABS(fi.part6)) or  (pc.colno=ABS(pi.part7) and fc.colno=ABS(fi.part7)) or  (pc.colno=ABS(pi.part8) and fc.colno=ABS(fi.part8))  ";
            if (this.conn.isOnLine()) {
                string8 = string8 + " or (pc.colno=ABS(pi.part9) and fc.colno=ABS(fi.part9))  or (pc.colno=ABS(pi.part10) and fc.colno=ABS(fi.part10))  or (pc.colno=ABS(pi.part11) and fc.colno=ABS(fi.part11))  or (pc.colno=ABS(pi.part12) and fc.colno=ABS(fi.part12))  or (pc.colno=ABS(pi.part13) and fc.colno=ABS(fi.part13))  or (pc.colno=ABS(pi.part14) and fc.colno=ABS(fi.part14))  or (pc.colno=ABS(pi.part15) and fc.colno=ABS(fi.part15))  or (pc.colno=ABS(pi.part16) and fc.colno=ABS(fi.part16)) ";
            }
            string8 = string8 + ") and pt.owner like '" + string2 + "' and ft.owner like '" + string5 + "' and pt.tabname like '" + string3 + "' and ft.tabname like '" + string6 + "' order by DBName, ft.owner, ft.tabname,KeySeq;";
            ResultSet resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string8, true) : ifxStatement.executeQuery(string8, false);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(14, this.conn);
            if (this.conn.isOnLine()) {
                n4 = 129;
                n3 = 0;
                n2 = 1;
                n = n4;
                ifxResultSetMetaData.setColumnName(n2, this.conn.retCapName("PKTABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PKTABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PKTABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PKCOLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("FKTABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("FKTABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("FKTABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("FKCOLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n + 1;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("KEY_SEQ"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("UPDATE_RULE"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("DELETE_RULE"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("FK_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("PK_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n2, 13);
                n = n4;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ifxResultSetMetaData.setColumnName(++n2, this.conn.retCapName("DEFERRABILITY"));
                ifxResultSetMetaData.setIfxColumnType(n2, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n2, n);
                ifxResultSetMetaData.setTableName(n2, "");
                ifxResultSetMetaData.setColtitle(n2, null);
                ifxResultSetMetaData.setColumnStartPosition(n2, n3);
                n3 += n;
                ++n2;
            } else {
                n4 = 0;
                n3 = 1;
                n = n2 = 18;
                ifxResultSetMetaData.setColumnName(n3, this.conn.retCapName("PKTABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PKTABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PKTABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PKCOLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("FKTABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("FKTABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("FKTABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("FKCOLUMN_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("KEY_SEQ"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("UPDATE_RULE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("DELETE_RULE"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("FK_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("PK_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n3, 0);
                n = n2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n + 1;
                ifxResultSetMetaData.setColumnName(++n3, this.conn.retCapName("DEFERRABILITY"));
                ifxResultSetMetaData.setIfxColumnType(n3, 1);
                n = 2;
                ifxResultSetMetaData.setEncodedLength(n3, n);
                ifxResultSetMetaData.setTableName(n3, "");
                ifxResultSetMetaData.setColtitle(n3, null);
                ifxResultSetMetaData.setColumnStartPosition(n3, n4);
                n4 += n;
                ++n3;
            }
            resultSetMetaData = ifxResultSetMetaData;
            IfxClientResultSet ifxClientResultSet2 = new IfxClientResultSet(this.conn, resultSetMetaData);
            n3 = resultSetMetaData.getColumnCount();
            Object object = null;
            ifxClientResultSet2.moveToInsertRow();
            while (resultSet.next()) {
                String string9 = resultSet.getString(1);
                String string10 = resultSet.getString(2);
                String string11 = resultSet.getString(3);
                String string12 = resultSet.getString(4);
                String string13 = resultSet.getString(5);
                String string14 = resultSet.getString(6);
                String string15 = resultSet.getString(7);
                String string16 = resultSet.getString(8);
                String string17 = resultSet.getString(9);
                int n5 = resultSet.getInt(10);
                s = this.conn.isOnLine() ? resultSet.getShort(27) : resultSet.getShort(19);
                short s2 = string16.equals("C") ? (short)0 : 1;
                for (n = 1; n <= n3; ++n) {
                    object = resultSetMetaData.getColumnName(n).equalsIgnoreCase("PKTABLE_CAT") ? string7 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PKTABLE_SCHEM") ? string17.trim() : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PKTABLE_NAME") ? string9 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PKCOLUMN_NAME") ? string10 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("FKTABLE_CAT") ? string7 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("FKTABLE_SCHEM") ? string11.trim() : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("FKTABLE_NAME") ? string12 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("FKCOLUMN_NAME") ? string13 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("KEY_SEQ") ? new Short(s) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("UPDATE_RULE") ? new Short(1) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("DELETE_RULE") ? new Short(s2) : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("FK_NAME") ? string14 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("PK_NAME") ? string15 : (resultSetMetaData.getColumnName(n).equalsIgnoreCase("DEFERRABILITY") ? new Short(7) : resultSet.getObject(n))))))))))))));
                    ifxClientResultSet2.updateObject(n, object);
                }
                if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && resultSet.getObject("column_name").toString().equals("ifx_replcheck")) continue;
                ifxClientResultSet2.insertRow();
            }
            ifxClientResultSet2.beforeFirst();
            ifxClientResultSet2.setType(1003);
            ifxClientResultSet2.setFetchDirection(1000);
            ifxClientResultSet2.setConcurrency(1007);
            ifxClientResultSet = ifxClientResultSet2;
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        ifxStatement2.close();
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return ifxClientResultSet;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        int n;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getTypeInfo() : create the ResultSetMetaData object");
        }
        IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(lmd.length, this.conn);
        for (int i = 0; i < lmd.length; ++i) {
            n = i + 1;
            ifxResultSetMetaData.setTableName(n, "SQL_TYPES");
            ifxResultSetMetaData.setColumnName(n, this.conn.retCapName(IfxDatabaseMetaData.lmd[i].colname));
            ifxResultSetMetaData.setIfxColumnType(n, IfxDatabaseMetaData.lmd[i].coltype & 0xFF);
            ifxResultSetMetaData.setEncodedLength(n, IfxDatabaseMetaData.lmd[i].collen);
            ifxResultSetMetaData.setNullable(n, IfxDatabaseMetaData.lmd[i].nullable ? 1 : 0);
            ifxResultSetMetaData.setColumnStartPosition(n, IfxDatabaseMetaData.lmd[i].stpos);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getTypeInfo() : create the ClientResultSet object");
        }
        IfxClientResultSet ifxClientResultSet = new IfxClientResultSet(this.conn, ifxResultSetMetaData);
        n = this.conn.isUSVER() ? nXtdRowTypesSupported : nStdRowTypes;
        ifxClientResultSet.newRow(n);
        for (int i = 0; i < n; ++i) {
            int n2 = i + 1;
            ifxClientResultSet.updateString(n2, 1, IfxDatabaseMetaData.lrow[i].tname);
            ifxClientResultSet.updateShort(n2, 2, (short)IfxDatabaseMetaData.lrow[i].jsqltype);
            ifxClientResultSet.updateInt(n2, 3, IfxDatabaseMetaData.lrow[i].precision);
            ifxClientResultSet.updateString(n2, 4, IfxDatabaseMetaData.lrow[i].lprefix);
            ifxClientResultSet.updateString(n2, 5, IfxDatabaseMetaData.lrow[i].lsuffix);
            ifxClientResultSet.updateString(n2, 6, IfxDatabaseMetaData.lrow[i].cparams);
            ifxClientResultSet.updateShort(n2, 7, (short)IfxDatabaseMetaData.lrow[i].nullable);
            ifxClientResultSet.updateBoolean(n2, 8, IfxDatabaseMetaData.lrow[i].casesen);
            ifxClientResultSet.updateShort(n2, 9, (short)IfxDatabaseMetaData.lrow[i].searchable);
            ifxClientResultSet.updateBoolean(n2, 10, IfxDatabaseMetaData.lrow[i].unsign);
            ifxClientResultSet.updateBoolean(n2, 11, IfxDatabaseMetaData.lrow[i].money);
            ifxClientResultSet.updateBoolean(n2, 12, IfxDatabaseMetaData.lrow[i].autoincrement);
            ifxClientResultSet.updateString(n2, 13, IfxDatabaseMetaData.lrow[i].ltname);
            ifxClientResultSet.updateShort(n2, 14, (short)IfxDatabaseMetaData.lrow[i].minscale);
            ifxClientResultSet.updateShort(n2, 15, (short)IfxDatabaseMetaData.lrow[i].maxscale);
            ifxClientResultSet.updateInt(n2, 16, IfxDatabaseMetaData.lrow[i].sqldatatype);
            ifxClientResultSet.updateInt(n2, 17, IfxDatabaseMetaData.lrow[i].sqldatetime);
            ifxClientResultSet.updateInt(n2, 18, IfxDatabaseMetaData.lrow[i].numradix);
        }
        ifxClientResultSet.beforeFirst();
        ifxClientResultSet.setFetchDirection(1000);
        ifxClientResultSet.setConcurrency(1007);
        ifxClientResultSet.setType(1003);
        return ifxClientResultSet;
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        int n;
        int n2;
        int n3;
        Object object;
        ResultSet resultSet;
        Object object2;
        String string4;
        String string5 = this.nextTempTableName();
        boolean bl3 = false;
        String string6 = "";
        if (this.conn == null) {
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getIndexInfo() : call IfxConnection:isDbOpen()");
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            String string7;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            string4 = this.getMetaDbName(string);
            object2 = this.checkSynonym(string3, string4);
            if (!((String)object2).equals(string3)) {
                bl3 = true;
                string6 = string3;
                string3 = object2;
            }
            if (!this.conn.isDelimIdentSet()) {
                string7 = string3.toLowerCase();
                string2 = this.toSchemaCaseLikeServer(string2);
            } else {
                string7 = string3;
            }
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string5 + "(   TABLE_CAT        varchar(129),   TABLE_SCHEM      varchar(129),   TABLE_NAME       varchar(129),   NON_UNIQUE       smallint,   INDEX_QUALIFIER  varchar(129),   INDEX_NAME       varchar(129),   TYPE             smallint,   ORDINAL_POSITION smallint,   COLUMN_NAME      varchar(129),   ASC_OR_DESC      char(1),   CARDINALITY      integer,   PAGES            integer,   FILTER_CONDITION  varchar(129) ) " + this.getNoLogTerm());
            } else {
                ifxStatement.executeUpdate("create temp table " + string5 + "(   TABLE_CAT        char(18),   TABLE_SCHEM      char(18),   TABLE_NAME       char(18),   NON_UNIQUE       smallint,   INDEX_QUALIFIER  char(18),   INDEX_NAME       char(18),   TYPE             smallint,   ORDINAL_POSITION smallint,   COLUMN_NAME      char(18),   ASC_OR_DESC      char(1),   CARDINALITY      integer,   PAGES            integer,   FILTER_CONDITION  char(18) )");
            }
            String string8 = "select sc.colname, si.owner, si.idxname, si.clustered, si.idxtype, st.tabname, st.owner, sc.colno, ABS(si.part1),ABS(si.part2),ABS(si.part3),ABS(si.part4),ABS(si.part5),ABS(si.part6),ABS(si.part7),ABS(si.part8)" + (this.conn.isOnLine() ? ",ABS(si.part9),ABS(si.part10),ABS(si.part11),ABS(si.part12),ABS(si.part13),ABS(si.part14),ABS(si.part15),ABS(si.part16) " : " ") + "from " + string4 + ":gbasedbt.systables st, " + string4 + ":gbasedbt.sysindexes si, " + string4 + ":gbasedbt.syscolumns sc where (st.tabname like '" + string3 + "' or st.tabname like '" + string7 + "') and st.tabid = si.tabid and sc.tabid = st.tabid and st.owner like '" + string2 + "' and   (sc.colno = ABS(si.part1) or    sc.colno = ABS(si.part2) or    sc.colno = ABS(si.part3) or    sc.colno = ABS(si.part4) or    sc.colno = ABS(si.part5) or    sc.colno = ABS(si.part6) or    sc.colno = ABS(si.part7) or    sc.colno = ABS(si.part8) ";
            if (this.conn.isOnLine()) {
                string8 = string8 + " or sc.colno = ABS(si.part9) or     sc.colno = ABS(si.part10) or     sc.colno = ABS(si.part11) or     sc.colno = ABS(si.part12) or     sc.colno = ABS(si.part13) or     sc.colno = ABS(si.part14) or     sc.colno = ABS(si.part15) or     sc.colno = ABS(si.part16))  order by si.idxname";
            }
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string8, true) : ifxStatement.executeQuery(string8, false);
            object = resultSet.getMetaData();
            int n4 = n3 = this.conn.isOnLine() ? 16 : 8;
            while (resultSet.next()) {
                String string9 = resultSet.getString(1);
                String string10 = resultSet.getString(2);
                String string11 = resultSet.getString(3);
                String string12 = resultSet.getString(4);
                String string13 = resultSet.getString(5);
                String string14 = resultSet.getString(6);
                if (bl3 && string6.length() > 0 && !string6.equals("%")) {
                    string14 = string6;
                }
                String string15 = resultSet.getString(7);
                int n5 = resultSet.getInt(8);
                short s = 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    if (n5 != resultSet.getInt(9 + n2)) continue;
                    s = (short)(n2 + 1);
                    break;
                }
                ifxStatement2.executeUpdate("insert into " + string5 + " values( '" + string4 + "', '" + string15.trim() + "', '" + string14 + "', " + (string13.equals("D") ? "1" : "0") + ", '" + string10.trim() + "', '" + string11.trim() + "', " + 3 + ", " + s + ", '" + string9 + "', null,  0, 0, null )");
            }
            ifxStatement2.close();
            resultSet.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        string4 = "select distinct * from " + string5 + " order by non_unique, index_name, ordinal_position";
        resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        object = resultSet.getMetaData();
        object2 = new IfxResultSetMetaData(13, this.conn);
        if (this.conn.isOnLine()) {
            n = 129;
            if (this.conn.getdbEncoding() == "UTF8") {
                n = 85;
            }
            n3 = 0;
            n2 = 1;
            int n6 = n;
            ((IfxResultSetMetaData)object2).setColumnName(n2, this.conn.retCapName("TABLE_CAT"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n2, 13);
            n6 = n;
            ((IfxResultSetMetaData)object2).setEncodedLength(n2, n6);
            ((IfxResultSetMetaData)object2).setTableName(n2, "");
            ((IfxResultSetMetaData)object2).setColtitle(n2, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n2, n3);
            n3 += n6 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n2, this.conn.retCapName("TABLE_SCHEM"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n2, 13);
            n6 = n;
            ((IfxResultSetMetaData)object2).setEncodedLength(n2, n6);
            ((IfxResultSetMetaData)object2).setTableName(n2, "");
            ((IfxResultSetMetaData)object2).setColtitle(n2, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n2, n3);
            n3 += n6 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n2, this.conn.retCapName("TABLE_NAME"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n2, 13);
            n6 = n;
            ((IfxResultSetMetaData)object2).setEncodedLength(n2, n6);
            ((IfxResultSetMetaData)object2).setTableName(n2, "");
            ((IfxResultSetMetaData)object2).setColtitle(n2, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n2, n3);
            n3 += n6 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n2, this.conn.retCapName("NON_UNIQUE"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n2, 13);
            n6 = n;
            ((IfxResultSetMetaData)object2).setEncodedLength(n2, n6);
            ((IfxResultSetMetaData)object2).setTableName(n2, "");
            ((IfxResultSetMetaData)object2).setColtitle(n2, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n2, n3);
            n3 += n6 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n2, this.conn.retCapName("INDEX_QUALIFIER"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n2, 13);
            n6 = n;
            ((IfxResultSetMetaData)object2).setEncodedLength(n2, n6);
            ((IfxResultSetMetaData)object2).setTableName(n2, "");
            ((IfxResultSetMetaData)object2).setColtitle(n2, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n2, n3);
            n3 += n6 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n2, this.conn.retCapName("INDEX_NAME"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n2, 13);
            n6 = n;
            ((IfxResultSetMetaData)object2).setEncodedLength(n2, n6);
            ((IfxResultSetMetaData)object2).setTableName(n2, "");
            ((IfxResultSetMetaData)object2).setColtitle(n2, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n2, n3);
            n3 += n6 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n2, this.conn.retCapName("TYPE"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n2, 13);
            n6 = n;
            ((IfxResultSetMetaData)object2).setEncodedLength(n2, n6);
            ((IfxResultSetMetaData)object2).setTableName(n2, "");
            ((IfxResultSetMetaData)object2).setColtitle(n2, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n2, n3);
            n3 += n6 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n2, this.conn.retCapName("ORDINAL_POSITION"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n2, 13);
            n6 = n;
            ((IfxResultSetMetaData)object2).setEncodedLength(n2, n6);
            ((IfxResultSetMetaData)object2).setTableName(n2, "");
            ((IfxResultSetMetaData)object2).setColtitle(n2, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n2, n3);
            n3 += n6 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n2, this.conn.retCapName("COLUMN_NAME"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n2, 13);
            n6 = n;
            ((IfxResultSetMetaData)object2).setEncodedLength(n2, n6);
            ((IfxResultSetMetaData)object2).setTableName(n2, "");
            ((IfxResultSetMetaData)object2).setColtitle(n2, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n2, n3);
            n3 += n6 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n2, this.conn.retCapName("ASC_OR_DESC"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n2, 13);
            n6 = n;
            ((IfxResultSetMetaData)object2).setEncodedLength(n2, n6);
            ((IfxResultSetMetaData)object2).setTableName(n2, "");
            ((IfxResultSetMetaData)object2).setColtitle(n2, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n2, n3);
            n3 += n6 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n2, this.conn.retCapName("CARDINALITY"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n2, 13);
            n6 = n;
            ((IfxResultSetMetaData)object2).setEncodedLength(n2, n6);
            ((IfxResultSetMetaData)object2).setTableName(n2, "");
            ((IfxResultSetMetaData)object2).setColtitle(n2, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n2, n3);
            n3 += n6 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n2, this.conn.retCapName("PAGES"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n2, 13);
            n6 = n;
            ((IfxResultSetMetaData)object2).setEncodedLength(n2, n6);
            ((IfxResultSetMetaData)object2).setTableName(n2, "");
            ((IfxResultSetMetaData)object2).setColtitle(n2, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n2, n3);
            n3 += n6 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n2, this.conn.retCapName("FILTER_CONDITION"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n2, 13);
            n6 = n;
            ((IfxResultSetMetaData)object2).setEncodedLength(n2, n6);
            ((IfxResultSetMetaData)object2).setTableName(n2, "");
            ((IfxResultSetMetaData)object2).setColtitle(n2, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n2, n3);
            n3 += n6 + 1;
            ++n2;
        } else {
            n = 0;
            n3 = 1;
            int n7 = n2 = 50;
            ((IfxResultSetMetaData)object2).setColumnName(n3, this.conn.retCapName("TABLE_CAT"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n3, 0);
            n7 = n2;
            ((IfxResultSetMetaData)object2).setEncodedLength(n3, n7);
            ((IfxResultSetMetaData)object2).setTableName(n3, "");
            ((IfxResultSetMetaData)object2).setColtitle(n3, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n3, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n3, this.conn.retCapName("TABLE_SCHEM"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n3, 0);
            n7 = n2;
            ((IfxResultSetMetaData)object2).setEncodedLength(n3, n7);
            ((IfxResultSetMetaData)object2).setTableName(n3, "");
            ((IfxResultSetMetaData)object2).setColtitle(n3, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n3, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n3, this.conn.retCapName("TABLE_NAME"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n3, 0);
            n7 = n2;
            ((IfxResultSetMetaData)object2).setEncodedLength(n3, n7);
            ((IfxResultSetMetaData)object2).setTableName(n3, "");
            ((IfxResultSetMetaData)object2).setColtitle(n3, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n3, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n3, this.conn.retCapName("NON_UNIQUE"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n3, 0);
            n7 = n2;
            ((IfxResultSetMetaData)object2).setEncodedLength(n3, n7);
            ((IfxResultSetMetaData)object2).setTableName(n3, "");
            ((IfxResultSetMetaData)object2).setColtitle(n3, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n3, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n3, this.conn.retCapName("INDEX_QUALIFIER"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n3, 0);
            n7 = n2;
            ((IfxResultSetMetaData)object2).setEncodedLength(n3, n7);
            ((IfxResultSetMetaData)object2).setTableName(n3, "");
            ((IfxResultSetMetaData)object2).setColtitle(n3, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n3, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n3, this.conn.retCapName("INDEX_NAME"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n3, 0);
            n7 = n2;
            ((IfxResultSetMetaData)object2).setEncodedLength(n3, n7);
            ((IfxResultSetMetaData)object2).setTableName(n3, "");
            ((IfxResultSetMetaData)object2).setColtitle(n3, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n3, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n3, this.conn.retCapName("TYPE"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n3, 0);
            n7 = n2;
            ((IfxResultSetMetaData)object2).setEncodedLength(n3, n7);
            ((IfxResultSetMetaData)object2).setTableName(n3, "");
            ((IfxResultSetMetaData)object2).setColtitle(n3, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n3, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n3, this.conn.retCapName("ORDINAL_POSITION"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n3, 0);
            n7 = n2;
            ((IfxResultSetMetaData)object2).setEncodedLength(n3, n7);
            ((IfxResultSetMetaData)object2).setTableName(n3, "");
            ((IfxResultSetMetaData)object2).setColtitle(n3, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n3, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n3, this.conn.retCapName("COLUMN_NAME"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n3, 0);
            n7 = n2;
            ((IfxResultSetMetaData)object2).setEncodedLength(n3, n7);
            ((IfxResultSetMetaData)object2).setTableName(n3, "");
            ((IfxResultSetMetaData)object2).setColtitle(n3, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n3, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n3, this.conn.retCapName("ASC_OR_DESC"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n3, 0);
            n7 = n2;
            ((IfxResultSetMetaData)object2).setEncodedLength(n3, n7);
            ((IfxResultSetMetaData)object2).setTableName(n3, "");
            ((IfxResultSetMetaData)object2).setColtitle(n3, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n3, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n3, this.conn.retCapName("CARDINALITY"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n3, 0);
            n7 = n2;
            ((IfxResultSetMetaData)object2).setEncodedLength(n3, n7);
            ((IfxResultSetMetaData)object2).setTableName(n3, "");
            ((IfxResultSetMetaData)object2).setColtitle(n3, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n3, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n3, this.conn.retCapName("PAGES"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n3, 0);
            n7 = n2;
            ((IfxResultSetMetaData)object2).setEncodedLength(n3, n7);
            ((IfxResultSetMetaData)object2).setTableName(n3, "");
            ((IfxResultSetMetaData)object2).setColtitle(n3, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n3, n);
            n += n7 + 1;
            ((IfxResultSetMetaData)object2).setColumnName(++n3, this.conn.retCapName("FILTER_CONDITION"));
            ((IfxResultSetMetaData)object2).setIfxColumnType(n3, 0);
            n7 = n2;
            ((IfxResultSetMetaData)object2).setEncodedLength(n3, n7);
            ((IfxResultSetMetaData)object2).setTableName(n3, "");
            ((IfxResultSetMetaData)object2).setColtitle(n3, null);
            ((IfxResultSetMetaData)object2).setColumnStartPosition(n3, n);
            n += n7 + 1;
            ++n3;
        }
        object = object2;
        ResultSet resultSet2 = this.populateClientResultSet(resultSet, (ResultSetMetaData)object);
        ifxStatement.close();
        this.dropTempTable(string5);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return resultSet2;
    }

    void close() throws SQLException {
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:supportsResultSetType()");
        }
        return n == 1004 || n == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:supportResultSetConcurrency()");
        }
        return n2 == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        ResultSet resultSet;
        String string4;
        Object object3;
        boolean bl = false;
        if (this.conn == null) {
            return null;
        }
        if (string != null && !this.conn.isDbOpen() && !string.equals("")) {
            object3 = (IfxStatement)this.conn.createStatement();
            ((IfxStatement)object3).setAutoFree(true);
            String string5 = "DATABASE " + string;
            ((IfxStatement)object3).executeUpdate(string5);
            bl = true;
        }
        if (!this.conn.isUSVER() && !this.conn.isDbOpen()) {
            return null;
        }
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        object3 = this.getMetaDbName(string);
        if (string2 == null || string2.equals("")) {
            string2 = "%";
        }
        if (string3 == null || string3.equals("")) {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string6 = "";
        if (nArray != null) {
            int n4 = 0;
            block13: for (int i = 0; i < nArray.length; ++i) {
                switch (nArray[i]) {
                    case 2000: {
                        if (bl2) continue block13;
                        bl2 = true;
                        if (++n4 == 1) {
                            string6 = string6 + "'B'";
                            continue block13;
                        }
                        string6 = string6 + ",'B'";
                        continue block13;
                    }
                    case 2002: {
                        if (bl3) continue block13;
                        bl3 = true;
                        if (++n4 == 1) {
                            string6 = string6 + "'R'";
                            continue block13;
                        }
                        string6 = string6 + ",'R'";
                        continue block13;
                    }
                    case 2001: {
                        if (bl4) continue block13;
                        bl4 = true;
                        string6 = ++n4 == 1 ? string6 + "'D'" : string6 + ",'D'";
                    }
                }
            }
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        String string7 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            string7 = this.nextTempTableName();
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("CREATE " + this.getTmpTableTerm() + " table " + string7 + " (  TYPE_CAT VARCHAR(129),  TYPE_SCHEM VARCHAR(129),  TYPE_NAME VARCHAR(129),  CLASS_NAME VARCHAR(129),  DATA_TYPE INT,  REMARKS VARCHAR(129),  BASE_TYPE SMALLINT ) " + this.getNoLogTerm());
            } else {
                ifxStatement.executeUpdate("CREATE temp table " + string7 + " (  TYPE_CAT char(18),  TYPE_SCHEM char(18),  TYPE_NAME char(18),  CLASS_NAME char(25),  DATA_TYPE int,  REMARKS char(255),  BASE_TYPE smallint ) ");
            }
            string4 = "SELECT owner, name, mode, type, source  FROM " + (String)object3 + ":gbasedbt.sysxtdtypes  WHERE owner != 'gbasedbt'  AND owner LIKE '" + string2 + "'  AND name LIKE '" + string3 + "' ";
            if (!string6.equals("")) {
                string4 = string4 + "and mode in (" + string6 + ") ";
            }
            resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
            while (resultSet.next()) {
                Object object4;
                int n5;
                object2 = resultSet.getString("owner").trim();
                object = resultSet.getString("name");
                String string8 = resultSet.getString("mode");
                n3 = resultSet.getInt("type");
                n2 = resultSet.getInt("source");
                String string9 = null;
                if (!(string8 = string8.trim()).equals("D")) {
                    string9 = "java.sql.SQLData";
                    n2 = 0;
                } else if (n2 == 0 && string8.equals("D")) {
                    string9 = IfxTypes.FromIfxTypeToJava(n3 & 0xFF);
                    n2 = IfxTypes.FromIfxToJDBCType(n3 & 0xFF);
                } else {
                    n5 = 0;
                    block15: while (n5 == 0) {
                        switch (n2) {
                            case 1: {
                                string9 = "java.lang.String";
                                if (string8.equals("D")) {
                                    n2 = -1;
                                }
                                n5 = 1;
                                continue block15;
                            }
                            case 5: {
                                string9 = "java.lang.Boolean";
                                if (string8.equals("D")) {
                                    n2 = 16;
                                }
                                n5 = 1;
                                continue block15;
                            }
                            case 11: {
                                string9 = "java.sql.Clob";
                                if (string8.equals("D")) {
                                    n2 = 2005;
                                }
                                n5 = 1;
                                continue block15;
                            }
                            case 10: {
                                string9 = "java.sql.Blob";
                                if (string8.equals("D")) {
                                    n2 = 2004;
                                }
                                n5 = 1;
                                continue block15;
                            }
                        }
                        object4 = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement2.executeQuery("select type, source from " + (String)object3 + ":gbasedbt.sysxtdtypes where extended_id = " + n2, true) : ifxStatement2.executeQuery("select type, source from " + (String)object3 + ":gbasedbt.sysxtdtypes where extended_id = " + n2, false);
                        if (!object4.next()) {
                            n5 = 1;
                            string9 = "unknown";
                            continue;
                        }
                        int n6 = object4.getInt("type");
                        n2 = object4.getInt("source");
                        if (n2 != 0) continue;
                        string9 = n6 == 40 || n6 == 41 ? "java.sql.SQLData" : IfxTypes.FromIfxTypeToJava(n3 & 0xFF);
                        n5 = 1;
                    }
                }
                n5 = string8.equals("B") ? 2000 : (string8.equals("R") ? 2002 : (string8.equals("D") ? 2001 : -1));
                object4 = "insert into " + string7 + " values ( '" + (String)object3 + "', '" + (String)object2 + "', '" + (String)object + "', '" + string9 + "', " + n5 + ", '' , " + n2 + ")";
                ifxStatement2.executeUpdate((String)object4);
            }
            resultSet.close();
            ifxStatement2.close();
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        string4 = "SELECT TYPE_CAT, TYPE_SCHEM, TYPE_NAME, CLASS_NAME, DATA_TYPE, REMARKS, BASE_TYPE  FROM " + string7 + " ORDER BY DATA_TYPE, TYPE_SCHEM, TYPE_NAME";
        resultSet = null;
        resultSet = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        object2 = resultSet.getMetaData();
        object = new IfxResultSetMetaData(7, this.conn);
        if (this.conn.isOnLine()) {
            n = 129;
            if (this.conn.getdbEncoding() == "UTF8") {
                n = 85;
            }
            n3 = 0;
            n2 = 1;
            int n7 = n;
            ((IfxResultSetMetaData)object).setColumnName(n2, this.conn.retCapName("TYPE_CAT"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n2, 13);
            n7 = n;
            ((IfxResultSetMetaData)object).setEncodedLength(n2, n7);
            ((IfxResultSetMetaData)object).setTableName(n2, "");
            ((IfxResultSetMetaData)object).setColtitle(n2, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n2, n3);
            n3 += n7 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n2, this.conn.retCapName("TYPE_SCHEM"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n2, 13);
            n7 = n;
            ((IfxResultSetMetaData)object).setEncodedLength(n2, n7);
            ((IfxResultSetMetaData)object).setTableName(n2, "");
            ((IfxResultSetMetaData)object).setColtitle(n2, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n2, n3);
            n3 += n7 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n2, this.conn.retCapName("TYPE_NAME"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n2, 13);
            n7 = n;
            ((IfxResultSetMetaData)object).setEncodedLength(n2, n7);
            ((IfxResultSetMetaData)object).setTableName(n2, "");
            ((IfxResultSetMetaData)object).setColtitle(n2, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n2, n3);
            n3 += n7 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n2, this.conn.retCapName("CLASS_NAME"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n2, 13);
            n7 = n;
            ((IfxResultSetMetaData)object).setEncodedLength(n2, n7);
            ((IfxResultSetMetaData)object).setTableName(n2, "");
            ((IfxResultSetMetaData)object).setColtitle(n2, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n2, n3);
            n3 += n7 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n2, this.conn.retCapName("DATA_TYPE"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n2, 2);
            n7 = 4;
            ((IfxResultSetMetaData)object).setEncodedLength(n2, n7);
            ((IfxResultSetMetaData)object).setTableName(n2, "");
            ((IfxResultSetMetaData)object).setColtitle(n2, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n2, n3);
            n3 += n7;
            ((IfxResultSetMetaData)object).setColumnName(++n2, this.conn.retCapName("REMARKS"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n2, 13);
            n7 = n;
            ((IfxResultSetMetaData)object).setEncodedLength(n2, n7);
            ((IfxResultSetMetaData)object).setTableName(n2, "");
            ((IfxResultSetMetaData)object).setColtitle(n2, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n2, n3);
            n3 += n7;
            ((IfxResultSetMetaData)object).setColumnName(++n2, this.conn.retCapName("BASE_TYPE"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n2, 2);
            n7 = 4;
            ((IfxResultSetMetaData)object).setEncodedLength(n2, n7);
            ((IfxResultSetMetaData)object).setTableName(n2, "");
            ((IfxResultSetMetaData)object).setColtitle(n2, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n2, n3);
            n3 += n7;
            ++n2;
        } else {
            n = 0;
            n3 = 1;
            int n8 = n2 = 50;
            ((IfxResultSetMetaData)object).setColumnName(n3, this.conn.retCapName("TYPE_CAT"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n3, 0);
            n8 = n2;
            ((IfxResultSetMetaData)object).setEncodedLength(n3, n8);
            ((IfxResultSetMetaData)object).setTableName(n3, "");
            ((IfxResultSetMetaData)object).setColtitle(n3, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n3, n);
            n += n8 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n3, this.conn.retCapName("TYPE_SCHEM"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n3, 0);
            n8 = n2;
            ((IfxResultSetMetaData)object).setEncodedLength(n3, n8);
            ((IfxResultSetMetaData)object).setTableName(n3, "");
            ((IfxResultSetMetaData)object).setColtitle(n3, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n3, n);
            n += n8 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n3, this.conn.retCapName("TYPE_NAME"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n3, 0);
            n8 = n2;
            ((IfxResultSetMetaData)object).setEncodedLength(n3, n8);
            ((IfxResultSetMetaData)object).setTableName(n3, "");
            ((IfxResultSetMetaData)object).setColtitle(n3, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n3, n);
            n += n8 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n3, this.conn.retCapName("CLASS_NAME"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n3, 0);
            n8 = n2;
            ((IfxResultSetMetaData)object).setEncodedLength(n3, n8);
            ((IfxResultSetMetaData)object).setTableName(n3, "");
            ((IfxResultSetMetaData)object).setColtitle(n3, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n3, n);
            n += n8 + 1;
            ((IfxResultSetMetaData)object).setColumnName(++n3, this.conn.retCapName("DATA_TYPE"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n3, 2);
            n8 = 4;
            ((IfxResultSetMetaData)object).setEncodedLength(n3, n8);
            ((IfxResultSetMetaData)object).setTableName(n3, "");
            ((IfxResultSetMetaData)object).setColtitle(n3, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n3, n);
            n += n8;
            ((IfxResultSetMetaData)object).setColumnName(++n3, this.conn.retCapName("REMARKS"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n3, 0);
            n8 = n2;
            ((IfxResultSetMetaData)object).setEncodedLength(n3, n8);
            ((IfxResultSetMetaData)object).setTableName(n3, "");
            ((IfxResultSetMetaData)object).setColtitle(n3, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n3, n);
            n += n8;
            ((IfxResultSetMetaData)object).setColumnName(++n3, this.conn.retCapName("BASE_TYPE"));
            ((IfxResultSetMetaData)object).setIfxColumnType(n3, 2);
            n8 = 4;
            ((IfxResultSetMetaData)object).setEncodedLength(n3, n8);
            ((IfxResultSetMetaData)object).setTableName(n3, "");
            ((IfxResultSetMetaData)object).setColtitle(n3, null);
            ((IfxResultSetMetaData)object).setColumnStartPosition(n3, n);
            n += n8;
            ++n3;
        }
        object2 = object;
        ResultSet resultSet2 = this.populateClientResultSet(resultSet, (ResultSetMetaData)object2);
        this.dropTempTable(string7);
        if (bl) {
            ifxStatement.executeUpdate("close database");
        }
        ifxStatement.close();
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return resultSet2;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    private void dropTempTable(String string) {
        try {
            Statement statement = this.conn.createStatement();
            statement.executeUpdate("drop table " + string);
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private ResultSet populateClientResultSet(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws SQLException {
        IfxClientResultSet ifxClientResultSet = new IfxClientResultSet(this.conn, resultSetMetaData);
        int n = resultSetMetaData.getColumnCount();
        Object object = null;
        ifxClientResultSet.moveToInsertRow();
        while (resultSet.next()) {
            for (int i = 1; i <= n; ++i) {
                object = resultSet.getObject(i);
                if (resultSet.wasNull()) {
                    ifxClientResultSet.updateNull(i);
                    continue;
                }
                ifxClientResultSet.updateObject(i, object);
            }
            if (!((IfxSqliConnect)this.conn).isReplCheckColumnEnabled() && resultSet.getObject("column_name").toString().equals("ifx_replcheck")) continue;
            ifxClientResultSet.insertRow();
        }
        ifxClientResultSet.beforeFirst();
        ifxClientResultSet.setType(1003);
        ifxClientResultSet.setFetchDirection(1000);
        ifxClientResultSet.setConcurrency(1007);
        return ifxClientResultSet;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        if (this.conn != null) {
            return ((IfxSqliConnect)this.conn).isNamedParametersSupported();
        }
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        if (this.conn != null) {
            return ((IfxSqliConnect)this.conn).isAutoGeneratedKeysSupported();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        Object var4_4 = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxDatabaseMetaData:getSuperTypes(): entry");
        }
        if (this.conn == null || !this.conn.isDbOpen()) {
            return null;
        }
        if (!this.conn.isUSVER()) {
            return null;
        }
        SQLException sQLException = null;
        ResultSet resultSet = null;
        String string4 = this.getMetaDbName(string);
        if (string2 == null || string2.equals("")) {
            string2 = "%";
        }
        if (string3 == null || string3.equals("")) {
            string3 = "%";
        } else {
            int n = string3.indexOf(58);
            int n2 = string3.indexOf(46);
            if (n != -1) {
                string4 = string3.substring(0, n);
                if (n2 > n) {
                    string2 = string3.substring(n + 1, n2);
                    string3 = string3.substring(n2 + 1);
                }
            } else if (n2 != -1) {
                string2 = string3.substring(0, n2);
                string3 = string3.substring(n2 + 1);
            }
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        }
        try {
            ((IfxSqliConnect)this.conn).startMetaDataQuery();
            IfxStatement ifxStatement = null;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string5 = "SELECT '" + string4 + "' AS  TYPE_CAT, s1.owner  as TYPE_SCHEM, s1.name  as TYPE_NAME,'" + string4 + "' as SUPERTYPE_CAT , s2.owner as SUPERTYPE_SCHEM , s2.name as  SUPERTYPE_NAME  FROM " + string4 + ":gbasedbt.sysxtdtypes s1, " + string4 + ":gbasedbt.sysxtdtypes s2 , " + string4 + ":gbasedbt.sysinherits s3  WHERE s1.name like '" + string3 + "'and s1.owner like '" + string2 + "' and s1.extended_id =  s3.child and s1.name != s2.name and  s2.extended_id = s3.parent  order by  TYPE_NAME , TYPE_SCHEM";
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(9, "IfxDatabaseMetaData:getSuperTypes() - query string " + string5);
            }
            ResultSet resultSet2 = null;
            resultSet2 = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
            ResultSetMetaData resultSetMetaData = resultSet2.getMetaData();
            IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(6, this.conn);
            if (this.conn.isOnLine()) {
                int n = 129;
                if (this.conn.getdbEncoding() == "UTF8") {
                    n = 85;
                }
                int n3 = 0;
                int n4 = 1;
                int n5 = n;
                ifxResultSetMetaData.setColumnName(n4, this.conn.retCapName("TYPE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n4, 13);
                n5 = n;
                ifxResultSetMetaData.setEncodedLength(n4, n5);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n3);
                n3 += n5 + 1;
                ifxResultSetMetaData.setColumnName(++n4, this.conn.retCapName("TYPE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n4, 13);
                n5 = n;
                ifxResultSetMetaData.setEncodedLength(n4, n5);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n3);
                n3 += n5 + 1;
                ifxResultSetMetaData.setColumnName(++n4, this.conn.retCapName("TYPE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n4, 13);
                n5 = n;
                ifxResultSetMetaData.setEncodedLength(n4, n5);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n3);
                n3 += n5 + 1;
                ifxResultSetMetaData.setColumnName(++n4, this.conn.retCapName("SUPERTYPE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n4, 13);
                n5 = n;
                ifxResultSetMetaData.setEncodedLength(n4, n5);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n3);
                n3 += n5 + 1;
                ifxResultSetMetaData.setColumnName(++n4, this.conn.retCapName("SUPERYTPE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n4, 13);
                n5 = n;
                ifxResultSetMetaData.setEncodedLength(n4, n5);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n3);
                n3 += n5 + 1;
                ifxResultSetMetaData.setColumnName(++n4, this.conn.retCapName("SUPERTYPE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n4, 13);
                n5 = n;
                ifxResultSetMetaData.setEncodedLength(n4, n5);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n3);
                n3 += n5 + 1;
                ++n4;
            } else {
                int n;
                int n6 = 0;
                int n7 = 1;
                int n8 = n = 50;
                ifxResultSetMetaData.setColumnName(n7, this.conn.retCapName("TYPE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n7, 0);
                n8 = n;
                ifxResultSetMetaData.setEncodedLength(n7, n8);
                ifxResultSetMetaData.setTableName(n7, "");
                ifxResultSetMetaData.setColtitle(n7, null);
                ifxResultSetMetaData.setColumnStartPosition(n7, n6);
                n6 += n8 + 1;
                ifxResultSetMetaData.setColumnName(++n7, this.conn.retCapName("TYPE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n7, 0);
                n8 = n;
                ifxResultSetMetaData.setEncodedLength(n7, n8);
                ifxResultSetMetaData.setTableName(n7, "");
                ifxResultSetMetaData.setColtitle(n7, null);
                ifxResultSetMetaData.setColumnStartPosition(n7, n6);
                n6 += n8 + 1;
                ifxResultSetMetaData.setColumnName(++n7, this.conn.retCapName("TYPE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n7, 0);
                n8 = n;
                ifxResultSetMetaData.setEncodedLength(n7, n8);
                ifxResultSetMetaData.setTableName(n7, "");
                ifxResultSetMetaData.setColtitle(n7, null);
                ifxResultSetMetaData.setColumnStartPosition(n7, n6);
                n6 += n8 + 1;
                ifxResultSetMetaData.setColumnName(++n7, this.conn.retCapName("SUPERTYPE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n7, 0);
                n8 = n;
                ifxResultSetMetaData.setEncodedLength(n7, n8);
                ifxResultSetMetaData.setTableName(n7, "");
                ifxResultSetMetaData.setColtitle(n7, null);
                ifxResultSetMetaData.setColumnStartPosition(n7, n6);
                n6 += n8 + 1;
                ifxResultSetMetaData.setColumnName(++n7, this.conn.retCapName("SUPERTYPE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n7, 0);
                n8 = n;
                ifxResultSetMetaData.setEncodedLength(n7, n8);
                ifxResultSetMetaData.setTableName(n7, "");
                ifxResultSetMetaData.setColtitle(n7, null);
                ifxResultSetMetaData.setColumnStartPosition(n7, n6);
                n6 += n8 + 1;
                ifxResultSetMetaData.setColumnName(++n7, this.conn.retCapName("SUPERTYPE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n7, 0);
                n8 = n;
                ifxResultSetMetaData.setEncodedLength(n7, n8);
                ifxResultSetMetaData.setTableName(n7, "");
                ifxResultSetMetaData.setColtitle(n7, null);
                ifxResultSetMetaData.setColumnStartPosition(n7, n6);
                n6 += n8 + 1;
                ++n7;
            }
            resultSetMetaData = ifxResultSetMetaData;
            resultSet = this.populateClientResultSet(resultSet2, resultSetMetaData);
            ifxStatement.close();
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
        if (sQLException != null) {
            throw sQLException;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxDatabaseMetaData:getSuperTypes(): exit");
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        Object var4_4 = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxDatabaseMetaData:getSuperTables() entry");
        }
        if (this.conn == null || !this.conn.isDbOpen()) {
            return null;
        }
        if (!this.conn.isUSVER()) {
            return null;
        }
        SQLException sQLException = null;
        ResultSet resultSet = null;
        String string4 = this.getMetaDbName(string);
        if (string2 == null || string2.equals("")) {
            string2 = "%";
        }
        if (string3 == null || string3.equals("")) {
            string3 = "%";
        } else {
            int n = string3.indexOf(58);
            int n2 = string3.indexOf(46);
            if (n != -1) {
                string4 = string3.substring(0, n);
                if (n2 > n) {
                    string2 = string3.substring(n + 1, n2);
                    string3 = string3.substring(n2 + 1);
                }
            } else if (n2 != -1) {
                string2 = string3.substring(0, n2);
                string3 = string3.substring(n2 + 1);
            }
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        }
        try {
            ((IfxSqliConnect)this.conn).startMetaDataQuery();
            IfxStatement ifxStatement = null;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            String string5 = "select '" + string4 + "' as  TABLE_CAT,s1.owner  as TABLE_SCHEM,s1.tabname  as TABLE_NAME,s2.tabname as  SUPERTABLE_NAME from " + string4 + ":gbasedbt.systables s1, " + string4 + ":gbasedbt.systables s2 , " + string4 + ":gbasedbt.sysinherits s3 where s1.tabname like '" + string3 + "'and s1.owner like '" + string2 + "' and s1.tabid =  s3.child and s1.tabname != s2.tabname and s2.tabid = s3.parent order by  TABLE_NAME , TABLE_SCHEM";
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(9, "IfxDatabaseMetaData:getSuperTables() - query string " + string5);
            }
            ResultSet resultSet2 = null;
            resultSet2 = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
            ResultSetMetaData resultSetMetaData = resultSet2.getMetaData();
            IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(4, this.conn);
            if (this.conn.isOnLine()) {
                int n = 129;
                if (this.conn.getdbEncoding() == "UTF8") {
                    n = 85;
                }
                int n3 = 0;
                int n4 = 1;
                int n5 = n;
                ifxResultSetMetaData.setColumnName(n4, this.conn.retCapName("TABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n4, 13);
                n5 = n;
                ifxResultSetMetaData.setEncodedLength(n4, n5);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n3);
                n3 += n5 + 1;
                ifxResultSetMetaData.setColumnName(++n4, this.conn.retCapName("TABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n4, 13);
                n5 = n;
                ifxResultSetMetaData.setEncodedLength(n4, n5);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n3);
                n3 += n5 + 1;
                ifxResultSetMetaData.setColumnName(++n4, this.conn.retCapName("TABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n4, 13);
                n5 = n;
                ifxResultSetMetaData.setEncodedLength(n4, n5);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n3);
                n3 += n5 + 1;
                ifxResultSetMetaData.setColumnName(++n4, this.conn.retCapName("SUPERTABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n4, 13);
                n5 = n;
                ifxResultSetMetaData.setEncodedLength(n4, n5);
                ifxResultSetMetaData.setTableName(n4, "");
                ifxResultSetMetaData.setColtitle(n4, null);
                ifxResultSetMetaData.setColumnStartPosition(n4, n3);
                n3 += n5 + 1;
                ++n4;
            } else {
                int n;
                int n6 = 0;
                int n7 = 1;
                int n8 = n = 50;
                ifxResultSetMetaData.setColumnName(n7, this.conn.retCapName("TABLE_CAT"));
                ifxResultSetMetaData.setIfxColumnType(n7, 0);
                n8 = n;
                ifxResultSetMetaData.setEncodedLength(n7, n8);
                ifxResultSetMetaData.setTableName(n7, "");
                ifxResultSetMetaData.setColtitle(n7, null);
                ifxResultSetMetaData.setColumnStartPosition(n7, n6);
                n6 += n8 + 1;
                ifxResultSetMetaData.setColumnName(++n7, this.conn.retCapName("TABLE_SCHEM"));
                ifxResultSetMetaData.setIfxColumnType(n7, 0);
                n8 = n;
                ifxResultSetMetaData.setEncodedLength(n7, n8);
                ifxResultSetMetaData.setTableName(n7, "");
                ifxResultSetMetaData.setColtitle(n7, null);
                ifxResultSetMetaData.setColumnStartPosition(n7, n6);
                n6 += n8 + 1;
                ifxResultSetMetaData.setColumnName(++n7, this.conn.retCapName("TABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n7, 0);
                n8 = n;
                ifxResultSetMetaData.setEncodedLength(n7, n8);
                ifxResultSetMetaData.setTableName(n7, "");
                ifxResultSetMetaData.setColtitle(n7, null);
                ifxResultSetMetaData.setColumnStartPosition(n7, n6);
                n6 += n8 + 1;
                ifxResultSetMetaData.setColumnName(++n7, this.conn.retCapName("SUPERTABLE_NAME"));
                ifxResultSetMetaData.setIfxColumnType(n7, 0);
                n8 = n;
                ifxResultSetMetaData.setEncodedLength(n7, n8);
                ifxResultSetMetaData.setTableName(n7, "");
                ifxResultSetMetaData.setColtitle(n7, null);
                ifxResultSetMetaData.setColumnStartPosition(n7, n6);
                n6 += n8 + 1;
                ++n7;
            }
            resultSetMetaData = ifxResultSetMetaData;
            resultSet = this.populateClientResultSet(resultSet2, resultSetMetaData);
            ifxStatement.close();
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        finally {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
        }
        if (sQLException != null) {
            throw sQLException;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxDatabaseMetaData:getSuperTables(): exit");
        }
        return resultSet;
    }

    private int getNumberParentColumns(int n, String string) throws SQLException {
        Statement statement;
        ResultSet resultSet;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxDatabaseMetaData:getNumberParentColumns entry");
        }
        int n2 = 0;
        boolean bl = false;
        String string2 = "select parent from " + string + ":gbasedbt.sysinherits where class = 't' and child = " + n;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(9, "IfxDatabaseMetaData:getNumberParentColumns query - " + string2);
        }
        if ((resultSet = (statement = this.conn.createStatement()).executeQuery(string2)).next()) {
            n = resultSet.getInt(1);
        } else {
            bl = true;
        }
        resultSet.close();
        statement.close();
        if (!bl) {
            string2 = "select mode, source from " + string + ":gbasedbt.sysxtdtypes where extended_id=?";
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(9, "IfxDatabaseMetaData:getNumberParentColumns query - " + string2);
            }
            PreparedStatement preparedStatement = this.conn.prepareStatement(string2);
            while (!bl) {
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    if (!resultSet.getString(1).equals("D")) {
                        bl = true;
                    } else {
                        n = resultSet.getInt(2);
                    }
                }
                resultSet.close();
            }
            preparedStatement.close();
            string2 = "select count(*) from " + string + ":gbasedbt.sysattrtypes where extended_id=" + n;
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(9, "IfxDatabaseMetaData:getNumberParentColumns final query - " + string2);
            }
            if ((resultSet = (statement = this.conn.createStatement()).executeQuery(string2)).next()) {
                n2 = resultSet.getInt(1);
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(9, "IfxDatabaseMetaData:getNumberParentColumns number parent columns - " + n2);
                }
            }
            resultSet.close();
            statement.close();
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxDatabaseMetaData:getNumberParentColumns exit");
        }
        return n2;
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        int n;
        int n2;
        Object object;
        Object object2;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getAttributes(): entry");
        }
        if (this.conn == null || !this.conn.isDbOpen()) {
            return null;
        }
        if (!this.conn.isUSVER()) {
            throw IfxErrMsg.getSQLException(-79700, ": IfxDatabaseMetaData.getAttributes()", this.conn);
        }
        String string5 = this.nextTempTableName();
        if (string2 == null || string2.length() == 0) {
            string2 = "%";
        }
        if (string3 == null || string3.length() == 0) {
            string3 = "%";
        }
        if (string4 == null || string4.length() == 0) {
            string4 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string4 = string4.toLowerCase();
            string2 = this.toSchemaCaseLikeServer(string2);
        }
        string3 = string3.trim();
        string4 = string4.trim();
        String string6 = this.getMetaDbName(string);
        ((IfxSqliConnect)this.conn).startMetaDataQuery();
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            ifxStatement.executeUpdate("create " + this.getTmpTableTerm() + " table " + string5 + "(   TYPE_CAT           varchar(129),   TYPE_SCHEM         varchar(129),   TYPE_NAME          varchar(129),   ATTR_NAME          varchar(129),   DATA_TYPE          smallint,   ATTR_TYPE_NAME     varchar(129),   ATTR_SIZE          integer,   DECIMAL_DIGITS     integer,   NUM_PREC_RADIX     integer,   NULLABLE           integer,   REMARKS            char(18),   ATTR_DEF           varchar(255),   SQL_DATA_TYPE      integer,   SQL_DATETIME_SUB   integer,   CHAR_OCTET_LENGTH  integer,   ORDINAL_POSITION   integer,   IS_NULLABLE        char(3),   SCOPE_CATALOG      varchar(129),   SCOPE_SCHEMA       varchar(129),   SCOPE_TABLE        varchar(129),   SOURCE_DATA_TYPE   smallint) " + this.getNoLogTerm());
            object2 = "select extended_id, tabname from " + string6 + ":gbasedbt.sysxtdtypes sx, OUTER " + string6 + ":gbasedbt.systables st where extended_id > 2047 and extended_id = type_xid  and ( mode = 'B' or mode = 'D' or mode = 'T' or mode = 'R' ) and name like '" + string3 + "' and sx.owner like '" + string2 + "'";
            object = null;
            object = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery((String)object2, true) : ifxStatement.executeQuery((String)object2, false);
            while (object.next()) {
                int n3 = object.getInt(1);
                int n4 = this.getNumberParentColumns(n3, string6);
                IfxUDTInfo ifxUDTInfo = this.conn.getUDTInfo(n3);
                String string7 = object.getString(2);
                IfxResultSetMetaData ifxResultSetMetaData = ifxUDTInfo.getMetaData();
                if (ifxResultSetMetaData == null) continue;
                n2 = ifxResultSetMetaData.getColumnCount();
                Vector vector = ifxResultSetMetaData.getColumnInfoVector();
                IfxColumnInfo ifxColumnInfo = null;
                for (int i = 1; i <= n2; ++i) {
                    ifxColumnInfo = (IfxColumnInfo)vector.elementAt(i - 1);
                    Vector vector2 = ifxColumnInfo.child;
                    if (n4 == 0) {
                        ++n4;
                    }
                    IfxColumnInfo ifxColumnInfo2 = null;
                    for (int j = n4 - 1; j < vector2.size(); ++j) {
                        String string8;
                        int n5;
                        ifxColumnInfo2 = (IfxColumnInfo)vector2.elementAt(j);
                        int n6 = ifxColumnInfo2.SQLtype;
                        short s = (short)(n6 & 0xFF);
                        int n7 = ifxColumnInfo2.ColLength;
                        int n8 = s == 5 || s == 8 ? ifxColumnInfo2.ColLength / 256 : ifxColumnInfo2.ColLength;
                        String string9 = IfxTypes.IfxTypeToName(s);
                        int n9 = 0;
                        int n10 = 0;
                        if (s == 1 || s == 2 || s == 6) {
                            n10 = 2;
                            n9 = 10;
                        } else if (s == 17 || s == 18) {
                            n9 = 10;
                        } else if (s == 5 || s == 8) {
                            n10 = n7 - n7 / 256 * 256;
                            n9 = 10;
                        } else if (s == 3) {
                            n10 = 15;
                            n9 = 10;
                        } else if (s == 4) {
                            n10 = 7;
                            n9 = 10;
                        } else if (s == 41 && (string9.equals("boolean") || (n6 & 0x4000) == 16384)) {
                            n9 = 2;
                        }
                        if (ifxColumnInfo2.Nullable == 0) {
                            n5 = 0;
                            string8 = "NO";
                        } else if (ifxColumnInfo2.Nullable == 1) {
                            n5 = 1;
                            string8 = "YES";
                        } else {
                            n5 = 2;
                            string8 = "";
                        }
                        int n11 = 0;
                        if (s == 0) {
                            n11 = n7;
                        }
                        String string10 = "insert into " + string5 + " values( '" + string6 + "', '" + ifxUDTInfo.owner + "', '" + ifxUDTInfo.name + "', '" + ifxColumnInfo2.ColName + "'," + ifxColumnInfo2.SQLtype + ", '" + string9 + "', " + n8 + "," + n10 + "," + n9 + "," + n5 + ",null,null,0,0," + n11 + ", " + ifxColumnInfo2.Fieldno + ", '" + string8 + "', null,null,null,";
                        string10 = ifxColumnInfo2.IsDistinct ? string10.concat(ifxColumnInfo2.SourceType + ")") : string10.concat("null)");
                        ifxStatement2.executeUpdate(string10);
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            ((IfxSqliConnect)this.conn).endMetaDataQuery();
            throw sQLException;
        }
        object2 = null;
        object = "select * from " + string5 + " where attr_name like '" + string4 + "' order by TYPE_SCHEM, TYPE_NAME, ORDINAL_POSITION";
        object2 = this.conn.isANSI() && this.conn.getAutoCommit() ? ifxStatement.executeQuery((String)object, true) : ifxStatement.executeQuery((String)object, false);
        ResultSetMetaData resultSetMetaData = object2.getMetaData();
        IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(21, this.conn);
        if (this.conn.isOnLine()) {
            n = 129;
            if (this.conn.getdbEncoding() == "UTF8") {
                n = 85;
            }
            int n12 = 0;
            int n13 = 1;
            n2 = n;
            ifxResultSetMetaData.setColumnName(n13, this.conn.retCapName("TYPE_CAT"));
            ifxResultSetMetaData.setIfxColumnType(n13, 13);
            n2 = n;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("TYPE_SCHEM"));
            ifxResultSetMetaData.setIfxColumnType(n13, 13);
            n2 = n;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("TYPE_NAME"));
            ifxResultSetMetaData.setIfxColumnType(n13, 13);
            n2 = n;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("ATTR_NAME"));
            ifxResultSetMetaData.setIfxColumnType(n13, 13);
            n2 = n;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("DATA_TYPE"));
            ifxResultSetMetaData.setIfxColumnType(n13, 1);
            n2 = 2;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("ATTR_TYPE_NAME"));
            ifxResultSetMetaData.setIfxColumnType(n13, 13);
            n2 = n;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("ATTR_SIZE"));
            ifxResultSetMetaData.setIfxColumnType(n13, 1);
            n2 = 2;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("DECIMAL_DIGITS"));
            ifxResultSetMetaData.setIfxColumnType(n13, 2);
            n2 = 4;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("NUM_PREC_RADIX"));
            ifxResultSetMetaData.setIfxColumnType(n13, 2);
            n2 = 4;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("NULLABLE"));
            ifxResultSetMetaData.setIfxColumnType(n13, 2);
            n2 = 4;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("REMARKS"));
            ifxResultSetMetaData.setIfxColumnType(n13, 0);
            n2 = 18;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("ATTR_DEF"));
            ifxResultSetMetaData.setIfxColumnType(n13, 13);
            n2 = 255;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("SQL_DATA_TYPE"));
            ifxResultSetMetaData.setIfxColumnType(n13, 2);
            n2 = 4;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("SQL_DATETIME_SUB"));
            ifxResultSetMetaData.setIfxColumnType(n13, 2);
            n2 = 4;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("CHAR_OCTET_LENGTH"));
            ifxResultSetMetaData.setIfxColumnType(n13, 2);
            n2 = 4;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("ORDINAL_POSITION"));
            ifxResultSetMetaData.setIfxColumnType(n13, 2);
            n2 = 4;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("IS_NULLABLE"));
            ifxResultSetMetaData.setIfxColumnType(n13, 0);
            n2 = 3;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("SCOPE_CATLOG"));
            ifxResultSetMetaData.setIfxColumnType(n13, 13);
            n2 = 255;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("SCOPE_SCHEMA"));
            ifxResultSetMetaData.setIfxColumnType(n13, 13);
            n2 = 255;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("SCOPE_TABLE"));
            ifxResultSetMetaData.setIfxColumnType(n13, 13);
            n2 = 255;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n13, this.conn.retCapName("SOURCE_DATA_TYPE"));
            ifxResultSetMetaData.setIfxColumnType(n13, 1);
            n2 = 2;
            ifxResultSetMetaData.setEncodedLength(n13, n2);
            ifxResultSetMetaData.setTableName(n13, "");
            ifxResultSetMetaData.setColtitle(n13, null);
            ifxResultSetMetaData.setColumnStartPosition(n13, n12);
            n12 += n2;
            ++n13;
        } else {
            int n14;
            n = 0;
            int n15 = 1;
            n2 = n14 = 50;
            ifxResultSetMetaData.setColumnName(n15, this.conn.retCapName("TYPE_CAT"));
            ifxResultSetMetaData.setIfxColumnType(n15, 13);
            n2 = n14;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("TYPE_SCHEM"));
            ifxResultSetMetaData.setIfxColumnType(n15, 13);
            n2 = n14;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("TYPE_NAME"));
            ifxResultSetMetaData.setIfxColumnType(n15, 13);
            n2 = n14;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("ATTR_NAME"));
            ifxResultSetMetaData.setIfxColumnType(n15, 13);
            n2 = n14;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("DATA_TYPE"));
            ifxResultSetMetaData.setIfxColumnType(n15, 1);
            n2 = 2;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("ATTR_TYPE_NAME"));
            ifxResultSetMetaData.setIfxColumnType(n15, 13);
            n2 = n14;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("ATTR_SIZE"));
            ifxResultSetMetaData.setIfxColumnType(n15, 1);
            n2 = 2;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("DECIMAL_DIGITS"));
            ifxResultSetMetaData.setIfxColumnType(n15, 2);
            n2 = 4;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("NUM_PREC_RADIX"));
            ifxResultSetMetaData.setIfxColumnType(n15, 2);
            n2 = 4;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("NULLABLE"));
            ifxResultSetMetaData.setIfxColumnType(n15, 2);
            n2 = 4;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("REMARKS"));
            ifxResultSetMetaData.setIfxColumnType(n15, 0);
            n2 = 18;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("ATTR_DEF"));
            ifxResultSetMetaData.setIfxColumnType(n15, 13);
            n2 = 255;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("SQL_DATA_TYPE"));
            ifxResultSetMetaData.setIfxColumnType(n15, 2);
            n2 = 4;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("SQL_DATETIME_SUB"));
            ifxResultSetMetaData.setIfxColumnType(n15, 2);
            n2 = 4;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("CHAR_OCTET_LENGTH"));
            ifxResultSetMetaData.setIfxColumnType(n15, 2);
            n2 = 4;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("ORDINAL_POSITION"));
            ifxResultSetMetaData.setIfxColumnType(n15, 2);
            n2 = 4;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("IS_NULLABLE"));
            ifxResultSetMetaData.setIfxColumnType(n15, 0);
            n2 = 3;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("SCOPE_CATLOG"));
            ifxResultSetMetaData.setIfxColumnType(n15, 13);
            n2 = 255;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("SCOPE_SCHEMA"));
            ifxResultSetMetaData.setIfxColumnType(n15, 13);
            n2 = 255;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("SCOPE_TABLE"));
            ifxResultSetMetaData.setIfxColumnType(n15, 13);
            n2 = 255;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2 + 1;
            ifxResultSetMetaData.setColumnName(++n15, this.conn.retCapName("SOURCE_DATA_TYPE"));
            ifxResultSetMetaData.setIfxColumnType(n15, 1);
            n2 = 2;
            ifxResultSetMetaData.setEncodedLength(n15, n2);
            ifxResultSetMetaData.setTableName(n15, "");
            ifxResultSetMetaData.setColtitle(n15, null);
            ifxResultSetMetaData.setColumnStartPosition(n15, n);
            n += n2;
            ++n15;
        }
        resultSetMetaData = ifxResultSetMetaData;
        ResultSet resultSet = this.populateClientResultSet((ResultSet)object2, resultSetMetaData);
        ifxStatement.close();
        this.dropTempTable(string5);
        ((IfxSqliConnect)this.conn).endMetaDataQuery();
        return resultSet;
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        boolean bl = false;
        if (n == 1 || n == 2) {
            bl = true;
        }
        return bl;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getDatabaseMajorVersion(): call IfxConnection:getDbVersion()");
        }
        String string = this.getDatabaseProductVersion();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getDatabaseMajorVersion(): call Driver.extractMajorVersion()");
        }
        return Driver.extractMajorVersion(string);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getDatabaseMinorVersion(): call IfxConnection:getDbVersion()");
        }
        String string = this.getDatabaseProductVersion();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getDatabaseMinorVersion(): call Driver.extractMinorVersion()");
        }
        return Driver.extractMinorVersion(string);
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getJDBCMajorVersion(): call Driver:getJDBCMajorVersion()");
        }
        return Driver.getJDBCMajorVersion();
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getJDBCMinorVersion(): call Driver:getJDBCMinorVersion()");
        }
        return Driver.getJDBCMinorVersion();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 1;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    private String checkSynonym(String string, String string2) throws SQLException {
        String string3 = string;
        ResultSet resultSet = null;
        String string4 = "T";
        int n = 0;
        IfxStatement ifxStatement = (IfxStatement)this.conn.createStatement();
        String string5 = null;
        string5 = this.conn.isOnLine() ? "select tabid, tabtype from " + string2 + ":gbasedbt.systables where (tabname like '" + string3 + "' and owner like '%')" : "select tabid, tabtype from gbasedbt.systables where (tabname like '" + string3 + "' and owner like '%')";
        resultSet = ifxStatement.executeQuery(string5);
        if (resultSet.next()) {
            n = resultSet.getInt(1);
            string4 = resultSet.getString(2);
        }
        if (string4.equalsIgnoreCase("S") || string4.equalsIgnoreCase("P")) {
            int n2 = 0;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            string5 = "select btabid, servername, dbname, owner, tabname from " + string2 + ":gbasedbt.syssyntable where tabid = " + n;
            resultSet = ifxStatement.executeQuery(string5);
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
                string6 = resultSet.getString(2);
                string7 = resultSet.getString(3);
                string8 = resultSet.getString(4);
                string9 = resultSet.getString(5);
            }
            if (n2 != 0) {
                string5 = "select tabname from " + string2 + ":gbasedbt.systables where tabid = " + n2;
                resultSet = ifxStatement.executeQuery(string5);
                if (resultSet.next()) {
                    string3 = resultSet.getString(1);
                }
            } else {
                string3 = string7 + "@" + string6 + ":" + string8 + "." + string9;
            }
        }
        resultSet.close();
        ifxStatement.close();
        return string3;
    }

    private String getMetaDbName(String string) throws SQLException {
        if (string == null || string.length() == 0) {
            return this.conn.getDbName();
        }
        return string;
    }

    protected static int getJDBCColumnSize(short s, short s2, int n) {
        switch (s) {
            case 5: 
            case 8: {
                return n >>> 8;
            }
            case 11: 
            case 12: {
                if (lrow == null) {
                    return n;
                }
                return RowInfo.getPrecisionForIfxType(lrow, s, s2);
            }
            case 41: {
                if (lrow != null && (s2 == 10 || s2 == 11)) {
                    return RowInfo.getPrecisionForIfxType(lrow, s, s2);
                }
                return n;
            }
            case 17: 
            case 18: 
            case 52: 
            case 53: {
                return 19;
            }
            case 3: {
                return 17;
            }
            case 4: {
                return 7;
            }
            case 2: 
            case 6: 
            case 7: {
                return 10;
            }
            case 1: {
                return 5;
            }
            case 10: 
            case 14: {
                int n2 = n >> 8 & 0xFF;
                int n3 = n >> 4 & 0xF;
                int n4 = n & 0xF;
                int n5 = n2 + ((n4 > 10 ? 12 : n4) - n3) / 2 + (n3 == 12 ? 1 : 0);
                return n5;
            }
        }
        return n;
    }

    private String toSchemaCaseLikeServer(String string) {
        if (this.conn.isANSI() && !string.toUpperCase().equals("GBASEDBT")) {
            return string.toUpperCase();
        }
        return string.toLowerCase();
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:autoCommitFailureClosesAllResultSets()not supported");
        }
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getClientInfoProperties()not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxDatabaseMetaData.getClientInfoProperties()", this.conn);
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getFunctionColumns(String, String , String, String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxDatabaseMetaData.getFunctionColumns(String, String, String, String)", this.conn);
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getFunctions(String, String, String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxDatabaseMetaData.getFunctions(String, String, String)", this.conn);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:isWrapperFor(Class)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxDatabaseMetaData.isWrapperFor(Class)", this.conn);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:unwrap(Class<T>)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxDatabaseMetaData.unwrap(Class<T>)", this.conn);
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getSchemas(String, String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxDatabaseMetaData.getSchemas(String, String)", this.conn);
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:getRowIdLifetime()not supported");
        }
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDatabaseMetaData:supportsStoredFunctionsUsingCallSyntax()not supported");
        }
        return true;
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        return null;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    static {
        int n;
        nextTempTableId = 1;
        nMdInfoRows = 18;
        nStdRowTypes = 19;
        nXtdRowTypes = 31;
        nXtdRowTypesSupported = 27;
        lmd = null;
        lrow = null;
        lrowgeneric = null;
        lrowLvc32k = null;
        if (lmd == null) {
            n = 0;
            lmd = new mdinfo[nMdInfoRows];
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("TYPE_NAME", 0, 128, true, 0);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("DATA_TYPE", 1, 2, true, 128);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("PRECISION", 2, 4, true, 130);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("LITERAL_PREFIX", 0, 128, true, 134);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("LITERAL_SUFFIX", 0, 128, true, 262);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("CREATE_PARAMS", 0, 128, true, 390);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("NULLABLE", 1, 2, true, 518);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("CASE_SENSITIVE", 1, 2, true, 520);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("SEARCHABLE", 2, 4, true, 522);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("UNSIGNED_ATTRIBUTE", 1, 2, true, 526);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("FIXED_PREC_SCALE", 1, 2, true, 528);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("AUTO_INCREMENT", 1, 2, true, 530);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("LOCAL_TYPE_NAME", 0, 128, true, 532);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("MINIMUM_SCALE", 1, 2, true, 660);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("MAXIMUM_SCALE", 1, 2, true, 662);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("SQL_DATA_TYPE", 2, 4, true, 664);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("SQL_DATETIME_SUB", 2, 4, true, 668);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("NUM_PREC_RADIX", 2, 4, true, 672);
        }
        if (lrowgeneric == null) {
            n = 0;
            lrowgeneric = new RowInfo[nXtdRowTypes];
            lrowLvc32k = new RowInfo[nXtdRowTypes];
            int n2 = n;
            int n3 = n++;
            RowInfo rowInfo = new RowInfo("byte", -4, 11, 0, Integer.MAX_VALUE, "<Null>", "<Null>", 1, false, 0, false, false, 0, Short.MAX_VALUE, 0);
            IfxDatabaseMetaData.lrowgeneric[n3] = rowInfo;
            IfxDatabaseMetaData.lrowLvc32k[n2] = rowInfo;
            int n4 = n;
            int n5 = n++;
            RowInfo rowInfo2 = new RowInfo("char", 1, 0, 0, Short.MAX_VALUE, "'", "'", 1, true, 3, false, false, 0, Short.MAX_VALUE, 0);
            IfxDatabaseMetaData.lrowgeneric[n5] = rowInfo2;
            IfxDatabaseMetaData.lrowLvc32k[n4] = rowInfo2;
            int n6 = n;
            int n7 = n++;
            RowInfo rowInfo3 = new RowInfo("character varying", 12, 13, 0, 255, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n7] = rowInfo3;
            IfxDatabaseMetaData.lrowLvc32k[n6] = rowInfo3;
            int n8 = n;
            int n9 = n++;
            RowInfo rowInfo4 = new RowInfo("date", 91, 7, 0, 10, "{d'", "'}", 1, false, 2, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n9] = rowInfo4;
            IfxDatabaseMetaData.lrowLvc32k[n8] = rowInfo4;
            int n10 = n;
            int n11 = n++;
            RowInfo rowInfo5 = new RowInfo("datetime year to fraction(5)", 93, 10, 0, 0, "{ts'", "'}", 1, false, 2, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n11] = rowInfo5;
            IfxDatabaseMetaData.lrowLvc32k[n10] = rowInfo5;
            int n12 = n;
            int n13 = n++;
            RowInfo rowInfo6 = new RowInfo("decimal", 3, 5, 0, 32, "<Null>", "<Null>", 1, false, 2, true, false, 1, 32, 10);
            IfxDatabaseMetaData.lrowgeneric[n13] = rowInfo6;
            IfxDatabaseMetaData.lrowLvc32k[n12] = rowInfo6;
            int n14 = n;
            int n15 = n++;
            RowInfo rowInfo7 = new RowInfo("double precision", 6, 3, 0, 15, "<Null>", "<Null>", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n15] = rowInfo7;
            IfxDatabaseMetaData.lrowLvc32k[n14] = rowInfo7;
            int n16 = n;
            int n17 = n++;
            RowInfo rowInfo8 = new RowInfo("float", 6, 3, 0, 15, "<Null>", "<Null>", 1, false, 2, false, false, 1, 8, 10);
            IfxDatabaseMetaData.lrowgeneric[n17] = rowInfo8;
            IfxDatabaseMetaData.lrowLvc32k[n16] = rowInfo8;
            int n18 = n;
            int n19 = n++;
            RowInfo rowInfo9 = new RowInfo("integer", 4, 2, 0, 10, "<Null>", "<Null>", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n19] = rowInfo9;
            IfxDatabaseMetaData.lrowLvc32k[n18] = rowInfo9;
            int n20 = n;
            int n21 = n++;
            RowInfo rowInfo10 = new RowInfo("interval", 1111, 14, 0, 0, "'", "'", 1, false, 2, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n21] = rowInfo10;
            IfxDatabaseMetaData.lrowLvc32k[n20] = rowInfo10;
            int n22 = n;
            int n23 = n++;
            RowInfo rowInfo11 = new RowInfo("nchar", 1, 15, 0, Short.MAX_VALUE, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n23] = rowInfo11;
            IfxDatabaseMetaData.lrowLvc32k[n22] = rowInfo11;
            int n24 = n;
            int n25 = n++;
            RowInfo rowInfo12 = new RowInfo("nvarchar", 12, 16, 0, 255, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n25] = rowInfo12;
            IfxDatabaseMetaData.lrowLvc32k[n24] = rowInfo12;
            int n26 = n;
            int n27 = n++;
            RowInfo rowInfo13 = new RowInfo("money", 3, 8, 0, 32, "<Null>", "<Null>", 1, false, 2, true, false, 16, 32, 10);
            IfxDatabaseMetaData.lrowgeneric[n27] = rowInfo13;
            IfxDatabaseMetaData.lrowLvc32k[n26] = rowInfo13;
            int n28 = n;
            int n29 = n++;
            RowInfo rowInfo14 = new RowInfo("numeric", 2, 5, 0, 32, "<Null>", "<Null>", 1, false, 2, true, false, 1, 32, 10);
            IfxDatabaseMetaData.lrowgeneric[n29] = rowInfo14;
            IfxDatabaseMetaData.lrowLvc32k[n28] = rowInfo14;
            int n30 = n;
            int n31 = n++;
            RowInfo rowInfo15 = new RowInfo("serial", 4, 6, 0, 10, "<Null>", "<Null>", 0, false, 2, false, true, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n31] = rowInfo15;
            IfxDatabaseMetaData.lrowLvc32k[n30] = rowInfo15;
            int n32 = n;
            int n33 = n++;
            RowInfo rowInfo16 = new RowInfo("smallint", 5, 1, 0, 4, "<Null>", "<Null>", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n33] = rowInfo16;
            IfxDatabaseMetaData.lrowLvc32k[n32] = rowInfo16;
            int n34 = n;
            int n35 = n++;
            RowInfo rowInfo17 = new RowInfo("smallfloat", 7, 4, 0, 6, "<Null>", "<Null>", 1, false, 2, false, false, 1, 6, 10);
            IfxDatabaseMetaData.lrowgeneric[n35] = rowInfo17;
            IfxDatabaseMetaData.lrowLvc32k[n34] = rowInfo17;
            int n36 = n;
            int n37 = n++;
            RowInfo rowInfo18 = new RowInfo("text", -1, 12, 0, Integer.MAX_VALUE, "'", "'", 1, false, 0, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n37] = rowInfo18;
            IfxDatabaseMetaData.lrowLvc32k[n36] = rowInfo18;
            int n38 = n;
            int n39 = n++;
            RowInfo rowInfo19 = new RowInfo("varchar", 12, 13, 0, 255, "'", "'", 1, true, 3, false, false, 0, 255, 0);
            IfxDatabaseMetaData.lrowgeneric[n39] = rowInfo19;
            IfxDatabaseMetaData.lrowLvc32k[n38] = rowInfo19;
            if (Driver.compareJDKVersion("1.4") < 0) {
                int n40 = n;
                int n41 = n++;
                RowInfo rowInfo20 = new RowInfo("boolean", 1111, 45, 5, 1, "<Null>", "<Null>", 1, false, 2, false, false, 0, 0, 2);
                IfxDatabaseMetaData.lrowgeneric[n41] = rowInfo20;
                IfxDatabaseMetaData.lrowLvc32k[n40] = rowInfo20;
            } else {
                int n42 = n;
                int n43 = n++;
                RowInfo rowInfo21 = new RowInfo("boolean", 16, 45, 5, 1, "<Null>", "<Null>", 1, false, 2, false, false, 0, 0, 2);
                IfxDatabaseMetaData.lrowgeneric[n43] = rowInfo21;
                IfxDatabaseMetaData.lrowLvc32k[n42] = rowInfo21;
            }
            int n44 = n;
            int n45 = n++;
            RowInfo rowInfo22 = new RowInfo("int8", -5, 17, 0, 19, "<Null>", "<Null>", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n45] = rowInfo22;
            IfxDatabaseMetaData.lrowLvc32k[n44] = rowInfo22;
            int n46 = n;
            int n47 = n++;
            RowInfo rowInfo23 = new RowInfo("serial8", -5, 18, 0, 19, "<Null>", "<Null>", 0, false, 2, false, true, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n47] = rowInfo23;
            IfxDatabaseMetaData.lrowLvc32k[n46] = rowInfo23;
            int n48 = n;
            int n49 = n++;
            RowInfo rowInfo24 = new RowInfo("clob", 2005, 41, 11, Integer.MAX_VALUE, "<Null>", "<Null>", 1, false, 0, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n49] = rowInfo24;
            IfxDatabaseMetaData.lrowLvc32k[n48] = rowInfo24;
            int n50 = n;
            int n51 = n++;
            RowInfo rowInfo25 = new RowInfo("blob", 2004, 41, 10, Integer.MAX_VALUE, "<Null>", "<Null>", 1, false, 0, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n51] = rowInfo25;
            IfxDatabaseMetaData.lrowLvc32k[n50] = rowInfo25;
            IfxDatabaseMetaData.lrowLvc32k[n] = new RowInfo("lvarchar", -1, 43, 1, 32739, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n++] = new RowInfo("lvarchar", -1, 43, 1, 2048, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            int n52 = n;
            int n53 = n++;
            RowInfo rowInfo26 = new RowInfo("bigint", -5, 52, 0, 19, "<Null>", "<Null>", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n53] = rowInfo26;
            IfxDatabaseMetaData.lrowLvc32k[n52] = rowInfo26;
            int n54 = n;
            int n55 = n++;
            RowInfo rowInfo27 = new RowInfo("bigserial", -5, 53, 0, 19, "<Null>", "<Null>", 0, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrowgeneric[n55] = rowInfo27;
            IfxDatabaseMetaData.lrowLvc32k[n54] = rowInfo27;
            int n56 = n;
            int n57 = n++;
            RowInfo rowInfo28 = new RowInfo("list", 1111, 21, 0, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n57] = rowInfo28;
            IfxDatabaseMetaData.lrowLvc32k[n56] = rowInfo28;
            int n58 = n;
            int n59 = n++;
            RowInfo rowInfo29 = new RowInfo("multiset", 1111, 20, 0, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n59] = rowInfo29;
            IfxDatabaseMetaData.lrowLvc32k[n58] = rowInfo29;
            int n60 = n;
            int n61 = n++;
            RowInfo rowInfo30 = new RowInfo("set", 1111, 19, 0, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n61] = rowInfo30;
            IfxDatabaseMetaData.lrowLvc32k[n60] = rowInfo30;
            int n62 = n;
            int n63 = n++;
            RowInfo rowInfo31 = new RowInfo("unnamed row", 1111, 22, 0, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrowgeneric[n63] = rowInfo31;
            IfxDatabaseMetaData.lrowLvc32k[n62] = rowInfo31;
        }
    }
}

