/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxDecimal;
import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.lang.Decimal;
import com.gbasedbt.lang.IfxToJavaType;
import com.gbasedbt.lang.JavaToIfxType;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.dateUtil;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class IfxDateTime
extends IfxObject {
    private long value = 0L;
    private int nanos = 0;
    private boolean isTime = false;
    private boolean isTimeStampFF = false;
    private boolean isTimeStampSS = false;
    private boolean isTimeStampMT = false;
    private boolean isTimeStampHH = false;
    private boolean isTimeStampDD = false;
    private boolean isTimeStampMM = false;
    private boolean isTimeStampYY = false;
    private boolean isTimeStampSF = false;
    private boolean isTimeStampMTF = false;
    private boolean isTimeStampMTS = false;
    private boolean isTimeStampHF = false;
    private boolean isTimeStampHM = false;
    private boolean isTimeStampDF = false;
    private boolean isTimeStampDS = false;
    private boolean isTimeStampDMT = false;
    private boolean isTimeStampDH = false;
    private boolean isTimeStampMF = false;
    private boolean isTimeStampMS = false;
    private boolean isTimeStampMMT = false;
    private boolean isTimeStampMH = false;
    private boolean isTimeStampMD = false;
    private boolean isTimeStampYS = false;
    private boolean isTimeStampYMT = false;
    private boolean isTimeStampYH = false;
    private boolean isTimeStampYD = false;
    private boolean isTimeStampYM = false;
    private short qualifier = 0;
    protected Calendar dbCalendar = null;
    private byte[] rawData = null;
    private short storedQualifier = 0;
    public static final byte TU_YEAR = 0;
    public static final byte TU_MONTH = 2;
    public static final byte TU_DAY = 4;
    public static final byte TU_HOUR = 6;
    public static final byte TU_MINUTE = 8;
    public static final byte TU_SECOND = 10;
    public static final byte TU_FRAC = 12;
    public static final byte TU_F1 = 11;
    public static final byte TU_F2 = 12;
    public static final byte TU_F3 = 13;
    public static final byte TU_F4 = 14;
    public static final byte TU_F5 = 15;

    IfxDateTime() throws SQLException {
        this.setIfxType(10);
    }

    IfxDateTime(Time time) throws SQLException {
        this.setIfxType(10);
        this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
        if (time != null) {
            this.value = time.getTime();
            this.isTime = true;
            this.unnullify();
        }
    }

    IfxDateTime(Timestamp timestamp) throws SQLException {
        this.setIfxType(10);
        this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)15);
        if (timestamp != null) {
            this.value = timestamp.getTime();
            this.nanos = timestamp.getNanos();
            this.isTime = false;
            this.unnullify();
        }
    }

    @Override
    public byte[] toIfx() {
        if (this.isTime) {
            return JavaToIfxType.JavaToIfxDateTime(new Time(this.value));
        }
        Timestamp timestamp = new Timestamp(this.value);
        timestamp.setNanos(this.nanos);
        return JavaToIfxType.JavaToIfxDateTime(timestamp, this.dbCalendar);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            return JavaToIfxType.JavaToIfxDecimalNull((short)this.encodedLength);
        }
        byte[] byArray = this.toIfx();
        return Decimal.fromBindToTuple(byArray, IfxDecimal.decLength(this.encodedLength));
    }

    @Override
    public void fromIfx(byte[] byArray, short s) {
        this.fromIfx(byArray, 0, byArray.length, s);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2, short s) {
        this.rawData = new byte[n2];
        System.arraycopy(byArray, n, this.rawData, 0, n2);
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            this.nullify();
        } else {
            this.storedQualifier = s;
            this.qualifier = s;
            Timestamp timestamp = IfxToJavaType.IfxToJavaDateTime(byArray, n, n2, s, this.dbCalendar);
            this.value = timestamp.getTime();
            byte by = IfxDateTime.getStartCode(this.qualifier);
            byte by2 = IfxDateTime.getEndCode(this.qualifier);
            this.nanos = timestamp.getNanos();
            this.setDateTimeType(this.nanos, by, by2);
            this.unnullify();
        }
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        if (this.isTime) {
            return Time.valueOf(new Time(this.value).toString());
        }
        Timestamp timestamp = new Timestamp(this.value);
        timestamp.setNanos(this.nanos);
        return timestamp;
    }

    @Override
    public java.sql.Date toDate() {
        if (this.isNull()) {
            return null;
        }
        return new java.sql.Date(this.value);
    }

    @Override
    public void fromDate(java.sql.Date date) throws SQLException {
        if (date == null) {
            this.nullify();
        } else {
            this.value = date.getTime();
            this.nanos = 0;
            this.isTime = false;
            this.unnullify();
        }
    }

    @Override
    public Timestamp toTimestamp() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        Timestamp timestamp = new Timestamp(this.value);
        timestamp.setNanos(this.nanos);
        return timestamp;
    }

    @Override
    public void fromTimestamp(Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.nullify();
        } else {
            this.value = timestamp.getTime();
            this.nanos = timestamp.getNanos();
            this.isTime = false;
            this.qualifier = IfxDateTime.getQualifier((byte)0, (byte)15);
            this.unnullify();
        }
    }

    public void fromRawDateTime(byte[] byArray, short s) throws SQLException {
        if (byArray == null) {
            this.nullify();
        } else {
            int n = byArray.length;
            this.rawData = new byte[n];
            System.arraycopy(byArray, 0, this.rawData, 0, n);
            if (byArray[0] == 0 && byArray[1] == 0) {
                this.nullify();
            } else {
                this.isTime = false;
                this.storedQualifier = s;
                this.unnullify();
            }
        }
    }

    Timestamp toTimestampFromRawData(Calendar calendar) throws SQLException {
        if (this.rawData == null || this.rawData.length == 0 || this.storedQualifier == 0) {
            return null;
        }
        Decimal decimal = new Decimal(this.rawData, 0, this.rawData.length, this.storedQualifier, true);
        Timestamp timestamp = decimal.timestampValue(calendar);
        this.value = timestamp.getTime();
        this.nanos = timestamp.getNanos();
        return timestamp;
    }

    public void fromTimestamp(Timestamp timestamp, short s) throws SQLException {
        if (timestamp == null) {
            this.nullify();
        } else {
            this.value = timestamp.getTime();
            this.nanos = timestamp.getNanos();
            this.isTime = false;
            this.qualifier = s;
            this.unnullify();
        }
    }

    @Override
    public Time toTime() throws SQLException {
        int n;
        if (this.isNull()) {
            return null;
        }
        Time time = new Time(this.value);
        String string = time.toString();
        if (string == null) {
            return null;
        }
        Time time2 = null;
        int n2 = string.indexOf(58);
        if (n2 > 0 & (n = string.indexOf(58, n2 + 1)) > 0 & n < string.length() - 1) {
            int n3 = Integer.parseInt(string.substring(0, n2));
            int n4 = Integer.parseInt(string.substring(n2 + 1, n));
            int n5 = Integer.parseInt(string.substring(n + 1));
            time2 = new Time(n3, n4, n5);
            time = null;
        }
        return time2;
    }

    @Override
    public void fromTime(Time time) throws SQLException {
        if (time == null) {
            this.nullify();
        } else {
            this.value = time.getTime();
            this.isTime = true;
            this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        String string = null;
        String string2 = null;
        if (this.isNull()) {
            return null;
        }
        try {
            if (this.isTime) {
                Time time = new Time(this.value);
                string = dateUtil.convertDateTimeStr(time, this.conn, this.value);
                int n = string.length();
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                n5 = string.indexOf(58);
                if (n5 > 0 & (n6 = string.indexOf(58, n5 + 1)) > 0 & n6 < n - 1) {
                    n2 = Integer.parseInt(string.substring(0, n5));
                    n3 = Integer.parseInt(string.substring(n5 + 1, n6));
                    n4 = Integer.parseInt(string.substring(n6 + 1));
                }
                if (this.isTimeStampSS) {
                    string = string2 = string.substring(n6 + 1, n);
                } else if (this.isTimeStampMTS) {
                    string = string2 = string.substring(n5 + 1, n6 + 3);
                } else if (this.isTimeStampMT) {
                    string = string2 = string.substring(n5 + 1, n6);
                } else if (this.isTimeStampHM) {
                    string = string2 = string.substring(0, n6);
                } else if (this.isTimeStampHH) {
                    string = string2 = string.substring(0, n6 - 3);
                }
            } else if (this.value + (long)(this.nanos / 1000000) != 0L || this.rawData == null || this.rawData.length < 1) {
                Timestamp timestamp = this.toTimestamp();
                string = dateUtil.convertDateTimeStr(timestamp, this.conn, this.value);
                int n = string.length();
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                n10 = string.indexOf(45);
                if (n10 > 0 & (n11 = string.indexOf(45, n10 + 1)) > 0 & n11 < string.length() - 1) {
                    n7 = Integer.parseInt(string.substring(0, n10));
                    n8 = Integer.parseInt(string.substring(n10 + 1, n11));
                    n9 = Integer.parseInt(string.substring(n11 + 1, n11 + 3));
                }
                if (this.isTimeStampFF) {
                    string = string2 = string.substring(n11 + 12, n);
                } else if (this.isTimeStampSF) {
                    string = string2 = string.substring(n11 + 10, n);
                } else if (this.isTimeStampMTF) {
                    string = string2 = string.substring(n11 + 7, n);
                } else if (this.isTimeStampHF) {
                    string = string2 = string.substring(11, n);
                } else if (this.isTimeStampDF) {
                    string = string2 = string.substring(n11 + 1, n);
                } else if (this.isTimeStampDS) {
                    string = string2 = string.substring(n11 + 1, n - 2);
                } else if (this.isTimeStampDMT) {
                    string = string2 = string.substring(n11 + 1, n - 5);
                } else if (this.isTimeStampDH) {
                    string = string2 = string.substring(n11 + 1, n - 8);
                } else if (this.isTimeStampDD) {
                    string = string2 = string.substring(n11 + 1, n - 11);
                } else if (this.isTimeStampMF) {
                    string = string2 = string.substring(n10 + 1, n);
                } else if (this.isTimeStampMS) {
                    string = string2 = string.substring(n10 + 1, n - 2);
                } else if (this.isTimeStampMMT) {
                    string = string2 = string.substring(n10 + 1, n - 5);
                } else if (this.isTimeStampMH) {
                    string = string2 = string.substring(n10 + 1, n - 8);
                } else if (this.isTimeStampMD) {
                    string = string2 = string.substring(n10 + 1, n - 11);
                } else if (this.isTimeStampMM) {
                    string = string2 = string.substring(n10 + 1, n - 14);
                } else if (this.isTimeStampYY) {
                    string = string2 = string.substring(0, n - 17);
                } else if (this.isTimeStampYM) {
                    string = string2 = string.substring(0, n - 14);
                } else if (this.isTimeStampYD) {
                    string = string2 = string.substring(0, n - 11);
                } else if (this.isTimeStampYH) {
                    string = string2 = string.substring(0, n - 8);
                } else if (this.isTimeStampYMT) {
                    string = string2 = string.substring(0, n - 5);
                } else if (this.isTimeStampYS) {
                    string = string2 = string.substring(0, n - 2);
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer(this.rawData.length * 3 + 2);
                for (int i = 0; i < this.rawData.length; ++i) {
                    stringBuffer.append(' ');
                    stringBuffer.append(this.rawData[i]);
                }
                string = new String(stringBuffer);
            }
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    @Override
    public String toUnloadString() {
        if (this.isNull()) {
            return null;
        }
        return IfxToJavaType.IfxToDateTimeUnloadString(this.rawData, 0, this.rawData.length, this.storedQualifier);
    }

    @Override
    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.nullify();
        } else {
            String string2 = string.trim();
            boolean bl = false;
            try {
                Timestamp timestamp = (Timestamp)dateUtil.convertDateTimeObj(string2, this.conn, bl);
                this.value = timestamp.getTime();
                this.nanos = timestamp.getNanos();
                this.isTime = false;
                this.unnullify();
            }
            catch (SQLException sQLException) {
                try {
                    bl = true;
                    Object object = dateUtil.convertDateTimeObj(string2, this.conn, bl);
                    this.value = ((Date)object).getTime();
                    Time time = new Time(this.value);
                    this.nanos = 0;
                    this.isTime = true;
                    this.qualifier = IfxDateTime.getQualifier((byte)6, (byte)10);
                    this.unnullify();
                }
                catch (Exception exception) {
                    this.nullify();
                    this.value = 0L;
                    this.nanos = 0;
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
            }
            catch (Exception exception) {
                this.nullify();
                this.value = 0L;
                this.nanos = 0;
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        if (object instanceof IfxDateTime) {
            IfxDateTime ifxDateTime = (IfxDateTime)object;
            if (ifxDateTime.isNull()) {
                return false;
            }
            if (ifxDateTime.value == this.value && ifxDateTime.nanos == this.nanos) {
                return true;
            }
        }
        return false;
    }

    static short getQualifier(byte by, byte by2) {
        short s = (short)(by2 - by + (by == 0 ? 4 : 2));
        short s2 = (short)((byte)s << 8 | by << 4 | by2);
        return s2;
    }

    static byte getLength(short s) {
        byte by = (byte)(s >> 8);
        return by;
    }

    public static byte getStartCode(short s) {
        byte by = (byte)(s >> 4 & 0xF);
        return by;
    }

    public static byte getEndCode(short s) {
        byte by = (byte)(s & 0xF);
        return by;
    }

    @Override
    public short getEncodedLength() {
        if (this.qualifier == 0) {
            byte by = 0;
            byte by2 = 15;
            this.qualifier = IfxDateTime.getQualifier(by, by2);
        }
        return this.qualifier;
    }

    static String getQualifierName(short s, int n) {
        if (s == 0) {
            return null;
        }
        byte by = IfxDateTime.getStartCode(s);
        byte by2 = IfxDateTime.getEndCode(s);
        byte by3 = IfxDateTime.getLength(s);
        String string = IfxDateTime.getFieldName(by, true);
        if (n == 14 && by <= 10) {
            int n2 = by3 - by2 + by;
            string = string + "(" + n2 + ")";
        }
        string = string + " to ";
        string = string + IfxDateTime.getFieldName(by2, false);
        return string;
    }

    static String getFieldName(byte by, boolean bl) {
        if (bl && by >= 11) {
            return "fraction";
        }
        switch (by) {
            case 0: {
                return "year";
            }
            case 2: {
                return "month";
            }
            case 4: {
                return "day";
            }
            case 6: {
                return "hour";
            }
            case 8: {
                return "minute";
            }
            case 10: {
                return "second";
            }
            case 11: {
                return "fraction(1)";
            }
            case 12: {
                return "fraction(2)";
            }
            case 13: {
                return "fraction(3)";
            }
            case 14: {
                return "fraction(4)";
            }
            case 15: {
                return "fraction(5)";
            }
        }
        return "";
    }

    public boolean isTimeValue() {
        return this.isTime;
    }

    public void setDateTimeType(int n, byte by, byte by2) {
        if (by == by2) {
            switch (by) {
                case 0: {
                    this.isTimeStampYY = true;
                    this.isTime = false;
                    break;
                }
                case 2: {
                    this.isTimeStampMM = true;
                    this.isTime = false;
                    break;
                }
                case 4: {
                    this.isTimeStampDD = true;
                    this.isTime = false;
                    break;
                }
                case 6: {
                    this.isTimeStampHH = true;
                    this.isTime = true;
                    break;
                }
                case 8: {
                    this.isTimeStampMT = true;
                    this.isTime = true;
                    break;
                }
                case 10: {
                    n = 0;
                    this.isTimeStampSS = true;
                    this.isTime = true;
                    break;
                }
                case 12: {
                    this.isTimeStampFF = true;
                    this.isTime = false;
                }
            }
        } else if (by2 < 11) {
            this.setDateTimeByStEndCode(by, by2);
        } else if (by2 <= 15) {
            this.setDateTimeByStCode(by);
        }
    }

    public void setDateTimeByStCode(byte by) {
        switch (by) {
            case 0: {
                this.isTime = false;
                break;
            }
            case 2: {
                this.isTimeStampMF = true;
                this.isTime = false;
                break;
            }
            case 4: {
                this.isTimeStampDF = true;
                this.isTime = false;
                break;
            }
            case 6: {
                this.isTimeStampHF = true;
                this.isTime = false;
                break;
            }
            case 8: {
                this.isTimeStampMTF = true;
                this.isTime = false;
                break;
            }
            case 10: {
                this.isTimeStampSF = true;
                this.isTime = false;
                break;
            }
            case 12: {
                this.isTimeStampFF = true;
                this.isTime = false;
            }
        }
    }

    public void setDateTimeByStEndCode(byte by, byte by2) {
        if (by == 0) {
            switch (by2) {
                case 2: {
                    this.isTimeStampYM = true;
                    this.isTime = false;
                    break;
                }
                case 4: {
                    this.isTimeStampYD = true;
                    this.isTime = false;
                    break;
                }
                case 6: {
                    this.isTimeStampYH = true;
                    this.isTime = false;
                    break;
                }
                case 8: {
                    this.isTimeStampYMT = true;
                    this.isTime = false;
                    break;
                }
                case 10: {
                    this.isTimeStampYS = true;
                    this.isTime = false;
                }
            }
        } else if (by == 2) {
            switch (by2) {
                case 4: {
                    this.isTimeStampMD = true;
                    this.isTime = false;
                    break;
                }
                case 6: {
                    this.isTimeStampMH = true;
                    this.isTime = false;
                    break;
                }
                case 8: {
                    this.isTimeStampMMT = true;
                    this.isTime = false;
                    break;
                }
                case 10: {
                    this.isTimeStampMS = true;
                    this.isTime = false;
                }
            }
        } else if (by == 4) {
            switch (by2) {
                case 6: {
                    this.isTimeStampDH = true;
                    this.isTime = false;
                    break;
                }
                case 8: {
                    this.isTimeStampDMT = true;
                    this.isTime = false;
                    break;
                }
                case 10: {
                    this.isTimeStampDS = true;
                    this.isTime = false;
                }
            }
        } else if (by == 6) {
            switch (by2) {
                case 8: {
                    this.nanos = 0;
                    this.isTimeStampHM = true;
                    this.isTime = true;
                    break;
                }
                case 10: {
                    this.nanos = 0;
                    this.isTime = true;
                }
            }
        } else if (by == 8) {
            switch (by2) {
                case 10: {
                    this.nanos = 0;
                    this.isTimeStampMTS = true;
                    this.isTime = true;
                }
            }
        }
    }
}

