/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.asf.IfxDataOutputStream;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.util.IfxErrMsg;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

class IfxDistinctOutput
implements SQLOutput {
    ByteArrayOutputStream bStream = new ByteArrayOutputStream();
    IfxDataOutputStream os = new IfxDataOutputStream(this.bStream);
    IfxObject sourceObj = null;
    IfxConnection conn = null;

    IfxDistinctOutput(IfxObject ifxObject, IfxConnection ifxConnection) {
        this.sourceObj = ifxObject;
        this.conn = ifxConnection;
    }

    void reset() {
        this.bStream.reset();
    }

    int length() {
        return this.bStream.size();
    }

    byte[] toByteArray() {
        return this.bStream.toByteArray();
    }

    @Override
    public void writeString(String string) throws SQLException {
        this.sourceObj.fromString(string);
    }

    @Override
    public void writeBoolean(boolean bl) throws SQLException {
        this.sourceObj.fromBoolean(bl);
    }

    @Override
    public void writeByte(byte by) throws SQLException {
        this.sourceObj.fromByte(by);
    }

    @Override
    public void writeShort(short s) throws SQLException {
        this.sourceObj.fromShort(s);
    }

    @Override
    public void writeInt(int n) throws SQLException {
        this.sourceObj.fromInt(n);
    }

    @Override
    public void writeLong(long l) throws SQLException {
        this.sourceObj.fromLong(l);
    }

    @Override
    public void writeFloat(float f) throws SQLException {
        this.sourceObj.fromFloat(f);
    }

    @Override
    public void writeDouble(double d) throws SQLException {
        this.sourceObj.fromDouble(d);
    }

    @Override
    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this.sourceObj.fromDecimal(bigDecimal);
    }

    @Override
    public void writeBytes(byte[] byArray) throws SQLException {
        this.sourceObj.fromBytes(byArray);
    }

    @Override
    public void writeDate(Date date) throws SQLException {
        this.sourceObj.fromDate(date);
    }

    @Override
    public void writeTime(Time time) throws SQLException {
        this.sourceObj.fromTime(time);
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        this.sourceObj.fromTimestamp(timestamp);
    }

    @Override
    public void writeCharacterStream(Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeCharacterStream(Reader).", this.conn);
    }

    @Override
    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        try {
            this.sourceObj.fromAsciiStream(inputStream, inputStream.available());
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        try {
            this.sourceObj.fromBinaryStream(inputStream, inputStream.available());
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public void writeObject(SQLData sQLData) throws SQLException {
        this.sourceObj.fromObject(sQLData);
    }

    @Override
    public void writeRef(Ref ref) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeRef(Ref).", this.conn);
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        this.sourceObj.fromBlob(blob);
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        this.sourceObj.fromClob(clob);
    }

    @Override
    public void writeStruct(Struct struct) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeStruct(Struct).", this.conn);
    }

    @Override
    public void writeArray(Array array) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeArray(Array).", this.conn);
    }

    @Override
    public void writeURL(URL uRL) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxDistinctOutput.writeURL(URL)", this.conn);
    }

    @Override
    public void writeNClob(NClob nClob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxDistinctOutput.writeNClob(NClob)", this.conn);
    }

    @Override
    public void writeNString(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxDistinctOutput.writeNString(String)", this.conn);
    }

    @Override
    public void writeRowId(RowId rowId) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxDistinctOutput.writeRowId(RowId)", this.conn);
    }

    @Override
    public void writeSQLXML(SQLXML sQLXML) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxDistinctOutput.writeSQLXML(SQLXML)", this.conn);
    }
}

