/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.lang.IfxToJavaType;
import com.gbasedbt.lang.JavaToIfxType;
import com.gbasedbt.util.TraceFlag;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxInteger
extends IfxObject {
    private int value;
    public static final int IFX_INT_NULL = Integer.MIN_VALUE;

    IfxInteger() throws SQLException {
        this.setIfxType(2);
    }

    public IfxInteger(int n) throws SQLException {
        this.value = n;
        this.setIfxType(2);
        this.unnullify();
    }

    IfxInteger(Integer n) throws SQLException {
        this.value = n;
        this.setIfxType(2);
        this.unnullify();
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxInt(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] byArray = new byte[]{-128, 0, 0, 0};
            return byArray;
        }
        return JavaToIfxType.JavaToIfxInt(this.value);
    }

    @Override
    public void fromIfx(byte[] byArray) {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) {
        this.value = IfxToJavaType.IfxToJavaInt(byArray, n);
        if (this.isIfxNull()) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value;
    }

    @Override
    public void fromByte(byte by) throws SQLException {
        this.value = by;
        this.unnullify();
    }

    @Override
    public void fromByte(Byte by) throws SQLException {
        if (by == null) {
            this.nullify();
        } else {
            this.value = by.intValue();
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (short)this.value;
    }

    @Override
    public void fromShort(short s) throws SQLException {
        this.value = s;
        this.unnullify();
    }

    @Override
    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
        } else {
            this.value = s.intValue();
            this.unnullify();
        }
    }

    @Override
    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value;
    }

    @Override
    public void fromInt(int n) throws SQLException {
        this.value = n;
        this.unnullify();
    }

    @Override
    public void fromInt(Integer n) throws SQLException {
        if (n == null) {
            this.nullify();
        } else {
            this.value = n;
            this.unnullify();
        }
    }

    @Override
    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value;
    }

    @Override
    public void fromLong(long l) throws SQLException {
        this.clearWarning();
        this.value = (int)l;
        this.unnullify();
    }

    @Override
    public void fromLong(Long l) throws SQLException {
        this.clearWarning();
        if (l == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.value = l.intValue();
        }
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        this.clearWarning();
        this.value = (int)f;
        this.unnullify();
    }

    @Override
    public void fromFloat(Float f) throws SQLException {
        this.clearWarning();
        if (f == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.value = f.intValue();
        }
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        this.clearWarning();
        this.value = (int)d;
        this.unnullify();
    }

    @Override
    public void fromDouble(Double d) throws SQLException {
        this.clearWarning();
        if (d == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.value = d.intValue();
        }
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal((double)this.value);
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal.intValue();
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value != 0;
    }

    @Override
    public void fromBoolean(boolean bl) throws SQLException {
        this.value = bl ? 1 : 0;
        this.unnullify();
    }

    @Override
    public void fromBoolean(Boolean bl) throws SQLException {
        if (bl == null) {
            this.nullify();
        } else {
            this.value = bl == true ? 1 : 0;
            this.unnullify();
        }
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return Integer.toString(this.value);
    }

    @Override
    public void fromString(String string) throws SQLException {
        if (string == null || string == "") {
            this.nullify();
        } else {
            this.value = Integer.valueOf(string.trim());
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        return object instanceof IfxInteger && this.value == ((IfxInteger)object).value;
    }

    @Override
    public short getEncodedLength() {
        short s = 2560;
        if (TraceFlag.compiletrace) {
            this.writeTrace(3, "IfxInteger ecodedLength = " + s);
        }
        return s;
    }

    public boolean isIfxNull() {
        return this.value == Integer.MIN_VALUE;
    }
}

