/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxDecimal;
import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.lang.Decimal;
import com.gbasedbt.lang.IfxToJavaType;
import com.gbasedbt.lang.Interval;
import com.gbasedbt.lang.IntervalDF;
import com.gbasedbt.lang.JavaToIfxType;
import com.gbasedbt.util.TraceFlag;
import java.sql.SQLException;

public class IfxIntervalDF
extends IfxObject {
    private IntervalDF value = null;

    public IfxIntervalDF() throws SQLException {
        this.setIfxType(14);
    }

    IfxIntervalDF(IntervalDF intervalDF) throws SQLException {
        this.setIfxType(14);
        this.value = intervalDF;
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.setEncodedLength(this.value.getQualifier());
        }
    }

    public IntervalDF value() {
        return this.value;
    }

    @Override
    public byte[] toIfx() {
        byte[] byArray = JavaToIfxType.JavaToIfxInterval(this.value);
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxIntervalDF.toIfx(): entered");
            this.trace.writeTrace(2, "   toIfx() data:");
            this.trace.writeTrace(2, byArray, 0, 'H', byArray.length);
        }
        return byArray;
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            return JavaToIfxType.JavaToIfxDecimalNull((short)this.encodedLength);
        }
        byte[] byArray = JavaToIfxType.JavaToIfxInterval(this.value);
        return Decimal.fromBindToTuple(byArray, IfxDecimal.decLength(this.encodedLength));
    }

    @Override
    public void fromIfx(byte[] byArray, short s) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length, s);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2, short s) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxIntervalDF.fromIfx(): entered");
            this.trace.writeTrace(2, "   fromIfx() data:");
            this.trace.writeTrace(2, byArray, n, 'H', n2);
        }
        this.value = (IntervalDF)IfxToJavaType.IfxToJavaInterval(byArray, n, n2, s);
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.value.setQualifier((short)this.encodedLength);
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxIntervalDF.fromIfx(): exited");
        }
    }

    @Override
    public String toString() {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxIntervalDF.toString(): entered");
        }
        if (this.isNull() || this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    @Override
    public void fromString(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxIntervalDF.fromString(): entered");
        }
        if (string == null) {
            this.nullify();
            this.value = null;
            return;
        }
        if (this.value == null) {
            this.value = new IntervalDF();
            this.value.setQualifier(super.getEncodedLength());
        }
        this.value.fromString(string);
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxIntervalDF.fromString(): exited");
        }
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public Interval toInterval() throws SQLException {
        return this.toIntervalDF();
    }

    @Override
    public IntervalDF toIntervalDF() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public void fromIntervalDF(IntervalDF intervalDF) throws SQLException {
        if (intervalDF == null) {
            this.nullify();
        } else {
            this.value = intervalDF;
            this.unnullify();
        }
    }

    @Override
    public short getEncodedLength() {
        if (this.value == null) {
            return (short)this.encodedLength;
        }
        return this.value.getQualifier();
    }

    @Override
    public String toUnloadString() {
        return this.toString();
    }
}

