/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import com.gbasedbt.util.dateUtil;
import com.gbasedbt.util.stringUtil;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxNativeSQL {
    static final char LBRACE = '{';
    static final char RBRACE = '}';
    static final String SLBRACE = "{";
    static final String SRBRACE = "}";
    static final String SLPAREN = "(";
    static final String SRPAREN = ")";
    static final char LPAREN = '(';
    static final char RPAREN = ')';
    static final String SBPAREN = "()";
    static final char DQUOTE = '\"';
    static final String SDQUOTE = "\"";
    static final String SQUOTE = "'";
    static final char QUOTE = '\'';
    static final char LBRACK = '[';
    static final char RBRACK = ']';
    static final String SLBRACK = "[";
    static final String SRBRACK = "]";
    static final char COMMA = ',';
    static final String SCOMMA = ",";
    static final char SEMICOLON = ';';
    static final String SSEMICOLON = ";";
    static final char SPACE = ' ';
    static final String SSPACE = " ";
    static final char TAB = '\t';
    static final String STAB = "\t";
    private String oldString = null;
    private String newString = null;
    private IfxConnection conn = null;
    private Trace trace = null;
    private static Hashtable funcTable = null;

    IfxNativeSQL(String string, IfxConnection ifxConnection) throws SQLException {
        if (string == null) {
            this.oldString = null;
            this.newString = null;
            throw IfxErrMsg.getSQLException(-79708, ifxConnection);
        }
        this.oldString = string;
        this.conn = ifxConnection;
        if (TraceFlag.compiletrace && this.conn != null) {
            this.trace = this.conn.getTrace();
        }
        this.newString = this.parseSQLString(string);
    }

    String getNewString() {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxNativeSQL: getNewString() called");
        }
        return this.newString;
    }

    String parseSQLString(String string) throws SQLException {
        String string2 = "";
        boolean bl = this.conn.isANSIJoin();
        String string3 = "";
        int n = 0;
        boolean bl2 = true;
        int n2 = -1;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxNativeSQL:parseSQLString(): entered");
        }
        if (string.indexOf(123) == -1 || string.indexOf(125) == -1) {
            return string;
        }
        String string4 = "{} \t";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string4, true);
        String string5 = "";
        String string6 = "";
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string7;
            String string8;
            String string9;
            Object object2;
            Object object3;
            char c;
            int n3;
            if (string6.trim().length() > 0) {
                string5 = string6.toLowerCase();
            }
            string6 = stringTokenizer.nextToken();
            String string10 = "";
            n2 = IfxNativeSQL.trackQuotes(string6, n2);
            if (!string6.equals(SLBRACE)) {
                if (!bl && string6.equalsIgnoreCase("WHERE")) {
                    if (string2.length() > 0) {
                        string3 = string3 + "and";
                        continue;
                    }
                    string3 = string3 + string6;
                    continue;
                }
                string3 = string3 + string6;
                continue;
            }
            if (IfxNativeSQL.isWithinQuotes(n2)) {
                string3 = string3 + string6;
                continue;
            }
            if (this.using9xSyntax(string5)) {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(2, "IfxNativeSQL():'{' was a 9.x bracket");
                }
                string3 = string3 + string6;
                continue;
            }
            int n4 = 0;
            for (n3 = 0; n3 < string.length(); ++n3) {
                c = string.charAt(n3);
                if (c != SRBRACE.charAt(0)) continue;
                ++n4;
            }
            n3 = 0;
            c = '\u0000';
            while (stringTokenizer.hasMoreTokens() && (!string6.equals(SRBRACE) || n3 < n4 && c != '\u0000')) {
                string5 = string6;
                string6 = stringTokenizer.nextToken();
                if (string6.equalsIgnoreCase("call")) {
                    c = '\u0001';
                }
                if (string6.equals(SRBRACE)) {
                    ++n3;
                }
                if (string6.equals(SRBRACE) && (n3 >= n4 || c == '\u0000')) continue;
                string10 = string10 + string6;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string10);
            String string11 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : "";
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxNativeSQL(): keyword = '" + string11 + SQUOTE);
            }
            if (string11.equalsIgnoreCase("call")) {
                n = 1;
            } else {
                object3 = new StringTokenizer(string10);
                if (((StringTokenizer)object3).countTokens() < 4) {
                    n = 0;
                } else {
                    ((StringTokenizer)object3).nextToken();
                    n = !((StringTokenizer)object3).nextToken().equals("=") ? 0 : (!((StringTokenizer)object3).nextToken().equalsIgnoreCase("call") ? 0 : 2);
                }
            }
            if (n > 0) {
                String string12;
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "IfxNativeSQL(): isAStoredProcCall =" + n);
                }
                if (!stringTokenizer2.hasMoreTokens()) {
                    throw IfxErrMsg.getSQLException(-79710, SLBRACE + string10 + SRBRACE, this.conn);
                }
                object2 = "execute procedure ";
                if (this.conn.isUSVER() && n > 1) {
                    object2 = "execute function ";
                }
                if (n > 1) {
                    stringTokenizer2.nextToken();
                    stringTokenizer2.nextToken();
                }
                if ((string12 = stringTokenizer2.nextToken()).indexOf(40) > 0) {
                    string12 = string12.substring(0, string12.indexOf(40));
                }
                int n5 = string10.indexOf(40);
                int n6 = string10.lastIndexOf(41) + 1;
                object3 = n5 != -1 && n6 != -1 ? string12 + string10.substring(string10.indexOf(40), string10.lastIndexOf(41) + 1) : string12;
                string3 = string3 + (String)object2 + (String)object3;
                if (((String)object3).indexOf(40) == -1) {
                    string3 = string3 + SBPAREN;
                }
                if (!TraceFlag.compiletrace) continue;
                this.trace.writeTrace(3, "IfxNativeSQL(): resStr ='" + string3 + SQUOTE);
                continue;
            }
            if (string11.equals("d") && stringTokenizer2.hasMoreTokens()) {
                object3 = stringTokenizer2.nextToken(SRBRACE).trim();
                object2 = null;
                string9 = ((String)object3).substring(0, 1);
                string8 = ((String)object3).substring(((String)object3).length() - 1, ((String)object3).length());
                String string13 = ((String)object3).substring(1, ((String)object3).length() - 1);
                if (!string9.equals(SQUOTE) || !string8.equals(SQUOTE)) {
                    throw IfxErrMsg.getSQLMinorException(-79710, SDQUOTE + string + SDQUOTE, -80004, "''' ", this.conn);
                }
                object2 = dateUtil.convertNativeSQLDate(string13, this.conn);
                string3 = string3 + SQUOTE + (String)object2 + SQUOTE;
                if (!TraceFlag.compiletrace) continue;
                this.trace.writeTrace(3, "IfxNativeSQL(): resStr = '" + string3 + SQUOTE);
                continue;
            }
            if (string11.equals("t") && stringTokenizer2.hasMoreTokens()) {
                object3 = stringTokenizer2.nextToken(SRBRACE).trim();
                object2 = null;
                boolean bl3 = true;
                string9 = ((String)object3).substring(0, 1);
                string8 = ((String)object3).substring(((String)object3).length() - 1, ((String)object3).length());
                String string14 = ((String)object3).substring(1, ((String)object3).length() - 1);
                if (!string9.equals(SQUOTE) || !string8.equals(SQUOTE)) {
                    throw IfxErrMsg.getSQLMinorException(-79710, SDQUOTE + string + SDQUOTE, -80004, "''' ", this.conn);
                }
                object2 = dateUtil.convertNativeSQLDateTime(string14, this.conn, bl3);
                string3 = string3 + SQUOTE + (String)object2 + SQUOTE;
                if (!TraceFlag.compiletrace) continue;
                this.trace.writeTrace(3, "IfxNativeSQL(): resStr = '" + string3 + SQUOTE);
                continue;
            }
            if (string11.equals("ts") && stringTokenizer2.hasMoreTokens()) {
                object3 = stringTokenizer2.nextToken(SRBRACE).trim();
                object2 = null;
                boolean bl4 = false;
                string9 = ((String)object3).substring(0, 1);
                string8 = ((String)object3).substring(((String)object3).length() - 1, ((String)object3).length());
                String string15 = ((String)object3).substring(1, ((String)object3).length() - 1);
                if (!string9.equals(SQUOTE) || !string8.equals(SQUOTE)) {
                    throw IfxErrMsg.getSQLMinorException(-79710, SDQUOTE + string + SDQUOTE, -80004, "''' ", this.conn);
                }
                object2 = dateUtil.convertNativeSQLDateTime(string15, this.conn, bl4);
                string3 = string3 + SQUOTE + (String)object2 + SQUOTE;
                if (!TraceFlag.compiletrace) continue;
                this.trace.writeTrace(3, "IfxNativeSQL(): resStr = '" + string3 + SQUOTE);
                continue;
            }
            if (string11.equals("fn") && stringTokenizer2.hasMoreTokens()) {
                object3 = stringTokenizer2.nextToken(SRBRACE);
                StringTokenizer stringTokenizer3 = new StringTokenizer((String)object3, SBPAREN);
                if (!stringTokenizer3.hasMoreTokens()) {
                    throw IfxErrMsg.getSQLException(-79710, SDQUOTE + stringTokenizer2 + SDQUOTE, this.conn);
                }
                object2 = stringTokenizer3.nextToken().trim();
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "IfxNativeSQL(): func = '" + (String)object2 + SQUOTE);
                }
                String string16 = stringTokenizer3.hasMoreTokens() ? stringTokenizer3.nextToken(SBPAREN) : "";
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "IfxNativeSQL(): args = '" + string16 + SQUOTE);
                }
                String string17 = (String)funcTable.get(((String)object2).toLowerCase());
                string7 = (String)funcTable.get(((String)object2).toUpperCase());
                if (string17 != null) {
                    string3 = string3 + string17 + SLPAREN + string16 + SRPAREN;
                    continue;
                }
                if (string7 != null) {
                    string3 = string3 + string7;
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("cot")) {
                    string3 = string3 + SLPAREN + "cos" + SLPAREN + string16 + SRPAREN + "/sin" + SLPAREN + string16 + SRPAREN + SRPAREN;
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("degrees")) {
                    string3 = string3 + SLPAREN + string16 + " * 180 / " + Math.PI + SRPAREN;
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("pi")) {
                    string3 = string3 + Math.PI;
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("radians")) {
                    string3 = string3 + SLPAREN + string16 + " * " + Math.PI + " / 180" + SRPAREN + SSPACE;
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("rand")) {
                    object = new Random(stringUtil.stringToInt(string16));
                    string3 = string3 + ((Random)object).nextFloat();
                    if (!TraceFlag.compiletrace) continue;
                    this.trace.writeTrace(3, "IfxNativeSQL: resStr == '" + string3 + SQUOTE);
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("concat")) {
                    object = new StringTokenizer(string16, SCOMMA);
                    String string18 = "";
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        string18 = string18 + ((StringTokenizer)object).nextToken();
                        if (!((StringTokenizer)object).hasMoreTokens()) continue;
                        string18 = string18 + " || ";
                    }
                    string3 = string3 + string18;
                    if (!TraceFlag.compiletrace) continue;
                    this.trace.writeTrace(3, "IfxNativeSQL: resStr == '" + string3 + SQUOTE);
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("left")) {
                    object = new StringTokenizer(string16, SCOMMA);
                    if (((StringTokenizer)object).countTokens() == 2) {
                        String string19 = ((StringTokenizer)object).nextToken().trim();
                        String string20 = ((StringTokenizer)object).nextToken().trim();
                        int n7 = stringUtil.stringToInt(string20) + 1;
                        string3 = string3 + ' ' + string19 + '[' + "1, " + n7 + ']';
                    }
                    if (!TraceFlag.compiletrace) continue;
                    this.trace.writeTrace(3, "IfxNativeSQL: resStr == '" + string3 + SQUOTE);
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("ltrim")) {
                    string3 = string3 + "trim " + SLPAREN + "LEADING FROM " + string16 + SRPAREN;
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("rtrim")) {
                    string3 = string3 + "trim " + SLPAREN + "TRAILING FROM " + string16 + SRPAREN;
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("dayofweek")) {
                    string3 = string3 + SLPAREN + "weekday" + SLPAREN + string16 + SRPAREN + "+1" + SRPAREN;
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("hour")) {
                    string3 = string3 + "extend" + SLPAREN + string16 + ", hour to hour" + SRPAREN;
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("minute")) {
                    string3 = string3 + "extend" + SLPAREN + string16 + ", minute to minute" + SRPAREN;
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("second")) {
                    string3 = string3 + "extend" + SLPAREN + string16 + ", second to second" + SRPAREN;
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("database")) {
                    object = this.conn.getDbName();
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, "IfxNativeSQL: db == '" + (String)object + SQUOTE);
                    }
                    if (object == null) continue;
                    string3 = string3 + (String)object;
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("ifnull")) {
                    object = new StringTokenizer(string16, SCOMMA);
                    if (((StringTokenizer)object).countTokens() != 2) {
                        throw IfxErrMsg.getSQLException(-79713, SDQUOTE + (String)object3 + SDQUOTE, this.conn);
                    }
                    String string21 = ((StringTokenizer)object).nextToken().trim();
                    String string22 = ((StringTokenizer)object).nextToken().trim();
                    string3 = string3 + "ifnull('" + string21 + "', " + string22 + SRPAREN;
                    if (!TraceFlag.compiletrace) continue;
                    this.trace.writeTrace(3, "IfxNativeSQL: resStr == '" + string3 + SQUOTE);
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("convert")) {
                    object = new StringTokenizer(string16, SCOMMA);
                    if (((StringTokenizer)object).countTokens() != 2) {
                        throw IfxErrMsg.getSQLException(-79713, SDQUOTE + (String)object3 + SDQUOTE, this.conn);
                    }
                    String string23 = ((StringTokenizer)object).nextToken().trim();
                    String string24 = ((StringTokenizer)object).nextToken().trim();
                    if (string24.equalsIgnoreCase("BINARY") || string24.equalsIgnoreCase("BIT") || string24.equalsIgnoreCase("LONGVARBINARY") || string24.equalsIgnoreCase("VARBINARY")) {
                        throw IfxErrMsg.getSQLException(-79714, ": " + string24, this.conn);
                    }
                    string3 = string3 + string23;
                    if (!TraceFlag.compiletrace) continue;
                    this.trace.writeTrace(3, "IfxNativeSQL: resStr == '" + string3 + SQUOTE);
                    continue;
                }
                string3 = string3 + (String)object2 + SLPAREN + string16 + SRPAREN;
                continue;
            }
            if (string11.equals("escape") && stringTokenizer2.hasMoreTokens()) {
                object2 = stringTokenizer2.nextToken(SRBRACE);
                object3 = new StringTokenizer((String)object2, SSPACE);
                if (((StringTokenizer)object3).hasMoreTokens()) {
                    string3 = string3 + "escape " + ((StringTokenizer)object3).nextToken();
                }
                if (!TraceFlag.compiletrace) continue;
                this.trace.writeTrace(3, "IfxNativeSQL: resStr == '" + string3 + SQUOTE);
                continue;
            }
            if (string11.equals("oj") && stringTokenizer2.hasMoreTokens()) {
                object3 = stringTokenizer2.nextToken(SRBRACE);
                object2 = new StringTokenizer((String)object3, SSPACE, true);
                Vector<String> vector = new Vector<String>();
                String string25 = "";
                string7 = "";
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    string25 = ((StringTokenizer)object2).nextToken();
                    string7 = "";
                    if (string25.equalsIgnoreCase("ON") || string25.equalsIgnoreCase("LEFT") || string25.equalsIgnoreCase("RIGHT") || string25.equalsIgnoreCase("FULL")) {
                        throw IfxErrMsg.getSQLMinorException(-79715, -80005, SDQUOTE + (String)object3 + SDQUOTE, this.conn);
                    }
                    while (!(!((StringTokenizer)object2).hasMoreTokens() || string25.equalsIgnoreCase("LEFT") || string25.equalsIgnoreCase("RIGHT") || string25.equalsIgnoreCase("FULL") || string25.equalsIgnoreCase("OUTER") || string25.equalsIgnoreCase("JOIN") || string25.equalsIgnoreCase("ON"))) {
                        string7 = string7 + string25;
                        string25 = ((StringTokenizer)object2).nextToken();
                    }
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, "IfxNativeSQL: tab == '" + string7 + SQUOTE);
                    }
                    if (bl) {
                        string3 = string3 + string7.trim();
                    } else {
                        vector.add(string7.trim());
                    }
                    if (!((StringTokenizer)object2).hasMoreTokens()) {
                        throw IfxErrMsg.getSQLMinorException(-79715, -80005, SDQUOTE + (String)object3 + SDQUOTE, this.conn);
                    }
                    String string26 = string25;
                    if (string26.equalsIgnoreCase("ON")) {
                        object = "";
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            string26 = ((StringTokenizer)object2).nextToken();
                            if (bl) {
                                object = (String)object + string26;
                                continue;
                            }
                            if (string26.equalsIgnoreCase("ON")) {
                                object = (String)object + " and ";
                                continue;
                            }
                            object = (String)object + string26;
                        }
                        if (TraceFlag.compiletrace) {
                            this.trace.writeTrace(3, "IfxNativeSQL: searchCond == '" + (String)object + SQUOTE);
                        }
                        string2 = bl ? " on" + (String)object : " where " + (String)object;
                    } else if (string26.equalsIgnoreCase("LEFT") || string26.equalsIgnoreCase("RIGHT") || string26.equalsIgnoreCase("FULL")) {
                        if (((StringTokenizer)object2).countTokens() < 3) {
                            throw IfxErrMsg.getSQLMinorException(-79715, -80005, SDQUOTE + (String)object3 + SDQUOTE, this.conn);
                        }
                        if (!(((StringTokenizer)object2).nextToken().equals(SSPACE) && ((StringTokenizer)object2).nextToken().equalsIgnoreCase("OUTER") && ((StringTokenizer)object2).nextToken().equals(SSPACE) && ((StringTokenizer)object2).nextToken().equalsIgnoreCase("JOIN"))) {
                            throw IfxErrMsg.getSQLMinorException(-79715, -80005, SDQUOTE + (String)object3 + SDQUOTE, this.conn);
                        }
                        if (bl) {
                            string3 = string3 + SSPACE + string26 + " outer join ";
                        }
                    } else {
                        throw IfxErrMsg.getSQLMinorException(-79715, -80005, SDQUOTE + (String)object3 + SDQUOTE, this.conn);
                    }
                    if (!TraceFlag.compiletrace) continue;
                    this.trace.writeTrace(3, "IfxNativeSQL: resStr == '" + string3 + SQUOTE);
                }
                if (!bl) {
                    object = "";
                    int n8 = 0;
                    int n9 = vector.size();
                    for (n8 = 0; n8 < n9; ++n8) {
                        object = n8 > 0 ? (String)object + ", outer(" + vector.elementAt(n8) : (String)object + vector.elementAt(n8);
                    }
                    for (n8 = 1; n8 <= n9 - 1; ++n8) {
                        object = (String)object + SRPAREN;
                    }
                    string3 = string3 + (String)object;
                }
                if (string2.length() <= 0) continue;
                string3 = string3 + string2;
                continue;
            }
            bl2 = false;
        }
        if (bl2) {
            return string3;
        }
        return string;
    }

    private boolean using9xSyntax(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        String string2 = string.trim();
        if (string2.length() == 0 || !string2.endsWith("t")) {
            return bl;
        }
        int n = string2.length();
        String[] stringArray = new String[]{"multiset", "list", "set"};
        for (int i = 0; i < stringArray.length && !bl; ++i) {
            int n2 = stringArray[i].length();
            if (n2 > n || !string2.substring(n - n2, n).equals(stringArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    private static int trackQuotes(String string, int n) {
        int n2 = n;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\'': {
                    if (n2 == -1) {
                        n2 = c;
                        continue block4;
                    }
                    if (n2 != c) continue block4;
                    if (i + 1 < string.length() && string.charAt(i + 1) == '\'') {
                        ++i;
                        continue block4;
                    }
                    n2 = -1;
                    continue block4;
                }
                case '\"': {
                    if (n2 == -1) {
                        n2 = c;
                        continue block4;
                    }
                    if (n2 != c) continue block4;
                    if (i + 1 < string.length() && string.charAt(i + 1) == '\"') {
                        ++i;
                        continue block4;
                    }
                    n2 = -1;
                    continue block4;
                }
            }
        }
        return n2;
    }

    private static boolean isWithinQuotes(int n) {
        return n != -1;
    }

    static {
        if (funcTable == null) {
            funcTable = new Hashtable();
            funcTable.put("abs", "abs");
            funcTable.put("acos", "acos");
            funcTable.put("asin", "asin");
            funcTable.put("atan", "atan");
            funcTable.put("atan2", "atan2");
            funcTable.put("ceiling", "round");
            funcTable.put("exp", "exp");
            funcTable.put("floor", "trunc");
            funcTable.put("log", "logn");
            funcTable.put("log10", "log10");
            funcTable.put("mod", "mod");
            funcTable.put("power", "pow");
            funcTable.put("round", "round");
            funcTable.put("sin", "sin");
            funcTable.put("sign", "sign");
            funcTable.put("sqrt", "sqrt");
            funcTable.put("tan", "tan");
            funcTable.put("truncate", "trunc");
            funcTable.put("length", "length");
            funcTable.put("dayofmonth", "day");
            funcTable.put("month", "month");
            funcTable.put("year", "year");
            funcTable.put("CURDATE", "today");
            funcTable.put("CURTIME", "current");
            funcTable.put("NOW", "current");
            funcTable.put("USER", "user");
        }
    }
}

