/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxBaseType;
import com.gbasedbt.jdbc.IfxBblob;
import com.gbasedbt.jdbc.IfxByteArrayInputStream;
import com.gbasedbt.jdbc.IfxCblob;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxInputStream;
import com.gbasedbt.jdbc.IfxLobDescriptor;
import com.gbasedbt.jdbc.IfxLobInputStream;
import com.gbasedbt.jdbc.IfxLocator;
import com.gbasedbt.jdbc.IfxOutputStream;
import com.gbasedbt.jdbc.IfxSmartBlob;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.jdbc.IfxTmpFile;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.TraceFlag;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;

public class IfxSmBlob
extends IfxBaseType {
    private static final short TYPE_IS_BYTE = 0;
    private static final short TYPE_IS_TEXT = 1;
    private static final short TYPE_IS_BLOB = 2;
    private static final short TYPE_IS_CLOB = 3;
    protected static final short BLOB_BUFFER_SIZE = 1024;
    protected static final short LO_READ = 0;
    protected static final short LO_READWITHSEEK = 1;
    protected static final short LO_WRITE = 2;
    protected static final short R_W_BUFSIZE = 32000;
    protected static final short FILE_OPEN = 0;
    protected static final short FILE_CLOSE = 1;
    protected static final short FILE_READ = 2;
    protected static final short FILE_WRITE = 3;
    protected static final int LO_O_EXCL = 1;
    protected static final int LO_O_APPEND = 2;
    protected static final int LO_O_TRUNC = 4;
    protected static final int LO_O_RDWR = 8;
    protected static final int LO_O_RDONLY = 16;
    protected static final int LO_O_WRONLY = 32;
    protected static final int LO_O_BINARY = 64;
    protected static final int LO_O_TEXT = 128;
    protected static final short EIO = 5;
    protected static final short ENOENT = 2;
    protected static final short EBADF = 9;
    protected static final short EACCES = 13;
    protected static final short EEXIST = 17;
    protected static final short ESPIPE = 29;
    protected static final short BLOB_TYPE_BYTES = 1;
    protected static final short BLOB_TYPE_STREAM = 2;
    protected static final short BLOB_TYPE_CHARSTREAM = 3;
    protected boolean LOB_ELEMENT_COLL = false;
    protected IfxLocator locator = null;
    protected int loFd = -1;
    protected long sm_size;
    protected InputStream BlobInputStream;
    protected Reader BlobCharInputStream;
    protected IfxTmpFile tempBlobFile = null;
    protected byte[] blobBuffer;
    protected short blobType;
    protected boolean isBlob_loaded = false;
    protected short IfxSmBlobType = (short)2;
    protected String tableName = null;
    protected String columnName = null;

    public IfxSmBlob() throws SQLException {
    }

    public IfxSmBlob(IfxConnection ifxConnection, IfxLocator ifxLocator) throws SQLException {
        this.conn = ifxConnection;
        this.locator = ifxLocator;
        this.isBlob_loaded = false;
        this.blobType = 0;
        this.unnullify();
    }

    public IfxSmBlob(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
    }

    public IfxSmBlob(byte[] byArray) throws SQLException {
        this.fromBytes(byArray);
    }

    public IfxSmBlob(Blob blob) throws SQLException {
        this.fromBlob(blob);
        this.IfxSmBlobType = (short)2;
    }

    public IfxSmBlob(Clob clob) throws SQLException {
        this.fromClob(clob);
        this.IfxSmBlobType = (short)3;
    }

    public void setTableName(String string) {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmBlob.setTableName(String) called");
        }
        int n = 0;
        String string2 = "";
        String string3 = "";
        this.tableName = string != null && string.indexOf(40) > 0 ? string.substring(0, string.indexOf(40)) : string;
        if (this.tableName != null && (n = this.tableName.indexOf(46)) > 0) {
            string2 = this.tableName.substring(0, n);
            string2 = this.toCaseLikeServer(string2);
            string3 = this.tableName.substring(n, this.tableName.length());
            this.tableName = string2.concat(string3);
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmBlob.setTableName(String) exit");
        }
    }

    public void setColumnName(String string) {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmBlob.setTableName(String) called");
        }
        this.columnName = string;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmBlob.setTableName(String) exit");
        }
    }

    private void getSize() {
        try {
            IfxSmartBlob ifxSmartBlob = new IfxSmartBlob(this.conn);
            this.loFd = ifxSmartBlob.IfxLoOpen(this.locator, 16);
            this.sm_size = ifxSmartBlob.IfxLoSize(this.loFd);
            ifxSmartBlob.IfxLoClose(this.loFd);
            ifxSmartBlob = null;
        }
        catch (Exception exception) {
            this.sm_size = 0L;
        }
    }

    @Override
    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        super.fromIfx(byArray, n, n2);
        if (!this.isNull()) {
            byte[] byArray2 = this.inputStream.toByteArray();
            this.locator = new IfxLocator(byArray2, this.conn);
            this.isBlob_loaded = false;
            this.blobType = 0;
            this.unnullify();
        } else {
            this.locator = null;
            this.nullify();
        }
    }

    protected void fromIfxFP(byte[] byArray) throws SQLException {
        super.fromIfx(byArray);
        if (!this.isNull()) {
            byte[] byArray2 = this.inputStream.toByteArray();
            this.locator = new IfxLocator(byArray2, this.conn);
        } else {
            this.locator = null;
            this.nullify();
        }
    }

    @Override
    public byte[] toIfx() throws SQLException {
        this.outputStream.reset();
        if (!this.isNull()) {
            this.outputStream.writeBytes(this.locator.getRawLocator());
        }
        return super.toIfx();
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        this.outputStream.reset();
        if (!this.isNull()) {
            this.outputStream.writeBytes(this.locator.getRawLocator());
        }
        return super.toIfxTuple();
    }

    @Override
    public InputStream toAsciiStream() throws SQLException {
        if (!this.isBlob_loaded) {
            try {
                IfxLobInputStream ifxLobInputStream = new IfxLobInputStream(this.conn, this.locator);
                return ifxLobInputStream;
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        if (this.tempBlobFile != null) {
            try {
                IfxInputStream ifxInputStream = this.tempBlobFile.getInputStream();
                return ifxInputStream;
            }
            catch (Exception exception) {
                if (TraceFlag.compiletrace) {
                    this.writeTrace(99, "IfxBlob:fromCharacterStream(): " + exception.getMessage());
                }
                SQLException sQLException = IfxErrMsg.getSQLException(-79701, exception.toString(), this.conn);
                sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                throw sQLException;
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.blobBuffer);
        return byteArrayInputStream;
    }

    @Override
    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        this.sm_size = n;
        this.BlobInputStream = inputStream;
        this.isBlob_loaded = false;
        this.blobType = (short)2;
        this.blobBuffer = null;
        this.locator = new IfxLocator(this.conn);
        if (((IfxSqliConnect)this.conn).usePut || this.LOB_ELEMENT_COLL) {
            this.createBlobOnServer(inputStream, n);
        }
    }

    void createBlobOnServer(Reader reader, int n) throws SQLException {
        this.unnullify();
        IfxSmartBlob ifxSmartBlob = null;
        InputStream inputStream = null;
        try {
            ifxSmartBlob = this.createSmartLob();
            if (n > 0) {
                try {
                    Object object;
                    if (((IfxSqliConnect)this.conn).isConvText() && this.useTmpFile(n) || ((IfxSqliConnect)this.conn).getBlobCacheSize() < n) {
                        object = this.createFile();
                        inputStream = this.codesetConvertToDbLocale(reader, (IfxTmpFile)object, n);
                        n = ((IfxTmpFile)object).length();
                        this.sm_size = n;
                    } else {
                        object = this.createByteArrayOutputStream(n);
                        inputStream = this.codesetConvertToDbLocale(reader, (ByteArrayOutputStream)object, n);
                        n = this.getCodesetConvertedLength((ByteArrayOutputStream)object);
                        this.sm_size = n;
                    }
                }
                catch (Exception exception) {
                    SQLException sQLException = IfxErrMsg.getSQLException(-79716, exception.toString(), (String)null);
                    sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                    throw sQLException;
                }
                int n2 = 0;
                if (inputStream != null ? (n2 = ifxSmartBlob.IfxLoWrite(this.loFd, inputStream, n)) != n : (n2 = ifxSmartBlob.IfxLoWrite(this.loFd, this.blobBuffer)) != (this.blobBuffer == null ? 0 : this.blobBuffer.length)) {
                    throw IfxErrMsg.getSQLException(-79754, this.conn);
                }
            }
            if (ifxSmartBlob != null && this.loFd != -1) {
                ifxSmartBlob.IfxLoClose(this.loFd);
            }
        }
        catch (SQLException sQLException) {
            if (ifxSmartBlob != null && this.loFd != -1) {
                ifxSmartBlob.IfxLoClose(this.loFd);
            }
            this.sm_size = 0L;
            this.nullify();
            throw sQLException;
        }
    }

    void createBlobOnServer(InputStream inputStream, int n) throws SQLException {
        this.unnullify();
        IfxSmartBlob ifxSmartBlob = null;
        try {
            ifxSmartBlob = this.createSmartLob();
            if (n > 0) {
                if (this.extendedID == 11 && ((IfxSqliConnect)this.conn).isConvText()) {
                    try {
                        Object object;
                        if (this.useTmpFile(n)) {
                            object = this.createFile();
                            inputStream = this.codesetConvertToDbLocale(inputStream, (IfxTmpFile)object, n);
                            n = ((IfxTmpFile)object).length();
                            this.sm_size = n;
                        } else {
                            object = this.createByteArrayOutputStream(n);
                            inputStream = this.codesetConvertToDbLocale(inputStream, (ByteArrayOutputStream)object, n);
                            n = this.getCodesetConvertedLength((ByteArrayOutputStream)object);
                            this.sm_size = n;
                        }
                    }
                    catch (Exception exception) {
                        SQLException sQLException = IfxErrMsg.getSQLException(-79716, exception.toString(), (String)null);
                        sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                        throw sQLException;
                    }
                }
                int n2 = 0;
                if (inputStream != null ? (n2 = ifxSmartBlob.IfxLoWrite(this.loFd, inputStream, n)) != n : (n2 = ifxSmartBlob.IfxLoWrite(this.loFd, this.blobBuffer)) != (this.blobBuffer == null ? 0 : this.blobBuffer.length)) {
                    throw IfxErrMsg.getSQLException(-79754, this.conn);
                }
            }
            if (ifxSmartBlob != null && this.loFd != -1) {
                ifxSmartBlob.IfxLoClose(this.loFd);
            }
        }
        catch (SQLException sQLException) {
            if (ifxSmartBlob != null && this.loFd != -1) {
                ifxSmartBlob.IfxLoClose(this.loFd);
            }
            this.sm_size = 0L;
            this.nullify();
            throw sQLException;
        }
    }

    private void coreCodesetConvert(Reader reader, OutputStream outputStream, String string) throws Exception {
        int n;
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string));
        char[] cArray = new char[4096];
        while ((n = reader.read(cArray)) != -1) {
            ((Writer)bufferedWriter).write(cArray, 0, n);
        }
        reader.close();
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
        outputStream.close();
    }

    private InputStream codesetConvertToDbLocale(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, int n) throws Exception {
        String string = ((IfxSqliConnect)this.conn).getclEncoding();
        String string2 = ((IfxSqliConnect)this.conn).getdbEncoding();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        this.coreCodesetConvert(bufferedReader, byteArrayOutputStream, string2);
        return new IfxByteArrayInputStream(byteArrayOutputStream);
    }

    private InputStream codesetConvertToDbLocale(InputStream inputStream, IfxTmpFile ifxTmpFile, int n) throws Exception {
        String string = ((IfxSqliConnect)this.conn).getclEncoding();
        String string2 = ((IfxSqliConnect)this.conn).getdbEncoding();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
        IfxOutputStream ifxOutputStream = null;
        ifxOutputStream = ifxTmpFile.getOutputStream();
        this.coreCodesetConvert(bufferedReader, ifxOutputStream, string2);
        return ifxTmpFile.getInputStream();
    }

    private InputStream codesetConvertToDbLocale(Reader reader, ByteArrayOutputStream byteArrayOutputStream, int n) throws Exception {
        if (((IfxSqliConnect)this.conn).getdbEncoding() == null) {
            throw IfxErrMsg.getSQLException(-79784, "ifxDB_LOCALE not set", this.conn);
        }
        String string = ((IfxSqliConnect)this.conn).getdbEncoding();
        this.coreCodesetConvert(reader, byteArrayOutputStream, string);
        return new IfxByteArrayInputStream(byteArrayOutputStream);
    }

    private InputStream codesetConvertToDbLocale(Reader reader, IfxTmpFile ifxTmpFile, int n) throws Exception {
        String string = ((IfxSqliConnect)this.conn).getdbEncoding();
        IfxOutputStream ifxOutputStream = null;
        ifxOutputStream = ifxTmpFile.getOutputStream();
        this.coreCodesetConvert(reader, ifxOutputStream, string);
        return ifxTmpFile.getInputStream();
    }

    private int getCodesetConvertedLength(ByteArrayOutputStream byteArrayOutputStream) throws SQLException {
        return byteArrayOutputStream.size();
    }

    private boolean useTmpFile(int n) {
        return n > ((IfxSqliConnect)this.conn).getCodesetLobSize();
    }

    private ByteArrayOutputStream createByteArrayOutputStream(int n) {
        return new ByteArrayOutputStream(n);
    }

    private IfxTmpFile createFile() throws Exception {
        this.tempBlobFile = new IfxTmpFile(this.conn);
        return this.tempBlobFile;
    }

    private IfxSmartBlob createSmartLob() throws SQLException {
        IfxSmartBlob ifxSmartBlob = null;
        ifxSmartBlob = new IfxSmartBlob(this.conn);
        IfxLobDescriptor ifxLobDescriptor = null;
        ifxLobDescriptor = this.tableName == null || this.columnName == null ? new IfxLobDescriptor(this.conn) : (((IfxSqliConnect)this.conn).isDelimIdentSet() ? ifxSmartBlob.IfxLoColInfo(this.tableName + ".\"" + this.columnName + "\"") : ifxSmartBlob.IfxLoColInfo(this.tableName + "." + this.columnName));
        this.loFd = ifxSmartBlob.IfxLoCreate(ifxLobDescriptor, 8, this.locator);
        return ifxSmartBlob;
    }

    @Override
    public void fromCharacterStream(Reader reader, int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmBlob.fromCharacterStream(Reader, int) called");
        }
        this.sm_size = n;
        this.BlobCharInputStream = reader;
        this.isBlob_loaded = false;
        this.blobType = (short)3;
        this.blobBuffer = null;
        this.BlobInputStream = null;
        this.locator = new IfxLocator(this.conn);
        if (((IfxSqliConnect)this.conn).usePut || this.LOB_ELEMENT_COLL) {
            this.createBlobOnServer(reader, n);
        }
        this.IfxSmBlobType = (short)3;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmBlob.fromCharacterStream(Reader, int) exited");
        }
    }

    @Override
    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
        this.IfxSmBlobType = (short)3;
    }

    @Override
    public InputStream toBinaryStream() throws SQLException {
        return this.toAsciiStream();
    }

    @Override
    public void fromBinaryStream(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
        this.IfxSmBlobType = (short)2;
    }

    @Override
    public String toString() {
        try {
            IfxCblob ifxCblob = new IfxCblob(this.conn, this.locator);
            ifxCblob.setSize(this.sm_size);
            return ifxCblob.getSubString(1L, (int)this.sm_size);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.sm_size = 0L;
            this.blobBuffer = null;
            this.nullify();
            return;
        }
        this.sm_size = string.length();
        try {
            String string2 = this.conn.getdbEncoding();
            this.blobBuffer = string2 != null ? string.getBytes(string2) : string.getBytes();
        }
        catch (IOException iOException) {
            SQLException sQLException = IfxErrMsg.getSQLException(-79783, iOException.toString(), this.conn);
            sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, iOException);
            throw sQLException;
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 1;
        this.unnullify();
        try {
            this.locator = new IfxLocator(this.conn);
        }
        catch (SQLException sQLException) {
            this.sm_size = 0L;
            this.nullify();
            throw sQLException;
        }
    }

    @Override
    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        if (this.extendedID == 10) {
            return this.toBlob();
        }
        return this.toClob();
    }

    @Override
    public void fromObject(Object object) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmBlob.fromObject(Object) called");
        }
        if (object == null) {
            if (TraceFlag.compiletrace) {
                this.writeTrace(2, "    Object is null");
            }
            return;
        }
        if (object instanceof String) {
            if (TraceFlag.compiletrace) {
                this.writeTrace(2, "    Object is instance of String");
            }
            this.fromString((String)object);
        } else if (object instanceof byte[]) {
            if (TraceFlag.compiletrace) {
                this.writeTrace(2, "    Object is instance of Byte[]");
            }
            this.fromBytes((byte[])object);
        } else if (object instanceof Blob) {
            if (TraceFlag.compiletrace) {
                this.writeTrace(2, "    Object is instance of Blob");
            }
            this.fromBlob((Blob)object);
        } else if (object instanceof Clob) {
            if (TraceFlag.compiletrace) {
                this.writeTrace(2, "    Object is instance of Clob");
            }
            this.fromClob((Clob)object);
        } else {
            throw IfxErrMsg.getSQLException(-79791, this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmBlob.fromObject(Object) exited");
        }
    }

    @Override
    public byte[] toBytes() throws SQLException {
        this.getSize();
        IfxBblob ifxBblob = new IfxBblob(this.conn, this.locator);
        ifxBblob.setSize(this.sm_size);
        byte[] byArray = ifxBblob.getPortion(1L, this.sm_size);
        ifxBblob.close();
        return byArray;
    }

    @Override
    public void fromBytes(byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.sm_size = 0L;
            this.blobBuffer = null;
            this.nullify();
            return;
        }
        this.sm_size = byArray.length;
        this.blobBuffer = byArray;
        this.unnullify();
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 1;
        try {
            this.locator = new IfxLocator(this.conn);
        }
        catch (SQLException sQLException) {
            this.sm_size = 0L;
            this.nullify();
            throw sQLException;
        }
    }

    @Override
    public Blob toBlob() throws SQLException {
        this.getSize();
        IfxBblob ifxBblob = null;
        if (this.isBlob_loaded) {
            if (this.tempBlobFile != null) {
                try {
                    ifxBblob = new IfxBblob(this.tempBlobFile);
                }
                catch (Exception exception) {
                    SQLException sQLException = IfxErrMsg.getSQLException(-79701, exception.toString(), this.conn);
                    sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                    throw sQLException;
                }
            } else if (this.blobBuffer != null) {
                ifxBblob = new IfxBblob(this.blobBuffer);
            }
        } else {
            ifxBblob = new IfxBblob(this.conn, this.locator);
        }
        ((IfxSqliConnect)this.conn).addToBlobList(ifxBblob.smb);
        ifxBblob.setIfxLobType((short)2);
        ifxBblob.setSize(this.sm_size);
        return ifxBblob;
    }

    @Override
    public Clob toClob() throws SQLException {
        return this.toClob(this.conn.isReadOnly() ? 4 : 8);
    }

    public Clob toClob(int n) throws SQLException {
        this.getSize();
        IfxCblob ifxCblob = null;
        if (this.isBlob_loaded) {
            if (this.tempBlobFile != null) {
                try {
                    ifxCblob = new IfxCblob(this.tempBlobFile);
                }
                catch (Exception exception) {
                    SQLException sQLException = IfxErrMsg.getSQLException(-79701, exception.toString(), this.conn);
                    sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                    throw sQLException;
                }
            } else if (this.blobBuffer != null) {
                ifxCblob = new IfxCblob(this.blobBuffer);
            }
        } else {
            ifxCblob = new IfxCblob(this.conn, this.locator, n);
        }
        ((IfxSqliConnect)this.conn).addToBlobList(ifxCblob.smb);
        ifxCblob.setIfxLobType((short)3);
        ifxCblob.setSize(this.sm_size);
        return ifxCblob;
    }

    @Override
    public void fromBlob(Blob blob) throws SQLException {
        if (blob instanceof IfxBblob) {
            IfxBblob ifxBblob = (IfxBblob)blob;
            short s = ifxBblob.getIfxLobType();
            if (s == 2) {
                this.locator = ifxBblob.getLocator();
            } else if (s == 0) {
                this.fromBinaryStream(ifxBblob.getBinaryStream(), (int)ifxBblob.length());
            }
        } else {
            this.fromBinaryStream(blob.getBinaryStream(), (int)blob.length());
        }
        this.unnullify();
    }

    @Override
    public void fromClob(Clob clob) throws SQLException {
        if (clob instanceof IfxCblob) {
            IfxCblob ifxCblob = (IfxCblob)clob;
            short s = ifxCblob.getIfxLobType();
            if (s == 3) {
                this.locator = ifxCblob.getLocator();
            } else if (s == 1) {
                this.fromAsciiStream(ifxCblob.getAsciiStream(), (int)ifxCblob.length());
            }
        } else {
            this.fromAsciiStream(clob.getAsciiStream(), (int)clob.length());
        }
        this.unnullify();
    }

    @Override
    public void clear() {
        this.nullify();
        this.isBlob_loaded = false;
        this.IfxSmBlobType = (short)2;
        this.blobBuffer = null;
        this.locator = null;
        if (this.tempBlobFile != null) {
            try {
                this.tempBlobFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tempBlobFile = null;
    }

    protected void finalize() {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String toCaseLikeServer(String string) {
        if (this.conn.isANSI() && !string.toUpperCase().equals("GBASEDBT")) {
            return string.toUpperCase();
        }
        return string.toLowerCase();
    }

    @Override
    public Reader toCharacterStream() throws SQLException {
        Reader reader = null;
        if (!this.extendedName.toLowerCase().equals("clob")) {
            throw IfxErrMsg.getSQLMinorException(-79741, -80039, this.conn);
        }
        Clob clob = this.toClob();
        reader = clob.getCharacterStream();
        return reader;
    }
}

