/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.lang.IfxToJavaType;
import com.gbasedbt.lang.JavaToIfxType;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.TraceFlag;
import com.gbasedbt.util.memoryUtil;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxSmallFloat
extends IfxObject {
    private float value;
    private static final int IFX_SMFLOAT_SIZE = 4;

    IfxSmallFloat() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat() constructor called");
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat() constructor exited");
        }
        this.setIfxType(4);
    }

    IfxSmallFloat(float f) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat(float) constructor called");
        }
        this.setIfxType(4);
        this.value = f;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat(float) constructor exited");
        }
    }

    IfxSmallFloat(Float f) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat(Float) constructor called");
        }
        this.setIfxType(4);
        if (f != null) {
            this.value = f.floatValue();
            this.unnullify();
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat(Float) constructor exited");
        }
    }

    IfxSmallFloat(double d) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat(double) constructor called");
        }
        this.setIfxType(4);
        this.value = (float)d;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat(double) constructor exited");
        }
    }

    IfxSmallFloat(Double d) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat(Double) constructor called");
        }
        this.setIfxType(4);
        if (d != null) {
            this.value = (float)d.doubleValue();
            this.unnullify();
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat(Double) constructor exited");
        }
    }

    @Override
    public byte[] toIfx() {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toIfx() called/exited");
        }
        return JavaToIfxType.JavaToIfxReal(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] byArray = new byte[4];
            memoryUtil.byfill(byArray, (byte)-1);
            return byArray;
        }
        return JavaToIfxType.JavaToIfxReal(this.value);
    }

    @Override
    public void fromIfx(byte[] byArray) {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) {
        boolean bl = true;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromIfx() called");
        }
        if (!(bl = IfxSmallFloat.isIfxNull(byArray, n, n2))) {
            this.unnullify();
            this.value = IfxToJavaType.IfxToJavaReal(byArray, n);
        } else {
            this.nullify();
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromIfx() exited");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        if (object instanceof IfxSmallFloat) {
            IfxSmallFloat ifxSmallFloat = (IfxSmallFloat)object;
            if (ifxSmallFloat.isNull()) {
                return false;
            }
            return this.value == ifxSmallFloat.value;
        }
        return false;
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Float(this.value);
    }

    @Override
    public byte toByte() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toByte() called");
        }
        this.clearWarning();
        byte by = this.isNull() ? (byte)0 : (byte)this.value;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toByte() exited");
        }
        return by;
    }

    @Override
    public void fromByte(Byte by) throws SQLException {
        if (by == null) {
            this.nullify();
        } else {
            this.fromByte((byte)by);
        }
    }

    @Override
    public void fromByte(byte by) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromByte() called");
        }
        this.value = by;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromByte() exited");
        }
    }

    @Override
    public short toShort() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toShort() called");
        }
        this.clearWarning();
        short s = this.isNull() ? (short)0 : (short)this.value;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toShort() exited");
        }
        return s;
    }

    @Override
    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
        } else {
            this.fromShort((short)s);
        }
    }

    @Override
    public void fromShort(short s) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromShort() called");
        }
        this.value = s;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromShort() exited");
        }
    }

    @Override
    public int toInt() throws SQLException {
        int n;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toInt() called");
        }
        this.clearWarning();
        if (this.isNull()) {
            n = 0;
        } else {
            n = (int)this.value;
            if (n <= Integer.MIN_VALUE) {
                n = -2147483647;
            }
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toInt() exited");
        }
        return n;
    }

    @Override
    public void fromInt(Integer n) throws SQLException {
        if (n == null) {
            this.nullify();
        } else {
            this.fromInt((int)n);
        }
    }

    @Override
    public void fromInt(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromInt() called");
        }
        this.value = n;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromInt() exited");
        }
    }

    @Override
    public long toLong() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toLong() called");
        }
        this.clearWarning();
        long l = this.isNull() ? 0L : (long)this.value;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toLong() called");
        }
        return l;
    }

    @Override
    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
        } else {
            this.fromLong((long)l);
        }
    }

    @Override
    public void fromLong(long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromLong() called");
        }
        this.value = l;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromLong() exited");
        }
    }

    @Override
    public double toDouble() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toDouble() called");
        }
        double d = this.isNull() ? 0.0 : (double)this.value;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toDouble() exited");
        }
        return d;
    }

    @Override
    public void fromDouble(Double d) throws SQLException {
        if (d == null) {
            this.nullify();
        } else {
            this.fromDouble((double)d);
        }
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromDouble() called");
        }
        this.value = (float)d;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromDouble() exited");
        }
    }

    @Override
    public float toFloat() {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    @Override
    public void fromFloat(Float f) throws SQLException {
        if (f == null) {
            this.nullify();
        } else {
            this.fromFloat(f.floatValue());
        }
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        this.value = f;
        this.unnullify();
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toDecimal() called/exited");
        }
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(this.value);
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromDecimal() called");
        }
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal.floatValue();
            this.unnullify();
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromDecimal() exited");
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        boolean bl;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toBoolean() called");
        }
        if (this.isNull()) {
            bl = false;
        } else {
            boolean bl2 = bl = this.value != 0.0f;
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toBoolean() exited");
        }
        return bl;
    }

    @Override
    public void fromBoolean(Boolean bl) throws SQLException {
        if (bl == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)bl);
            this.unnullify();
        }
    }

    @Override
    public void fromBoolean(boolean bl) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromBoolean() called");
        }
        this.value = bl ? 1 : 0;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromBoolean() exited");
        }
    }

    @Override
    public String toString() {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toString() called");
        }
        String string = this.isNull() ? null : Float.toString(this.value);
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: toString() exited");
        }
        return string;
    }

    @Override
    public void fromString(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromString() called");
        }
        if (string == null || string.length() == 0) {
            this.nullify();
        } else {
            try {
                this.value = Float.valueOf(string.trim()).floatValue();
                this.unnullify();
            }
            catch (Exception exception) {
                this.nullify();
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxSmallFloat: fromString() called");
        }
    }

    static boolean isIfxNull(float f) {
        byte[] byArray = JavaToIfxType.JavaToIfxReal(f);
        return IfxSmallFloat.isIfxNull(byArray);
    }

    static boolean isIfxNull(byte[] byArray) {
        return IfxSmallFloat.isIfxNull(byArray, 0, byArray.length);
    }

    static boolean isIfxNull(byte[] byArray, int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            if (byArray[i + n] == -1) continue;
            return false;
        }
        return true;
    }

    static float getIfxNull() {
        byte[] byArray = new byte[4];
        float f = 0.0f;
        for (int i = 0; i < 4; ++i) {
            byArray[i] = -1;
            f = IfxToJavaType.IfxToJavaReal(byArray);
        }
        return f;
    }
}

