/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxBblob;
import com.gbasedbt.jdbc.IfxCblob;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxInt8;
import com.gbasedbt.jdbc.IfxInteger;
import com.gbasedbt.jdbc.IfxLoStat;
import com.gbasedbt.jdbc.IfxLobDescriptor;
import com.gbasedbt.jdbc.IfxLocator;
import com.gbasedbt.jdbc.IfxLvarchar;
import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.jdbc.IfxProtocol;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.jdbc.IfxUDT;
import com.gbasedbt.jdbc.IfxUDTInput;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class IfxSmartBlob {
    public static final int LO_APPEND = 1;
    public static final int LO_WRONLY = 2;
    public static final int LO_RDONLY = 4;
    public static final int LO_RDWR = 8;
    public static final int LO_DIRTY_READ = 16;
    public static final int LO_RANDOM = 32;
    public static final int LO_SEQUENTIAL = 64;
    public static final int LO_FORWARD = 128;
    public static final int LO_REVERSE = 256;
    public static final int LO_BUFFER = 512;
    public static final int LO_NOBUFFER = 1024;
    public static final int LO_NODIRTY_READ = 2048;
    public static final int LO_LOCKALL = 4096;
    public static final int LO_LOCKRANGE = 8192;
    public static final int LO_SEEK_SET = 0;
    public static final int LO_SEEK_CUR = 1;
    public static final int LO_SEEK_END = 2;
    public static final int LO_CLIENT_FILE = 0x20000000;
    public static final int LO_SERVER_FILE = 0x10000000;
    public static final int LO_SHARED_MODE = 1;
    public static final int LO_EXCLUSIVE_MODE = 2;
    public static final int LO_MAX_END = -1;
    public static final int LO_CURRENT_END = -2;
    private static final String IFX_LO_COL_INFO = "function gbasedbt.ifx_lo_col_sbinfo(lvarchar,ifx_lo_spec)";
    private static final String IFX_LO_CREATE = "function gbasedbt.ifx_lo_create( ifx_lo_spec,integer,blob)";
    private static final String IFX_LO_RELEASE = "function gbasedbt.ifx_lo_release(blob)";
    private static final String IFX_LO_OPEN = "function gbasedbt.ifx_lo_open(blob ,integer)";
    private static final String IFX_LO_CLOSE = "function gbasedbt.ifx_lo_close(integer)";
    private static final String IFX_LO_SEEK = "function gbasedbt.ifx_lo_seek(integer,int8,integer,int8)";
    private static final String IFX_LO_LOCK = "function gbasedbt.ifx_lo_lock(integer,integer,int8,int8,integer)";
    private static final String IFX_LO_UNLOCK = "function gbasedbt.ifx_lo_unlock( integer,integer,int8,int8)";
    private static final String IFX_LO_TELL = "function gbasedbt.ifx_lo_tell(int, int8)";
    private static final String IFX_LO_TRUNCATE = "function gbasedbt.ifx_lo_truncate(integer,int8)";
    private static final String IFX_LO_COPY_TO_LO = "function gbasedbt.ifx_lo_from_file(int,lvarchar,int,int,int)";
    private static final String IFX_LO_COPY_TO_FILE = "function gbasedbt.ifx_lo_to_file(blob,lvarchar,int, int)";
    private static final String IFX_LO_FILENAME = "function gbasedbt.ifx_lo_filename(blob,lvarchar)";
    private static final String IFX_LO_ALTER = "function gbasedbt.ifx_lo_alter(blob,ifx_lo_spec)";
    private static final String IFX_LO_STAT = "function gbasedbt.ifx_lo_stat(int, ifx_lo_stat)";
    private static final String LO_CREATE_SPEC_NAME = "ifx_lo_spec";
    private static final String LO_COL_NAME = "lvarchar";
    private static final String LO_STAT_NAME = "ifx_lo_stat";
    private static final String LO_NAME = "blob";
    private static final int LO_STAT_SIZE = 644;
    private static final int PRE_LONG_ID_LO_STAT_SIZE = 212;
    protected IfxLocator locator = null;
    private int loFd = -1;
    private IfxConnection conn = null;
    private IfxProtocol prot = null;
    private Trace trace = null;

    public IfxSmartBlob(Connection connection) throws SQLException {
        this.conn = (IfxConnection)connection;
        if (TraceFlag.compiletrace) {
            this.setTrace(this.conn.getTrace());
        }
        try {
            Class<?> clazz = Class.forName(this.conn.getProtoClassName());
            Class<?> clazz2 = Class.forName(this.conn.getConnClassName());
            Class[] classArray = new Class[]{clazz2};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.conn};
            this.prot = (IfxProtocol)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79735, exception.toString(), this.conn);
        }
    }

    public IfxLobDescriptor IfxLoColInfo(String string) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79708, this.conn);
        }
        byte[] byArray = new IfxLobDescriptor(this.conn).getRawLobDescriptor();
        IfxLvarchar ifxLvarchar = new IfxLvarchar(string);
        ifxLvarchar.setConnection(this.conn);
        ifxLvarchar.setExtendedTypeName(LO_COL_NAME);
        IfxUDT ifxUDT = new IfxUDT();
        ifxUDT.setConnection(this.conn);
        ifxUDT.setExtendedTypeName(LO_CREATE_SPEC_NAME);
        ifxUDT.fromBytes(byArray);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector<IfxObject> vector2 = null;
        vector.addElement(ifxLvarchar);
        vector.addElement(ifxUDT);
        vector2 = this.prot.executeFastPath(IFX_LO_COL_INFO, vector, false);
        IfxUDT ifxUDT2 = (IfxUDT)vector2.elementAt(0);
        byte[] byArray2 = ifxUDT2.toBytes();
        IfxInteger ifxInteger = (IfxInteger)vector2.elementAt(1);
        int n = ifxInteger.toInt();
        return new IfxLobDescriptor(this.conn, byArray2);
    }

    public int IfxLoCreate(IfxLobDescriptor ifxLobDescriptor, int n, IfxLocator ifxLocator) throws SQLException {
        byte[] byArray = new byte[72];
        byte[] byArray2 = ifxLobDescriptor.getRawLobDescriptor();
        this.locator = ifxLocator;
        IfxUDT ifxUDT = new IfxUDT();
        ifxUDT.setConnection(this.conn);
        ifxUDT.setExtendedTypeName(LO_CREATE_SPEC_NAME);
        ifxUDT.fromBytes(byArray2);
        IfxInteger ifxInteger = new IfxInteger(n);
        IfxUDT ifxUDT2 = new IfxUDT();
        ifxUDT2.setConnection(this.conn);
        ifxUDT2.setExtendedTypeName(LO_NAME);
        ifxUDT2.fromBytes(byArray);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector<IfxObject> vector2 = null;
        vector.addElement(ifxUDT);
        vector.addElement(ifxInteger);
        vector.addElement(ifxUDT2);
        vector2 = this.prot.executeFastPath(IFX_LO_CREATE, vector, false);
        IfxUDT ifxUDT3 = (IfxUDT)vector2.elementAt(0);
        byte[] byArray3 = ifxUDT3.toBytes();
        IfxInteger ifxInteger2 = (IfxInteger)vector2.elementAt(1);
        this.loFd = ifxInteger2.toInt();
        ifxLocator.setRawLocator(byArray3);
        return this.loFd;
    }

    public int IfxLoCreate(IfxLobDescriptor ifxLobDescriptor, int n, IfxBblob ifxBblob) throws SQLException {
        this.locator = new IfxLocator(this.conn);
        ifxBblob.smb = this;
        ifxBblob.setConnection(this.conn);
        return this.IfxLoCreate(ifxLobDescriptor, n, this.locator);
    }

    public int IfxLoCreate(IfxLobDescriptor ifxLobDescriptor, int n, IfxCblob ifxCblob) throws SQLException {
        this.locator = new IfxLocator(this.conn);
        ifxCblob.smb = this;
        ifxCblob.setConnection(this.conn);
        return this.IfxLoCreate(ifxLobDescriptor, n, this.locator);
    }

    public int IfxLoOpen(IfxLocator ifxLocator, int n) throws SQLException {
        byte[] byArray = ifxLocator.getRawLocator();
        IfxUDT ifxUDT = new IfxUDT();
        ifxUDT.setConnection(this.conn);
        ifxUDT.setExtendedTypeName(LO_NAME);
        ifxUDT.fromBytes(byArray);
        IfxInteger ifxInteger = new IfxInteger(n);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector<IfxObject> vector2 = null;
        vector.addElement(ifxUDT);
        vector.addElement(ifxInteger);
        vector2 = this.prot.executeFastPath(IFX_LO_OPEN, vector, false);
        IfxInteger ifxInteger2 = (IfxInteger)vector2.elementAt(0);
        this.loFd = ifxInteger2.toInt();
        this.locator = ifxLocator;
        return this.loFd;
    }

    public int IfxLoOpen(IfxBblob ifxBblob, int n) throws SQLException {
        IfxLocator ifxLocator = ifxBblob.getLocator();
        return this.IfxLoOpen(ifxLocator, n);
    }

    public int IfxLoOpen(IfxCblob ifxCblob, int n) throws SQLException {
        IfxLocator ifxLocator = ifxCblob.getLocator();
        return this.IfxLoOpen(ifxLocator, n);
    }

    public void IfxLoRelease() throws SQLException {
        if (this.locator == null) {
            return;
        }
        this.IfxLoRelease(this.locator);
    }

    public void IfxLoRelease(IfxLocator ifxLocator) throws SQLException {
        byte[] byArray = ifxLocator.getRawLocator();
        int n = 0;
        IfxUDT ifxUDT = new IfxUDT();
        ifxUDT.setConnection(this.conn);
        ifxUDT.setExtendedTypeName(LO_NAME);
        ifxUDT.fromBytes(byArray);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector<IfxObject> vector2 = null;
        vector.addElement(ifxUDT);
        vector2 = this.prot.executeFastPath(IFX_LO_RELEASE, vector, false);
        IfxInteger ifxInteger = (IfxInteger)vector2.elementAt(0);
        n = ifxInteger.toInt();
        this.loFd = -1;
    }

    public void IfxLoRelease(IfxBblob ifxBblob) throws SQLException {
        IfxLocator ifxLocator = ifxBblob.getLocator();
        this.IfxLoRelease(ifxLocator);
    }

    public void IfxLoRelease(IfxCblob ifxCblob) throws SQLException {
        IfxLocator ifxLocator = ifxCblob.getLocator();
        this.IfxLoRelease(ifxLocator);
    }

    public void IfxLoClose(int n) throws SQLException {
        IfxInteger ifxInteger = new IfxInteger(n);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector<IfxObject> vector2 = null;
        vector.addElement(ifxInteger);
        vector2 = this.prot.executeFastPath(IFX_LO_CLOSE, vector, false);
        this.loFd = -1;
    }

    public long IfxLoSeek(int n, long l, int n2) throws SQLException {
        long l2 = 0L;
        IfxInteger ifxInteger = new IfxInteger(n);
        IfxInt8 ifxInt8 = new IfxInt8(l);
        IfxInteger ifxInteger2 = new IfxInteger(n2);
        IfxInt8 ifxInt82 = new IfxInt8(l2);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector<IfxObject> vector2 = null;
        vector.addElement(ifxInteger);
        vector.addElement(ifxInt8);
        vector.addElement(ifxInteger2);
        vector.addElement(ifxInt82);
        vector2 = this.prot.executeFastPath(IFX_LO_SEEK, vector, false);
        IfxInt8 ifxInt83 = (IfxInt8)vector2.elementAt(0);
        IfxInteger ifxInteger3 = (IfxInteger)vector2.elementAt(1);
        return ifxInt83.toLong();
    }

    public void IfxLoTruncate(int n, long l) throws SQLException {
        IfxInteger ifxInteger = new IfxInteger(n);
        IfxInt8 ifxInt8 = new IfxInt8(l);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector<IfxObject> vector2 = null;
        vector.addElement(ifxInteger);
        vector.addElement(ifxInt8);
        vector2 = this.prot.executeFastPath(IFX_LO_TRUNCATE, vector, false);
    }

    public long IfxLoSize(int n) throws SQLException {
        int n2 = this.conn.isLongID() ? 644 : 212;
        byte[] byArray = new byte[n2];
        IfxInteger ifxInteger = new IfxInteger(n);
        IfxUDT ifxUDT = new IfxUDT();
        ifxUDT.setConnection(this.conn);
        ifxUDT.setExtendedTypeName(LO_STAT_NAME);
        ifxUDT.fromBytes(byArray);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector<IfxObject> vector2 = null;
        vector.addElement(ifxInteger);
        vector.addElement(ifxUDT);
        vector2 = this.prot.executeFastPath(IFX_LO_STAT, vector, false);
        ifxUDT = (IfxUDT)vector2.elementAt(0);
        byArray = ifxUDT.toBytes();
        IfxUDTInput ifxUDTInput = new IfxUDTInput(this.conn, byArray, 0, byArray.length);
        ifxUDTInput.setAutoAlignment(false);
        ifxUDTInput.readInt();
        long l = ifxUDTInput.readLong();
        return l;
    }

    public IfxLoStat IfxLoGetStat(int n) throws SQLException {
        int n2 = this.conn.isLongID() ? 644 : 212;
        byte[] byArray = new byte[n2];
        IfxInteger ifxInteger = new IfxInteger(n);
        IfxUDT ifxUDT = new IfxUDT();
        ifxUDT.setConnection(this.conn);
        ifxUDT.setExtendedTypeName(LO_STAT_NAME);
        ifxUDT.fromBytes(byArray);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector<IfxObject> vector2 = null;
        vector.addElement(ifxInteger);
        vector.addElement(ifxUDT);
        vector2 = this.prot.executeFastPath(IFX_LO_STAT, vector, false);
        IfxUDT ifxUDT2 = (IfxUDT)vector2.elementAt(0);
        byArray = ifxUDT2.toBytes();
        return new IfxLoStat(this.conn, byArray);
    }

    protected int getHandle() {
        return this.loFd;
    }

    public long IfxLoTell(int n) throws SQLException {
        long l = 0L;
        IfxInteger ifxInteger = new IfxInteger(n);
        IfxInt8 ifxInt8 = new IfxInt8(l);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector<IfxObject> vector2 = null;
        vector.addElement(ifxInteger);
        vector.addElement(ifxInt8);
        vector2 = this.prot.executeFastPath(IFX_LO_TELL, vector, false);
        IfxInt8 ifxInt82 = (IfxInt8)vector2.elementAt(0);
        return ifxInt82.toLong();
    }

    public byte[] IfxLoRead(int n, int n2) throws SQLException {
        if (n2 < 1 || n < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        byte[] byArray = new byte[n2];
        this.prot.executeReadSmBlob(n, byArray, n2);
        return byArray;
    }

    public int IfxLoRead(int n, byte[] byArray, int n2) throws SQLException {
        if (byArray == null || byArray.length < n2 || n < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        return this.prot.executeReadSmBlob(n, byArray, n2);
    }

    public int IfxLoRead(int n, FileOutputStream fileOutputStream, int n2) throws SQLException {
        if (n2 < 1 || n < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        return this.prot.executeReadSmBlob(n, fileOutputStream, n2);
    }

    public int IfxLoRead(int n, byte[] byArray, int n2, int n3) throws SQLException {
        if (byArray == null || byArray.length < n2 || n < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        return this.prot.executeReadSmBlob(n, byArray, n2, n3);
    }

    public int IfxLoWrite(int n, byte[] byArray) throws SQLException {
        return this.IfxLoWrite(n, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    public int IfxLoWrite(int n, byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = 0;
        if (byArray == null || n < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        n4 = this.prot.executeWriteSmBlob(n, byArray, n2, n3);
        if (n4 < 0) {
            throw IfxErrMsg.getSQLException(-79754, this.conn);
        }
        return n4;
    }

    public int IfxLoWrite(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = 0;
        if (n2 < 1 || n < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        n3 = this.prot.executeWriteSmBlob(n, inputStream, n2);
        if (n3 < 0) {
            throw IfxErrMsg.getSQLException(-79754, this.conn);
        }
        return n3;
    }

    public int IfxLoLock(int n, long l, int n2, long l2, int n3) throws SQLException {
        long l3 = 0L;
        IfxInteger ifxInteger = new IfxInteger(n);
        IfxInt8 ifxInt8 = new IfxInt8(l);
        IfxInteger ifxInteger2 = new IfxInteger(n2);
        IfxInt8 ifxInt82 = new IfxInt8(l2);
        IfxInteger ifxInteger3 = new IfxInteger(n3);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector<IfxObject> vector2 = null;
        vector.addElement(ifxInteger);
        vector.addElement(ifxInt8);
        vector.addElement(ifxInteger2);
        vector.addElement(ifxInt82);
        vector.addElement(ifxInteger3);
        vector2 = this.prot.executeFastPath(IFX_LO_LOCK, vector, false);
        IfxInteger ifxInteger4 = (IfxInteger)vector2.elementAt(0);
        return ifxInteger4.toInt();
    }

    public int IfxLoUnLock(int n, long l, int n2, long l2) throws SQLException {
        long l3 = 0L;
        IfxInteger ifxInteger = new IfxInteger(n);
        IfxInt8 ifxInt8 = new IfxInt8(l);
        IfxInteger ifxInteger2 = new IfxInteger(n2);
        IfxInt8 ifxInt82 = new IfxInt8(l2);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector<IfxObject> vector2 = null;
        vector.addElement(ifxInteger);
        vector.addElement(ifxInt8);
        vector.addElement(ifxInteger2);
        vector.addElement(ifxInt82);
        vector2 = this.prot.executeFastPath(IFX_LO_UNLOCK, vector, false);
        IfxInteger ifxInteger3 = (IfxInteger)vector2.elementAt(0);
        return ifxInteger3.toInt();
    }

    public int IfxLoAlter(IfxLocator ifxLocator, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        byte[] byArray = ifxLocator.getRawLocator();
        IfxUDT ifxUDT = new IfxUDT();
        ifxUDT.setConnection(this.conn);
        ifxUDT.setExtendedTypeName(LO_NAME);
        ifxUDT.fromBytes(byArray);
        byte[] byArray2 = ifxLobDescriptor.getRawLobDescriptor();
        IfxUDT ifxUDT2 = new IfxUDT();
        ifxUDT2.setConnection(this.conn);
        ifxUDT2.setExtendedTypeName(LO_CREATE_SPEC_NAME);
        ifxUDT2.fromBytes(byArray2);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector<IfxObject> vector2 = null;
        vector.addElement(ifxUDT);
        vector.addElement(ifxUDT2);
        vector2 = this.prot.executeFastPath(IFX_LO_ALTER, vector, false);
        IfxInteger ifxInteger = (IfxInteger)vector2.elementAt(0);
        return ifxInteger.toInt();
    }

    public int IfxLoAlter(IfxBblob ifxBblob, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        IfxLocator ifxLocator = ifxBblob.getLocator();
        return this.IfxLoAlter(ifxLocator, ifxLobDescriptor);
    }

    public int IfxLoAlter(IfxCblob ifxCblob, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        IfxLocator ifxLocator = ifxCblob.getLocator();
        return this.IfxLoAlter(ifxLocator, ifxLobDescriptor);
    }

    public int IfxLoFromFile(int n, String string, int n2, int n3, int n4) throws SQLException {
        IfxInteger ifxInteger = new IfxInteger(n);
        IfxLvarchar ifxLvarchar = new IfxLvarchar(string);
        ifxLvarchar.setConnection(this.conn);
        ifxLvarchar.setExtendedTypeName(LO_COL_NAME);
        IfxInteger ifxInteger2 = new IfxInteger(n2);
        IfxInteger ifxInteger3 = new IfxInteger(n3);
        IfxInteger ifxInteger4 = new IfxInteger(n4);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector<IfxObject> vector2 = null;
        vector.addElement(ifxInteger);
        vector.addElement(ifxLvarchar);
        vector.addElement(ifxInteger2);
        vector.addElement(ifxInteger3);
        vector.addElement(ifxInteger4);
        vector2 = this.prot.executeFastPath(IFX_LO_COPY_TO_LO, vector, false);
        IfxInteger ifxInteger5 = (IfxInteger)vector2.elementAt(0);
        return ifxInteger5.toInt();
    }

    public int IfxLoToFile(IfxLocator ifxLocator, String string, int n) throws SQLException {
        byte[] byArray = ifxLocator.getRawLocator();
        int n2 = 0;
        IfxUDT ifxUDT = new IfxUDT();
        ifxUDT.setConnection(this.conn);
        ifxUDT.setExtendedTypeName(LO_NAME);
        ifxUDT.fromBytes(byArray);
        IfxLvarchar ifxLvarchar = new IfxLvarchar(string);
        ifxLvarchar.setConnection(this.conn);
        ifxLvarchar.setExtendedTypeName(LO_COL_NAME);
        IfxInteger ifxInteger = new IfxInteger(n);
        IfxInteger ifxInteger2 = new IfxInteger(n2);
        Vector<IfxObject> vector = new Vector<IfxObject>();
        Vector<IfxObject> vector2 = null;
        vector.addElement(ifxUDT);
        vector.addElement(ifxLvarchar);
        vector.addElement(ifxInteger);
        vector.addElement(ifxInteger2);
        vector2 = this.prot.executeFastPath(IFX_LO_COPY_TO_FILE, vector, false);
        IfxInteger ifxInteger3 = (IfxInteger)vector2.elementAt(0);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxLoToFile() exited. op1.toInt= " + ifxInteger3.toInt());
        }
        return ifxInteger3.toInt();
    }

    public int IfxLoToFile(IfxBblob ifxBblob, String string, int n) throws SQLException {
        IfxLocator ifxLocator = ifxBblob.getLocator();
        return this.IfxLoToFile(ifxLocator, string, n);
    }

    public int IfxLoToFile(IfxCblob ifxCblob, String string, int n) throws SQLException {
        IfxLocator ifxLocator = ifxCblob.getLocator();
        return this.IfxLoToFile(ifxLocator, string, n);
    }

    void setTrace(Trace trace) {
        if (TraceFlag.compiletrace) {
            this.trace = trace;
        }
    }

    protected synchronized void finalize() {
        if (((IfxSqliConnect)this.conn).autoCommit) {
            ((IfxSqliConnect)this.conn).removeFromBlobTable(this.hashCode());
        }
        if (this.loFd != -1) {
            ((IfxSqliConnect)this.conn).addLoFdToFinalizedBlobQueue(this.loFd, this.locator);
        }
    }
}

