/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxLob;
import com.gbasedbt.jdbc.IfxSmartBlob;
import com.gbasedbt.util.IfxByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;

class IfxSmartLobOutputStream
extends OutputStream {
    private IfxByteArrayOutputStream buffer;
    private IfxLob ifxLobRef;
    private long currentPosition;

    IfxConnection getConnection() {
        if (this.ifxLobRef != null) {
            return this.ifxLobRef.conn;
        }
        return null;
    }

    IfxSmartLobOutputStream(IfxLob ifxLob, long l) {
        this.buffer = new IfxByteArrayOutputStream();
        this.ifxLobRef = ifxLob;
        this.currentPosition = l;
    }

    IfxSmartLobOutputStream(IfxLob ifxLob, int n, long l) {
        this.buffer = new IfxByteArrayOutputStream(n);
        this.ifxLobRef = ifxLob;
        this.currentPosition = l;
    }

    @Override
    public void close() throws IOException {
        if (this.buffer.getCount() > 0) {
            this.flush();
        }
        super.close();
    }

    @Override
    public void flush() throws IOException {
        try {
            this.setStream(this.currentPosition, new ByteArrayInputStream(this.buffer.getBuffer()), this.buffer.getCount());
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        this.currentPosition += (long)this.buffer.getCount();
        this.buffer.reset();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.buffer.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.buffer.write(byArray, n, n2);
    }

    @Override
    public void write(int n) {
        this.buffer.write(n);
    }

    private void setStream(long l, InputStream inputStream, int n) throws SQLException {
        IfxSmartBlob cfr_ignored_0 = this.ifxLobRef.smb;
        this.ifxLobRef.smb.IfxLoSeek(this.ifxLobRef.smb.getHandle(), l, 0);
        this.ifxLobRef.setStream(inputStream, n);
    }
}

