/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.asf.IfxASFException;
import com.gbasedbt.jdbc.CacheSQLMap;
import com.gbasedbt.jdbc.Driver;
import com.gbasedbt.jdbc.IfmxCancelQuery;
import com.gbasedbt.jdbc.IfmxStatement;
import com.gbasedbt.jdbc.IfxCachedRowSetImpl;
import com.gbasedbt.jdbc.IfxClientResultSet;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.jdbc.IfxPreparedStatement;
import com.gbasedbt.jdbc.IfxProtocol;
import com.gbasedbt.jdbc.IfxResultCache;
import com.gbasedbt.jdbc.IfxResultSet;
import com.gbasedbt.jdbc.IfxResultSetMetaData;
import com.gbasedbt.jdbc.IfxSavepoint;
import com.gbasedbt.jdbc.IfxSqli;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.rws.RwsUtil;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.IfxWarnMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Vector;

public class IfxStatement
implements IfmxStatement {
    private String cursorName = null;
    protected boolean cursorOpen = false;
    private int maxRows = 0;
    private Trace trace = null;
    private boolean statementProcessed = false;
    private SQLWarning statementWarnings = null;
    private boolean calledgetResultSet = false;
    private boolean calledgetUpdateCount = false;
    private boolean autoFree = false;
    private boolean isRsHoldable = false;
    protected IfxConnection jconn = null;
    protected IfxProtocol prot = null;
    public String commandString = null;
    protected IfxResultSet currentResult = null;
    boolean escapeProcessing = true;
    protected int numqmarks = 0;
    private int ResultSetType = 1003;
    private int ResultSetConcurrency = 1007;
    private int FetchSize = 0;
    private int FetchDirection = 1000;
    private int fetchBufferSize = 0;
    protected Vector BatchVector = new Vector();
    protected Vector BatchParamVector = new Vector();
    protected boolean executeBatchInProgress = false;
    protected IfxResultSetMetaData outputMetaData = null;
    protected int statementType = 0;
    private int maxFieldSize;
    protected boolean Closed = false;
    private int timeoutSeconds = 0;
    private boolean versionCheckOK = false;
    Class cquery = null;
    protected static final short SGK_NO_KEYS = 0;
    protected static final short SGK_ALL_KEYS = 1;
    protected static final short SGK_KEYS_BY_INDEX = 2;
    protected static final short SGK_KEYS_BY_NAME = 3;
    short SGK_returnGeneratedKeys = 0;
    protected int[] SGK_indexes = null;
    protected String[] SGK_names = null;
    protected IfxResultSetMetaData SGK_metaData = null;
    protected IfxClientResultSet SGK_resultSet = null;
    protected boolean rws = false;
    protected IfxConnection oriConn = null;
    protected IfxProtocol oriProt = null;
    protected IfxConnection slaConn = null;
    protected IfxProtocol slaProt = null;

    public void rws() {
        this.rws(this.commandString);
    }

    public void rws(String string) {
        String string2 = RwsUtil.formatSql(string);
        if (string2.replaceAll(" ", "").equalsIgnoreCase("select1fromdual") || string2.replaceAll(" ", "").equalsIgnoreCase("selectsitefromgbasedbt.systableswheretabname='gl_collate'")) {
            this.jconn = this.oriConn;
            this.prot = this.oriProt;
        } else if (string2.startsWith("select") && (string2.endsWith("update") || string2.contains(" into "))) {
            this.rws(false);
        } else {
            boolean bl = string2.startsWith("select");
            this.rws(bl);
        }
    }

    public String formatSql(String string) {
        String string2 = null;
        string2 = string.toLowerCase().replaceAll(" ", "");
        if (string2.endsWith(";")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public void rws(boolean bl) {
        String string = RwsUtil.nodeType(this.oriConn, bl);
        if (string.equalsIgnoreCase("master")) {
            this.jconn = this.oriConn;
            this.prot = this.oriProt;
        } else {
            IfxSqliConnect ifxSqliConnect = (IfxSqliConnect)RwsUtil.getConnection(this.oriConn, "slave", IfxSqliConnect.class);
            IfxProtocol ifxProtocol = null;
            if (RwsUtil.getProtocol(ifxSqliConnect, this) != null) {
                ifxProtocol = (IfxProtocol)RwsUtil.getProtocol(ifxSqliConnect, this);
            } else {
                try {
                    if (this instanceof IfxPreparedStatement) {
                        IfxStatement ifxStatement = null;
                        switch (this.SGK_returnGeneratedKeys) {
                            case 0: {
                                ifxStatement = (IfxPreparedStatement)ifxSqliConnect.prepareStatement(this.commandString);
                                break;
                            }
                            case 1: {
                                ifxStatement = (IfxPreparedStatement)ifxSqliConnect.prepareStatement(this.commandString, 1);
                                break;
                            }
                            case 2: {
                                ifxStatement = (IfxPreparedStatement)ifxSqliConnect.prepareStatement(this.commandString, this.SGK_indexes);
                                break;
                            }
                            case 3: {
                                ifxStatement = (IfxPreparedStatement)ifxSqliConnect.prepareStatement(this.commandString, this.SGK_names);
                            }
                        }
                        ifxStatement.setResultSetType(this.getResultSetType());
                        ifxStatement.setResultSetConcurrency(this.getResultSetConcurrency());
                        ifxStatement.setResultSetHoldability(this.isRsHoldable());
                        ifxProtocol = ((IfxPreparedStatement)ifxStatement).prot;
                    } else {
                        IfxStatement ifxStatement = (IfxStatement)ifxSqliConnect.createStatement();
                        ifxProtocol = ifxStatement.prot;
                        ifxStatement.setResultSetType(this.getResultSetType());
                        ifxStatement.setResultSetConcurrency(this.getResultSetConcurrency());
                        ifxStatement.setResultSetHoldability(this.isRsHoldable());
                    }
                    RwsUtil.putProtocol(ifxSqliConnect, this, ifxProtocol);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            this.slaConn = ifxSqliConnect;
            this.slaProt = ifxProtocol;
            this.jconn = this.slaConn;
            this.prot = this.slaProt;
        }
    }

    IfxStatement(IfxConnection ifxConnection) throws SQLException {
        this.rws = ifxConnection.isRws();
        if (this.rws) {
            this.oriConn = ifxConnection;
        }
        this.jconn = ifxConnection;
        if (this.jconn != null) {
            this.autoFree = ((IfxSqliConnect)this.jconn).getAutoFree();
        }
        if (this.jconn != null) {
            this.setResultSetHoldability(((IfxSqliConnect)this.jconn).isHoldable());
            try {
                Class<?> clazz = Class.forName(ifxConnection.getProtoClassName());
                Class<?> clazz2 = Class.forName(ifxConnection.getConnClassName());
                Class[] classArray = new Class[]{clazz2};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{ifxConnection};
                this.prot = (IfxProtocol)constructor.newInstance(objectArray);
                if (this.rws) {
                    this.oriProt = this.prot;
                }
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79735, exception.toString(), ifxConnection);
            }
        }
        if (TraceFlag.compiletrace && this.jconn != null) {
            this.trace = this.jconn.getTrace();
            if (this.trace == null) {
                System.out.println("IfxStatement: Trace is NULL");
            }
            this.trace.writeTrace(99, "IfxStatement: constructor exited");
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "Statement.executeQuery(): sql = " + string);
        }
        this.validate(string);
        if (this.currentResult != null) {
            this.currentResult.closePrev();
            this.currentResult = null;
        }
        return this.executeQueryImpl(this.isRsHoldable());
    }

    @Override
    public ResultSet executeQuery(String string, boolean bl) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "Statement.executeQuery(sql,withHold): sql = " + string + " , withHold = " + bl);
        }
        this.validate(string);
        if (this.currentResult != null) {
            this.currentResult.closePrev();
            this.currentResult = null;
        }
        return this.executeQueryImpl(bl);
    }

    void validate(String string) throws SQLException {
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        if (this.jconn == null || this.jconn.isClosed()) {
            throw IfxErrMsg.getSQLException(-79730, this.jconn);
        }
        this.commandString = this.escapeProcessing ? this.jconn.nativeSQL(string) : string;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "Statement.executeUpdate(): sql = " + string);
        }
        this.SGK_returnGeneratedKeys = 0;
        return this.executeUpdateBody(string);
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "Statement.executeUpdate(): sql = " + string + " autoGeneratedKeys = " + n);
        }
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:executeUpdate(String, int)not supported with server");
            }
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.executeUpdate(String, int)", this.jconn);
        }
        if (n == 1) {
            this.SGK_returnGeneratedKeys = 1;
        } else if (n == 2) {
            this.SGK_returnGeneratedKeys = 0;
        } else {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:executeUpdate(String, int)invalid return generated key value");
            }
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, int)", this.jconn);
        }
        return this.executeUpdateBody(string);
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "Statement.executeUpdate(String, int[]): sql = " + string + " autoGeneratedKeys = " + nArray);
        }
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:executeUpdate(String, int[])not supported with server");
            }
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.executeUpdate(String, int[])", this.jconn);
        }
        if (nArray == null || nArray.length <= 0) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:executeUpdate(String, int[]) error in specifying auto generated key");
            }
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, int[])", this.jconn);
        }
        this.SGK_indexes = (int[])nArray.clone();
        this.SGK_returnGeneratedKeys = (short)2;
        return this.executeUpdateBody(string);
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "Statement.executeUpdate(String, String[]): sql = " + string + " autoGeneratedKeys = " + stringArray);
        }
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:executeUpdate(String, String[])not supported with server");
            }
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.executeUpdate(String, String[])", this.jconn);
        }
        if (stringArray == null || stringArray.length <= 0) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:executeUpdate(String, String[]) error in specifying auto generated key");
            }
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, String[])", this.jconn);
        }
        this.SGK_names = (String[])stringArray.clone();
        this.SGK_returnGeneratedKeys = (short)3;
        return this.executeUpdateBody(string);
    }

    private int executeUpdateBody(String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "Statement.executeUpdateBody(): sql = " + string);
        }
        this.validate(string);
        if (this.currentResult != null) {
            this.currentResult.closePrev();
            this.currentResult = null;
        }
        return this.executeUpdateImpl();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "Statement.getGeneratedKeys() called");
        }
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:getGeneratedKeys()not supported with server");
            }
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.getGeneratedKeys()", this.jconn);
        }
        IfxSqli ifxSqli = (IfxSqli)this.prot;
        if (ifxSqli.SGK_rowColumn == null) {
            IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(0, this.jconn);
            this.SGK_resultSet = new IfxClientResultSet(this.jconn, ifxResultSetMetaData);
        } else {
            this.SGK_metaData = (IfxResultSetMetaData)ifxSqli.getSGK_metaData();
            this.SGK_resultSet = new IfxClientResultSet(this.jconn, this.SGK_metaData);
            while (ifxSqli.getNextSGKRow()) {
                this.SGK_resultSet.newRow(1);
                for (int i = 1; i <= this.SGK_metaData.getColumnCount(); ++i) {
                    IfxObject ifxObject = ifxSqli.SGK_rowColumn.getColumn(i);
                    this.SGK_resultSet.updateIfxObject(i, (Object)ifxObject);
                }
            }
        }
        this.SGK_resultSet.beforeFirst();
        this.SGK_resultSet.setType(1003);
        this.SGK_resultSet.setFetchDirection(1000);
        this.SGK_resultSet.setConcurrency(1007);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "Statement.getGeneratedKeys() exited");
        }
        return this.SGK_resultSet;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxStatement.close() called");
        }
        this.Closed = true;
        if (this.currentResult != null) {
            this.currentResult.close();
            this.currentResult = null;
        }
        if (this.cursorOpen) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "cursor is open");
            }
            this.prot.executeClose(this);
        }
        if (!this.rws) {
            this.prot.executeRelease(this);
            if (this.jconn != null) {
                ((IfxSqliConnect)this.jconn).removeFromStmtList(this);
            }
        } else {
            if (this.oriConn != null) {
                this.oriProt.executeRelease(this);
                ((IfxSqliConnect)this.oriConn).removeFromStmtList(this);
            }
            if (this.slaConn != null) {
                RwsUtil.close(this.oriConn);
            }
            this.oriConn = null;
            this.slaConn = null;
        }
        this.cursorName = null;
        this.statementWarnings = null;
        this.jconn = null;
        this.commandString = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxStatement.close() exited");
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:getMaxFieldSize() returns " + this.maxFieldSize);
        }
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (n < 0) {
            throw IfxErrMsg.getSQLException(-79877, this.jconn);
        }
        this.maxFieldSize = n;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:setMaxFileldSize(): Dummy  Implementation");
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (n < 0) {
            throw IfxErrMsg.getSQLMinorException(-79731, -80007, this.jconn);
        }
        this.maxRows = n;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.escapeProcessing = bl;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:getQueryTimeout() returns 0");
        }
        return this.timeoutSeconds;
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (Driver.compareJDKVersion("1.4") < 0) {
            throw IfxErrMsg.getSQLException(-79700, ": Statement.setQueryTimeout(int).", this.jconn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:setQueryTimeout() entered");
        }
        if (!this.versionCheckOK) {
            try {
                Class<?> clazz = Class.forName("java.util.Timer");
                Class<?> clazz2 = Class.forName("java.util.TimerTask");
                this.cquery = Class.forName("com.gbasedbt.jdbc.IfxCancelQueryImpl");
                this.versionCheckOK = true;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79700, ": Statement.setQueryTimeout(int).", this.jconn);
            }
        }
        if (n < 0) {
            throw IfxErrMsg.getSQLException(-79773, this.jconn);
        }
        this.timeoutSeconds = n;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:setQueryTimeout() exited");
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (Driver.compareJDKVersion("1.4") < 0) {
            throw IfxErrMsg.getSQLException(-79700, ": Statement.cancel().", this.jconn);
        }
        try {
            ((IfxSqliConnect)this.jconn).asfconn.sOOBSocket();
        }
        catch (IfxASFException ifxASFException) {
            throw IfxErrMsg.getSQLException(-908, this.jconn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:cancel() exited");
        }
    }

    private void addWarning(String string, String string2) {
        if (this.statementWarnings == null) {
            this.statementWarnings = string2 != null ? IfxWarnMsg.getSQLWarning(string2, string, this.jconn) : IfxWarnMsg.getSQLWarning(string, this.jconn);
        } else if (string2 != null) {
            SQLWarning sQLWarning = IfxWarnMsg.getSQLWarning(string2, string, this.jconn);
            this.statementWarnings.setNextWarning(sQLWarning);
        } else {
            SQLWarning sQLWarning = IfxWarnMsg.getSQLWarning(string, this.jconn);
            this.statementWarnings.setNextWarning(sQLWarning);
        }
    }

    void chainWarnings(SQLWarning sQLWarning) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxStatement.chainWarnings() called");
        }
        if (sQLWarning != null) {
            if (this.statementWarnings != null) {
                this.statementWarnings.setNextWarning(sQLWarning);
            } else {
                this.statementWarnings = sQLWarning;
            }
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxStatement.chainWarnings() exited");
        }
    }

    protected void transferWarnings() throws SQLException {
        SQLWarning sQLWarning;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxStatement.transferWarnings() called");
        }
        if (this.currentResult != null && (sQLWarning = this.currentResult.getWarnings()) != null) {
            if (this.statementWarnings != null) {
                this.statementWarnings.setNextWarning(sQLWarning);
            } else {
                this.statementWarnings = sQLWarning;
            }
            this.currentResult.clearWarnings();
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxStatement.transferWarnings() exited");
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.currentResult != null) {
            this.chainWarnings(this.currentResult.getWarnings());
        }
        return this.statementWarnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.currentResult != null) {
            this.currentResult.clearWarnings();
        }
        this.statementWarnings = null;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (string.length() <= 0) {
            throw IfxErrMsg.getSQLException(-79732, this.jconn);
        }
        this.cursorName = string;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "Statement.execute(): sql = " + string);
        }
        this.SGK_returnGeneratedKeys = 0;
        return this.executeBody(string);
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "Statement.execute(): sql = " + string + " autoGeneratedKeys = " + n);
        }
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:execute(String, int) not supported with server");
            }
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.execute(String, int)", this.jconn);
        }
        if (n == 1) {
            this.SGK_returnGeneratedKeys = 1;
        } else if (n == 2) {
            this.SGK_returnGeneratedKeys = 0;
        } else {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:executeUpdate(String, int)invalid return generated key value");
            }
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, int)", this.jconn);
        }
        return this.executeBody(string);
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "Statement.execute(): sql = " + string + ", " + nArray);
        }
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:execute(String, int[]) not supported with server");
            }
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.execute(String, int[])", this.jconn);
        }
        if (nArray == null || nArray.length <= 0) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:executeUpdate(String, int[]) error in specifying auto generated key");
            }
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, int[])", this.jconn);
        }
        this.SGK_indexes = (int[])nArray.clone();
        this.SGK_returnGeneratedKeys = (short)2;
        return this.executeBody(string);
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "Statement.execute(): sql = " + string + ", " + stringArray);
        }
        if (!(this.jconn instanceof IfxSqliConnect) || !((IfxSqliConnect)this.jconn).isAutoGeneratedKeysSupported()) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:execute(String, String[]) not supported with server");
            }
            throw IfxErrMsg.getSQLException(-79882, ": IfxStatement.execute(String, String[])", this.jconn);
        }
        if (stringArray == null || stringArray.length <= 0) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:executeUpdate(String, String[]) error in specifying auto generated key");
            }
            throw IfxErrMsg.getSQLException(-19841, ": IfxStatement.executeUpdate(String, String[])", this.jconn);
        }
        this.SGK_names = (String[])stringArray.clone();
        this.SGK_returnGeneratedKeys = (short)3;
        return this.executeBody(string);
    }

    private boolean executeBody(String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "Statement.executeBody(): sql = " + string);
        }
        this.validate(string);
        if (this.currentResult != null) {
            this.currentResult.closePrev();
            this.currentResult = null;
        }
        return this.executeImpl();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.chkAndSetGetRsltCalledFlag();
        if (this.currentResult == null) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:getResultSet():null result set");
            }
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        if (this.currentResult.isClosed() || this.currentResult.getUpdateCount() != -1) {
            return null;
        }
        return this.currentResult;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.calledgetUpdateCount) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:getUpdateCount():getUpdateCount called twice");
            }
            throw IfxErrMsg.getSQLException(-79782, this.jconn);
        }
        this.calledgetUpdateCount = true;
        if (this.currentResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        return this.currentResult.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.currentResult != null) {
            this.currentResult.clearWarnings();
            this.currentResult.close();
        }
        this.resetMethodCalledFlags();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:getMoreResult():result set is null");
        }
        return false;
    }

    public String getCursorName() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.cursorName != null) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:getCursorName():" + this.cursorName);
            }
            return this.cursorName;
        }
        return this.getGeneratedCursor();
    }

    private String getGeneratedCursor() throws SQLException {
        if (this.jconn == null) {
            throw IfxErrMsg.getSQLException(-79730, this.jconn);
        }
        this.cursorName = this.jconn.getGeneratedCursor();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:getGeneratedCursor():" + this.cursorName);
        }
        return this.cursorName;
    }

    int getqmarks() {
        return this.numqmarks;
    }

    void setqmarks(int n) {
        this.numqmarks = n;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.jconn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ResultSet executeQueryImpl(boolean bl) throws SQLException {
        Object object;
        if (!this.jconn.isDirect()) {
            ((IfxSqliConnect)this.jconn).closeFinalizedBlobsOnServer();
        }
        this.resetMethodCalledFlags();
        IfmxCancelQuery ifmxCancelQuery = null;
        if (TraceFlag.compiletrace && this.commandString != null) {
            this.trace.writeTrace(3, "Statement: commandString = " + this.commandString + "\nwithHold = " + bl);
        }
        if (this.rws) {
            this.rws();
        }
        this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        this.clearWarnings();
        if (this.timeoutSeconds > 0 && this.versionCheckOK && !((IfxSqli)this.prot).conn.asfconn.cache_result) {
            try {
                ifmxCancelQuery = (IfmxCancelQuery)this.cquery.newInstance();
                ifmxCancelQuery.startCancel(this, this.timeoutSeconds);
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        if (((IfxSqli)this.prot).conn.asfconn.cache_result && this.commandString.indexOf("select") == 0) {
            long l;
            ResultSet resultSet;
            object = ((IfxSqli)this.prot).conn.asfconn + "_" + this.commandString;
            if (this instanceof IfxPreparedStatement && ((IfxSqli)this.prot).conn.asfconn.cache_ps_bindsql) {
                object = ((IfxPreparedStatement)this).vector.size() > 0 ? ((IfxSqli)this.prot).conn.asfconn + "_" + this.commandString + "_" + ((IfxPreparedStatement)this).vector.toString() : ((IfxSqli)this.prot).conn.asfconn + "_" + this.commandString + "_[]";
            }
            if ((resultSet = IfxResultCache.getResult((String)object, l = (long)((IfxSqli)this.prot).conn.asfconn.cache_result_timeout)) != null) {
                int n = ((IfxSqli)this.prot).conn.asfconn.cache_result_delay_counter;
                try {
                    if (n > 0) {
                        Thread.sleep(n);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!TraceFlag.compiletrace) return resultSet;
                this.trace.writeTrace(1, "Statement: read data from jdbc cache,the cache key: " + (String)object);
                return resultSet;
            }
        }
        if (this.outputMetaData != null) {
            this.currentResult.executeQuery(this.outputMetaData, bl);
        } else {
            this.currentResult.executeQuery(bl);
        }
        object = (IfxSqli)this.prot;
        ((IfxSqliConnect)this.jconn).changeStmtId(this, ((IfxSqli)object).getStatementID());
        if (this.timeoutSeconds > 0 && this.versionCheckOK && !((IfxSqli)this.prot).conn.asfconn.cache_result) {
            try {
                ifmxCancelQuery.stopCancel();
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        this.transferWarnings();
        if (!bl) {
            this.addResultSetToSvpt(this.currentResult);
        }
        if (!((IfxSqli)this.prot).conn.asfconn.cache_result || this.commandString.indexOf("select") != 0) return this.currentResult;
        if (((IfxSqli)this.prot).conn.asfconn.cache_result_size_enable && this.ResultSetType != 1003) {
            this.currentResult.last();
            int n = this.currentResult.getRow();
            this.currentResult.beforeFirst();
            if (n > ((IfxSqli)this.prot).conn.asfconn.cache_result_size) {
                return this.currentResult;
            }
        }
        IfxCachedRowSetImpl ifxCachedRowSetImpl = new IfxCachedRowSetImpl();
        if (((IfxSqli)this.prot).conn.asfconn.cache_sql_filter_enable) {
            if (!CacheSQLMap.getInstanse().isNeedPrepare(this.commandString)) return this.currentResult;
            ifxCachedRowSetImpl = new IfxCachedRowSetImpl();
            ifxCachedRowSetImpl.populate(this.currentResult);
            this.currentResult.close();
            this.currentResult = null;
        } else {
            ifxCachedRowSetImpl.populate(this.currentResult);
            this.currentResult.close();
            this.currentResult = null;
        }
        String string = ((IfxSqli)this.prot).conn.asfconn + "_" + this.commandString;
        if (this instanceof IfxPreparedStatement && ((IfxSqli)this.prot).conn.asfconn.cache_ps_bindsql) {
            string = ((IfxPreparedStatement)this).vector.size() > 0 ? ((IfxSqli)this.prot).conn.asfconn + "_" + this.commandString + "_" + ((IfxPreparedStatement)this).vector.toString() : ((IfxSqli)this.prot).conn.asfconn + "_" + this.commandString + "_[]";
        }
        IfxResultCache.putResult(string, ifxCachedRowSetImpl);
        return ifxCachedRowSetImpl;
    }

    int executeUpdateImpl() throws SQLException {
        this.resetMethodCalledFlags();
        int n = 0;
        if (this.rws) {
            this.rws();
        }
        this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        if (TraceFlag.compiletrace && this.commandString != null) {
            this.trace.writeTrace(3, "Statement: commandString = " + this.commandString);
        }
        this.clearWarnings();
        n = this.currentResult.executeUpdate();
        if (n == 0 && this.commandString.toLowerCase().indexOf("isolation") != -1) {
            ((IfxSqliConnect)this.jconn).setTxnIsolationLvl(this.commandString);
        }
        this.transferWarnings();
        return n;
    }

    protected boolean executeImpl() throws SQLException {
        return this.executeImpl(this.isRsHoldable());
    }

    boolean executeImpl(boolean bl) throws SQLException {
        this.resetMethodCalledFlags();
        IfmxCancelQuery ifmxCancelQuery = null;
        if (this.rws) {
            this.rws();
        }
        this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        this.clearWarnings();
        if (this.timeoutSeconds > 0 && this.versionCheckOK) {
            try {
                ifmxCancelQuery = (IfmxCancelQuery)this.cquery.newInstance();
                ifmxCancelQuery.startCancel(this, this.timeoutSeconds);
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        boolean bl2 = this.outputMetaData != null ? this.currentResult.executeExecute(bl, this.outputMetaData) : this.currentResult.executeExecute(bl);
        if (this.timeoutSeconds > 0 && this.versionCheckOK) {
            try {
                ifmxCancelQuery.stopCancel();
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        this.transferWarnings();
        return bl2;
    }

    @Override
    public int getSerial() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:getSerial()");
        }
        if (this.currentResult == null) {
            return 0;
        }
        return this.currentResult.getSerial();
    }

    @Override
    public long getSerial8() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:getSerial8()");
        }
        if (this.currentResult == null) {
            return 0L;
        }
        return this.currentResult.getSerial8();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:setFetchDirection()");
        }
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (n != 1000 && n != 1001 && n != 1002) {
            throw IfxErrMsg.getSQLException(-79764, this.jconn);
        }
        if (this.getResultSetType() == 1003 && n != 1000) {
            throw IfxErrMsg.getSQLException(-79765, this.jconn);
        }
        this.FetchDirection = n;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:getFetchDirection()");
        }
        return this.FetchDirection;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:setFetchSize()");
        }
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (n < 0 || this.maxRows != 0 && n > this.maxRows) {
            throw IfxErrMsg.getSQLException(-79766, this.jconn);
        }
        this.FetchSize = n;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:getFetchSize()");
        }
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.FetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:getResultSetConcurrency()");
        }
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.ResultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:getResultSetType()");
        }
        return this.ResultSetType;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxStatement:addBatch()");
        }
        this.validate(string);
        this.commandString = this.commandString.trim();
        if (!this.commandString.endsWith(";")) {
            this.commandString = this.commandString + ";";
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:commandString is " + this.commandString);
        }
        this.BatchVector.addElement(this.commandString);
    }

    @Override
    public void clearBatch() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxStatement:clearBatch()");
        }
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.BatchVector.removeAllElements();
        this.scrubBatch();
    }

    protected void scrubBatch() throws SQLException {
        IfxSqli ifxSqli;
        this.executeBatchInProgress = false;
        if (this.currentResult != null && (ifxSqli = (IfxSqli)this.prot) != null) {
            ifxSqli.clearBatch();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int n;
        int[] nArray = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxStatement:executeBatch()");
        }
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.executeBatchInProgress = true;
        this.commandString = "";
        if (this.BatchVector.size() == 0) {
            return new int[0];
        }
        for (n = 0; n < this.BatchVector.size(); ++n) {
            this.commandString = this.commandString + this.BatchVector.elementAt(n);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:commandString is " + this.commandString);
        }
        if (this.rws) {
            this.rws();
        }
        if (((IfxSqliConnect)this.jconn).isBatchUpdatePerSpec()) {
            try {
                n = this.executeUpdateImpl();
                IfxSqli ifxSqli = (IfxSqli)this.prot;
                ArrayList<Integer> arrayList = ifxSqli.batchRowStatus;
                nArray = new int[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    nArray[i] = arrayList.get(i);
                }
                ifxSqli.batchRowStatus.clear();
            }
            catch (SQLException sQLException) {
                IfxSqli ifxSqli = (IfxSqli)this.prot;
                ArrayList<Integer> arrayList = ifxSqli.batchRowStatus;
                this.executeBatchInProgress = false;
                if (arrayList != null) {
                    nArray = new int[arrayList.size()];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        nArray[i] = arrayList.get(i);
                    }
                    ifxSqli.batchRowStatus.clear();
                    this.clearBatch();
                    throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
                }
                this.clearBatch();
                throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), new int[0]);
            }
        }
        try {
            nArray = new int[this.BatchVector.size()];
            nArray[0] = this.executeUpdateImpl();
            for (n = 1; n < this.BatchVector.size(); ++n) {
                nArray[n] = -2;
            }
        }
        catch (SQLException sQLException) {
            this.clearBatch();
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), new int[0]);
        }
        this.clearBatch();
        this.executeBatchInProgress = false;
        return nArray;
    }

    protected void setResultSetType(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:setResultSetType()");
        }
        if (n != 1004 && n != 1003) {
            this.addWarning(IfxErrMsg.getSQLException(-79775, this.jconn).toString(), "01000");
        }
        this.ResultSetType = n == 1005 ? 1004 : n;
    }

    protected void setResultSetConcurrency(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:setResultSetConcurrency()");
        }
        if (n != 1008 && n != 1007) {
            throw IfxErrMsg.getSQLException(-79773, this.jconn);
        }
        this.ResultSetConcurrency = n;
    }

    @Override
    public void setAutoFree(boolean bl) {
        this.autoFree = bl && this.jconn.isAutoFree() ? bl : false;
    }

    void setResultSetHoldability(boolean bl) {
        this.isRsHoldable = bl;
    }

    @Override
    public boolean getAutoFree() {
        return this.autoFree;
    }

    protected void setStatementType(int n) {
        this.statementType = n;
    }

    @Override
    public int getStatementType() {
        return this.statementType;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:getMoreResults(int) not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": Statement.getMoreResults(int)", this.jconn);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:getResultSetHoldability()");
        }
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        return this.isRsHoldable() ? 1 : 2;
    }

    boolean isRsHoldable() {
        return this.isRsHoldable;
    }

    protected void chkAndSetGetRsltCalledFlag() throws SQLException {
        if (this.calledgetResultSet) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "IfxStatement:getResultSet():getResultSet called twice");
            }
            throw IfxErrMsg.getSQLException(-79782, this.jconn);
        }
        this.calledgetResultSet = true;
    }

    protected void resetMethodCalledFlags() {
        this.calledgetResultSet = false;
        this.calledgetUpdateCount = false;
    }

    void setIsReleased(boolean bl) {
        IfxSqli ifxSqli = (IfxSqli)this.prot;
        ifxSqli.setIsReleased(bl);
    }

    @Override
    public long getBigSerial() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:getBigSerial()");
        }
        if (this.currentResult == null) {
            return 0L;
        }
        return this.currentResult.getBigSerial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResultSetToSvpt(ResultSet resultSet) {
        if (((IfxSqliConnect)this.jconn).svptList != null) {
            ArrayList arrayList = ((IfxSqliConnect)this.jconn).svptList;
            synchronized (arrayList) {
                WeakReference weakReference2 = null;
                IfxSavepoint ifxSavepoint = null;
                for (WeakReference weakReference2 : ((IfxSqliConnect)this.jconn).svptList) {
                    ifxSavepoint = (IfxSavepoint)weakReference2.get();
                    ifxSavepoint.addResultSet(resultSet);
                }
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:isClosed()not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxStatement.isClosed()", this.jconn);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:isPoolable()not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxStatement.isPoolable()", this.jconn);
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:setPoolable(boolean)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxStatement.setPoolable(boolean)", this.jconn);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:isWrapperFor(Class)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxStatement.isWrapperFor(Class)", this.jconn);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:unwrap(Class<T>)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxStatement.unwrap(Class<T>)", this.jconn);
    }

    @Override
    public void setFetchBufferSize(int n) {
        this.fetchBufferSize = n;
    }

    @Override
    public int getFetchBufferSize() {
        return this.fetchBufferSize;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxStatement.closeOnCompletion()", this.jconn);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

