/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxComplex;
import com.gbasedbt.jdbc.IfxComplexInput;
import com.gbasedbt.jdbc.IfxComplexOutput;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import java.util.Vector;

public class IfxStruct
implements Struct {
    private Map typeMap;
    private IfxComplexInput inputStream;
    private IfxComplexOutput outputStream;
    private Object[] attributes = null;
    private IfxConnection conn;
    private Trace trace;
    private String SQLTypeName = null;
    private boolean isNull = true;

    IfxStruct(byte[] byArray, Vector vector, IfxConnection ifxConnection) throws SQLException {
        String string = null;
        this.inputStream = new IfxComplexInput(byArray, 0, byArray.length, vector, false, ifxConnection);
        this.outputStream = new IfxComplexOutput(true, false);
        this.outputStream.setConnection(ifxConnection);
        this.setConnection(ifxConnection);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxStruct() constructor entered/exited");
        }
        if (ifxConnection != null) {
            string = ifxConnection.getclLocale();
        }
        this.SQLTypeName = IfxComplex.getExtendedName(vector, this.trace, string);
    }

    @Override
    public String getSQLTypeName() {
        return this.SQLTypeName;
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxStruct().getAttributes(void) called");
        }
        return this.getAttributes((Map)this.conn.getTypeMap());
    }

    public Object[] getAttributes(Map map) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxStruct().getAttributes(Map) called");
        }
        if (this.attributes != null && map == this.typeMap) {
            return this.attributes;
        }
        this.setAttributes(map);
        this.typeMap = map;
        return this.attributes;
    }

    private void clear() {
        this.attributes = null;
        this.outputStream.reset();
    }

    void setConnection(IfxConnection ifxConnection) throws SQLException {
        this.conn = ifxConnection;
        if (ifxConnection == null) {
            throw IfxErrMsg.getSQLException(-79716, ifxConnection);
        }
        if (TraceFlag.compiletrace) {
            this.trace = ifxConnection.getTrace();
        }
    }

    private void setAttributes(Map map) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxStruct().setAttributes(Map) called");
        }
        if (this.inputStream == null) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        this.inputStream.setTypeMap(map);
        this.attributes = this.inputStream.readStructAttributes();
    }
}

