/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfmxUDTSQLOutput;
import com.gbasedbt.jdbc.IfxBblob;
import com.gbasedbt.jdbc.IfxCblob;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxLocator;
import com.gbasedbt.jdbc.IfxSQLOutput;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.jdbc.IfxUDTInfo;
import com.gbasedbt.jdbc.SQLUDTOutput;
import com.gbasedbt.lang.Decimal;
import com.gbasedbt.lang.Interval;
import com.gbasedbt.lang.IntervalDF;
import com.gbasedbt.lang.IntervalYM;
import com.gbasedbt.lang.JavaToIfxType;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.TraceFlag;
import com.gbasedbt.util.stringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Timestamp;

public class IfxUDTOutput
extends IfxSQLOutput
implements SQLUDTOutput,
IfmxUDTSQLOutput {
    private static final int NO_ALIGNMENT = -1;
    private boolean autoAlignmentEnabled = true;

    IfxUDTOutput() {
    }

    IfxUDTOutput(IfxConnection ifxConnection) throws SQLException {
        super(ifxConnection);
    }

    private void checkAlignment(int n, int n2) throws SQLException {
        if (this.autoAlignmentEnabled && n2 != -1) {
            int n3 = this.getCurrentPosition();
            int n4 = (n3 + n + (n2 - 1) & ~(n2 - 1)) - (n3 + n);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "IfxUDTOutput.checkAlignment(): currentPos = " + n3);
                this.trace.writeTrace(3, "                               dataSize = " + n);
                this.trace.writeTrace(3, "                               nPadded = " + n4);
            }
            try {
                while (n4-- > 0) {
                    this.os.write(0);
                    super.adjustTotalDataSize();
                }
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
    }

    @Override
    public void writeString(String string, int n) throws SQLException {
        this.checkAlignment(n, -1);
        try {
            int n2 = n - string.length();
            byte[] byArray = string.getBytes();
            byArray = stringUtil.getBytes(string, this.conn);
            this.os.write(byArray, 0, string.length() > n ? n : string.length());
            while (n2-- > 0) {
                this.os.write(0);
            }
            super.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeString(String string, String string2) throws SQLException {
        try {
            this.os.write(((IfxSqliConnect)this.conn).javatoifx.JavaToIfxLvarchar(string, string2, ((IfxSqliConnect)this.conn).encoption));
            return;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public void writeByte(byte by) throws SQLException {
        this.checkAlignment(1, -1);
        try {
            this.os.writeByte(by);
            super.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public void writeBoolean(boolean bl) throws SQLException {
        byte by = 0;
        if (bl) {
            by = 1;
        }
        try {
            this.writeByte(by);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public void writeShort(short s) throws SQLException {
        this.checkAlignment(2, 2);
        super.writeShort(s);
    }

    @Override
    public void writeInt(int n) throws SQLException {
        this.checkAlignment(4, 4);
        super.writeInt(n);
    }

    @Override
    public void writeLong(long l) throws SQLException {
        try {
            short s = 1;
            if (l < 0L) {
                s = -1;
                l = -l;
            }
            long l2 = l & 0xFFFFFFFFL;
            this.writeInt((int)l2);
            int n = (int)(l >> 32);
            this.writeInt(n);
            this.writeShort(s);
            if (this.autoAlignmentEnabled) {
                this.writeByte((byte)0);
                this.writeByte((byte)0);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeLongBigint(long l) throws SQLException {
        try {
            long l2 = l & 0xFFFFFFFFL;
            this.writeInt((int)l2);
            int n = (int)(l >> 32);
            this.writeInt(n);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public void writeFloat(float f) throws SQLException {
        this.checkAlignment(4, 4);
        super.writeFloat(f);
    }

    @Override
    public void writeDouble(double d) throws SQLException {
        this.checkAlignment(8, 8);
        super.writeDouble(d);
    }

    @Override
    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        try {
            this.checkAlignment(2, 2);
            this.os.write(new Decimal(bigDecimal).javaToDec_t());
            super.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public void writeBytes(byte[] byArray, int n) throws SQLException {
        try {
            this.checkAlignment(n, -1);
            int n2 = n - byArray.length;
            this.os.write(byArray);
            while (n2-- > 0) {
                this.os.write(0);
            }
            super.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        try {
            Decimal decimal = JavaToIfxType.convertTimestampToDecimal(timestamp);
            short s = 4365;
            this.checkAlignment(2, 2);
            this.os.writeShort(s);
            this.os.write(decimal.javaToDec_t());
            super.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public void writeCharacterStream(Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeCharacterStream(Reader).", this.conn);
    }

    @Override
    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeAsciiStream(InputStream).", this.conn);
    }

    @Override
    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeBinaryStream(InputStream).", this.conn);
    }

    @Override
    public void writeObject(SQLData sQLData) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeObject(SQLData).", this.conn);
    }

    @Override
    public void writeRef(Ref ref) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeRef(Ref).", this.conn);
    }

    void writeIfxLocator(IfxLocator ifxLocator) throws SQLException {
        this.writeBytes(ifxLocator.getRawLocator());
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        if (!(blob instanceof IfxBblob)) {
            throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeBlob(Blob).", this.conn);
        }
        this.writeIfxLocator(((IfxBblob)blob).getLocator());
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        if (!(clob instanceof IfxCblob)) {
            throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeClob(Clob).", this.conn);
        }
        this.writeIfxLocator(((IfxCblob)clob).getLocator());
    }

    @Override
    public void writeStruct(Struct struct) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeStruct(Struct).", this.conn);
    }

    @Override
    public void writeArray(Array array) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeArray(Array).", this.conn);
    }

    @Override
    public void writeInterval(Interval interval) throws SQLException {
        try {
            Object var2_2 = null;
            short s = 0;
            s = interval.getQualifier();
            Decimal decimal = interval instanceof IntervalYM ? JavaToIfxType.convertIntervalToDecimal((IntervalYM)interval) : JavaToIfxType.convertIntervalToDecimal((IntervalDF)interval);
            this.checkAlignment(2, 2);
            this.os.writeShort(s);
            this.os.write(decimal.javaToDec_t());
            super.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.getMessage(), this.conn);
        }
    }

    @Override
    public int length() {
        return super.length();
    }

    @Override
    public void setAutoAlignment(boolean bl) {
        this.autoAlignmentEnabled = bl;
    }

    @Override
    public boolean getAutoAlignment() {
        return this.autoAlignmentEnabled;
    }

    @Override
    public void skipBytes(int n) throws SQLException {
        this.setCurrentPosition(this.bStream.getCount() + n);
    }

    @Override
    public int getCurrentPosition() {
        return this.bStream.getCount();
    }

    @Override
    public void setCurrentPosition(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxUDTOutput.setCurrentPosition entering");
            this.trace.writeTrace(3, "    position: " + n);
            this.trace.writeTrace(3, "    getCurrentPosition: " + this.getCurrentPosition());
        }
        if (n < 0 || n > this.bStream.getTotalDataSize()) {
            throw IfxErrMsg.getSQLException(-79772, this.conn);
        }
        this.bStream.setCount(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "    getCurrentPosition: " + this.getCurrentPosition());
            this.trace.writeTrace(1, "IfxUDTOutput.setCurrentPosition exiting");
        }
    }

    @Override
    public int available() {
        return this.bStream.getTotalDataSize() - this.bStream.getCount();
    }

    @Override
    public IfxUDTInfo getUDTInfo(int n) throws SQLException {
        return this.conn.getUDTInfo(n);
    }

    @Override
    public IfxUDTInfo getUDTInfo(String string, String string2) throws SQLException {
        return this.conn.getUDTInfo(string, string2);
    }

    @Override
    public void writeURL(URL uRL) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxUDTOutput:writeURL()not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeURL()", this.conn);
    }

    @Override
    public void writeNClob(NClob nClob) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxUDTOutput:writeNClob(NClob)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeNClob(NClob)", this.conn);
    }

    @Override
    public void writeNString(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxUDTOutput:writeNString(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeNString(String)", this.conn);
    }

    @Override
    public void writeRowId(RowId rowId) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxUDTOutput:writeRowId(RowId)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeRowId(RowId)", this.conn);
    }

    @Override
    public void writeSQLXML(SQLXML sQLXML) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxUDTOutput:writeSQLXML(SQLXML)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxUDTOutput.writeSQLXML(SQLXML)", this.conn);
    }
}

