/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxCollection;
import com.gbasedbt.jdbc.IfxColumnInfo;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxDateTime;
import com.gbasedbt.jdbc.IfxDistinct;
import com.gbasedbt.jdbc.IfxLobInputStream;
import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.jdbc.IfxRow;
import com.gbasedbt.jdbc.IfxSmBlob;
import com.gbasedbt.jdbc.IfxUDT;
import com.gbasedbt.jdbc.IfxUDTInfo;
import com.gbasedbt.lang.IfxTypes;
import com.gbasedbt.lang.IntervalDF;
import com.gbasedbt.lang.IntervalYM;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Hashtable;

class IfxValue {
    static Hashtable<Integer, String> IfxTypeToObjectTable = null;
    static Hashtable<Integer, String> IfxTypeToObjectTable_9x = null;
    private static final int IUS_TYPES = 10;
    private static final int NO_SCALE = -1;
    private static final String DISTINCT_CLASS_NAME = "IfxDistinct";
    private static final String BLOB_CLASS_NAME = "IfxSmBlob";
    private static final String CLOB_CLASS_NAME = "IfxSmBlob";
    private static final String SERVER_BLOB_CLASS_NAME = "IfxDirectBlob";
    private static final String SERVER_CLOB_CLASS_NAME = "IfxDirectClob";
    private static final String BOOLEAN_CLASS_NAME = "IfxBoolean";
    private static final String LVARCHAR_CLASS_NAME = "IfxLvarchar";
    private static final String UDT_CLASS_NAME = "IfxUDT";
    private static final String IMPEXP_CLASS_NAME = "IfxImpExp";
    private static final String BSON_CLASS_NAME = "IfxBSONObject";
    private static final String JSON_CLASS_NAME = "IfxJSON";

    IfxValue() {
    }

    private static String IfxTypeToObject_9x(IfxConnection ifxConnection, int n) {
        return IfxTypeToObjectTable_9x.get(n);
    }

    private static int getRealIfxType(IfxConnection ifxConnection, int n) {
        if (!ifxConnection.isIEEEM() && IfxTypes.IsFloatTypes(n)) {
            n = 5;
        } else if (!ifxConnection.isUSVER() && n == 17 && !ifxConnection.isXPSVER8_50()) {
            n = 2;
        }
        return n & 0xFF;
    }

    private static String getClassNameForExtendedId(int n) {
        String string = null;
        switch (n) {
            case 5: {
                string = BOOLEAN_CLASS_NAME;
                break;
            }
            case 1: {
                string = LVARCHAR_CLASS_NAME;
                break;
            }
            case 10: {
                string = "IfxSmBlob";
                break;
            }
            case 11: {
                string = "IfxSmBlob";
                break;
            }
            case 25: {
                string = JSON_CLASS_NAME;
                break;
            }
            case 26: {
                string = BSON_CLASS_NAME;
                break;
            }
            case 40: 
            case 41: {
                string = UDT_CLASS_NAME;
            }
        }
        return string;
    }

    static String getIfxTypeName(IfxConnection ifxConnection, IfxColumnInfo ifxColumnInfo) throws SQLException {
        if (ifxColumnInfo == null) {
            throw IfxErrMsg.getSQLException(-79714, ifxConnection);
        }
        if (ifxColumnInfo.ifxTypeClassName == null) {
            int n;
            Trace trace;
            String string = null;
            if (TraceFlag.compiletrace && (trace = ifxConnection.getTrace()) != null) {
                trace.writeTrace(2, "IfxValue.getIfxTypeName()...");
            }
            if (!((n = IfxValue.getRealIfxType(ifxConnection, ifxColumnInfo.SQLtype)) != 52 && n != 53 || ifxConnection.isBigintSupported())) {
                throw IfxErrMsg.getSQLException(-79882, ": IfxValue.makeInstance", ifxConnection);
            }
            if (ifxConnection.isDirect()) {
                if (n >= 17) {
                    if (ifxColumnInfo.ExtendedId == 5 || ifxColumnInfo.SourceType == 5) {
                        string = BOOLEAN_CLASS_NAME;
                        n = 45;
                    } else if (ifxColumnInfo.ExtendedId == 1 || ifxColumnInfo.SourceType == 1) {
                        string = LVARCHAR_CLASS_NAME;
                        n = 43;
                    }
                    if (ifxColumnInfo.ExtendedId != 0 && (n == 40 || n == 41)) {
                        string = UDT_CLASS_NAME;
                        n = 44;
                    }
                    if (string == null) {
                        string = IfxValue.IfxTypeToObject_9x(ifxConnection, n);
                    }
                } else {
                    string = IfxTypeToObjectTable.get(new Integer(n));
                }
                if (n == 14) {
                    byte by = (byte)(ifxColumnInfo.ColLength >> 4 & 0xF);
                    string = by == 0 || by == 2 ? string + "YM" : string + "DF";
                }
            } else if (n == 46) {
                string = IMPEXP_CLASS_NAME;
                n = 46;
            } else if (!ifxColumnInfo.IsDistinct) {
                if (n >= 17 && ifxConnection.isUSVER()) {
                    if (ifxColumnInfo.ExtendedId == 5) {
                        string = BOOLEAN_CLASS_NAME;
                        n = 45;
                    } else if (ifxColumnInfo.ExtendedId == 1) {
                        string = LVARCHAR_CLASS_NAME;
                        n = 43;
                    }
                    if (ifxColumnInfo.ExtendedId != 0) {
                        if (ifxColumnInfo.ExtendedId == 10) {
                            string = "IfxSmBlob";
                            n = 44;
                        } else if (ifxColumnInfo.ExtendedId == 11) {
                            string = "IfxSmBlob";
                            n = 44;
                        } else if (ifxColumnInfo.ExtendedId == 26) {
                            string = BSON_CLASS_NAME;
                            n = 44;
                        } else if (ifxColumnInfo.ExtendedId == 25) {
                            string = JSON_CLASS_NAME;
                            n = 44;
                        } else if (n == 40 || n == 41) {
                            string = UDT_CLASS_NAME;
                            n = 44;
                        }
                    }
                    if (string == null) {
                        string = IfxValue.IfxTypeToObject_9x(ifxConnection, n);
                    }
                } else {
                    string = IfxTypeToObjectTable.get(new Integer(n));
                    if (string == null && ifxConnection.isXPSVER8_50() && (n == 17 || n == 18)) {
                        string = "IfxInt8";
                    }
                }
                if (n == 14) {
                    byte by = (byte)(ifxColumnInfo.ColLength >> 4 & 0xF);
                    string = by == 0 || by == 2 ? string + "YM" : string + "DF";
                }
            } else {
                string = n == 52 ? IfxValue.IfxTypeToObject_9x(ifxConnection, n) : DISTINCT_CLASS_NAME;
            }
            ifxColumnInfo.ifxTypeClassName = string;
            ifxColumnInfo.ifxRealType = n;
            if (TraceFlag.compiletrace && (trace = ifxConnection.getTrace()) != null) {
                trace.writeTrace(2, "IfxValue.getIfxTypeName:");
                trace.writeTrace(2, "  ColInfo.ifxTypeClassName = " + string);
                trace.writeTrace(2, "  ColInfo.ifxRealType = " + n);
            }
        }
        return ifxColumnInfo.ifxTypeClassName;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, IfxColumnInfo ifxColumnInfo) throws SQLException {
        return IfxValue.makeInstance(ifxConnection, ifxColumnInfo, (Calendar)null);
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, IfxColumnInfo ifxColumnInfo, Calendar calendar) throws SQLException {
        Trace trace;
        String string = null;
        String string2 = null;
        string = IfxValue.getIfxTypeName(ifxConnection, ifxColumnInfo);
        int n = ifxColumnInfo.ifxRealType;
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79714, ifxConnection);
        }
        IfxObject ifxObject = IfxValue.createInstanceFromClassName(string, string2, ifxConnection);
        if (ifxObject != null) {
            ifxObject.setIfxType(n);
            ifxObject.setExtendedTypeName(ifxColumnInfo.ExtendedName);
            ifxObject.setExtendedOwner(ifxColumnInfo.ExtendedOwner);
            ifxObject.setExtendedId(ifxColumnInfo.ExtendedId);
            ifxObject.setSourceType(ifxColumnInfo.SourceType);
            ifxObject.setEncodedLength(ifxColumnInfo.ColLength);
            ifxObject.setConnection(ifxConnection);
            if (ifxObject instanceof IfxSmBlob) {
                ((IfxSmBlob)ifxObject).setTableName(ifxColumnInfo.TableName);
                ((IfxSmBlob)ifxObject).setColumnName(ifxColumnInfo.ColName);
            }
            if (calendar != null && ifxObject instanceof IfxDateTime) {
                ((IfxDateTime)ifxObject).dbCalendar = calendar;
            }
        }
        if (TraceFlag.compiletrace && (trace = ifxConnection.getTrace()) != null) {
            trace.writeTrace(2, "IfxValue.makeInstance:");
            trace.writeTrace(2, "  ColInfo.SQLType = " + n);
            trace.writeTrace(2, "  ColInfo.ExtendedId = " + ifxColumnInfo.ExtendedId);
            trace.writeTrace(2, "  This instance is " + ifxObject.getClass().getName());
        }
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, IfxColumnInfo ifxColumnInfo, int n) throws SQLException {
        Object var3_3 = null;
        Trace trace = ifxConnection.getTrace();
        if (TraceFlag.compiletrace && trace != null) {
            trace.writeTrace(2, "makeInstance: 2");
        }
        return IfxValue.makeInstance(ifxConnection, var3_3, ifxColumnInfo, -1, n);
    }

    private static IfxObject createInstanceFromClassName(String string, String string2, IfxConnection ifxConnection) throws SQLException {
        IfxObject ifxObject = null;
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79728, ifxConnection);
        }
        try {
            Class<?> clazz = string2 == null ? Class.forName("com.gbasedbt.jdbc." + string) : Class.forName("com.gbasedbt.jdbc." + string + string2);
            ifxObject = (IfxObject)clazz.newInstance();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), ifxConnection);
        }
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Object object, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = IfxValue.makeInstance(ifxConnection, object, (String)null, ifxColumnInfo);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Object object, String string, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        Trace trace = ifxConnection.getTrace();
        if (TraceFlag.compiletrace && trace != null) {
            trace.writeTrace(2, "makeInstance: 3");
            if (ifxColumnInfo == null) {
                trace.writeTrace(2, "colinfo is NULL!");
            }
        }
        if (object == null && ifxColumnInfo != null) {
            ifxObject = IfxValue.makeInstance(ifxConnection, ifxColumnInfo);
        } else if (object instanceof SQLData) {
            ifxObject = IfxValue.makeInstance(ifxConnection, (SQLData)object, ifxColumnInfo);
        } else if (object instanceof Clob) {
            ifxObject = IfxValue.makeInstance(ifxConnection, (Clob)object, ifxColumnInfo);
        } else if (object instanceof Blob) {
            ifxObject = IfxValue.makeInstance(ifxConnection, (Blob)object, ifxColumnInfo);
        } else if (object instanceof Struct) {
            ifxObject = IfxValue.makeInstance(ifxConnection, (Struct)object, ifxColumnInfo);
        } else if (object instanceof Array) {
            ifxObject = IfxValue.makeInstance(ifxConnection, (Array)object, string, ifxColumnInfo);
        } else if (object instanceof Collection) {
            ifxObject = IfxValue.makeInstance(ifxConnection, (Collection)object, string, ifxColumnInfo);
        } else {
            Class<?> clazz = object.getClass();
            String string2 = clazz.getName();
            if (ifxColumnInfo != null) {
                if (string2.equals("java.lang.Boolean")) {
                    ifxObject = IfxValue.makeInstance(ifxConnection, (Boolean)object, ifxColumnInfo);
                } else if (string2.equals("[B")) {
                    ifxObject = IfxValue.makeInstance(ifxConnection, (byte[])object, ifxColumnInfo);
                } else if (clazz.isArray()) {
                    ifxObject = IfxValue.makeInstanceFromArray(ifxConnection, object, string);
                }
            }
            if (ifxObject == null) {
                if (ifxColumnInfo == null || ifxColumnInfo.ExtendedId != 0) {
                    String string3 = null;
                    if (object instanceof IntervalYM) {
                        string3 = new String("YM");
                    } else if (object instanceof IntervalDF) {
                        string3 = new String("DF");
                    }
                    int n = IfxTypes.FromJavaToIfxType(string2);
                    if (n == 49) {
                        throw IfxErrMsg.getSQLException(-79728, ifxConnection);
                    }
                    if (ifxConnection.isUSVER() && n == 0) {
                        n = ifxColumnInfo != null && ifxColumnInfo.ExtendedId == 10 ? 102 : (ifxColumnInfo != null && ifxColumnInfo.ExtendedId == 11 ? 101 : 43);
                    }
                    if (ifxConnection.isUSVER() && ifxColumnInfo != null && ifxColumnInfo.ExtendedName.equalsIgnoreCase("lvarchar")) {
                        n = 43;
                    }
                    ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n, string3);
                    ifxObject.fromObject(object);
                } else {
                    String string4 = null;
                    if (object instanceof IntervalYM) {
                        string4 = new String("YM");
                        ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 14, string4);
                    } else if (object instanceof IntervalDF) {
                        string4 = new String("DF");
                        ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 14, string4);
                    } else {
                        ifxObject = IfxValue.makeInstance(ifxConnection, ifxColumnInfo);
                    }
                    ifxObject.fromObject(object);
                }
            }
        }
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Object object, IfxColumnInfo ifxColumnInfo, int n) throws SQLException {
        Trace trace = ifxConnection.getTrace();
        if (TraceFlag.compiletrace && trace != null) {
            trace.writeTrace(2, "makeInstance: 4");
        }
        return IfxValue.makeInstance(ifxConnection, object, ifxColumnInfo, -1, n);
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Object object, IfxColumnInfo ifxColumnInfo, int n, int n2) throws SQLException {
        IfxObject ifxObject = null;
        Trace trace = ifxConnection.getTrace();
        if (TraceFlag.compiletrace && trace != null) {
            trace.writeTrace(2, "makeInstance: 5");
        }
        if ((ifxObject = ifxColumnInfo != null && n2 == -1 && ifxColumnInfo.ExtendedId != 0 && ifxColumnInfo.ExtendedId != 11 ? IfxValue.makeInstanceFromIfxType(ifxConnection, 43) : (ifxColumnInfo != null ? IfxValue.makeInstance(ifxConnection, ifxColumnInfo) : IfxValue.makeInstanceFromIfxType(ifxConnection, IfxTypes.FromJDBCToIfxType(n2)))) != null) {
            if (n == -1) {
                ifxObject.fromObject(object);
            } else {
                ifxObject.fromObject(object, n);
            }
        }
        return ifxObject;
    }

    static IfxObject makeInstanceFromIfxType(IfxConnection ifxConnection, int n) throws SQLException {
        return IfxValue.makeInstanceFromIfxType(ifxConnection, n, null);
    }

    static IfxObject makeInstanceFromIfxType(IfxConnection ifxConnection, int n, String string) throws SQLException {
        IfxObject ifxObject = null;
        Trace trace = ifxConnection.getTrace();
        ifxObject = (n = IfxValue.getRealIfxType(ifxConnection, n)) >= 17 && ifxConnection.isUSVER() ? IfxValue.createInstanceFromClassName(IfxValue.IfxTypeToObject_9x(ifxConnection, n), null, ifxConnection) : IfxValue.createInstanceFromClassName(IfxTypeToObjectTable.get(n), string, ifxConnection);
        if (ifxObject != null) {
            if (n == 101 || n == 102) {
                ifxObject.setExtendedTypeName(IfxTypes.IfxTypeToName(n));
                if (!ifxConnection.isDirect()) {
                    n = 44;
                }
            }
            ifxObject.setIfxType(n);
            ifxObject.setConnection(ifxConnection);
        }
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, BigDecimal bigDecimal, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        ifxObject = ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18 && ifxColumnInfo.SQLtype != 14 && ifxColumnInfo.SQLtype != 7 && ifxColumnInfo.SQLtype != 10 ? IfxValue.makeInstanceFromIfxType(ifxConnection, ifxColumnInfo.SQLtype) : IfxValue.makeInstanceFromIfxType(ifxConnection, 5);
        ifxObject.fromDecimal(bigDecimal);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, boolean bl, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        ifxObject = ifxColumnInfo != null && ifxColumnInfo.SQLtype != 14 && ifxColumnInfo.SQLtype != 7 && ifxColumnInfo.SQLtype != 10 ? IfxValue.makeInstance(ifxConnection, ifxColumnInfo) : IfxValue.makeInstanceFromIfxType(ifxConnection, 45);
        ifxObject.fromBoolean(bl);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, short s, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        ifxObject = ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18 && ifxColumnInfo.SQLtype != 14 && ifxColumnInfo.SQLtype != 7 && ifxColumnInfo.SQLtype != 10 ? IfxValue.makeInstanceFromIfxType(ifxConnection, ifxColumnInfo.SQLtype) : IfxValue.makeInstanceFromIfxType(ifxConnection, 1);
        ifxObject.fromShort(s);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, byte by, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        ifxObject = ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18 && ifxColumnInfo.SQLtype != 7 && ifxColumnInfo.SQLtype != 10 && ifxColumnInfo.SQLtype != 14 ? IfxValue.makeInstanceFromIfxType(ifxConnection, ifxColumnInfo.SQLtype) : IfxValue.makeInstanceFromIfxType(ifxConnection, 1);
        ifxObject.fromByte(by);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, int n, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        ifxObject = ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18 && ifxColumnInfo.SQLtype != 14 && ifxColumnInfo.SQLtype != 7 && ifxColumnInfo.SQLtype != 10 ? IfxValue.makeInstanceFromIfxType(ifxConnection, ifxColumnInfo.SQLtype) : IfxValue.makeInstanceFromIfxType(ifxConnection, 2);
        ifxObject.fromInt(n);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, long l, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        if (ifxColumnInfo == null) {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, ifxConnection.isUSVER() ? 17 : 2);
        } else if (ifxColumnInfo.SQLtype < 17 && ifxColumnInfo.SQLtype != 14 && ifxColumnInfo.SQLtype != 7 && ifxColumnInfo.SQLtype != 10) {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, ifxColumnInfo.SQLtype);
        } else if (ifxColumnInfo.SQLtype == 52 || ifxColumnInfo.SQLtype == 53) {
            if (ifxConnection.isBigintSupported()) {
                ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 52);
            } else if (!ifxConnection.isBigintSupported()) {
                throw IfxErrMsg.getSQLException(-79882, ": IfxValue.makeInstance", ifxConnection);
            }
        } else {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, ifxConnection.isUSVER() ? 17 : 2);
        }
        ifxObject.fromLong(l);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, float f, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        ifxObject = ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18 && ifxColumnInfo.SQLtype != 14 && ifxColumnInfo.SQLtype != 7 && ifxColumnInfo.SQLtype != 10 ? IfxValue.makeInstanceFromIfxType(ifxConnection, ifxColumnInfo.SQLtype) : IfxValue.makeInstanceFromIfxType(ifxConnection, 4);
        ifxObject.fromFloat(f);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, double d, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        ifxObject = ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18 && ifxColumnInfo.SQLtype != 14 && ifxColumnInfo.SQLtype != 7 && ifxColumnInfo.SQLtype != 10 ? (ifxColumnInfo.SQLtype == 8 || ifxColumnInfo.SQLtype == 3 || ifxColumnInfo.SQLtype == 5 || ifxColumnInfo.SQLtype == 2 ? IfxValue.makeInstanceFromIfxType(ifxConnection, ifxColumnInfo.SQLtype) : IfxValue.makeInstanceFromIfxType(ifxConnection, 0)) : IfxValue.makeInstanceFromIfxType(ifxConnection, 3);
        ifxObject.fromDouble(d);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, String string, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject;
        Trace trace = ifxConnection.getTrace();
        if (!ifxConnection.isDirect() && ifxColumnInfo != null) {
            String string2 = null;
            if (ifxColumnInfo.SQLtype == 46) {
                ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 46);
            } else if (ifxColumnInfo.SQLtype == 13 || ifxColumnInfo.SQLtype == 16) {
                ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 13);
            } else if (ifxColumnInfo.SQLtype > 18) {
                if (ifxColumnInfo.ExtendedId == 11) {
                    ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 101);
                    ifxObject.extendedID = 11;
                    if (ifxObject instanceof IfxSmBlob) {
                        ((IfxSmBlob)ifxObject).setTableName(ifxColumnInfo.TableName);
                        ((IfxSmBlob)ifxObject).setColumnName(ifxColumnInfo.ColName);
                    }
                } else if (ifxColumnInfo.ExtendedId == 5) {
                    ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 0);
                } else {
                    ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 43);
                    ifxObject.extendedID = 1;
                    if (ifxColumnInfo.IsDistinct) {
                        ifxColumnInfo.ExtendedOwner = new String("gbasedbt");
                        ifxObject.extendedName = new String("lvarchar");
                    }
                }
            } else {
                if (ifxColumnInfo.SQLtype == 14) {
                    byte by = (byte)(ifxColumnInfo.ColLength >> 4 & 0xF);
                    string2 = by == 0 || by == 2 ? "YM" : "DF";
                }
                ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, ifxColumnInfo.SQLtype, string2);
            }
            if (ifxColumnInfo.SQLtype == 13 || ifxColumnInfo.SQLtype == 16) {
                ifxObject.fromString(string, false);
            } else {
                if (ifxColumnInfo.SQLtype == 14) {
                    ifxObject.setEncodedLength(ifxColumnInfo.ColLength);
                }
                ifxObject.fromString(string);
            }
        } else {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 0);
            if (TraceFlag.compiletrace && trace != null) {
                trace.writeTrace(2, "makeInstance from String, object created: " + ifxObject.getClass().getName());
            }
            ifxObject.fromString(string);
        }
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, byte[] byArray, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = ifxColumnInfo != null && ifxColumnInfo.SQLtype != 1 && ifxColumnInfo.SQLtype != 2 && ifxColumnInfo.SQLtype != 3 && ifxColumnInfo.SQLtype != 4 && ifxColumnInfo.SQLtype != 5 && ifxColumnInfo.SQLtype != 6 && ifxColumnInfo.SQLtype != 8 && ifxColumnInfo.SQLtype != 17 && ifxColumnInfo.SQLtype != 18 && ifxColumnInfo.SQLtype != 7 && ifxColumnInfo.SQLtype != 10 && ifxColumnInfo.SQLtype != 14 ? IfxValue.makeInstance(ifxConnection, ifxColumnInfo) : (ifxConnection.isDirect() ? IfxValue.makeInstanceFromIfxType(ifxConnection, 102) : IfxValue.makeInstanceFromIfxType(ifxConnection, 11));
        ifxObject.fromBytes(byArray);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Date date, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        ifxObject = ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18 && ifxColumnInfo.SQLtype != 1 && ifxColumnInfo.SQLtype != 2 && ifxColumnInfo.SQLtype != 3 && ifxColumnInfo.SQLtype != 4 && ifxColumnInfo.SQLtype != 5 && ifxColumnInfo.SQLtype != 6 && ifxColumnInfo.SQLtype != 8 && ifxColumnInfo.SQLtype != 17 && ifxColumnInfo.SQLtype != 18 ? IfxValue.makeInstanceFromIfxType(ifxConnection, ifxColumnInfo.SQLtype) : IfxValue.makeInstanceFromIfxType(ifxConnection, 7);
        ifxObject.fromDate(date);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Time time, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        ifxObject = ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18 && ifxColumnInfo.SQLtype != 1 && ifxColumnInfo.SQLtype != 2 && ifxColumnInfo.SQLtype != 3 && ifxColumnInfo.SQLtype != 4 && ifxColumnInfo.SQLtype != 5 && ifxColumnInfo.SQLtype != 6 && ifxColumnInfo.SQLtype != 8 && ifxColumnInfo.SQLtype != 17 && ifxColumnInfo.SQLtype != 7 && ifxColumnInfo.SQLtype != 18 ? IfxValue.makeInstanceFromIfxType(ifxConnection, ifxColumnInfo.SQLtype) : IfxValue.makeInstanceFromIfxType(ifxConnection, 10);
        ifxObject.fromTime(time);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Timestamp timestamp, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        ifxObject = ifxColumnInfo != null && ifxColumnInfo.SQLtype <= 18 && ifxColumnInfo.SQLtype != 1 && ifxColumnInfo.SQLtype != 2 && ifxColumnInfo.SQLtype != 3 && ifxColumnInfo.SQLtype != 4 && ifxColumnInfo.SQLtype != 5 && ifxColumnInfo.SQLtype != 6 && ifxColumnInfo.SQLtype != 8 && ifxColumnInfo.SQLtype != 17 && ifxColumnInfo.SQLtype != 7 && ifxColumnInfo.SQLtype != 18 ? IfxValue.makeInstanceFromIfxType(ifxConnection, ifxColumnInfo.SQLtype) : IfxValue.makeInstanceFromIfxType(ifxConnection, 10);
        ifxObject.fromTimestamp(timestamp);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, InputStream inputStream, int n, IfxColumnInfo ifxColumnInfo) throws SQLException {
        InputStream inputStream2 = inputStream instanceof IfxLobInputStream ? ((IfxLobInputStream)inputStream).getStream() : inputStream;
        IfxObject ifxObject = ifxColumnInfo != null ? IfxValue.makeInstance(ifxConnection, ifxColumnInfo) : (ifxConnection.isDirect() ? IfxValue.makeInstanceFromIfxType(ifxConnection, 102) : IfxValue.makeInstanceFromIfxType(ifxConnection, 11));
        ifxObject.fromInputStream(inputStream2, n);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, InputStream inputStream, long l, IfxColumnInfo ifxColumnInfo) throws SQLException {
        InputStream inputStream2 = inputStream instanceof IfxLobInputStream ? ((IfxLobInputStream)inputStream).getStream() : inputStream;
        IfxObject ifxObject = ifxColumnInfo != null ? IfxValue.makeInstance(ifxConnection, ifxColumnInfo) : (ifxConnection.isDirect() ? IfxValue.makeInstanceFromIfxType(ifxConnection, 102) : IfxValue.makeInstanceFromIfxType(ifxConnection, 11));
        ifxObject.fromInputStream(inputStream2, l);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Reader reader, int n, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = IfxValue.makeInstance(ifxConnection, ifxColumnInfo);
        ifxObject.fromCharacterStream(reader, n);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Reader reader, long l, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = IfxValue.makeInstance(ifxConnection, ifxColumnInfo);
        ifxObject.fromCharacterStream(reader, l);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, IntervalYM intervalYM, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 14, "YM");
        ifxObject.fromIntervalYM(intervalYM);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, IntervalDF intervalDF, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 14, "DF");
        ifxObject.fromIntervalDF(intervalDF);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Clob clob, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = ifxColumnInfo != null ? IfxValue.makeInstance(ifxConnection, ifxColumnInfo) : (ifxConnection.isDirect() ? IfxValue.makeInstanceFromIfxType(ifxConnection, 101) : IfxValue.makeInstanceFromIfxType(ifxConnection, 12));
        ifxObject.fromClob(clob);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Blob blob, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = ifxColumnInfo != null ? IfxValue.makeInstance(ifxConnection, ifxColumnInfo) : (ifxConnection.isDirect() ? IfxValue.makeInstanceFromIfxType(ifxConnection, 102) : IfxValue.makeInstanceFromIfxType(ifxConnection, 11));
        ifxObject.fromBlob(blob);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, SQLData sQLData, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = null;
        IfxUDTInfo ifxUDTInfo = null;
        String string = sQLData.getSQLTypeName();
        if (string != null) {
            ifxUDTInfo = ifxConnection.getUDTInfo(ifxColumnInfo, string);
        }
        if (ifxUDTInfo == null) {
            throw IfxErrMsg.getSQLException(-79770, ifxConnection);
        }
        ifxObject = IfxValue.createInstanceByTypeInfo(ifxConnection, ifxUDTInfo);
        if (ifxObject != null) {
            ifxObject.fromObject(sQLData);
        }
        return ifxObject;
    }

    private static IfxObject createInstanceByTypeInfo(IfxConnection ifxConnection, IfxUDTInfo ifxUDTInfo) throws SQLException {
        IfxObject ifxObject = null;
        try {
            switch (ifxUDTInfo.JDBCtype) {
                case 2000: {
                    ifxObject = new IfxUDT();
                    if (!ifxConnection.isDirect()) {
                        ifxObject.setIfxType(44);
                        break;
                    }
                    ifxObject.setIfxType(ifxUDTInfo.SQLtype);
                    break;
                }
                case 2001: {
                    ifxObject = new IfxDistinct();
                    ifxObject.setIfxType(ifxUDTInfo.SQLtype);
                    ifxObject.isDistinct = true;
                    break;
                }
                case 2002: {
                    ifxObject = new IfxRow();
                    ifxObject.setIfxType(44);
                    ifxObject.isNamedRow = true;
                }
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), ifxConnection);
        }
        if (ifxObject != null) {
            ifxObject.setExtendedTypeName(ifxUDTInfo.name);
            ifxObject.setExtendedOwner(ifxUDTInfo.owner);
            ifxObject.setExtendedId(ifxUDTInfo.xid);
            ifxObject.setSourceType(ifxUDTInfo.source);
            ifxObject.setConnection(ifxConnection);
        }
        return ifxObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static IfxObject makeInstance(IfxConnection ifxConnection, IfxColumnInfo ifxColumnInfo, int n, String string) throws SQLException {
        IfxObject ifxObject = null;
        if (ifxColumnInfo != null) {
            return IfxValue.makeInstance(ifxConnection, ifxColumnInfo);
        }
        int n2 = IfxTypes.FromJDBCToIfxType(n);
        if (n2 <= 18) return IfxValue.makeInstanceFromIfxType(ifxConnection, n2);
        if (n2 == 101) return IfxValue.makeInstanceFromIfxType(ifxConnection, n2);
        if (n2 == 102) {
            return IfxValue.makeInstanceFromIfxType(ifxConnection, n2);
        }
        IfxUDTInfo ifxUDTInfo = null;
        if (string == null) return ifxObject;
        if (n != 2003) {
            ifxUDTInfo = ifxConnection.getUDTInfo(ifxColumnInfo, string);
            if (ifxUDTInfo != null) return IfxValue.createInstanceByTypeInfo(ifxConnection, ifxUDTInfo);
            if (n2 != 22) throw IfxErrMsg.getSQLException(-79770, ifxConnection);
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n2);
            ifxObject.setExtendedTypeName(string);
            return ifxObject;
        } else {
            ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, n2);
            ifxObject.setExtendedTypeName(string);
        }
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Struct struct, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 22);
        ifxObject.fromObject(struct);
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Array array, String string, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 19);
        if (string == null) {
            ifxObject.fromObject(array);
        } else {
            ((IfxCollection)ifxObject).fromObject((Object)array, string);
        }
        return ifxObject;
    }

    static IfxObject makeInstance(IfxConnection ifxConnection, Collection collection, String string, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxObject ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 19);
        if (string == null) {
            ifxObject.fromObject(collection);
        } else {
            ((IfxCollection)ifxObject).fromObject((Object)collection, string);
        }
        if (collection.size() == 0 && ifxColumnInfo != null && IfxTypes.isCollection(ifxColumnInfo.SQLtype)) {
            ifxObject.setExtendedTypeName(ifxColumnInfo.ExtendedName);
        }
        return ifxObject;
    }

    private static IfxObject makeInstanceFromArray(IfxConnection ifxConnection, Object object, String string) throws SQLException {
        IfxObject ifxObject = IfxValue.makeInstanceFromIfxType(ifxConnection, 19);
        if (string == null) {
            ifxObject.fromObject(object);
        } else {
            ((IfxCollection)ifxObject).fromObject(object, string);
        }
        return ifxObject;
    }

    static {
        if (IfxTypeToObjectTable == null) {
            IfxTypeToObjectTable = new Hashtable(54, 1.0f);
            IfxTypeToObjectTable.put(0, "IfxChar");
            IfxTypeToObjectTable.put(1, "IfxShort");
            IfxTypeToObjectTable.put(2, "IfxInteger");
            IfxTypeToObjectTable.put(3, "IfxFloat");
            IfxTypeToObjectTable.put(4, "IfxSmallFloat");
            IfxTypeToObjectTable.put(5, "IfxDecimal");
            IfxTypeToObjectTable.put(6, "IfxInteger");
            IfxTypeToObjectTable.put(8, "IfxDecimal");
            IfxTypeToObjectTable.put(7, "IfxDate");
            IfxTypeToObjectTable.put(10, "IfxDateTime");
            IfxTypeToObjectTable.put(8, "IfxDecimal");
            IfxTypeToObjectTable.put(11, "IfxBlob");
            IfxTypeToObjectTable.put(12, "IfxBlob");
            IfxTypeToObjectTable.put(13, "IfxVarChar");
            IfxTypeToObjectTable.put(14, "IfxInterval");
            IfxTypeToObjectTable.put(15, "IfxChar");
            IfxTypeToObjectTable.put(16, "IfxVarChar");
        }
        if (IfxTypeToObjectTable_9x == null) {
            IfxTypeToObjectTable_9x = new Hashtable(10, 1.0f);
            IfxTypeToObjectTable_9x.put(17, "IfxInt8");
            IfxTypeToObjectTable_9x.put(18, "IfxInt8");
            IfxTypeToObjectTable_9x.put(19, "IfxCollection");
            IfxTypeToObjectTable_9x.put(20, "IfxCollection");
            IfxTypeToObjectTable_9x.put(21, "IfxCollection");
            IfxTypeToObjectTable_9x.put(22, "IfxRow");
            IfxTypeToObjectTable_9x.put(40, UDT_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(41, UDT_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(43, LVARCHAR_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(45, BOOLEAN_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(44, UDT_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(101, "IfxSmBlob");
            IfxTypeToObjectTable_9x.put(102, "IfxSmBlob");
            IfxTypeToObjectTable_9x.put(46, IMPEXP_CLASS_NAME);
            IfxTypeToObjectTable_9x.put(52, "IfxBigInt");
            IfxTypeToObjectTable_9x.put(53, "IfxBigInt");
        }
    }
}

