/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbcx;

import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.jdbcx.IfxConnectionPoolManager;
import com.gbasedbt.jdbcx.IfxPooledConnection;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.sql.Connection;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;

public class IfxConnectionEventListener
implements ConnectionEventListener {
    private IfxConnectionPoolManager IfxCPM = null;
    private Trace trace = null;

    public void IfxConnectionEventListener() {
        this.IfxCPM = null;
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        IfxPooledConnection ifxPooledConnection = (IfxPooledConnection)connectionEvent.getSource();
        if (TraceFlag.compiletrace) {
            try {
                Connection connection = ifxPooledConnection.getConnection();
                this.trace = ((IfxSqliConnect)connection).getTrace();
                this.trace.writeTrace(1, "IfxConnectionEventListener:connectionClosed(): called.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.IfxCPM != null) {
            this.IfxCPM.recycleConnection(ifxPooledConnection, 0);
        }
        if (TraceFlag.compiletrace && this.trace != null) {
            this.trace.writeTrace(1, "ConnectionEventListener:connectionClosed() exited.");
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        IfxPooledConnection ifxPooledConnection = (IfxPooledConnection)connectionEvent.getSource();
        if (TraceFlag.compiletrace) {
            try {
                Connection connection = ifxPooledConnection.getConnection();
                this.trace = ((IfxSqliConnect)connection).getTrace();
                this.trace.writeTrace(1, "IfxConnectionEventListener:connectionErrorOccurred(): called.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.IfxCPM != null) {
            this.IfxCPM.recycleConnection(ifxPooledConnection, 1);
        }
        if (TraceFlag.compiletrace && this.trace != null) {
            this.trace.writeTrace(1, "ConnectionEventListener:connectionErrorOccurred() exited.");
        }
    }

    void setParent(IfxConnectionPoolManager ifxConnectionPoolManager) {
        this.IfxCPM = ifxConnectionPoolManager;
    }
}

