/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbcx;

import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.jdbcx.IfxConnectionPoolDataSource;
import com.gbasedbt.jdbcx.IfxReUsableConnection;
import com.gbasedbt.jdbcx.IfxSqliConnReUsableConnection;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

public class IfxPooledConnection
implements PooledConnection {
    private Vector listeners = null;
    private Properties DSProp = null;
    private IfxReUsableConnection conn = null;
    private IfxConnectionPoolDataSource cpds = null;
    protected long timeInPool = 0L;
    Trace trace = null;

    public IfxPooledConnection() throws SQLException {
        this.listeners = new Vector();
        this.DSProp = null;
        this.conn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IfxPooledConnection(String string, String string2, IfxConnectionPoolDataSource ifxConnectionPoolDataSource) throws SQLException {
        int n;
        this.cpds = ifxConnectionPoolDataSource;
        this.conn = null;
        this.listeners = new Vector();
        this.DSProp = this.cpds.getDsProperties();
        String string3 = this.DSProp.getProperty("IFMX_CPM_MAX_CONNECTIONS");
        if (string3 == null || string3.length() == 0) {
            string3 = "-1";
        }
        if ((n = Integer.parseInt(string3)) != -1 && this.cpds.getConnectionCount() >= n) {
            throw IfxErrMsg.getLocSQLException(-79831, this.cpds.getIfxCLIENT_LOCALE());
        }
        this.establishConnection(string, string2);
        Properties properties = this.DSProp;
        synchronized (properties) {
            this.cpds.addToReferenceList(this);
        }
        if (TraceFlag.compiletrace && this.trace != null) {
            this.trace.writeTrace(1, "IfxPooledConnection.java:IfxPooledConnection() got pooled conn.");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxPooledConnection.java:getConnection() callled");
        }
        if (this.conn != null) {
            ((IfxSqliConnect)((Object)this.conn)).isOpen = true;
        }
        return (Connection)((Object)this.conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.conn == null) {
            return;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxPooledConnection.java:close() callled");
        }
        IfxConnectionPoolDataSource ifxConnectionPoolDataSource = this.cpds;
        synchronized (ifxConnectionPoolDataSource) {
            try {
                this.conn.hardClose();
            }
            finally {
                this.cpds.removeFromReferenceList(this);
            }
        }
        this.conn = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxPooledConnection.java:close() exited");
        }
    }

    @Override
    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.addElement(connectionEventListener);
    }

    @Override
    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (TraceFlag.compiletrace && this.trace != null) {
            this.trace.writeTrace(1, "IfxPooledConnection.java:removeConnectionEventListener() called");
        }
        this.listeners.removeElement(connectionEventListener);
    }

    void notifyListeners() throws SQLException {
        if (TraceFlag.compiletrace && this.trace != null) {
            this.trace.writeTrace(1, "IfxPooledConnection.java:notifyListeners() callled");
        }
        this.notifyListenersOfErrors(null);
        if (TraceFlag.compiletrace && this.trace != null) {
            this.trace.writeTrace(1, "IfxPooledConnection.java:notifyListeners() exited.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListenersOfErrors(SQLException sQLException) throws SQLException {
        if (TraceFlag.compiletrace && this.trace != null) {
            this.trace.writeTrace(1, "IfxPooledConnection.java:notifyListenersOfErrors() callled");
        }
        int n = 0;
        int n2 = 0;
        ConnectionEventListener connectionEventListener = null;
        Vector vector = null;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        n = vector.size();
        for (n2 = 0; n2 < n; ++n2) {
            connectionEventListener = (ConnectionEventListener)vector.elementAt(n2);
            if (sQLException != null) {
                connectionEventListener.connectionErrorOccurred(new ConnectionEvent(this, sQLException));
                throw sQLException;
            }
            connectionEventListener.connectionClosed(new ConnectionEvent(this));
        }
        if (TraceFlag.compiletrace && this.trace != null) {
            this.trace.writeTrace(1, "IfxPooledConnection.java:notifyListenersOfErrors() exited.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishConnection(String string, String string2) throws SQLException {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        string5 = this.DSProp.getProperty("IFXHOST");
        string6 = this.DSProp.getProperty("PORTNO");
        if (string5 != null && string6 != null) {
            string3 = string5 + ":" + string6;
        }
        if ((string4 = this.DSProp.getProperty("DATABASE")) != null) {
            try {
                this.conn = this.getClientServerReUsable(string, string2, string3, string4);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getLocSQLException(-79716, exception.toString(), this.cpds.getIfxCLIENT_LOCALE());
            }
            finally {
                Properties properties = this.DSProp;
                synchronized (properties) {
                    this.DSProp.setProperty("DATABASE", string4);
                }
            }
        }
        throw IfxErrMsg.getLocSQLException(-79716, "Missing DATABASE Property", this.cpds.getIfxCLIENT_LOCALE());
        if (TraceFlag.compiletrace && this.conn != null) {
            this.trace = ((IfxSqliConnect)((Object)this.conn)).getTrace();
            this.trace.writeTrace(1, "IfxPooledConnection:establishConnection() go a conn.");
        }
    }

    public void setTimeInPool() {
        this.timeInPool = System.currentTimeMillis();
    }

    private IfxReUsableConnection getClientServerReUsable(String string, String string2, String string3, String string4) throws SQLException {
        if (!this.cpds.checkIsDirect()) {
            IfxSqliConnReUsableConnection ifxSqliConnReUsableConnection = null;
            ifxSqliConnReUsableConnection = new IfxSqliConnReUsableConnection(string, string2, this, string3, this.DSProp, string4);
            return ifxSqliConnReUsableConnection;
        }
        Constructor constructor = this.cpds.getReUsableCons();
        Object[] objectArray = new Object[]{this, string3, this.DSProp, string4};
        if (constructor != null) {
            try {
                this.conn = (IfxReUsableConnection)constructor.newInstance(objectArray);
                return this.conn;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw IfxErrMsg.getLocSQLException(-79716, exception.toString());
            }
        }
        try {
            String string5 = "com.gbasedbt.jdbcx.IfxDirConnReUsableConnection";
            Class<?> clazz = Class.forName(string5);
            if (string3 == null) {
                string3 = "";
            }
            if (string4 == null) {
                string4 = "";
            }
            Class[] classArray = new Class[]{this.getClass(), string3.getClass(), this.DSProp.getClass(), string4.getClass()};
            Constructor<?> constructor2 = clazz.getConstructor(classArray);
            this.cpds.setReUsableCons(constructor2);
            this.conn = (IfxReUsableConnection)constructor2.newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw IfxErrMsg.getLocSQLException(-79716, exception.toString());
        }
        return this.conn;
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxPooledConnection:addStatementEventListener(StatementEventListener)not supported");
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxPooledConnection:addStatementEventListener(StatementEventListener)not supported");
        }
    }
}

