/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbcx;

import com.gbasedbt.jdbcx.IfxPooledConnection;
import com.gbasedbt.jdbcx.IfxXADataSource;
import com.gbasedbt.jdbcx.IfxXAResource;
import com.gbasedbt.jdbcx.IfxXAReusableConnection;
import com.gbasedbt.jdbcx.IfxXASqli;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

class IfxXAPooledConnection
extends IfxPooledConnection
implements XAConnection {
    private final int TMMTSDTC = 4096;
    private Vector listeners;
    private IfxXADataSource xads;
    private IfxXAReusableConnection conn;
    protected IfxXAResource xaRes;
    protected boolean connOpen;
    private String url;
    private String dbName;
    private IfxXASqli proto;
    private boolean isConnAvailable;

    public IfxXAPooledConnection() throws SQLException {
        this.listeners = new Vector();
        this.xads = null;
        this.conn = null;
        this.xaRes = null;
        this.url = null;
        this.dbName = null;
        this.proto = null;
        this.isConnAvailable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IfxXAPooledConnection(IfxXADataSource ifxXADataSource, String string, String string2) throws SQLException {
        Properties properties = new Properties();
        this.xaRes = null;
        this.url = null;
        this.dbName = null;
        this.proto = null;
        this.listeners = new Vector();
        this.xads = ifxXADataSource;
        properties.putAll((Map<?, ?>)this.xads.getDsProperties());
        Properties properties2 = properties;
        synchronized (properties2) {
            String string3 = properties.getProperty("IFXHOST");
            String string4 = properties.getProperty("PORTNO");
            if (string3 != null && string4 != null) {
                this.url = string3 + ":" + string4;
            }
            if ((this.dbName = properties.getProperty("DATABASE")) != null) {
                properties.remove("DATABASE");
            }
            try {
                this.conn = new IfxXAReusableConnection(string, string2, this, this.url, properties);
            }
            catch (SQLException sQLException) {
                this.conn = null;
                this.url = null;
                if (this.dbName != null) {
                    properties.put("DATABASE", this.dbName);
                }
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw sQLException;
            }
            if (this.dbName != null) {
                properties.put("DATABASE", this.dbName);
            }
            this.proto = (IfxXASqli)this.conn.getProto();
            this.openDBforXA();
            this.conn.setServerIsolationLevel();
        }
        this.connOpen = true;
        this.isConnAvailable = true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public void close() throws SQLException {
        block6: {
            SQLException sQLException = null;
            if (!this.connOpen) {
                return;
            }
            try {
                this.conn.hardClose();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            finally {
                this.conn = null;
                this.dbName = null;
                this.proto = null;
                this.xaRes = null;
                this.connOpen = false;
                if (sQLException == null) break block6;
                throw sQLException;
            }
        }
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        if (this.xaRes == null) {
            this.xaRes = new IfxXAResource(this.conn);
        }
        return this.xaRes;
    }

    void openDBforXA() throws SQLException {
        String string = this.xads.getIfxIFX_XASPEC();
        this.proto.executeXAOpen(this.dbName, 1, string.equals("y") ? 4096 : 0);
        this.connOpen = true;
    }

    void closeDBforXA() throws SQLException {
        this.proto.executeXAClose(this.dbName, 1, 0);
        this.connOpen = false;
    }
}

