/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.json;

import com.gbasedbt.json.AbstractObjectSerializer;
import com.gbasedbt.json.Bytes;
import com.gbasedbt.json.ObjectSerializer;
import java.util.Iterator;
import java.util.List;
import org.bson.util.ClassMap;

public class ClassMapBasedObjectSerializer
extends AbstractObjectSerializer {
    private ClassMap<ObjectSerializer> _serializers = new ClassMap();

    public void addObjectSerializer(Class<?> clazz, ObjectSerializer objectSerializer) {
        this._serializers.put(clazz, objectSerializer);
    }

    @Override
    public void serialize(Object object, StringBuilder stringBuilder) {
        Class<?> clazz;
        if ((object = Bytes.applyEncodingHooks(object)) == null) {
            stringBuilder.append(" null ");
            return;
        }
        ObjectSerializer objectSerializer = null;
        List<Class<?>> list = ClassMap.getAncestry(object.getClass());
        Iterator<Class<?>> iterator = list.iterator();
        while (iterator.hasNext() && (objectSerializer = this._serializers.get(clazz = iterator.next())) == null) {
        }
        if (objectSerializer == null && object.getClass().isArray()) {
            objectSerializer = this._serializers.get(Object[].class);
        }
        if (objectSerializer == null) {
            throw new RuntimeException("json can't serialize type : " + object.getClass());
        }
        objectSerializer.serialize(object, stringBuilder);
    }
}

