/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.lang;

import com.gbasedbt.lang.Decimal;
import com.gbasedbt.lang.Interval;
import com.gbasedbt.util.IfxErrMsg;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class IfxToJavaType {
    private static final ThreadLocal<Calendar> localCalendar = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    };
    public static final int DAYS1900 = 693594;
    public static final int DAYS4CENT = 146097;
    public static final int DAYS4YEAR = 1461;
    CharsetDecoder dec = null;
    CharsetDecoder defdec = null;

    public synchronized String IfxToJavaChar(byte[] byArray, short s, boolean bl) throws IOException {
        return this.IfxToJavaChar(byArray, bl);
    }

    public synchronized String IfxToJavaChar(byte[] byArray, boolean bl) throws IOException {
        int n;
        for (n = byArray.length; n > 0 && byArray[n - 1] == 0; --n) {
        }
        return this.IfxToJavaChar(byArray, 0, n, bl);
    }

    public synchronized String IfxToJavaChar(byte[] byArray, int n, int n2, short s, boolean bl) throws IOException {
        return this.IfxToJavaChar(byArray, n, n2, bl);
    }

    public synchronized String IfxToJavaChar(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        String string = this.IfxToJavaChar(byArray, n, n2, "ISO8859_1", bl);
        return string;
    }

    public synchronized String IfxToJavaChar(byte[] byArray, short s, String string, boolean bl) throws IOException {
        return this.IfxToJavaChar(byArray, 0, byArray.length, string, bl);
    }

    public synchronized String IfxToJavaChar(byte[] byArray, String string, boolean bl) throws IOException {
        return this.IfxToJavaChar(byArray, 0, byArray.length, string, bl);
    }

    public synchronized String IfxToJavaChar(byte[] byArray, int n, int n2, short s, String string, boolean bl) throws IOException {
        return this.IfxToJavaChar(byArray, n, n2, string, bl);
    }

    public synchronized String IfxToJavaChar(byte[] byArray, int n, int n2, String string, boolean bl) throws IOException {
        String string2 = null;
        if (bl) {
            string2 = string != null ? new String(byArray, n, n2, string == "ISO2022CN_GB" ? "ISO2022CN" : string) : new String(byArray, n, n2, "ISO8859_1");
        } else {
            CharsetDecoder charsetDecoder = null;
            if (string == null) {
                string = "ISO8859_1";
            }
            if (!string.equals("ISO8859_1") && !string.equals("NOCODING")) {
                if (this.dec == null) {
                    this.dec = Charset.forName(string == "ISO2022CN_GB" ? "ISO2022CN" : string).newDecoder();
                }
                charsetDecoder = this.dec;
            } else {
                if (this.defdec == null) {
                    this.defdec = Charset.forName("ISO8859_1").newDecoder();
                }
                charsetDecoder = this.defdec;
            }
            charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
            byteBuffer.put(byArray, n, n2);
            byteBuffer.position(0);
            try {
                if (string.equals("NOCODING")) {
                    string2 = new String(byArray, n, n2);
                } else {
                    CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
                    string2 = charBuffer.toString();
                    if (string2.length() == 0 && n2 == 1) {
                        byteBuffer = ByteBuffer.allocate(n2 + 1);
                        byteBuffer.put(byArray, n, n2);
                        byteBuffer.position(0);
                        string2 = charsetDecoder.decode(byteBuffer).toString().substring(0, n2);
                    }
                }
            }
            catch (CharacterCodingException characterCodingException) {
                throw new IOException(IfxErrMsg.getMessage(-23103));
            }
        }
        return string2;
    }

    public static Date IfxToJavaDate(byte[] byArray, short s) {
        return IfxToJavaType.IfxToJavaDate(byArray, 0);
    }

    public static Date IfxToJavaDate(byte[] byArray) {
        return IfxToJavaType.IfxToJavaDate(byArray, 0);
    }

    public static Date IfxToJavaDate(byte[] byArray, int n, int n2, short s) {
        return IfxToJavaType.IfxToJavaDate(byArray, n);
    }

    public static Date IfxToJavaDate(byte[] byArray, int n) {
        int n2 = IfxToJavaType.IfxToJavaInt(byArray, n);
        if (n2 == Integer.MIN_VALUE) {
            return null;
        }
        return IfxToJavaType.convertDaysToDate(n2);
    }

    public static final boolean rleapyear(int n) {
        return (n & 3) == 0 && (n % 400 == 0 || n % 100 != 0);
    }

    public static Date convertDaysToDate(int n) {
        int n2;
        int n3 = n + 693594;
        byte[] byArray = new byte[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int n4 = (n3 * 4 + 3) / 146097;
        n3 -= n4 * 146097 / 4;
        int n5 = n4 * 100;
        n4 = (n3 * 4 + 3) / 1461;
        int n6 = (n3 -= n4 * 1461 / 4) + 1;
        byArray[2] = IfxToJavaType.rleapyear(n5 += n4 + 1) ? 29 : 28;
        for (n2 = 1; n2 <= 12 && n6 > byArray[n2]; n6 -= byArray[n2], ++n2) {
        }
        GregorianCalendar gregorianCalendar = (GregorianCalendar)localCalendar.get();
        gregorianCalendar.set(n5, n2 - 1, n6, 0, 0, 0);
        Date date = new Date(gregorianCalendar.getTimeInMillis());
        return date;
    }

    public static int convertDateToDays(Date date) {
        byte[] byArray = new byte[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(2) + 1;
        int n2 = calendar.get(5);
        int n3 = calendar.get(1);
        byArray[2] = IfxToJavaType.rleapyear(n3) ? 29 : 28;
        int n4 = n3 - 1;
        int n5 = n4 / 100 * 146097 / 4 + n4 % 100 * 1461 / 4 + n2 - 1 - 693594;
        for (int i = 1; i < n; ++i) {
            n5 += byArray[i];
        }
        return n5;
    }

    public static Timestamp IfxToJavaDateTime(byte[] byArray, short s) {
        return IfxToJavaType.IfxToJavaDateTime(byArray, 0, byArray.length, s, null);
    }

    public static Timestamp IfxToJavaDateTime(byte[] byArray, int n, int n2, short s) {
        return IfxToJavaType.IfxToJavaDateTime(byArray, n, n2, s, null);
    }

    public static Timestamp IfxToJavaDateTime(byte[] byArray, int n, int n2, short s, Calendar calendar) {
        Decimal decimal = new Decimal(byArray, n, n2, s, true);
        return decimal.timestampValue(calendar);
    }

    public static String IfxToDateTimeUnloadString(byte[] byArray, int n, int n2, short s) {
        Decimal decimal = new Decimal(byArray, n, n2, s, true);
        return decimal.timestampStringValue();
    }

    public static Interval IfxToJavaInterval(byte[] byArray, short s) {
        return IfxToJavaType.IfxToJavaInterval(byArray, 0, byArray.length, s);
    }

    public static Interval IfxToJavaInterval(byte[] byArray, int n, int n2, short s) {
        Decimal decimal = new Decimal(byArray, n, n2, s, true);
        if (decimal.dec_pos == -1) {
            return null;
        }
        return decimal.intervalValue();
    }

    public static BigDecimal IfxToJavaDecimal(byte[] byArray, short s) {
        return IfxToJavaType.IfxToJavaDecimal(byArray, 0, byArray.length, s);
    }

    public static BigDecimal IfxToJavaDecimal(byte[] byArray, int n, int n2, short s) {
        Decimal decimal = new Decimal(byArray, n, n2, s);
        return decimal.numericValue();
    }

    public static double IfxToJavaDouble(byte[] byArray, short s) {
        return IfxToJavaType.IfxToJavaDouble(byArray, 0);
    }

    public static double IfxToJavaDouble(byte[] byArray) {
        return IfxToJavaType.IfxToJavaDouble(byArray, 0);
    }

    public static double IfxToJavaDouble(byte[] byArray, int n, int n2, short s) {
        return IfxToJavaType.IfxToJavaDouble(byArray, n);
    }

    public static double IfxToJavaDouble(byte[] byArray, int n) {
        long l = (long)byArray[0 + n] << 56 | (long)byArray[1 + n] << 48 & 0xFF000000000000L | (long)byArray[2 + n] << 40 & 0xFF0000000000L | (long)byArray[3 + n] << 32 & 0xFF00000000L | (long)byArray[4 + n] << 24 & 0xFF000000L | (long)byArray[5 + n] << 16 & 0xFF0000L | (long)byArray[6 + n] << 8 & 0xFF00L | (long)byArray[7 + n] & 0xFFL;
        return Double.longBitsToDouble(l);
    }

    public static float IfxToJavaReal(byte[] byArray, short s) {
        return IfxToJavaType.IfxToJavaReal(byArray, 0);
    }

    public static float IfxToJavaReal(byte[] byArray) {
        return IfxToJavaType.IfxToJavaReal(byArray, 0);
    }

    public static float IfxToJavaReal(byte[] byArray, int n, int n2, short s) {
        return IfxToJavaType.IfxToJavaReal(byArray, n);
    }

    public static float IfxToJavaReal(byte[] byArray, int n) {
        int n2 = IfxToJavaType.IfxToJavaInt(byArray, n);
        return Float.intBitsToFloat(n2);
    }

    protected static final short widenByte(byte by) {
        return (short)((short)by & 0xFF);
    }

    public static short IfxToJavaSmallInt(byte[] byArray, short s) {
        return IfxToJavaType.IfxToJavaSmallInt(byArray, 0);
    }

    public static short IfxToJavaSmallInt(byte[] byArray) {
        return IfxToJavaType.IfxToJavaSmallInt(byArray, 0);
    }

    public static short IfxToJavaSmallInt(byte[] byArray, int n, int n2, short s) {
        return IfxToJavaType.IfxToJavaSmallInt(byArray, n);
    }

    public static short IfxToJavaSmallInt(byte[] byArray, int n) {
        short s = byArray[0 + n];
        s = (short)((s << 8) + IfxToJavaType.widenByte(byArray[1 + n]));
        return s;
    }

    public static int IfxToJavaInt(byte[] byArray, short s) {
        return IfxToJavaType.IfxToJavaInt(byArray, 0);
    }

    public static int IfxToJavaInt(byte[] byArray) {
        return IfxToJavaType.IfxToJavaInt(byArray, 0);
    }

    public static int IfxToJavaInt(byte[] byArray, int n, int n2, short s) {
        return IfxToJavaType.IfxToJavaInt(byArray, n);
    }

    public static int IfxToJavaInt(byte[] byArray, int n) {
        int n2 = byArray[n];
        n2 = (((n2 << 8) + IfxToJavaType.widenByte(byArray[n + 1]) << 8) + IfxToJavaType.widenByte(byArray[n + 2]) << 8) + IfxToJavaType.widenByte(byArray[n + 3]);
        return n2;
    }

    public static long IfxToJavaLongInt(byte[] byArray, short s) {
        return IfxToJavaType.IfxToJavaLongInt(byArray, 0);
    }

    public static long IfxToJavaLongInt(byte[] byArray) {
        return IfxToJavaType.IfxToJavaLongInt(byArray, 0);
    }

    public static long IfxToJavaLongInt(byte[] byArray, int n, int n2, short s) {
        return IfxToJavaType.IfxToJavaLongInt(byArray, n);
    }

    public static long IfxToJavaLongInt(byte[] byArray, int n) {
        long l = Long.MIN_VALUE;
        short s = (short)((byArray[n] << 8) + IfxToJavaType.widenByte(byArray[n + 1]));
        if (s != 0) {
            l = 0xFF & byArray[n + 6];
            l = l << 8 | (long)(0xFF & byArray[n + 7]);
            l = l << 8 | (long)(0xFF & byArray[n + 8]);
            l = l << 8 | (long)(0xFF & byArray[n + 9]);
            l = l << 8 | (long)(0xFF & byArray[n + 2]);
            l = l << 8 | (long)(0xFF & byArray[n + 3]);
            l = l << 8 | (long)(0xFF & byArray[n + 4]);
            l = l << 8 | (long)(0xFF & byArray[n + 5]);
            if (s == -1) {
                l *= -1L;
            }
        }
        return l;
    }

    public static long IfxToJavaLongBigInt(byte[] byArray, short s) {
        return IfxToJavaType.IfxToJavaLongBigInt(byArray, 0);
    }

    public static long IfxToJavaLongBigInt(byte[] byArray) {
        return IfxToJavaType.IfxToJavaLongBigInt(byArray, 0);
    }

    public static long IfxToJavaLongBigInt(byte[] byArray, int n, int n2, short s) {
        return IfxToJavaType.IfxToJavaLongBigInt(byArray, n);
    }

    public static long IfxToJavaLongBigInt(byte[] byArray, int n) {
        long l = byArray[n];
        l = (((((((l << 8) + (long)IfxToJavaType.widenByte(byArray[n + 1]) << 8) + (long)IfxToJavaType.widenByte(byArray[n + 2]) << 8) + (long)IfxToJavaType.widenByte(byArray[n + 3]) << 8) + (long)IfxToJavaType.widenByte(byArray[n + 4]) << 8) + (long)IfxToJavaType.widenByte(byArray[n + 5]) << 8) + (long)IfxToJavaType.widenByte(byArray[n + 6]) << 8) + (long)IfxToJavaType.widenByte(byArray[n + 7]);
        return l;
    }
}

