/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.lang;

import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.util.IfxErrMsg;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class Interval {
    public static final byte TU_YEAR = 0;
    public static final byte TU_MONTH = 2;
    public static final byte TU_DAY = 4;
    public static final byte TU_HOUR = 6;
    public static final byte TU_MINUTE = 8;
    public static final byte TU_SECOND = 10;
    public static final byte TU_FRAC = 12;
    public static final byte TU_F1 = 11;
    public static final byte TU_F2 = 12;
    public static final byte TU_F3 = 13;
    public static final byte TU_F4 = 14;
    public static final byte TU_F5 = 15;
    protected static final int DECSIZE = 16;
    protected static final int NUMBER_UNITS = 7;
    protected static final int YEAR_IDX = 0;
    protected static final int MONTH_IDX = 1;
    protected static final int DAY_IDX = 2;
    protected static final int HOUR_IDX = 3;
    protected static final int MIN_IDX = 4;
    protected static final int SEC_IDX = 5;
    protected static final int FRAC_IDX = 6;
    protected static final char[] dtdelim = new char[]{'-', '-', ' ', ':', ':', '.', ' '};
    protected static final boolean DEBUG = true;
    protected static boolean debugFlag = false;
    protected short int_qual = 0;
    private String locale = null;
    private static String staticlocale = null;

    protected Interval() throws SQLException {
    }

    protected Interval(Connection connection) throws SQLException {
        this.setConnection(connection);
    }

    public static byte getLength(short s) {
        return (byte)(s >> 8);
    }

    protected byte getLength() {
        return Interval.getLength(this.int_qual);
    }

    public short getQualifier() {
        return this.int_qual;
    }

    public static short getQualifier(byte by, byte by2, byte by3) throws SQLException {
        Interval.goodQualifier(by, by2, by3);
        byte by4 = (byte)(by3 - by2 + by);
        short s = (short)(by4 << 8 | by2 << 4 | by3);
        return s;
    }

    protected short getQualifier(byte by, byte by2) throws SQLException {
        this.goodQualifier(by, by2);
        short s = (short)(by2 - by + (by == 0 ? 4 : 2));
        short s2 = (short)((byte)s << 8 | by << 4 | by2);
        return s2;
    }

    public static void goodQualifier(byte by, byte by2, byte by3) throws SQLException {
        if (by < 0 || by > 9) {
            throw IfxErrMsg.getSQLException(-79717, "", staticlocale);
        }
        if (by2 < 0 || by2 > 15) {
            throw IfxErrMsg.getSQLException(-79718, "", staticlocale);
        }
        if (by3 < 0 || by3 > 15) {
            throw IfxErrMsg.getSQLException(-79719, "", staticlocale);
        }
    }

    protected boolean goodQualifier(byte by, byte by2) throws SQLException {
        if (by > by2) {
            throw IfxErrMsg.getSQLException(-79720, "", this.locale);
        }
        if (by < 0 || by > 15) {
            throw IfxErrMsg.getSQLException(-79718, "", this.locale);
        }
        if (by2 < 0 || by2 > 15) {
            throw IfxErrMsg.getSQLException(-79719, "", this.locale);
        }
        return true;
    }

    public static byte getScale(short s) {
        byte by = Interval.getEndCode(s);
        byte by2 = 0;
        if (by > 10) {
            by2 = (byte)(by - 10);
        }
        return by2;
    }

    public static byte getStartCode(short s) {
        byte by = (byte)(s >> 4 & 0xF);
        return by;
    }

    public static byte getEndCode(short s) {
        byte by = (byte)(s & 0xF);
        return by;
    }

    public byte getStartCode() {
        return Interval.getStartCode(this.int_qual);
    }

    public byte getEndCode() {
        return Interval.getEndCode(this.int_qual);
    }

    protected byte getFirstLength(short s) {
        int n = Interval.getLength(s) - (Interval.getEndCode(s) - Interval.getStartCode(s));
        byte by = (byte)n;
        return by;
    }

    public static byte getStaticStartCode(short s) {
        byte by = (byte)(s >> 4 & 0xF);
        return by;
    }

    public static byte getStaticEndCode(short s) {
        byte by = (byte)(s & 0xF);
        return by;
    }

    public static String getFieldName(byte by) {
        switch (by) {
            case 0: {
                return "year";
            }
            case 2: {
                return "month";
            }
            case 4: {
                return "day";
            }
            case 6: {
                return "hour";
            }
            case 8: {
                return "minute";
            }
            case 10: {
                return "second";
            }
            case 11: {
                return "fraction(1)";
            }
            case 12: {
                return "fraction(2)";
            }
            case 13: {
                return "fraction(3)";
            }
            case 14: {
                return "fraction(4)";
            }
            case 15: {
                return "fraction(5)";
            }
        }
        return "";
    }

    public static String getIfxTypeName(int n, short s) {
        String string = null;
        if (n == 14) {
            string = "interval ";
        } else if (n == 10) {
            string = "datetime ";
        } else {
            return null;
        }
        string = string + Interval.getFieldName(Interval.getStaticStartCode(s)) + " to " + Interval.getFieldName(Interval.getStaticEndCode(s));
        return string;
    }

    protected int[] stringToUnits(String string, short s) throws SQLException {
        int n;
        int[] nArray = new int[7];
        for (n = 0; n < 7; ++n) {
            nArray[n] = 0;
        }
        n = Interval.getEndCode(s);
        int n2 = Interval.getStartCode(s);
        byte by = Interval.getLength(s);
        string = string.trim();
        int n3 = 0;
        if (string.length() == 0) {
            return nArray;
        }
        Interval.println("str --" + string + "--");
        Interval.println("startCode " + n2 + " endCode " + n + " qual " + Integer.toString(s, 16));
        try {
            int n4;
            int n5;
            if (n2 == 12) {
                if (string.charAt(n3) == '0') {
                    ++n3;
                }
                if (string.charAt(n3) != '.') {
                    throw IfxErrMsg.getLocSQLMinorException(-79721, -80000, this.locale);
                }
                ++n3;
            } else {
                for (n5 = 0; n5 < string.length() && Character.isDigit(string.charAt(n3 + n5)); n5 = (int)((byte)(n5 + 1))) {
                }
                Interval.println("fwidth " + by + " numDigits " + n5);
                if (n5 == 0) {
                    throw IfxErrMsg.getLocSQLMinorException(-79721, -80001, this.locale);
                }
                if (n5 > by) {
                    throw IfxErrMsg.getLocSQLMinorException(-79721, -80002, this.locale);
                }
                nArray[n2 / 2] = Integer.parseInt(string.substring(n3, n3 + n5));
                Interval.println("data[" + n2 / 2 + "]: " + nArray[n2 / 2]);
                n3 += n5 + 1;
                n2 = (byte)(n2 + 2);
            }
            while (n2 <= n && n2 <= 10) {
                n5 = n3;
                n4 = n3 + 1;
                if (!Character.isDigit(string.charAt(n3)) && string.charAt(n3) != ' ') {
                    throw IfxErrMsg.getLocSQLMinorException(-79722, -80003, Integer.toString(n3), this.locale);
                }
                if (n4 < string.length() && Character.isDigit(string.charAt(n4))) {
                    n5 = n4++;
                }
                nArray[n2 / 2] = Integer.parseInt(string.substring(n3, n5 + 1));
                Interval.println("data[" + n2 / 2 + "]: " + nArray[n2 / 2]);
                Interval.println("strIdx " + n3 + " endIdx " + n5 + " idx " + n4);
                if (n4 < string.length() && string.charAt(n4) != dtdelim[n2 / 2]) {
                    if (n2 == n) break;
                    Interval.println("startCode " + n2 + " idx " + n4);
                    throw IfxErrMsg.getLocSQLMinorException(-79723, -80003, Integer.toString(n4), this.locale);
                }
                n3 = n4 + 1;
                n2 = (byte)(n2 + 2);
            }
            if (n3 < string.length()) {
                Interval.println("fraction part if any :" + string.substring(n3) + ":");
                n5 = n3 - 1;
                n4 = n3;
                n2 = 11;
                int n6 = 0;
                while (n4 < string.length() && n2 <= n && Character.isDigit(string.charAt(n4))) {
                    ++n5;
                    ++n4;
                    n2 = (byte)(n2 + 1);
                    ++n6;
                }
                if (n5 >= n3) {
                    int n7 = Integer.parseInt(string.substring(n3, n5 + 1));
                    int n8 = 9 - n6;
                    for (int i = 0; i < n8; ++i) {
                        n7 *= 10;
                    }
                    nArray[6] = n7;
                }
                n3 = n4;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw IfxErrMsg.getLocSQLException(-79724, this.locale);
        }
        if (n3 < string.length()) {
            throw IfxErrMsg.getSQLException(-79725, string.substring(n3), this.locale);
        }
        return nArray;
    }

    protected static void print(String string) {
        if (debugFlag) {
            System.out.print(string);
        }
    }

    protected static void println(String string) {
        if (debugFlag) {
            System.out.println(string);
        }
    }

    public void setConnection(Connection connection) {
        if (connection != null) {
            this.locale = ((IfxConnection)connection).getclLocale();
        }
        Interval.setStaticLocale(this.locale);
    }

    private static void setStaticLocale(String string) {
        staticlocale = string;
    }
}

