/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.lang;

import com.gbasedbt.lang.Interval;
import com.gbasedbt.util.IfxErrMsg;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class IntervalYM
extends Interval {
    private static final ThreadLocal<Calendar> localCalendar = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    };
    protected long months;
    private String locale = null;
    protected static final int MonthsPerYear = 12;

    public IntervalYM() throws SQLException {
        this.setQualifier((byte)4, (byte)0, (byte)2);
    }

    public IntervalYM(Connection connection) throws SQLException {
        this();
        this.setConnection(connection);
    }

    public IntervalYM(Timestamp timestamp, Timestamp timestamp2) throws SQLException {
        this.setQualifier((byte)4, (byte)0, (byte)2);
        this.set(timestamp, timestamp2);
    }

    public IntervalYM(Timestamp timestamp, Timestamp timestamp2, Connection connection) throws SQLException {
        this(timestamp, timestamp2);
        this.setConnection(connection);
    }

    public IntervalYM(int n, int n2) throws SQLException {
        this.setQualifier((byte)4, (byte)0, (byte)2);
        this.set(n, n2);
    }

    public IntervalYM(int n, int n2, Connection connection) throws SQLException {
        this(n, n2);
        this.setConnection(connection);
    }

    public IntervalYM(int n, short s) throws SQLException {
        this.setQualifier(s);
        this.months = n;
    }

    public IntervalYM(int n, short s, Connection connection) throws SQLException {
        this(n, s);
        this.setConnection(connection);
    }

    public IntervalYM(String string) throws SQLException {
        this.setQualifier((byte)4, (byte)0, (byte)2);
        this.set(string);
    }

    public IntervalYM(String string, Connection connection) throws SQLException {
        this(string);
        this.setConnection(connection);
    }

    public IntervalYM(String string, short s) throws SQLException {
        this.setQualifier(s);
        this.set(string);
    }

    public IntervalYM(String string, short s, Connection connection) throws SQLException {
        this(string, s);
        this.setConnection(connection);
    }

    public IntervalYM(String string, int n, byte by, byte by2) throws SQLException {
        this.setQualifier((byte)n, by, by2);
        this.set(string);
    }

    public IntervalYM(String string, int n, byte by, byte by2, Connection connection) throws SQLException {
        this(string, n, by, by2);
        this.setConnection(connection);
    }

    public void set(Timestamp timestamp, Timestamp timestamp2) {
        GregorianCalendar gregorianCalendar = (GregorianCalendar)localCalendar.get();
        GregorianCalendar gregorianCalendar2 = (GregorianCalendar)localCalendar.get();
        gregorianCalendar.setTime(timestamp);
        gregorianCalendar2.setTime(timestamp2);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar2.get(1);
        int n3 = gregorianCalendar.get(2);
        int n4 = gregorianCalendar2.get(2);
        int n5 = n - n2;
        int n6 = n3 - n4;
        this.set(n5, n6);
    }

    public void set(int n, int n2) {
        if (n < 0) {
            if (n2 > 0) {
                ++n;
                n2 -= 12;
            }
        } else if (n2 < 0 && n > 0) {
            --n;
            n2 += 12;
        }
        this.months = n2 + n * 12;
    }

    public void set(String string) throws SQLException {
        this.fromString(string);
    }

    public String toString() {
        String string;
        short s = this.getQualifier();
        byte by = IntervalYM.getEndCode(s);
        byte by2 = IntervalYM.getStartCode(s);
        long l = this.months;
        boolean bl = false;
        if (l < 0L) {
            bl = true;
            l = -l;
        }
        if (by2 == 0 && by == 2) {
            String string2 = String.valueOf(l / 12L);
            String string3 = "";
            if (l % 12L < 10L) {
                string3 = "0";
            }
            string3 = string3 + String.valueOf(l % 12L);
            string = string2 + dtdelim[0] + string3;
        } else if (by2 == 0) {
            string = String.valueOf(l / 12L);
        } else if (by2 == 2) {
            string = String.valueOf(l);
        } else {
            throw new NumberFormatException("Invalid qualifier for IntervalYM");
        }
        if (bl) {
            string = "-" + string;
        }
        return string;
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            return;
        }
        short s = this.getQualifier();
        string = string.trim();
        boolean bl = false;
        if (string.length() > 0 && (string.charAt(0) == '-' || string.charAt(0) == '+')) {
            if (string.length() == 1) {
                throw IfxErrMsg.getLocSQLException(-79706, this.locale);
            }
            if (string.charAt(0) == '-') {
                bl = true;
            }
            string = string.substring(1);
        }
        int[] nArray = this.stringToUnits(string, s);
        this.months = nArray[0] * 12 + nArray[1];
        if (bl) {
            this.months = -this.months;
        }
    }

    public long getMonths() {
        return this.months;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof IntervalYM && object != null) {
            bl = this.months == ((IntervalYM)object).getMonths();
        }
        return bl;
    }

    public boolean greaterThan(IntervalYM intervalYM) {
        return intervalYM != null && this.months > intervalYM.getMonths();
    }

    public boolean lessThan(IntervalYM intervalYM) {
        return intervalYM != null && this.months < intervalYM.getMonths();
    }

    public void setQualifier(byte by, byte by2, byte by3) throws SQLException {
        if (by2 > 2 || by3 > 2 || by2 > by3) {
            throw IfxErrMsg.getLocSQLException(-79707, this.locale);
        }
        this.int_qual = (short)(by3 - by2 + by << 8 | by2 << 4 | by3);
    }

    public void setQualifier(short s) throws SQLException {
        byte by = IntervalYM.getStartCode(s);
        byte by2 = IntervalYM.getEndCode(s);
        if (by > 2 || by2 > 2 || by > by2) {
            throw IfxErrMsg.getLocSQLException(-79707, this.locale);
        }
        this.int_qual = s;
    }
}

