/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.rws;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;

public class RwsDataSource {
    private static ConcurrentHashMap<String, DataSource> pool = new ConcurrentHashMap();
    private static ReentrantLock lock = new ReentrantLock();

    public static DataSource getDataSource(String string) {
        if (!pool.containsKey(string)) {
            try {
                lock.lock();
                if (!pool.containsKey(string)) {
                    DataSource dataSource = RwsDataSource.dataSource("rws.properties");
                    pool.put(string, dataSource);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return pool.get(string);
    }

    public static DataSource dataSource(String string) {
        DataSource dataSource = null;
        String string2 = System.getProperty("rws.path");
        InputStream inputStream = null;
        Reader reader = null;
        Properties properties = new Properties();
        try {
            inputStream = string2 == null ? RwsDataSource.class.getResourceAsStream("/" + string) : new FileInputStream(string2 + "/" + string);
            reader = new InputStreamReader(inputStream, "utf-8");
            properties.load(reader);
            String string3 = "com.zaxxer.hikari.HikariConfig";
            Class<?> clazz = Class.forName(string3);
            Class[] classArray = new Class[]{Properties.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{properties};
            Object obj = constructor.newInstance(objectArray);
            String string4 = "com.zaxxer.hikari.HikariDataSource";
            Class<?> clazz2 = Class.forName(string4);
            Class[] classArray2 = new Class[]{obj.getClass()};
            Constructor<?> constructor2 = clazz2.getConstructor(classArray2);
            Object[] objectArray2 = new Object[]{obj};
            Object obj2 = constructor2.newInstance(objectArray2);
            dataSource = (DataSource)obj2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return dataSource;
    }
}

