/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.bson.BSONDecoder;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.Transformer;
import org.bson.util.ClassMap;

public class BSON {
    static final Logger LOGGER = Logger.getLogger("org.bson.BSON");
    public static final byte EOO = 0;
    public static final byte NUMBER = 1;
    public static final byte STRING = 2;
    public static final byte OBJECT = 3;
    public static final byte ARRAY = 4;
    public static final byte BINARY = 5;
    public static final byte UNDEFINED = 6;
    public static final byte OID = 7;
    public static final byte BOOLEAN = 8;
    public static final byte DATE = 9;
    public static final byte NULL = 10;
    public static final byte REGEX = 11;
    public static final byte REF = 12;
    public static final byte CODE = 13;
    public static final byte SYMBOL = 14;
    public static final byte CODE_W_SCOPE = 15;
    public static final byte NUMBER_INT = 16;
    public static final byte TIMESTAMP = 17;
    public static final byte NUMBER_LONG = 18;
    public static final byte MINKEY = -1;
    public static final byte MAXKEY = 127;
    public static final byte B_GENERAL = 0;
    public static final byte B_FUNC = 1;
    public static final byte B_BINARY = 2;
    public static final byte B_UUID = 3;
    private static final int GLOBAL_FLAG = 256;
    private static boolean _encodeHooks = false;
    private static boolean _decodeHooks = false;
    static ClassMap<List<Transformer>> _encodingHooks = new ClassMap();
    static ClassMap<List<Transformer>> _decodingHooks = new ClassMap();
    protected static Charset _utf8 = Charset.forName("UTF-8");
    static ThreadLocal<BSONEncoder> _staticEncoder = new ThreadLocal<BSONEncoder>(){

        @Override
        protected BSONEncoder initialValue() {
            return new BasicBSONEncoder();
        }
    };
    static ThreadLocal<BSONDecoder> _staticDecoder = new ThreadLocal<BSONDecoder>(){

        @Override
        protected BSONDecoder initialValue() {
            return new BasicBSONDecoder();
        }
    };

    public static int regexFlags(String string) {
        int n = 0;
        if (string == null || string.length() == 0) {
            return n;
        }
        string = string.toLowerCase();
        for (int i = 0; i < string.length(); ++i) {
            RegexFlag regexFlag = RegexFlag.getByCharacter(string.charAt(i));
            if (regexFlag != null) {
                n |= regexFlag.javaFlag;
                if (regexFlag.unsupported == null) continue;
                BSON._warnUnsupportedRegex(regexFlag.unsupported);
                continue;
            }
            throw new IllegalArgumentException("unrecognized flag [" + string.charAt(i) + "] " + string.charAt(i));
        }
        return n;
    }

    public static int regexFlag(char c) {
        RegexFlag regexFlag = RegexFlag.getByCharacter(c);
        if (regexFlag == null) {
            throw new IllegalArgumentException("unrecognized flag [" + c + "]");
        }
        if (regexFlag.unsupported != null) {
            BSON._warnUnsupportedRegex(regexFlag.unsupported);
            return 0;
        }
        return regexFlag.javaFlag;
    }

    public static String regexFlags(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (RegexFlag regexFlag : RegexFlag.values()) {
            if ((n & regexFlag.javaFlag) <= 0) continue;
            stringBuilder.append(regexFlag.flagChar);
            n -= regexFlag.javaFlag;
        }
        if (n > 0) {
            throw new IllegalArgumentException("some flags could not be recognized.");
        }
        return stringBuilder.toString();
    }

    private static void _warnUnsupportedRegex(String string) {
        LOGGER.info("flag " + string + " not supported by db.");
    }

    public static boolean hasDecodeHooks() {
        return _decodeHooks;
    }

    public static void addEncodingHook(Class<?> clazz, Transformer transformer) {
        _encodeHooks = true;
        List<Transformer> list = _encodingHooks.get(clazz);
        if (list == null) {
            list = new CopyOnWriteArrayList<Transformer>();
            _encodingHooks.put(clazz, list);
        }
        list.add(transformer);
    }

    public static void addDecodingHook(Class<?> clazz, Transformer transformer) {
        _decodeHooks = true;
        List<Transformer> list = _decodingHooks.get(clazz);
        if (list == null) {
            list = new CopyOnWriteArrayList<Transformer>();
            _decodingHooks.put(clazz, list);
        }
        list.add(transformer);
    }

    public static Object applyEncodingHooks(Object object) {
        if (!BSON._anyHooks()) {
            return object;
        }
        if (_encodingHooks.size() == 0 || object == null) {
            return object;
        }
        List<Transformer> list = _encodingHooks.get(object.getClass());
        if (list != null) {
            for (Transformer transformer : list) {
                object = transformer.transform(object);
            }
        }
        return object;
    }

    public static Object applyDecodingHooks(Object object) {
        if (!BSON._anyHooks() || object == null) {
            return object;
        }
        List<Transformer> list = _decodingHooks.get(object.getClass());
        if (list != null) {
            for (Transformer transformer : list) {
                object = transformer.transform(object);
            }
        }
        return object;
    }

    public static List<Transformer> getEncodingHooks(Class<?> clazz) {
        return _encodingHooks.get(clazz);
    }

    public static void clearEncodingHooks() {
        _encodeHooks = false;
        _encodingHooks.clear();
    }

    public static void removeEncodingHooks(Class<?> clazz) {
        _encodingHooks.remove(clazz);
    }

    public static void removeEncodingHook(Class<?> clazz, Transformer transformer) {
        BSON.getEncodingHooks(clazz).remove(transformer);
    }

    public static List<Transformer> getDecodingHooks(Class<?> clazz) {
        return _decodingHooks.get(clazz);
    }

    public static void clearDecodingHooks() {
        _decodeHooks = false;
        _decodingHooks.clear();
    }

    public static void removeDecodingHooks(Class<?> clazz) {
        _decodingHooks.remove(clazz);
    }

    public static void removeDecodingHook(Class<?> clazz, Transformer transformer) {
        BSON.getDecodingHooks(clazz).remove(transformer);
    }

    public static void clearAllHooks() {
        BSON.clearEncodingHooks();
        BSON.clearDecodingHooks();
    }

    private static boolean _anyHooks() {
        return _encodeHooks || _decodeHooks;
    }

    public static byte[] encode(BSONObject bSONObject) {
        BSONEncoder bSONEncoder = _staticEncoder.get();
        try {
            byte[] byArray = bSONEncoder.encode(bSONObject);
            return byArray;
        }
        finally {
            bSONEncoder.done();
        }
    }

    public static BSONObject decode(byte[] byArray) {
        BSONDecoder bSONDecoder = _staticDecoder.get();
        return bSONDecoder.readObject(byArray);
    }

    public static int toInt(Object object) {
        if (object == null) {
            throw new NullPointerException("can't be null");
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        throw new IllegalArgumentException("can't convert: " + object.getClass().getName() + " to int");
    }

    private static enum RegexFlag {
        CANON_EQ(128, 'c', "Pattern.CANON_EQ"),
        UNIX_LINES(1, 'd', "Pattern.UNIX_LINES"),
        GLOBAL(256, 'g', null),
        CASE_INSENSITIVE(2, 'i', null),
        MULTILINE(8, 'm', null),
        DOTALL(32, 's', "Pattern.DOTALL"),
        LITERAL(16, 't', "Pattern.LITERAL"),
        UNICODE_CASE(64, 'u', "Pattern.UNICODE_CASE"),
        COMMENTS(4, 'x', null);

        private static final Map<Character, RegexFlag> byCharacter;
        public final int javaFlag;
        public final char flagChar;
        public final String unsupported;

        public static RegexFlag getByCharacter(char c) {
            return byCharacter.get(Character.valueOf(c));
        }

        private RegexFlag(int n2, char c, String string2) {
            this.javaFlag = n2;
            this.flagChar = c;
            this.unsupported = string2;
        }

        static {
            byCharacter = new HashMap<Character, RegexFlag>();
            for (RegexFlag regexFlag : RegexFlag.values()) {
                byCharacter.put(Character.valueOf(regexFlag.flagChar), regexFlag);
            }
        }
    }
}

