/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.BasicBSONList;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public class BasicBSONCallback
implements BSONCallback {
    private Object _root;
    private final LinkedList<BSONObject> _stack = new LinkedList();
    private final LinkedList<String> _nameStack = new LinkedList();

    public BasicBSONCallback() {
        this.reset();
    }

    public BSONObject create() {
        return new BasicBSONObject();
    }

    protected BSONObject createList() {
        return new BasicBSONList();
    }

    @Override
    public BSONCallback createBSONCallback() {
        return new BasicBSONCallback();
    }

    public BSONObject create(boolean bl, List<String> list) {
        if (bl) {
            return this.createList();
        }
        return this.create();
    }

    @Override
    public void objectStart() {
        if (this._stack.size() > 0) {
            throw new IllegalStateException("something is wrong");
        }
        this.objectStart(false);
    }

    @Override
    public void objectStart(boolean bl) {
        this._root = this.create(bl, null);
        this._stack.add((BSONObject)this._root);
    }

    @Override
    public void objectStart(String string) {
        this.objectStart(false, string);
    }

    public void objectStart(boolean bl, String string) {
        this._nameStack.addLast(string);
        BSONObject bSONObject = this.create(bl, this._nameStack);
        this._stack.getLast().put(string, bSONObject);
        this._stack.addLast(bSONObject);
    }

    @Override
    public Object objectDone() {
        BSONObject bSONObject = this._stack.removeLast();
        if (this._nameStack.size() > 0) {
            this._nameStack.removeLast();
        } else if (this._stack.size() > 0) {
            throw new IllegalStateException("something is wrong");
        }
        return !BSON.hasDecodeHooks() ? bSONObject : (BSONObject)BSON.applyDecodingHooks(bSONObject);
    }

    @Override
    public void arrayStart() {
        this.objectStart(true);
    }

    @Override
    public void arrayStart(String string) {
        this.objectStart(true, string);
    }

    @Override
    public Object arrayDone() {
        return this.objectDone();
    }

    @Override
    public void gotNull(String string) {
        this.cur().put(string, null);
    }

    @Override
    public void gotUndefined(String string) {
    }

    @Override
    public void gotMinKey(String string) {
        this.cur().put(string, new MinKey());
    }

    @Override
    public void gotMaxKey(String string) {
        this.cur().put(string, new MaxKey());
    }

    @Override
    public void gotBoolean(String string, boolean bl) {
        this._put(string, bl);
    }

    @Override
    public void gotDouble(String string, double d) {
        this._put(string, d);
    }

    @Override
    public void gotInt(String string, int n) {
        this._put(string, n);
    }

    @Override
    public void gotLong(String string, long l) {
        this._put(string, l);
    }

    @Override
    public void gotDate(String string, long l) {
        this._put(string, new Date(l));
    }

    @Override
    public void gotRegex(String string, String string2, String string3) {
        this._put(string, Pattern.compile(string2, BSON.regexFlags(string3)));
    }

    @Override
    public void gotString(String string, String string2) {
        this._put(string, string2);
    }

    @Override
    public void gotSymbol(String string, String string2) {
        this._put(string, string2);
    }

    @Override
    public void gotTimestamp(String string, int n, int n2) {
        this._put(string, new BSONTimestamp(n, n2));
    }

    @Override
    public void gotObjectId(String string, ObjectId objectId) {
        this._put(string, objectId);
    }

    @Override
    public void gotDBRef(String string, String string2, ObjectId objectId) {
        this._put(string, new BasicBSONObject("$ns", string2).append("$id", objectId));
    }

    @Override
    @Deprecated
    public void gotBinaryArray(String string, byte[] byArray) {
        this.gotBinary(string, (byte)0, byArray);
    }

    @Override
    public void gotBinary(String string, byte by, byte[] byArray) {
        if (by == 0 || by == 2) {
            this._put(string, byArray);
        } else {
            this._put(string, new Binary(by, byArray));
        }
    }

    @Override
    public void gotUUID(String string, long l, long l2) {
        this._put(string, new UUID(l, l2));
    }

    @Override
    public void gotCode(String string, String string2) {
        this._put(string, new Code(string2));
    }

    @Override
    public void gotCodeWScope(String string, String string2, Object object) {
        this._put(string, new CodeWScope(string2, (BSONObject)object));
    }

    protected void _put(String string, Object object) {
        this.cur().put(string, !BSON.hasDecodeHooks() ? object : BSON.applyDecodingHooks(object));
    }

    protected BSONObject cur() {
        return this._stack.getLast();
    }

    protected String curName() {
        return !this._nameStack.isEmpty() ? this._nameStack.getLast() : null;
    }

    @Override
    public Object get() {
        return this._root;
    }

    protected void setRoot(Object object) {
        this._root = object;
    }

    protected boolean isStackEmpty() {
        return this._stack.size() < 1;
    }

    @Override
    public void reset() {
        this._root = null;
        this._stack.clear();
        this._nameStack.clear();
    }
}

