/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BSONException;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.io.Bits;
import org.bson.io.PoolOutputBuffer;
import org.bson.types.ObjectId;

public class BasicBSONDecoder
implements BSONDecoder {
    protected BSONInput _in;
    protected BSONCallback _callback;
    private byte[] _random = new byte[1024];
    private byte[] _inputBuffer = new byte[1024];
    private PoolOutputBuffer _stringBuffer = new PoolOutputBuffer();
    protected int _pos;
    protected int _len;
    private static final int MAX_STRING = 0x2000000;
    private static final String DEFAULT_ENCODING = "UTF-8";
    static final String[] ONE_BYTE_STRINGS = new String[128];

    @Override
    public BSONObject readObject(byte[] byArray) {
        try {
            return this.readObject(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new BSONException("should be impossible", iOException);
        }
    }

    @Override
    public BSONObject readObject(InputStream inputStream) throws IOException {
        BasicBSONCallback basicBSONCallback = new BasicBSONCallback();
        this.decode(inputStream, (BSONCallback)basicBSONCallback);
        return (BSONObject)basicBSONCallback.get();
    }

    @Override
    public int decode(byte[] byArray, BSONCallback bSONCallback) {
        try {
            return this._decode(new BSONInput(new ByteArrayInputStream(byArray)), bSONCallback);
        }
        catch (IOException iOException) {
            throw new BSONException("should be impossible", iOException);
        }
    }

    @Override
    public int decode(InputStream inputStream, BSONCallback bSONCallback) throws IOException {
        return this._decode(new BSONInput(inputStream), bSONCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _decode(BSONInput bSONInput, BSONCallback bSONCallback) throws IOException {
        if (this._in != null || this._callback != null) {
            throw new IllegalStateException("not ready");
        }
        this._in = bSONInput;
        this._callback = bSONCallback;
        if (bSONInput.numRead() != 0) {
            throw new IllegalArgumentException("i'm confused");
        }
        try {
            int n = this._in.readInt();
            this._in.setMax(n);
            this._callback.objectStart();
            while (this.decodeElement()) {
            }
            this._callback.objectDone();
            if (this._in.numRead() != n) {
                throw new IllegalArgumentException("bad data.  lengths don't match read:" + this._in.numRead() + " != len:" + n);
            }
            int n2 = n;
            return n2;
        }
        finally {
            this._in = null;
            this._callback = null;
        }
    }

    int decode(boolean bl) throws IOException {
        int n = this._in.numRead();
        int n2 = this._in.readInt();
        if (bl) {
            this._in.setMax(n2);
        }
        this._callback.objectStart();
        while (this.decodeElement()) {
        }
        this._callback.objectDone();
        int n3 = this._in.numRead() - n;
        if (n3 != n2) {
            // empty if block
        }
        return n2;
    }

    boolean decodeElement() throws IOException {
        byte by = this._in.read();
        if (by == 0) {
            return false;
        }
        String string = this._in.readCStr();
        switch (by) {
            case 10: {
                this._callback.gotNull(string);
                break;
            }
            case 6: {
                this._callback.gotUndefined(string);
                break;
            }
            case 8: {
                this._callback.gotBoolean(string, this._in.read() > 0);
                break;
            }
            case 1: {
                this._callback.gotDouble(string, this._in.readDouble());
                break;
            }
            case 16: {
                this._callback.gotInt(string, this._in.readInt());
                break;
            }
            case 18: {
                this._callback.gotLong(string, this._in.readLong());
                break;
            }
            case 14: {
                this._callback.gotSymbol(string, this._in.readUTF8String());
                break;
            }
            case 2: {
                this._callback.gotString(string, this._in.readUTF8String());
                break;
            }
            case 7: {
                this._callback.gotObjectId(string, new ObjectId(this._in.readIntBE(), this._in.readIntBE(), this._in.readIntBE()));
                break;
            }
            case 12: {
                this._in.readInt();
                String string2 = this._in.readCStr();
                ObjectId objectId = new ObjectId(this._in.readInt(), this._in.readInt(), this._in.readInt());
                this._callback.gotDBRef(string, string2, objectId);
                break;
            }
            case 9: {
                this._callback.gotDate(string, this._in.readLong());
                break;
            }
            case 11: {
                this._callback.gotRegex(string, this._in.readCStr(), this._in.readCStr());
                break;
            }
            case 5: {
                this._binary(string);
                break;
            }
            case 13: {
                this._callback.gotCode(string, this._in.readUTF8String());
                break;
            }
            case 15: {
                this._in.readInt();
                this._callback.gotCodeWScope(string, this._in.readUTF8String(), this._readBasicObject());
                break;
            }
            case 4: {
                this._in.readInt();
                this._callback.arrayStart(string);
                while (this.decodeElement()) {
                }
                this._callback.arrayDone();
                break;
            }
            case 3: {
                this._in.readInt();
                this._callback.objectStart(string);
                while (this.decodeElement()) {
                }
                this._callback.objectDone();
                break;
            }
            case 17: {
                int n = this._in.readInt();
                int n2 = this._in.readInt();
                this._callback.gotTimestamp(string, n2, n);
                break;
            }
            case -1: {
                this._callback.gotMinKey(string);
                break;
            }
            case 127: {
                this._callback.gotMaxKey(string);
                break;
            }
            default: {
                throw new UnsupportedOperationException("BSONDecoder doesn't understand type : " + by + " name: " + string);
            }
        }
        return true;
    }

    protected void _binary(String string) throws IOException {
        int n = this._in.readInt();
        byte by = this._in.read();
        switch (by) {
            case 0: {
                byte[] byArray = new byte[n];
                this._in.fill(byArray);
                this._callback.gotBinary(string, by, byArray);
                return;
            }
            case 2: {
                int n2 = this._in.readInt();
                if (n2 + 4 != n) {
                    throw new IllegalArgumentException("bad data size subtype 2 len: " + n2 + " totalLen: " + n);
                }
                byte[] byArray = new byte[n2];
                this._in.fill(byArray);
                this._callback.gotBinary(string, by, byArray);
                return;
            }
            case 3: {
                if (n != 16) {
                    throw new IllegalArgumentException("bad data size subtype 3 len: " + n + " != 16");
                }
                long l = this._in.readLong();
                long l2 = this._in.readLong();
                this._callback.gotUUID(string, l, l2);
                return;
            }
        }
        byte[] byArray = new byte[n];
        this._in.fill(byArray);
        this._callback.gotBinary(string, by, byArray);
    }

    Object _readBasicObject() throws IOException {
        BSONCallback bSONCallback;
        this._in.readInt();
        BSONCallback bSONCallback2 = this._callback;
        this._callback = bSONCallback = this._callback.createBSONCallback();
        bSONCallback.reset();
        bSONCallback.objectStart(false);
        while (this.decodeElement()) {
        }
        this._callback = bSONCallback2;
        return bSONCallback.get();
    }

    private static final boolean _isAscii(byte by) {
        return by >= 0 && by <= 127;
    }

    static void _fillRange(byte by, byte by2) {
        while (by < by2) {
            String string = "";
            BasicBSONDecoder.ONE_BYTE_STRINGS[by] = string = string + (char)by;
            by = (byte)(by + 1);
        }
    }

    static {
        BasicBSONDecoder._fillRange((byte)48, (byte)57);
        BasicBSONDecoder._fillRange((byte)97, (byte)122);
        BasicBSONDecoder._fillRange((byte)65, (byte)90);
    }

    protected class BSONInput {
        int _read;
        final InputStream _raw;
        int _max = 4;

        public BSONInput(InputStream inputStream) {
            this._raw = inputStream;
            this._read = 0;
            BasicBSONDecoder.this._pos = 0;
            BasicBSONDecoder.this._len = 0;
        }

        protected int _need(int n) throws IOException {
            int n2;
            if (BasicBSONDecoder.this._len - BasicBSONDecoder.this._pos >= n) {
                int n3 = BasicBSONDecoder.this._pos;
                BasicBSONDecoder.this._pos += n;
                this._read += n;
                return n3;
            }
            if (n >= BasicBSONDecoder.this._inputBuffer.length) {
                throw new IllegalArgumentException("you can't need that much");
            }
            int n4 = BasicBSONDecoder.this._len - BasicBSONDecoder.this._pos;
            if (BasicBSONDecoder.this._pos > 0) {
                System.arraycopy(BasicBSONDecoder.this._inputBuffer, BasicBSONDecoder.this._pos, BasicBSONDecoder.this._inputBuffer, 0, n4);
                BasicBSONDecoder.this._pos = 0;
                BasicBSONDecoder.this._len = n4;
            }
            int n5 = Math.min(this._max - this._read - n4, BasicBSONDecoder.this._inputBuffer.length - BasicBSONDecoder.this._len);
            while (n5 > 0) {
                n2 = this._raw.read(BasicBSONDecoder.this._inputBuffer, BasicBSONDecoder.this._len, n5);
                if (n2 <= 0) {
                    throw new IOException("unexpected EOF");
                }
                n5 -= n2;
                BasicBSONDecoder.this._len += n2;
            }
            n2 = BasicBSONDecoder.this._pos;
            BasicBSONDecoder.this._pos += n;
            this._read += n;
            return n2;
        }

        public int readInt() throws IOException {
            return Bits.readInt(BasicBSONDecoder.this._inputBuffer, this._need(4));
        }

        public int readIntBE() throws IOException {
            return Bits.readIntBE(BasicBSONDecoder.this._inputBuffer, this._need(4));
        }

        public long readLong() throws IOException {
            return Bits.readLong(BasicBSONDecoder.this._inputBuffer, this._need(8));
        }

        public double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        public byte read() throws IOException {
            if (BasicBSONDecoder.this._pos < BasicBSONDecoder.this._len) {
                ++this._read;
                return BasicBSONDecoder.this._inputBuffer[BasicBSONDecoder.this._pos++];
            }
            return BasicBSONDecoder.this._inputBuffer[this._need(1)];
        }

        public void fill(byte[] byArray) throws IOException {
            this.fill(byArray, byArray.length);
        }

        public void fill(byte[] byArray, int n) throws IOException {
            int n2 = BasicBSONDecoder.this._len - BasicBSONDecoder.this._pos;
            int n3 = Math.min(n, n2);
            System.arraycopy(BasicBSONDecoder.this._inputBuffer, BasicBSONDecoder.this._pos, byArray, 0, n3);
            BasicBSONDecoder.this._pos += n3;
            this._read += n3;
            n -= n3;
            int n4 = n3;
            while (n > 0) {
                int n5 = this._raw.read(byArray, n4, n);
                if (n5 <= 0) {
                    throw new IOException("unexpected EOF");
                }
                this._read += n5;
                n4 += n5;
                n -= n5;
            }
        }

        protected boolean _isAscii(byte by) {
            return by >= 0 && by <= 127;
        }

        public String readCStr() throws IOException {
            byte by;
            boolean bl = true;
            ((BasicBSONDecoder)BasicBSONDecoder.this)._random[0] = this.read();
            if (BasicBSONDecoder.this._random[0] == 0) {
                return "";
            }
            ((BasicBSONDecoder)BasicBSONDecoder.this)._random[1] = this.read();
            if (BasicBSONDecoder.this._random[1] == 0) {
                String string = ONE_BYTE_STRINGS[BasicBSONDecoder.this._random[0]];
                return string != null ? string : new String(BasicBSONDecoder.this._random, 0, 1, BasicBSONDecoder.DEFAULT_ENCODING);
            }
            BasicBSONDecoder.this._stringBuffer.reset();
            BasicBSONDecoder.this._stringBuffer.write(BasicBSONDecoder.this._random, 0, 2);
            boolean bl2 = bl = this._isAscii(BasicBSONDecoder.this._random[0]) && this._isAscii(BasicBSONDecoder.this._random[1]);
            while ((by = this.read()) != 0) {
                BasicBSONDecoder.this._stringBuffer.write(by);
                bl = bl && this._isAscii(by);
            }
            String string = null;
            if (bl) {
                string = BasicBSONDecoder.this._stringBuffer.asAscii();
            } else {
                try {
                    string = BasicBSONDecoder.this._stringBuffer.asString(BasicBSONDecoder.DEFAULT_ENCODING);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw new BSONException("impossible", unsupportedOperationException);
                }
            }
            BasicBSONDecoder.this._stringBuffer.reset();
            return string;
        }

        public String readUTF8String() throws IOException {
            int n = this.readInt();
            if (n <= 0 || n > 0x2000000) {
                throw new BSONException("bad string size: " + n);
            }
            if (n < BasicBSONDecoder.this._inputBuffer.length / 2) {
                if (n == 1) {
                    this.read();
                    return "";
                }
                return new String(BasicBSONDecoder.this._inputBuffer, this._need(n), n - 1, BasicBSONDecoder.DEFAULT_ENCODING);
            }
            byte[] byArray = n < BasicBSONDecoder.this._random.length ? BasicBSONDecoder.this._random : new byte[n];
            this.fill(byArray, n);
            try {
                return new String(byArray, 0, n - 1, BasicBSONDecoder.DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new BSONException("impossible", unsupportedEncodingException);
            }
        }

        public int numRead() {
            return this._read;
        }

        public int getPos() {
            return BasicBSONDecoder.this._pos;
        }

        public int getMax() {
            return this._max;
        }

        public void setMax(int n) {
            this._max = n;
        }
    }
}

