/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.bson.io.OutputBuffer;

public class BasicOutputBuffer
extends OutputBuffer {
    private int _cur;
    private int _size;
    private byte[] _buffer = new byte[512];

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this._ensure(n2);
        System.arraycopy(byArray, n, this._buffer, this._cur, n2);
        this._cur += n2;
        this._size = Math.max(this._cur, this._size);
    }

    @Override
    public void write(int n) {
        this._ensure(1);
        this._buffer[this._cur++] = (byte)(0xFF & n);
        this._size = Math.max(this._cur, this._size);
    }

    @Override
    public int getPosition() {
        return this._cur;
    }

    @Override
    public void setPosition(int n) {
        this._cur = n;
    }

    @Override
    public void seekEnd() {
        this._cur = this._size;
    }

    @Override
    public void seekStart() {
        this._cur = 0;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public int pipe(OutputStream outputStream) throws IOException {
        outputStream.write(this._buffer, 0, this._size);
        return this._size;
    }

    public int pipe(DataOutput dataOutput) throws IOException {
        dataOutput.write(this._buffer, 0, this._size);
        return this._size;
    }

    void _ensure(int n) {
        int n2 = this._cur + n;
        if (n2 < this._buffer.length) {
            return;
        }
        int n3 = this._buffer.length * 2;
        if (n3 <= n2) {
            n3 = n2 + 128;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this._buffer, 0, byArray, 0, this._size);
        this._buffer = byArray;
    }

    @Override
    public String asString() {
        return new String(this._buffer, 0, this._size);
    }

    @Override
    public String asString(String string) throws UnsupportedEncodingException {
        return new String(this._buffer, 0, this._size, string);
    }
}

