/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class Bits {
    public static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        Bits.readFully(inputStream, byArray, byArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n) throws IOException {
        Bits.readFully(inputStream, byArray, 0, n);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        if (byArray.length - n > n2) {
            throw new IllegalArgumentException("Buffer is too small");
        }
        int n3 = n;
        int n4 = n2;
        while (n4 > 0) {
            int n5 = inputStream.read(byArray, n3, n4);
            if (n5 < 0) {
                throw new EOFException();
            }
            n4 -= n5;
            n3 += n5;
        }
    }

    public static int readInt(InputStream inputStream) throws IOException {
        return Bits.readInt(inputStream, new byte[4]);
    }

    public static int readInt(InputStream inputStream, byte[] byArray) throws IOException {
        Bits.readFully(inputStream, byArray, 4);
        return Bits.readInt(byArray);
    }

    public static int readInt(byte[] byArray) {
        return Bits.readInt(byArray, 0);
    }

    public static int readInt(byte[] byArray, int n) {
        int n2 = 0;
        n2 |= (0xFF & byArray[n + 0]) << 0;
        n2 |= (0xFF & byArray[n + 1]) << 8;
        n2 |= (0xFF & byArray[n + 2]) << 16;
        return n2 |= (0xFF & byArray[n + 3]) << 24;
    }

    public static int readIntBE(byte[] byArray, int n) {
        int n2 = 0;
        n2 |= (0xFF & byArray[n + 0]) << 24;
        n2 |= (0xFF & byArray[n + 1]) << 16;
        n2 |= (0xFF & byArray[n + 2]) << 8;
        return n2 |= (0xFF & byArray[n + 3]) << 0;
    }

    public static long readLong(InputStream inputStream) throws IOException {
        return Bits.readLong(inputStream, new byte[8]);
    }

    public static long readLong(InputStream inputStream, byte[] byArray) throws IOException {
        Bits.readFully(inputStream, byArray, 8);
        return Bits.readLong(byArray);
    }

    public static long readLong(byte[] byArray) {
        return Bits.readLong(byArray, 0);
    }

    public static long readLong(byte[] byArray, int n) {
        long l = 0L;
        l |= (0xFFL & (long)byArray[n + 0]) << 0;
        l |= (0xFFL & (long)byArray[n + 1]) << 8;
        l |= (0xFFL & (long)byArray[n + 2]) << 16;
        l |= (0xFFL & (long)byArray[n + 3]) << 24;
        l |= (0xFFL & (long)byArray[n + 4]) << 32;
        l |= (0xFFL & (long)byArray[n + 5]) << 40;
        l |= (0xFFL & (long)byArray[n + 6]) << 48;
        return l |= (0xFFL & (long)byArray[n + 7]) << 56;
    }
}

