/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.IOException;
import java.text.MessageFormat;

class UTF8Encoding {
    private static final int MIN_2_BYTES = 128;
    private static final int MIN_3_BYTES = 2048;
    private static final int MIN_4_BYTES = 65536;
    private static final int MAX_CODE_POINT = 0x10FFFF;
    private char[] decoderArray = new char[1024];

    UTF8Encoding() {
    }

    private static final void checkByte(int n, int n2, int n3) throws IOException {
        if ((n & 0xC0) != 128) {
            throw new IOException(MessageFormat.format("Illegal UTF-8 sequence: byte {0} of {1} byte sequence is not 10xxxxxx: {2}", new Integer(n2), new Integer(n3), new Integer(n)));
        }
    }

    private static final void checkMinimal(int n, int n2) throws IOException {
        int n3;
        int n4;
        if (n >= n2) {
            return;
        }
        switch (n2) {
            case 128: {
                n4 = 2;
                break;
            }
            case 2048: {
                n4 = 3;
                break;
            }
            case 65536: {
                n4 = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected minValue passed to checkMinimal: " + n2);
            }
        }
        if (n < 128) {
            n3 = 1;
        } else if (n < 2048) {
            n3 = 2;
        } else if (n < 65536) {
            n3 = 3;
        } else {
            throw new IllegalArgumentException("unexpected ch passed to checkMinimal: " + n);
        }
        throw new IOException(MessageFormat.format("Illegal UTF-8 sequence: {0} bytes used to encode a {1} byte value: {2}", new Integer(n4), new Integer(n3), new Integer(n)));
    }

    public synchronized String decode(byte[] byArray, int n, int n2) throws IOException {
        char[] cArray = this.decoderArray;
        if (cArray.length < n2) {
            cArray = this.decoderArray = new char[n2];
        }
        int n3 = n;
        int n4 = 0;
        int n5 = n2 + n;
        try {
            while (n3 < n5) {
                int n6;
                if ((n6 = byArray[n3++] & 0xFF) >= 128) {
                    if (n6 < 192) {
                        throw new IOException(MessageFormat.format("Illegal UTF-8 sequence: initial byte is {0}: {1}", "10xxxxxx", new Integer(n6)));
                    }
                    if (n6 < 224) {
                        n6 = (n6 & 0x1F) << 6;
                        UTF8Encoding.checkByte(byArray[n3], 2, 2);
                        UTF8Encoding.checkMinimal(n6 |= byArray[n3++] & 0x3F, 128);
                    } else if (n6 < 240) {
                        n6 = (n6 & 0xF) << 12;
                        UTF8Encoding.checkByte(byArray[n3], 2, 3);
                        n6 |= (byArray[n3++] & 0x3F) << 6;
                        UTF8Encoding.checkByte(byArray[n3], 3, 3);
                        UTF8Encoding.checkMinimal(n6 |= byArray[n3++] & 0x3F, 2048);
                    } else if (n6 < 248) {
                        n6 = (n6 & 7) << 18;
                        UTF8Encoding.checkByte(byArray[n3], 2, 4);
                        n6 |= (byArray[n3++] & 0x3F) << 12;
                        UTF8Encoding.checkByte(byArray[n3], 3, 4);
                        n6 |= (byArray[n3++] & 0x3F) << 6;
                        UTF8Encoding.checkByte(byArray[n3], 4, 4);
                        UTF8Encoding.checkMinimal(n6 |= byArray[n3++] & 0x3F, 65536);
                    } else {
                        throw new IOException(MessageFormat.format("Illegal UTF-8 sequence: initial byte is {0}: {1}", "11111xxx", new Integer(n6)));
                    }
                }
                if (n6 > 0x10FFFF) {
                    throw new IOException(MessageFormat.format("Illegal UTF-8 sequence: final value is out of range: {0}", new Integer(n6)));
                }
                if (n6 > 65535) {
                    cArray[n4++] = (char)(55296 + ((n6 -= 65536) >> 10));
                    cArray[n4++] = (char)(56320 + (n6 & 0x3FF));
                    continue;
                }
                if (n6 >= 55296 && n6 < 57344) {
                    throw new IOException(MessageFormat.format("Illegal UTF-8 sequence: final value is a surrogate value: {0}", new Integer(n6)));
                }
                cArray[n4++] = (char)n6;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("Illegal UTF-8 sequence: multibyte sequence was truncated");
        }
        if (n3 > n5) {
            throw new IOException("Illegal UTF-8 sequence: multibyte sequence was truncated");
        }
        return new String(cArray, 0, n4);
    }
}

