/*
 * Decompiled with CFR 0.152.
 */
package org.bson.types;

import java.io.Serializable;
import java.util.Date;

public class BSONTimestamp
implements Comparable<BSONTimestamp>,
Serializable {
    private static final long serialVersionUID = -3268482672267936464L;
    static final boolean D = Boolean.getBoolean("DEBUG.DBTIMESTAMP");
    final int _inc;
    final Date _time;
    protected static Date previous = null;
    protected static int increment = 0;

    public BSONTimestamp() {
        this._inc = 0;
        this._time = null;
    }

    public BSONTimestamp(int n, int n2) {
        this._time = new Date((long)n * 1000L);
        this._inc = n2;
    }

    public BSONTimestamp(Date date, int n) {
        this._time = date;
        this._inc = n;
    }

    public static final synchronized BSONTimestamp current() {
        Date date = new Date();
        if (previous != null && previous.getTime() / 1000L != date.getTime() / 1000L) {
            increment = 0;
        }
        BSONTimestamp bSONTimestamp = new BSONTimestamp(date, increment);
        ++increment;
        previous = date;
        return bSONTimestamp;
    }

    public int getTime() {
        if (this._time == null) {
            return 0;
        }
        return (int)(this._time.getTime() / 1000L);
    }

    public int getInc() {
        return this._inc;
    }

    public String toString() {
        return "TS time:" + this._time + " inc:" + this._inc;
    }

    @Override
    public int compareTo(BSONTimestamp bSONTimestamp) {
        if (this.getTime() != bSONTimestamp.getTime()) {
            return this.getTime() - bSONTimestamp.getTime();
        }
        return this.getInc() - bSONTimestamp.getInc();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this._inc;
        n = 31 * n + this.getTime();
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BSONTimestamp) {
            BSONTimestamp bSONTimestamp = (BSONTimestamp)object;
            return this.getTime() == bSONTimestamp.getTime() && this.getInc() == bSONTimestamp.getInc();
        }
        return false;
    }
}

