/*
 * Decompiled with CFR 0.152.
 */
package org.bson.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.bson.util.CopyOnWriteMap;

class ClassAncestry {
    private static final ConcurrentMap<Class<?>, List<Class<?>>> _ancestryCache = CopyOnWriteMap.newHashMap();

    ClassAncestry() {
    }

    public static <T> List<Class<?>> getAncestry(Class<T> clazz) {
        ConcurrentMap<Class<?>, List<Class<?>>> concurrentMap = ClassAncestry.getClassAncestryCache();
        List list;
        while ((list = (List)concurrentMap.get(clazz)) == null) {
            concurrentMap.putIfAbsent(clazz, ClassAncestry.computeAncestry(clazz));
        }
        return list;
    }

    private static List<Class<?>> computeAncestry(Class<?> clazz) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(Object.class);
        ClassAncestry.computeAncestry(clazz, arrayList);
        Collections.reverse(arrayList);
        return Collections.unmodifiableList(new ArrayList(arrayList));
    }

    private static <T> void computeAncestry(Class<T> clazz, List<Class<?>> list) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = classArray.length - 1; i >= 0; --i) {
            ClassAncestry.computeAncestry(classArray[i], list);
        }
        ClassAncestry.computeAncestry(clazz.getSuperclass(), list);
        if (!list.contains(clazz)) {
            list.add(clazz);
        }
    }

    private static ConcurrentMap<Class<?>, List<Class<?>>> getClassAncestryCache() {
        return _ancestryCache;
    }
}

