/*
 * Decompiled with CFR 0.152.
 */
package org.bson.util;

import java.util.List;
import java.util.Map;
import org.bson.util.ClassAncestry;
import org.bson.util.ComputingMap;
import org.bson.util.CopyOnWriteMap;
import org.bson.util.Function;

public class ClassMap<T> {
    private final Map<Class<?>, T> map = CopyOnWriteMap.newHashMap();
    private final Map<Class<?>, T> cache = ComputingMap.create(new ComputeFunction());

    public static <T> List<Class<?>> getAncestry(Class<T> clazz) {
        return ClassAncestry.getAncestry(clazz);
    }

    public T get(Object object) {
        return this.cache.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T put(Class<?> clazz, T t) {
        try {
            T t2 = this.map.put(clazz, t);
            return t2;
        }
        finally {
            this.cache.clear();
        }
    }

    public T remove(Object object) {
        try {
            T t = this.map.remove(object);
            return t;
        }
        finally {
            this.cache.clear();
        }
    }

    public void clear() {
        this.map.clear();
        this.cache.clear();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    private final class ComputeFunction
    implements Function<Class<?>, T> {
        private ComputeFunction() {
        }

        @Override
        public T apply(Class<?> clazz) {
            for (Class<?> clazz2 : ClassMap.getAncestry(clazz)) {
                Object v = ClassMap.this.map.get(clazz2);
                if (v == null) continue;
                return v;
            }
            return null;
        }
    }
}

