/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.bson;

import com.gbasedbt.bson.BSON;
import com.gbasedbt.bson.BSONObject;
import com.gbasedbt.bson.types.ObjectId;
import com.gbasedbt.json.JSON;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class BasicBSONObject
extends LinkedHashMap<String, Object>
implements BSONObject {
    private static final long serialVersionUID = -4415279469780082174L;
    public static int b;

    public BasicBSONObject() {
    }

    public BasicBSONObject(int n2) {
        super(n2);
    }

    public BasicBSONObject(String string, Object object) {
        this.put(string, object);
    }

    public BasicBSONObject(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Map<String, Object> toMap() {
        return new LinkedHashMap<String, Object>(this);
    }

    @Override
    public Object removeField(String string) {
        return this.remove(string);
    }

    @Override
    public boolean containsField(String string) {
        return super.containsKey(string);
    }

    @Override
    @Deprecated
    public boolean containsKey(String string) {
        return this.containsField(string);
    }

    @Override
    public Object get(String string) {
        return super.get(string);
    }

    public int getInt(String string) {
        Object object = this.get(string);
        if (object == null) {
            throw new NullPointerException("no value for: " + string);
        }
        return BSON.toInt(object);
    }

    public int getInt(String string, int n2) {
        Object object = this.get(string);
        if (object == null) {
            return n2;
        }
        return BSON.toInt(object);
    }

    public long getLong(String string) {
        Object object = this.get(string);
        return ((Number)object).longValue();
    }

    public long getLong(String string, long l2) {
        Object object = this.get(string);
        if (object == null) {
            return l2;
        }
        return ((Number)object).longValue();
    }

    public double getDouble(String string) {
        Object object = this.get(string);
        return ((Number)object).doubleValue();
    }

    public double getDouble(String string, double d2) {
        Object object = this.get(string);
        if (object == null) {
            return d2;
        }
        return ((Number)object).doubleValue();
    }

    public String getString(String string) {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public String getString(String string, String string2) {
        Object object = this.get(string);
        if (object == null) {
            return string2;
        }
        return object.toString();
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(String string, boolean bl) {
        Object object;
        block10: {
            boolean bl2;
            block12: {
                block11: {
                    object = this.get(string);
                    if (object == null) {
                        return bl;
                    }
                    if (!(object instanceof Number)) break block10;
                    if (((Number)object).intValue() <= 0) break block11;
                    bl2 = true;
                    break block12;
                }
                bl2 = false;
            }
            return bl2;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new IllegalArgumentException("can't coerce to bool:" + object.getClass());
    }

    public ObjectId getObjectId(String string) {
        return (ObjectId)this.get(string);
    }

    public ObjectId getObjectId(String string, ObjectId objectId) {
        Object object = this.get(string);
        ObjectId objectId2 = object != null ? (ObjectId)object : objectId;
        return objectId2;
    }

    public Date getDate(String string) {
        return (Date)this.get(string);
    }

    public Date getDate(String string, Date date) {
        Object object = this.get(string);
        Date date2 = object != null ? (Date)object : date;
        return date2;
    }

    @Override
    public Object put(String string, Object object) {
        return super.put(string, object);
    }

    @Override
    public void putAll(Map map) {
        int n2 = b;
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
            if (n2 == 0) continue;
        }
    }

    @Override
    public void putAll(BSONObject bSONObject) {
        int n2 = b;
        for (String string : bSONObject.keySet()) {
            this.put(string, bSONObject.get(string));
            if (n2 == 0) continue;
        }
    }

    public BasicBSONObject append(String string, Object object) {
        this.put(string, object);
        return this;
    }

    @Override
    public String toString() {
        return JSON.serialize(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object object) {
        int n2 = b;
        if (!(object instanceof BSONObject)) {
            return false;
        }
        BSONObject bSONObject = (BSONObject)object;
        if (!this.keySet().equals(bSONObject.keySet())) {
            return false;
        }
        for (String string : this.keySet()) {
            block27: {
                Object object2;
                Object object3;
                block29: {
                    block28: {
                        block26: {
                            object3 = this.get(string);
                            object2 = bSONObject.get(string);
                            if (object3 == null && object2 != null) {
                                return false;
                            }
                            if (object2 != null) break block26;
                            if (object3 != null) {
                                return false;
                            }
                            break block27;
                        }
                        if (!(object3 instanceof Number) || !(object2 instanceof Number)) break block28;
                        if (((Number)object3).doubleValue() != ((Number)object2).doubleValue()) {
                            return false;
                        }
                        break block27;
                    }
                    if (!(object3 instanceof Pattern) || !(object2 instanceof Pattern)) break block29;
                    Pattern pattern = (Pattern)object3;
                    Pattern pattern2 = (Pattern)object2;
                    if (!pattern.pattern().equals(pattern2.pattern()) || pattern.flags() != pattern2.flags()) {
                        return false;
                    }
                    if (n2 == 0) break block27;
                }
                if (!object3.equals(object2)) {
                    return false;
                }
            }
            if (n2 == 0) continue;
        }
        return true;
    }
}

