/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.bson.io;

import com.gbasedbt.bson.BSONException;
import com.gbasedbt.bson.io.OutputBuffer;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BSONByteBuffer {
    protected ByteBuffer buf;

    private BSONByteBuffer(ByteBuffer byteBuffer) {
        this.buf = byteBuffer;
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static BSONByteBuffer wrap(byte[] byArray, int n2, int n3) {
        return new BSONByteBuffer(ByteBuffer.wrap(byArray, n2, n3));
    }

    public static BSONByteBuffer wrap(byte[] byArray) {
        return new BSONByteBuffer(ByteBuffer.wrap(byArray));
    }

    public byte get(int n2) {
        return this.buf.get(n2);
    }

    public ByteBuffer get(byte[] byArray, int n2, int n3) {
        return this.buf.get(byArray, n2, n3);
    }

    public ByteBuffer get(byte[] byArray) {
        return this.buf.get(byArray);
    }

    public byte[] array() {
        return this.buf.array();
    }

    public String toString() {
        return this.buf.toString();
    }

    public int hashCode() {
        return this.buf.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        BSONByteBuffer bSONByteBuffer;
        block14: {
            block13: {
                if (this == object) {
                    return true;
                }
                if (object != null && this.getClass() == object.getClass()) break block13;
                return false;
            }
            bSONByteBuffer = (BSONByteBuffer)object;
            if (this.buf == null) break block14;
            if (this.buf.equals(bSONByteBuffer.buf)) return true;
            return false;
        }
        if (bSONByteBuffer.buf == null) return true;
        return false;
    }

    public int getInt(int n2) {
        return this.getIntLE(n2);
    }

    public int getIntLE(int n2) {
        int n3 = 0;
        n3 |= (0xFF & this.buf.get(n2 + 0)) << 0;
        n3 |= (0xFF & this.buf.get(n2 + 1)) << 8;
        n3 |= (0xFF & this.buf.get(n2 + 2)) << 16;
        return n3 |= (0xFF & this.buf.get(n2 + 3)) << 24;
    }

    public int getIntBE(int n2) {
        int n3 = 0;
        n3 |= (0xFF & this.buf.get(n2 + 0)) << 24;
        n3 |= (0xFF & this.buf.get(n2 + 1)) << 16;
        n3 |= (0xFF & this.buf.get(n2 + 2)) << 8;
        return n3 |= (0xFF & this.buf.get(n2 + 3)) << 0;
    }

    public long getLong(int n2) {
        return this.buf.getLong(n2);
    }

    public String getCString(int n2) {
        boolean bl = OutputBuffer.b;
        int n3 = n2;
        while (this.get(n3) != 0) {
            ++n3;
            if (!bl) continue;
        }
        int n4 = n3 - n2;
        return new String(this.array(), n2, n4);
    }

    public String getUTF8String(int n2) {
        int n3 = this.getInt(n2) - 1;
        try {
            return new String(this.array(), n2 + 4, n3, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BSONException("Cannot decode string as UTF-8.");
        }
    }

    public Buffer position(int n2) {
        return this.buf.position(n2);
    }

    public Buffer reset() {
        return this.buf.reset();
    }

    public int size() {
        return this.getInt(0);
    }
}

