/*
 * Decompiled with CFR 0.152.
 */
package sqlj.semantics;

import java.util.Enumeration;
import java.util.Vector;
import sqlj.framework.JSClass;
import sqlj.framework.checker.HostItem;
import sqlj.framework.checker.SQLOperation;
import sqlj.framework.checker.SQLToken;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.JSError;
import sqlj.framework.error.Warning;
import sqlj.mesg.SemanticErrors;
import sqlj.semantics.ExecAnalysis;
import sqlj.semantics.OfflineChecker;
import sqlj.semantics.SemanticAnalyzerFactory;
import sqlj.semantics.sql.SQLTokenizer;
import sqlj.syntax.BindExpr;
import sqlj.syntax.DirectBindExpr;
import sqlj.syntax.IntoBindExpr;
import sqlj.syntax.ReturnBindExpr;
import sqlj.syntax.SQLUnit;
import sqlj.util.ClassDescriptor;
import sqlj.util.ExpressionDescriptor;
import sqlj.util.Parselet;
import sqlj.util.TypeDescriptor;

class SQLOperationImpl
implements SQLOperation {
    private SQLUnit m_sql_unit;
    private ErrorLog m_error_log;
    private int m_host_item_count;
    private int m_syntax_context;
    private Vector m_host_items;
    private JSClass m_result_type;
    private int m_result_index;

    SQLOperationImpl(ErrorLog errorLog, SQLUnit sQLUnit, JSClass jSClass, SemanticAnalyzerFactory semanticAnalyzerFactory) {
        block25: {
            Object object;
            this.m_result_index = 0;
            this.m_sql_unit = sQLUnit;
            this.m_error_log = errorLog;
            this.m_result_type = jSClass;
            this.setOperationCode(this.getOperationCode());
            this.m_host_item_count = 0;
            this.m_host_items = new Vector();
            Enumeration enumeration = this.m_sql_unit.getBindExprs();
            IntoBindExpr intoBindExpr = null;
            while (enumeration.hasMoreElements()) {
                object = (BindExpr)enumeration.nextElement();
                if (object instanceof IntoBindExpr) {
                    if (intoBindExpr != null) {
                        errorLog.addEntry(new JSError(SemanticErrors.severalIntos()));
                        continue;
                    }
                    intoBindExpr = (IntoBindExpr)object;
                    continue;
                }
                if (object instanceof ReturnBindExpr) {
                    errorLog.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-1")));
                    continue;
                }
                if (object instanceof DirectBindExpr) {
                    ++this.m_host_item_count;
                    this.m_host_items.addElement(new HostItemImpl((DirectBindExpr)object, this.m_host_item_count));
                    continue;
                }
                errorLog.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-2")));
            }
            if (intoBindExpr != null) {
                if (this.m_result_type != null) {
                    errorLog.addEntry(new JSError(SemanticErrors.intoAndValue()));
                } else {
                    try {
                        this.m_result_type = semanticAnalyzerFactory.m_pf.newIteratorClass(intoBindExpr);
                        object = intoBindExpr.getParselets();
                        int n2 = 0;
                        while (object.hasMoreElements()) {
                            ++n2;
                            try {
                                ExpressionDescriptor expressionDescriptor = (ExpressionDescriptor)((Parselet)object.nextElement()).getDescriptor();
                                if (expressionDescriptor.isAssignable()) continue;
                                errorLog.addEntry(new JSError(SemanticErrors.intoListItemMustBeLvalue(n2)));
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        boolean bl;
                        this.m_result_type = JSClass.ResultSetIterator_TYPE;
                        SQLToken sQLToken = ExecAnalysis.nextToken(this.tokens());
                        boolean bl2 = bl = sQLToken != null && sQLToken.tokenText().equalsIgnoreCase("FETCH");
                        if (bl) break block25;
                        errorLog.addEntry(new JSError(SemanticErrors.illegalIntoList(classNotFoundException.getMessage())));
                    }
                }
            }
        }
        if (this.m_host_item_count != this.m_sql_unit.getNumActualBindExprs()) {
            errorLog.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-3")));
        }
        int n3 = 0;
        Enumeration enumeration = this.tokens();
        int n4 = 0;
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            SQLToken sQLToken = (SQLToken)enumeration.nextElement();
            if (0 <= n4 && sQLToken.tokenType() != 1) {
                if (++n4 == 1) {
                    if (sQLToken.tokenText().equalsIgnoreCase("SET")) {
                        bl = true;
                    } else {
                        n4 = -99999;
                    }
                } else if (n4 == 2) {
                    HostItemImpl hostItemImpl;
                    if (bl && sQLToken.tokenType() == 3 && (hostItemImpl = (HostItemImpl)this.m_host_items.elementAt(n3)).getHostItemMode() != 4) {
                        if (hostItemImpl.getHostItemMode() != 0) {
                            errorLog.addEntry(new Warning(SemanticErrors.setModeChangedToOut()));
                        }
                        hostItemImpl.setHostItemMode(4);
                    }
                    n4 = -99999;
                }
            }
            if (sQLToken.tokenType() != 3) continue;
            if (++n3 > this.m_host_item_count) {
                errorLog.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-4")));
                continue;
            }
            ((HostItemImpl)this.m_host_items.elementAt(n3 - 1)).setPos(sQLToken.tokenPosition());
        }
        if (n3 < this.m_host_item_count) {
            errorLog.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-5")));
        }
    }

    @Override
    public String getSQLString() {
        if (this.m_sql_unit.getSQL() == null) {
            throw new IllegalArgumentException("SQLUnit.getSQL() returns null");
        }
        return this.m_sql_unit.getSQL();
    }

    @Override
    public void setSQLString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("SQLOperation.setSQLString(null)");
        }
        this.m_sql_unit.setSQL(string);
    }

    @Override
    public Enumeration tokens() {
        return new SQLTokenizer(this.m_error_log, this.getSQLString());
    }

    @Override
    public int getOperationCode() {
        return this.m_sql_unit.getOperationType();
    }

    @Override
    public void setOperationCode(int n2) {
        if (n2 != 9 && n2 != 4 && n2 != 11 && n2 != 8 && n2 != 6 && n2 != 2 && n2 != 7 && n2 != 12 && n2 != 3 && n2 != 17 && n2 != 1023 && n2 != 5 && n2 != 1022 && n2 != 19 && n2 != 18 && !OfflineChecker.isInternalOperation(n2) && n2 < 1024) {
            throw new IllegalArgumentException("sqlj.semantics.SQLOperationImpl.setOperationCode(int): illegal operation code " + n2);
        }
        this.m_sql_unit.setOperationType(n2);
    }

    @Override
    public void setDescriptor(Object object) {
        this.m_sql_unit.setDescriptor(object);
    }

    public Object getDescriptor() {
        return this.m_sql_unit.getDescriptor();
    }

    @Override
    public int hostItemCount() {
        return this.m_host_item_count;
    }

    @Override
    public HostItem hostItem(int n2) {
        if (--n2 < 0 || n2 >= this.m_host_item_count) {
            return null;
        }
        return (HostItem)this.m_host_items.elementAt(n2);
    }

    @Override
    public JSClass getResultType() {
        return this.m_result_type;
    }

    public void setResultType(JSClass jSClass) {
        this.m_result_type = jSClass;
    }

    @Override
    public void setResultParamIndex(int n2) {
        if (n2 < 0 || n2 > this.hostItemCount() + 1) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (this.m_result_index == 0) {
            if (n2 != 0) {
                this.m_sql_unit.insertBindExprAt(ReturnBindExpr.COLUMN_RETURN, n2);
            }
        } else {
            throw new IllegalArgumentException("can only set result param once");
        }
        this.m_result_index = n2;
    }

    @Override
    public int getResultParamIndex() {
        return this.m_result_index;
    }

    class HostItemImpl
    implements HostItem {
        private DirectBindExpr m_dbe;
        private int m_pos;
        private int m_nth;
        private JSClass m_type;
        private String m_name;
        private boolean m_lvalue;

        HostItemImpl(DirectBindExpr directBindExpr, int n2) {
            block13: {
                this.m_dbe = directBindExpr;
                this.m_nth = n2;
                if (this.m_dbe.getParselet() == null) {
                    SQLOperationImpl.this.m_error_log.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-6")));
                }
                this.m_type = null;
                this.m_name = null;
                this.m_lvalue = false;
                try {
                    if (this.m_dbe.getParselet() == null) {
                        SQLOperationImpl.this.m_error_log.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-8")));
                        break block13;
                    }
                    TypeDescriptor typeDescriptor = null;
                    try {
                        typeDescriptor = this.m_dbe.getParselet().getDescriptor();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        String string = "INTERNAL ERROR - PLEASE NOTIFY:\nException occurrend in parselet of DirectBindExpression when issuing getDescriptor():\n" + exception.toString() + "\nThis is at host expression #" + n2 + " in " + SQLOperationImpl.this.getSQLString();
                        System.out.println(string);
                        SQLOperationImpl.this.m_error_log.addEntry(new JSError(string));
                    }
                    if (typeDescriptor == null) {
                        SQLOperationImpl.this.m_error_log.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-9")));
                        break block13;
                    }
                    try {
                        if (typeDescriptor instanceof ClassDescriptor) {
                            this.m_type = ((ClassDescriptor)typeDescriptor).getReflection();
                        } else if (typeDescriptor instanceof ExpressionDescriptor) {
                            this.m_type = ((ExpressionDescriptor)typeDescriptor).getReflection();
                            this.m_name = ((ExpressionDescriptor)typeDescriptor).getName();
                            this.m_lvalue = ((ExpressionDescriptor)typeDescriptor).isAssignable();
                            int n3 = this.getHostItemMode();
                            if (!(this.m_lvalue || n3 != 4 && n3 != 2)) {
                                SQLOperationImpl.this.m_error_log.addEntry(new JSError(SemanticErrors.hostItemMustBeLvalue(this.m_nth)));
                            }
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    SQLOperationImpl.this.m_error_log.addEntry(new JSError(SemanticErrors.internalError("SQLOperationImpl-10")));
                }
            }
        }

        void setPos(int n2) {
            this.m_pos = n2;
        }

        @Override
        public int getHostItemPosition() {
            return this.m_pos;
        }

        @Override
        public JSClass getHostItemType() {
            return this.m_type;
        }

        @Override
        public String getHostItemName() {
            return this.m_name;
        }

        @Override
        public int getHostItemMode() {
            return this.m_dbe.getModality();
        }

        @Override
        public void setHostItemMode(int n2) {
            if (n2 == 1 || n2 == 4 || n2 == 2 || n2 == 0) {
                this.m_dbe.setModality(n2);
                if (!(this.m_lvalue || n2 != 4 && n2 != 2)) {
                    SQLOperationImpl.this.m_error_log.addEntry(new JSError(SemanticErrors.hostItemMustBeLvalue(this.m_nth)));
                }
            } else {
                throw new IllegalArgumentException("HostItem.setHostItemMode(" + n2 + ") - illegal mode value.");
            }
        }
    }
}

