/*
 * Decompiled with CFR 0.152.
 */
package sqlj.syntax;

import sqlj.framework.JSClass;
import sqlj.util.Parselet;

public class Type {
    private String m_name;
    private Type arrayOf;
    private Type toArray;

    Type(String string) {
        if (string.indexOf(91) >= 0) {
            throw new IllegalArgumentException("name = " + string);
        }
        this.m_name = string;
    }

    private Type(Type type) {
        this.m_name = "[" + type.m_name;
        this.arrayOf = type;
    }

    public String getName() {
        return this.m_name;
    }

    public JSClass getClass(Parselet parselet) throws ClassNotFoundException {
        return parselet.getClassResolver().getClass(this.getName()).getJSClass();
    }

    static Type forClass(JSClass jSClass) {
        if (jSClass.isArray()) {
            return new Type(Type.forClass(jSClass.getComponentType()));
        }
        return new Type(jSClass.getName());
    }

    Type newArrayType() {
        if (this.toArray == null) {
            this.toArray = new Type(this);
        }
        return this.toArray;
    }

    Type getComponentType() {
        return this.arrayOf;
    }

    boolean isArray() {
        return this.arrayOf != null;
    }
}

