/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClassGenerator {
    public static final short GETSQL = 0;
    public static final short READ = 1;
    public static final short WRITE = 2;
    public static final String CRLF = "\n";
    public static final String TAB = "    ";
    public static final String BASE = "B";
    public static final String COLLECTION = "C";
    public static final String DISTINCT = "D";
    public static final String NAMEDROW = "R";
    public static final String BUILTIN = " ";
    public static final short IFX_TYPE_CHAR = 0;
    public static final short IFX_TYPE_SMALLINT = 1;
    public static final short IFX_TYPE_INT = 2;
    public static final short IFX_TYPE_FLOAT = 3;
    public static final short IFX_TYPE_SMFLOAT = 4;
    public static final short IFX_TYPE_DECIMAL = 5;
    public static final short IFX_TYPE_DATE = 7;
    public static final short IFX_TYPE_MONEY = 8;
    public static final short IFX_TYPE_NULL = 9;
    public static final short IFX_TYPE_DATETIME = 10;
    public static final short IFX_TYPE_BYTE = 11;
    public static final short IFX_TYPE_VARCHAR = 13;
    public static final short IFX_TYPE_INTERVAL = 14;
    public static final short IFX_TYPE_NCHAR = 15;
    public static final short IFX_TYPE_NVCHAR = 16;
    public static final short IFX_TYPE_INT8 = 17;
    public static final short IFX_TYPE_SERIAL8 = 18;
    public static final short IFX_TYPE_SET = 19;
    public static final short IFX_TYPE_MULTISET = 20;
    public static final short IFX_TYPE_LIST = 21;
    public static final short IFX_TYPE_ROW = 22;
    public static final short IFX_BIT_DISTINCT = 2048;
    public static final short IFX_XID_LVARCHAR = 1;
    public static final short IFX_XID_BOOLEAN = 5;
    public static final short IFX_XID_BLOB = 10;
    public static final short IFX_XID_CLOB = 11;
    static final byte TU_YEAR = 0;
    static final byte TU_MONTH = 2;
    static final byte TU_DAY = 4;
    static final byte TU_HOUR = 6;
    static final byte TU_MINUTE = 8;
    static final byte TU_SECOND = 10;
    static final byte TU_FRAC = 12;
    static final byte TU_F1 = 11;
    static final byte TU_F2 = 12;
    static final byte TU_F3 = 13;
    static final byte TU_F4 = 14;
    static final byte TU_F5 = 15;
    private String className;
    private String fileName;
    private RandomAccessFile file;
    private static Connection conn;
    private int exId;
    private String mode;
    private String owner;
    private int dataType;
    private String dataTypeName;
    private int numFields;
    private Vector fields = new Vector();
    private boolean importDF = false;
    private boolean importYM = false;

    public static void main(String[] argv) throws Exception {
        int len = argv.length;
        String URL2 = null;
        String classname = null;
        if (len != 0) {
            if (len > 1) {
                block6: for (int i2 = 1; i2 < argv.length; i2 += 2) {
                    switch (argv[i2].charAt(1)) {
                        case 'U': 
                        case 'u': {
                            URL2 = argv[i2 + 1];
                            continue block6;
                        }
                        case 'C': 
                        case 'c': {
                            classname = argv[i2 + 1];
                        }
                    }
                }
            }
            if (URL2 == null) {
                URL2 = ClassGenerator.loadSetupFile();
            }
            if (classname == null) {
                classname = argv[0];
            }
        } else {
            throw new IllegalArgumentException("Usage : Java ClassGenerator datatype [URL]");
        }
        conn = ClassGenerator.connect(URL2);
        ClassGenerator cg = new ClassGenerator(argv[0], classname);
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public ClassGenerator(String datatypename, String classname) throws Exception {
        this.className = classname;
        this.dataTypeName = datatypename;
        this.exId = this.getExId(this.dataTypeName);
        this.mode = this.getMode();
        if (this.exId == -1) {
            throw new IllegalArgumentException(this.className);
        }
        this.fileName = this.className + ".java";
        this.file = new RandomAccessFile(this.fileName, "rw");
        if (this.mode.equals(DISTINCT)) {
            this.fields = this.getDistinctFields(this.exId, "value");
        } else if (this.mode.equals(NAMEDROW)) {
            this.fields = this.getNamedRowFields(this.exId);
        } else {
            if (this.mode.equals(BASE)) {
                ClassGenerator.message("Opaque type not supported");
                return;
            }
            if (this.mode.equals(COLLECTION)) {
                ClassGenerator.message("Collection types not supported");
                return;
            }
        }
        this.generateCode("import java.sql.*;\n");
        this.generateCode("import java.math.*;\n");
        if (this.importDF) {
            this.generateCode("import com.gbasedbt.jdbc.IfxIntervalDF;\n");
        }
        if (this.importYM) {
            this.generateCode("import com.gbasedbt.jdbc.IfxIntervalYM;\n");
        }
        this.generateCode("public class " + this.className + " implements SQLData " + CRLF + "{ " + CRLF);
        for (int i2 = 0; i2 < this.numFields; ++i2) {
            this.generateCode("    public " + ((Field)this.fields.elementAt((int)i2)).datatype + BUILTIN + ((Field)this.fields.elementAt((int)i2)).name + ";" + CRLF);
        }
        this.generateCode(0);
        this.generateCode(1);
        this.generateCode(2);
        this.generateCode("\n}\n");
        this.file.close();
        ClassGenerator.message(this.fileName + " is generated");
    }

    private static void message(String text) {
        System.out.println(text);
    }

    private static Connection connect(String URL2) {
        String driver = "com.gbasedbt.jdbc.IfxDriver";
        ClassGenerator.message("URL: " + URL2);
        try {
            Class.forName(driver);
        }
        catch (Exception e2) {
            ClassGenerator.message("Failed to load GBasedbt JDBC driver.");
            e2.printStackTrace();
        }
        try {
            conn = DriverManager.getConnection(URL2);
        }
        catch (SQLException e3) {
            ClassGenerator.message("Failed to connect: " + e3.toString());
            e3.printStackTrace();
        }
        return conn;
    }

    private int getExId(String datatypename) throws SQLException {
        Statement stmt = conn.createStatement();
        String query = "select * from gbasedbt.sysxtdtypes where name = '" + datatypename + "'";
        ResultSet r2 = stmt.executeQuery(query);
        while (r2.next()) {
            this.exId = r2.getInt("extended_id");
            this.mode = r2.getString("mode");
            this.owner = r2.getString("owner");
            this.dataType = r2.getInt("type");
        }
        return this.exId;
    }

    private void generateCode(String text) throws IOException {
        this.file.write(text.getBytes());
    }

    private void generateCode(int code) throws IOException {
        if (this.file == null) {
            throw new IOException("File Not found");
        }
        switch (code) {
            case 0: {
                String text = "    private String sql_type;\n\n    public String getSQLTypeName() { return \"" + this.dataTypeName + "\"; }" + CRLF;
                this.generateCode(text);
                break;
            }
            case 1: {
                String text = "\n    public void readSQL (SQLInput stream, String type) throws SQLException\n    {\n";
                text = text + TAB + TAB + "sql_type = type; " + CRLF;
                for (int i2 = 0; i2 < this.numFields; ++i2) {
                    String text1 = "        " + ((Field)this.fields.elementAt((int)i2)).name + " = " + ((Field)this.fields.elementAt((int)i2)).readProcName + ";" + CRLF;
                    text = text + text1;
                }
                text = text + TAB + "}" + CRLF;
                this.generateCode(text);
                break;
            }
            case 2: {
                String text = "\n    public void writeSQL (SQLOutput stream) throws SQLException\n    { \n";
                for (int i3 = 0; i3 < this.numFields; ++i3) {
                    String text1 = "        " + ((Field)this.fields.elementAt((int)i3)).writeProcName + ";" + CRLF;
                    text = text + text1;
                }
                text = text + TAB + "}" + CRLF;
                this.generateCode(text);
            }
        }
    }

    public Vector getDistinctFields(int exId, String name) throws SQLException {
        Statement stmt = conn.createStatement();
        String type = null;
        String readProcName = null;
        String writeProcName = null;
        String query = "select * from gbasedbt.sysxtddesc where extended_id = " + exId;
        ResultSet r2 = stmt.executeQuery(query);
        while (r2.next()) {
            type = r2.getString(3);
        }
        readProcName = ClassGenerator.getReadProcName(type);
        writeProcName = ClassGenerator.getWriteProcName(type, name);
        ++this.numFields;
        this.fields.addElement(new Field(name, type, readProcName, writeProcName));
        return this.fields;
    }

    public Vector getNamedRowFields(int exId) throws SQLException {
        Statement stmt = conn.createStatement();
        String name = null;
        String type = null;
        String readProcName = null;
        String writeProcName = null;
        String query = "select * from gbasedbt.sysattrtypes where extended_id =" + exId + " and fieldno > 0";
        ResultSet r2 = stmt.executeQuery(query);
        while (r2.next()) {
            name = r2.getString("fieldname").trim();
            int dataType = r2.getInt("type");
            int xId = r2.getInt("xtd_type_id");
            short length = (short)r2.getInt("length");
            if (xId != 0) {
                String query1 = "select * from gbasedbt.sysxtdtypes where extended_id = " + xId;
                Statement stmt2 = conn.createStatement();
                ResultSet r1 = stmt2.executeQuery(query1);
                r1.next();
                if ((dataType & 0x800) > 0) {
                    dataType &= 0xFF;
                    xId = r1.getInt("source");
                }
                if (xId == 1) {
                    readProcName = "stream.readString()";
                    writeProcName = "stream.writeString(" + name + ")";
                    type = "String";
                } else if (xId == 5) {
                    readProcName = "stream.readBoolean()";
                    writeProcName = "stream.writeBoolean(" + name + ")";
                    type = "boolean";
                } else if (xId == 10) {
                    readProcName = "stream.readBlob()";
                    writeProcName = "stream.writeBlob(" + name + ")";
                    type = "Blob";
                } else if (xId == 11) {
                    readProcName = "stream.readClob()";
                    writeProcName = "stream.writeClob(" + name + ")";
                    type = "Clob";
                } else {
                    length = (short)r1.getInt("length");
                    type = this.toJavabuiltintypes(dataType, length);
                    if (type != null) {
                        readProcName = ClassGenerator.getReadProcName(type);
                        writeProcName = ClassGenerator.getWriteProcName(type, name);
                    } else {
                        type = r1.getString("name").trim();
                        readProcName = "(" + type + ")stream.readObject()";
                        writeProcName = "stream.writeObject(" + name + ")";
                    }
                }
            } else {
                type = this.toJavabuiltintypes(dataType, length);
                if (type == null) {
                    throw new ClassGeneratorException("Data type not supported");
                }
                readProcName = ClassGenerator.getReadProcName(type);
                writeProcName = ClassGenerator.getWriteProcName(type, name);
            }
            ++this.numFields;
            this.fields.addElement(new Field(name, type, readProcName, writeProcName));
        }
        return this.fields;
    }

    private static String getReadProcName(String type) {
        if (type.startsWith("IfxInterval")) {
            return "new " + type + "(stream.readString())";
        }
        if (type.equalsIgnoreCase("struct")) {
            return "(Struct)stream.readObject()";
        }
        StringBuffer sbuf = new StringBuffer(type);
        sbuf.setCharAt(0, Character.toUpperCase(sbuf.charAt(0)));
        return "stream.read" + sbuf + "()";
    }

    private static String getWriteProcName(String type, String name) {
        if (type.startsWith("IfxInterval")) {
            return "stream.writeString(" + name + ".toString())";
        }
        StringBuffer sbuf = new StringBuffer(type);
        sbuf.setCharAt(0, Character.toUpperCase(sbuf.charAt(0)));
        return "stream.write" + sbuf + "(" + name + ")";
    }

    private String toJavabuiltintypes(int dataType, short length) {
        switch (dataType) {
            case 0: {
                return "String";
            }
            case 1: {
                return "short";
            }
            case 2: {
                return "int";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "float";
            }
            case 5: {
                return "BigDecimal";
            }
            case 7: {
                return "Date";
            }
            case 8: {
                return "BigDecimal";
            }
            case 9: {
                return "String";
            }
            case 10: {
                return this.getTimeType(length);
            }
            case 13: {
                return "String";
            }
            case 14: {
                return this.getIntervalType(length);
            }
            case 15: {
                return "String";
            }
            case 16: {
                return "String";
            }
            case 19: {
                return "Array";
            }
            case 20: {
                return "Array";
            }
            case 21: {
                return "Array";
            }
            case 17: {
                return "long";
            }
            case 22: {
                return "Struct";
            }
        }
        return null;
    }

    private String getMode() {
        return this.mode;
    }

    private String getTimeType(short length) {
        byte startCode = (byte)(length >> 4 & 0xF);
        if (startCode < 6) {
            return "Timestamp";
        }
        return "Time";
    }

    private String getIntervalType(short length) {
        byte startCode = (byte)(length >> 4 & 0xF);
        if (startCode < 6) {
            this.importYM = true;
            return "IfxIntervalYM";
        }
        this.importDF = true;
        return "IfxIntervalDF";
    }

    public static String loadSetupFile() throws Exception {
        StringTokenizer tok;
        String database = null;
        Object driver = null;
        String user = null;
        String passwd = null;
        String serverName = null;
        String gbasedbtProperties = null;
        boolean usev5server = false;
        String ldap_user = null;
        String ldap_passwd = null;
        String ldap_ifxbase = null;
        String ldap_url = null;
        String sqlh_type = null;
        String sqlh_file = null;
        String default_tok = "aa";
        String p1 = null;
        String myURL = null;
        String setupFile = System.getProperty("user.home", ".");
        if (setupFile == null) {
            setupFile = ".";
        }
        FileInputStream istream = new FileInputStream(setupFile + "/setup.std");
        DataInputStream p2 = new DataInputStream(istream);
        while (default_tok != null && (default_tok = p2.readLine()) != null && (tok = new StringTokenizer(default_tok, " \t")) != null && tok.hasMoreTokens()) {
            p1 = tok.nextToken();
            if (p1 == null) {
                return null;
            }
            if (p1.equals("URL")) {
                myURL = tok.nextToken();
                continue;
            }
            if (p1.equals("database")) {
                database = tok.nextToken();
                continue;
            }
            if (p1.equals("user")) {
                user = tok.nextToken();
                continue;
            }
            if (p1.equals("passwd")) {
                passwd = tok.nextToken();
                continue;
            }
            if (p1.equals("USEV5SERVER")) {
                if (!tok.nextToken().equals("1")) continue;
                usev5server = true;
                continue;
            }
            if (p1.equals("gbasedbtserver")) {
                serverName = tok.nextToken();
                continue;
            }
            if (p1.equals("gbasedbtProperties")) {
                gbasedbtProperties = tok.nextToken();
                continue;
            }
            if (p1.equalsIgnoreCase("SQLH_TYPE")) {
                sqlh_type = tok.nextToken();
                continue;
            }
            if (p1.equalsIgnoreCase("LDAP_IFXBASE")) {
                ldap_ifxbase = tok.nextToken();
                continue;
            }
            if (p1.equalsIgnoreCase("LDAP_URL")) {
                ldap_url = tok.nextToken();
                continue;
            }
            if (p1.equalsIgnoreCase("LDAP_USER")) {
                ldap_user = tok.nextToken();
                continue;
            }
            if (p1.equalsIgnoreCase("LDAP_PASSWD")) {
                ldap_passwd = tok.nextToken();
                continue;
            }
            if (!p1.equalsIgnoreCase("SQLH_FILE")) continue;
            sqlh_file = tok.nextToken();
        }
        String sep = ":";
        if (database != null) {
            myURL = myURL + "/" + database;
        }
        if (myURL.equals("jdbc:gbasedbt-sqli:")) {
            sep = "";
        }
        if (user != null) {
            myURL = myURL + sep + "user=" + user;
            sep = ";";
        }
        if (passwd != null) {
            myURL = myURL + sep + "password=" + passwd;
            sep = ";";
        }
        if (serverName != null) {
            myURL = myURL + sep + "gbasedbtserver=" + serverName;
            sep = ";";
        } else {
            ClassGenerator.message("GBasedbt server must be specified either in your setup.std file ");
        }
        if (usev5server) {
            myURL = myURL + ";USEV5SERVER=1";
        }
        if (sqlh_type != null) {
            myURL = myURL + ";sqlh_type=" + sqlh_type;
        }
        if (ldap_user != null) {
            myURL = myURL + ";ldap_user=" + ldap_user;
        }
        if (ldap_passwd != null) {
            myURL = myURL + ";ldap_passwd=" + ldap_passwd;
        }
        if (ldap_url != null) {
            myURL = myURL + ";ldap_url=" + ldap_url;
        }
        if (ldap_ifxbase != null) {
            myURL = myURL + ";ldap_ifxbase=" + ldap_ifxbase;
        }
        if (sqlh_file != null) {
            myURL = myURL + ";sqlh_file=" + sqlh_file;
        }
        return myURL;
    }
}

