/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.asf;

import com.gbasedbt.asf.IfxDebugDataInputStream;
import com.gbasedbt.asf.IfxDebugDataOutputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

public class SqliDbg {
    private static int sqliTraceNum = 0;
    private static final byte[] sqliHeader = new byte[]{83, 81, 76, 73, 0, 0, 0, 1};
    private IfxDebugDataInputStream in;
    private IfxDebugDataOutputStream out;
    private OutputStream traceOut;
    private int myTraceNum;
    private static long runid = System.currentTimeMillis();

    private static synchronized int getNextTraceNum() {
        return sqliTraceNum++;
    }

    public static void printSqliTraceException(Exception exception) {
        System.err.println("Sqli trace file could not be generated due to exception " + exception);
    }

    public SqliDbg(IfxDebugDataInputStream ifxDebugDataInputStream, IfxDebugDataOutputStream ifxDebugDataOutputStream, String string) {
        this.in = ifxDebugDataInputStream;
        this.out = ifxDebugDataOutputStream;
        try {
            this.myTraceNum = SqliDbg.getNextTraceNum();
            final String string2 = string + runid + "." + this.myTraceNum;
            this.traceOut = AccessController.doPrivileged(new PrivilegedExceptionAction<BufferedOutputStream>(){

                @Override
                public BufferedOutputStream run() throws IOException {
                    return new BufferedOutputStream(new FileOutputStream(string2));
                }
            });
            this.traceOut.write(sqliHeader);
            this.traceOut.flush();
        }
        catch (Exception exception) {
            SqliDbg.printSqliTraceException(exception);
        }
    }

    public void recordS2C() {
        try {
            this.traceOut.write(83);
            this.traceOut.write(67);
            this.traceOut.write(SqliDbg.marshallInteger(this.in.getTraceLength()));
            this.traceOut.write(SqliDbg.marshallLong(this.getTimeStamp()));
            this.traceOut.flush();
            this.in.dumpTrace(this.traceOut);
            this.traceOut.flush();
        }
        catch (Exception exception) {
            SqliDbg.printSqliTraceException(exception);
        }
    }

    public void recordC2S() {
        try {
            this.traceOut.write(67);
            this.traceOut.write(83);
            this.traceOut.write(SqliDbg.marshallInteger(this.out.getTraceLength()));
            this.traceOut.write(SqliDbg.marshallLong(this.getTimeStamp()));
            this.traceOut.flush();
            this.out.dumpTrace(this.traceOut);
            this.traceOut.flush();
        }
        catch (Exception exception) {
            SqliDbg.printSqliTraceException(exception);
        }
    }

    public void clearC2S() {
        try {
            this.out.clearTrace();
        }
        catch (Exception exception) {
            SqliDbg.printSqliTraceException(exception);
        }
    }

    public void clearS2C() {
        try {
            this.in.clearTrace();
        }
        catch (Exception exception) {
            SqliDbg.printSqliTraceException(exception);
        }
    }

    private long getTimeStamp() {
        long l2 = System.currentTimeMillis();
        long l3 = l2 / 1000L;
        long l4 = l2 % 1000L * 1000L;
        double d2 = (double)l3 + (double)l4 / 1000000.0;
        return Double.doubleToLongBits(d2);
    }

    protected static byte[] marshallShort(int n2) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)(n2 >> 8 & 0xFF);
        byArray[2] = (byte)(n2 >> 0 & 0xFF);
        return byArray;
    }

    protected static byte[] marshallInteger(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >> 24 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 0 & 0xFF)};
        return byArray;
    }

    protected static byte[] marshallLong(long l2) {
        byte[] byArray = new byte[]{(byte)(l2 >> 56 & 0xFFL), (byte)(l2 >> 48 & 0xFFL), (byte)(l2 >> 40 & 0xFFL), (byte)(l2 >> 32 & 0xFFL), (byte)(l2 >> 24 & 0xFFL), (byte)(l2 >> 16 & 0xFFL), (byte)(l2 >> 8 & 0xFFL), (byte)(l2 >> 0 & 0xFFL)};
        return byArray;
    }

    public void finalize() {
        try {
            this.traceOut.flush();
            this.traceOut.close();
        }
        catch (IOException iOException) {
            System.err.println("An error occured while finalizing the trace file.");
        }
    }
}

