/*
 * Decompiled with CFR 0.152.
 */
package sqlj.javac;

import sqlj.framework.JSClass;
import sqlj.javac.JavaParserImplConstants;

public class Token
implements JavaParserImplConstants {
    public int kind;
    public int beginLine;
    public int beginColumn;
    public int endLine;
    public int endColumn;
    public String image;
    public Token next;
    public Token specialToken;
    static int numCreated = 0;
    static volatile int numDeleted = 0;
    static int numHighest = 0;

    public final String toString() {
        return this.image;
    }

    public static final Token newToken(int n2) {
        switch (n2) {
            default: 
        }
        return new Token();
    }

    private static final int numLive() {
        return numCreated - numDeleted;
    }

    public Token() {
        ++numCreated;
        if (numHighest < Token.numLive()) {
            numHighest = Token.numLive();
        }
    }

    protected void finalize() throws Throwable {
        ++numDeleted;
        super.finalize();
    }

    public static void printDiagnostics() {
        System.out.println();
        System.out.println("Tokens created:     " + numCreated);
        System.out.println("Tokens deleted:     " + numDeleted);
        System.out.println("Highest number:     " + numHighest);
        System.out.println("Current number:     " + Token.numLive());
        System.out.println();
        int n2 = numDeleted;
        System.gc();
        System.out.println("Garbage-collected:  " + (numDeleted - n2));
        System.out.println("Remaining:          " + Token.numLive());
        System.out.println();
        n2 = numDeleted;
    }

    final StringBuffer getTextTo(StringBuffer stringBuffer) {
        if (this.specialToken != null) {
            this.specialToken.getTextTo(stringBuffer);
        }
        stringBuffer.append(this.image);
        return stringBuffer;
    }

    final String getText() {
        return this.getTextTo(new StringBuffer()).toString();
    }

    final Token dup() {
        Token token = Token.newToken(this.kind);
        token.kind = this.kind;
        token.beginLine = this.beginLine;
        token.beginColumn = this.beginColumn;
        token.endLine = this.endLine;
        token.endColumn = this.endColumn;
        token.image = this.image;
        token.next = null;
        token.specialToken = this.specialToken == null ? null : this.specialToken.dup();
        return token;
    }

    final JSClass getType() {
        switch (this.kind) {
            case 12: 
            case 26: 
            case 56: {
                return JSClass.boolean_TYPE;
            }
            case 14: {
                return JSClass.byte_TYPE;
            }
            case 17: 
            case 75: {
                return JSClass.char_TYPE;
            }
            case 23: {
                return JSClass.double_TYPE;
            }
            case 29: {
                return JSClass.float_TYPE;
            }
            case 73: {
                if (this.image.endsWith("f") || this.image.endsWith("F")) {
                    return JSClass.float_TYPE;
                }
                return JSClass.double_TYPE;
            }
            case 36: {
                return JSClass.int_TYPE;
            }
            case 69: {
                if (this.image.endsWith("l") || this.image.endsWith("L")) {
                    return JSClass.long_TYPE;
                }
                return JSClass.int_TYPE;
            }
            case 38: {
                return JSClass.long_TYPE;
            }
            case 41: {
                return JSClass.null_TYPE;
            }
            case 47: {
                return JSClass.short_TYPE;
            }
            case 76: {
                return JSClass.String_TYPE;
            }
            case 58: {
                return JSClass.void_TYPE;
            }
        }
        return null;
    }
}

