/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Stack;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.RTStatement;

public class ExecutionContext {
    private int m_maxFieldSize = 0;
    private int m_maxRows = 0;
    private int m_queryTimeout = 0;
    private int m_updateCount = 0;
    private SQLWarning m_warnings = null;
    private StatementStack m_statementStack = new StatementStack();
    public static final int QUERY_COUNT = -1;
    public static final int EXCEPTION_COUNT = -2;
    private static final boolean DEBUG = false;

    public synchronized int getMaxFieldSize() {
        return this.m_maxFieldSize;
    }

    public synchronized void setMaxFieldSize(int n2) {
        this.m_maxFieldSize = n2;
    }

    public synchronized int getMaxRows() {
        return this.m_maxRows;
    }

    public synchronized void setMaxRows(int n2) {
        this.m_maxRows = n2;
    }

    public synchronized int getQueryTimeout() {
        return this.m_queryTimeout;
    }

    public synchronized void setQueryTimeout(int n2) {
        this.m_queryTimeout = n2;
    }

    public synchronized SQLWarning getWarnings() {
        return this.m_warnings;
    }

    public synchronized int getUpdateCount() {
        return this.m_updateCount;
    }

    public void cancel() throws SQLException {
        this.m_statementStack.cancelCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTStatement registerStatement(ConnectionContext connectionContext, Object object, int n2) throws SQLException {
        ConnectedProfile connectedProfile = connectionContext.getConnectedProfile(object);
        RTStatement rTStatement = this.m_statementStack.setStatement(connectedProfile, n2);
        boolean bl = true;
        try {
            if (this.m_maxRows != 0) {
                rTStatement.setMaxRows(this.m_maxRows);
            }
            if (this.m_maxFieldSize != 0) {
                rTStatement.setMaxFieldSize(this.m_maxFieldSize);
            }
            if (this.m_queryTimeout != 0) {
                rTStatement.setQueryTimeout(this.m_queryTimeout);
            }
            bl = false;
        }
        finally {
            if (bl) {
                this.releaseStatement();
            }
        }
        return rTStatement;
    }

    public int executeUpdate() throws SQLException {
        this.startExec();
        try {
            int n2 = this.getStatement().executeUpdate();
            return n2;
        }
        finally {
            this.endExec();
        }
    }

    public RTResultSet executeQuery() throws SQLException {
        this.startExec();
        try {
            RTResultSet rTResultSet = this.getStatement().executeQuery();
            return rTResultSet;
        }
        finally {
            this.endExec();
        }
    }

    public boolean execute() throws SQLException {
        this.startExec();
        try {
            boolean bl = this.getStatement().execute();
            return bl;
        }
        finally {
            this.endExec();
        }
    }

    public synchronized ResultSet getNextResultSet() throws SQLException {
        StatementFrame statementFrame = this.getStatement();
        if (statementFrame.getStatement() != null) {
            try {
                ResultSet resultSet = statementFrame.getNextResultSet();
                return resultSet;
            }
            finally {
                this.m_warnings = statementFrame.getWarnings();
            }
        }
        return null;
    }

    public void releaseStatement() throws SQLException {
        StatementFrame statementFrame = this.getStatement();
        try {
            statementFrame.releaseStatement();
        }
        finally {
            this.m_warnings = statementFrame.getWarnings();
            this.m_updateCount = statementFrame.getUpdateCount();
        }
    }

    private StatementFrame getStatement() {
        return this.m_statementStack.getStatement();
    }

    private void startExec() {
        this.m_statementStack.pushFrame();
    }

    private void endExec() throws SQLException {
        this.m_statementStack.popFrame();
    }

    private static void Assert(boolean bl) {
    }

    private static class StatementFrame {
        RTStatement m_stmt = null;
        private int m_updateCount = 0;
        private SQLWarning m_warnings = null;
        private boolean m_executeResult = false;
        private boolean m_holdStmt = false;
        private StatementStack m_lock;
        private boolean m_pendingResults = false;

        StatementFrame(StatementStack statementStack) {
            this.m_lock = statementStack;
        }

        SQLWarning getWarnings() {
            return this.m_warnings;
        }

        int getUpdateCount() {
            return this.m_updateCount;
        }

        void cancel() throws SQLException {
            this.m_stmt.cancel();
        }

        RTStatement getStatement() {
            return this.m_stmt;
        }

        void setStatement(RTStatement rTStatement) {
            this.m_updateCount = -2;
            this.m_warnings = null;
            this.m_holdStmt = false;
            this.m_executeResult = false;
            this.m_stmt = rTStatement;
            this.m_pendingResults = false;
        }

        int executeUpdate() throws SQLException {
            this.m_updateCount = this.m_stmt.executeUpdate();
            return this.m_updateCount;
        }

        RTResultSet executeQuery() throws SQLException {
            RTResultSet rTResultSet = this.m_stmt.executeRTQuery();
            this.m_updateCount = -1;
            return rTResultSet;
        }

        boolean execute() throws SQLException {
            boolean bl = this.m_stmt.execute();
            while (!bl && this.m_stmt.getUpdateCount() != -1) {
                bl = this.m_stmt.getMoreResults();
            }
            this.m_holdStmt = this.m_executeResult = bl;
            this.m_updateCount = -1;
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResultSet getNextResultSet() throws SQLException {
            if (this.m_stmt == null) {
                return null;
            }
            boolean bl = true;
            try {
                if (this.m_executeResult) {
                    this.m_executeResult = false;
                } else {
                    while (!this.m_stmt.getMoreResults()) {
                        if (this.m_stmt.getUpdateCount() != -1) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) {
                    ResultSet resultSet = this.m_stmt.getResultSet();
                    this.m_warnings = this.m_stmt.getWarnings();
                    return resultSet;
                }
            }
            catch (SQLException sQLException) {
                this.m_holdStmt = false;
                try {
                    this.releaseStatement();
                }
                catch (SQLException sQLException2) {
                    sQLException.setNextException(sQLException2);
                }
                finally {
                    throw sQLException;
                }
            }
            this.m_holdStmt = false;
            this.releaseStatement();
            return null;
        }

        void cleanupResults() throws SQLException {
            if (this.m_stmt != null) {
                while (this.getNextResultSet() != null) {
                }
            }
        }

        void releaseStatement() throws SQLException {
            if (!this.m_holdStmt) {
                this.m_pendingResults = false;
                RTStatement rTStatement = this.m_stmt;
                this.m_lock.releaseStatement(this);
                try {
                    this.m_warnings = rTStatement.getWarnings();
                }
                finally {
                    rTStatement.executeComplete();
                }
            } else {
                this.m_pendingResults = true;
                this.m_warnings = this.m_stmt.getWarnings();
            }
        }
    }

    private static class StatementStack {
        private int m_callDepth = 0;
        private Stack m_statementStack = new Stack();
        private StatementFrame m_stmt = new StatementFrame(this);

        private StatementStack() {
        }

        StatementFrame getStatement() {
            return this.m_stmt;
        }

        synchronized void cancelCurrent() throws SQLException {
            if (this.m_stmt.getStatement() != null) {
                this.m_stmt.cancel();
            } else if (!this.m_statementStack.empty()) {
                ((StatementFrame)this.m_statementStack.peek()).cancel();
            }
        }

        synchronized RTStatement setStatement(ConnectedProfile connectedProfile, int n2) throws SQLException {
            if (this.m_statementStack.size() < this.m_callDepth) {
                this.m_statementStack.push(this.m_stmt);
                this.m_stmt = new StatementFrame(this);
            } else {
                this.m_stmt.cleanupResults();
            }
            RTStatement rTStatement = connectedProfile.getStatement(n2);
            this.m_stmt.setStatement(rTStatement);
            return rTStatement;
        }

        void pushFrame() {
            ++this.m_callDepth;
        }

        void popFrame() throws SQLException {
            --this.m_callDepth;
            if (this.m_statementStack.size() > this.m_callDepth) {
                this.doPopFrame();
            }
        }

        private synchronized void doPopFrame() throws SQLException {
            this.m_stmt.cleanupResults();
            this.m_stmt = (StatementFrame)this.m_statementStack.pop();
        }

        synchronized void releaseStatement(StatementFrame statementFrame) {
            statementFrame.m_stmt = null;
        }
    }
}

