/*
 * Decompiled with CFR 0.152.
 */
package sqlj.semantics;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Vector;
import sqlj.framework.JSClass;
import sqlj.framework.JSMethod;
import sqlj.framework.checker.HostItem;
import sqlj.framework.checker.SQLChecker;
import sqlj.framework.checker.SQLOperation;
import sqlj.framework.checker.SQLToken;
import sqlj.framework.checker.SimpleChecker;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.Info;
import sqlj.framework.error.JSError;
import sqlj.framework.error.Warning;
import sqlj.mesg.SemanticErrors;
import sqlj.runtime.profile.SetTransactionDescriptor;
import sqlj.semantics.TypeProperties;
import sqlj.semantics.sql.CheckerOptions;

public class OfflineCheckerBuilder
extends CheckerOptions
implements SQLChecker {
    protected SimpleChecker m_simple_checker;
    private boolean connected_checking;
    public TypeProperties m_tp;
    public TypeProperties m_jdbc_tp;
    protected static final int CALL_OR_VALUES = -88;
    protected static final int VALUES_AS_CALL = -89;
    protected static final int ERRONEOUS = -90;
    protected Vector calledName;
    protected Vector argumentItems;
    private static int PARSE_EMPTY = 984630;
    private static int PARSE_ERROR = -173852;
    private static final String blanks = "                                      ";

    public OfflineCheckerBuilder(SimpleChecker simpleChecker) {
        this(false, new TypeProperties(), simpleChecker);
    }

    public OfflineCheckerBuilder(boolean bl, SimpleChecker simpleChecker) {
        this(bl, new TypeProperties(), simpleChecker);
    }

    public OfflineCheckerBuilder(TypeProperties typeProperties, SimpleChecker simpleChecker) {
        this(false, typeProperties, simpleChecker);
    }

    public OfflineCheckerBuilder(boolean bl, TypeProperties typeProperties, SimpleChecker simpleChecker) {
        this.connected_checking = bl;
        this.m_tp = typeProperties;
        this.m_jdbc_tp = typeProperties.getClass().getName().equals(TypeProperties.class.getName()) ? typeProperties : new TypeProperties();
        this.m_simple_checker = simpleChecker;
    }

    @Override
    public boolean supportsDatabase(ErrorLog errorLog, Connection connection, String string, String string2) {
        return true;
    }

    public static boolean isInternalOperation(int n2) {
        return n2 == -88 || n2 == -89 || n2 == -90;
    }

    private int categorize(ErrorLog errorLog, SQLOperation sQLOperation, TypeProperties typeProperties) {
        int n2 = sQLOperation.getOperationCode();
        this.argumentItems = null;
        this.calledName = null;
        if (n2 != 1023) {
            return n2;
        }
        MiniTokenizer miniTokenizer = new MiniTokenizer(sQLOperation.tokens());
        SQLToken sQLToken = miniTokenizer.nextToken();
        SQLToken sQLToken2 = null;
        if (sQLToken == null) {
            return 3;
        }
        if (sQLToken == null) {
            return 1023;
        }
        String string = sQLToken.tokenText();
        if (string.equalsIgnoreCase("SELECT")) {
            return 2;
        }
        if (string.equalsIgnoreCase("BEGIN") || string.equalsIgnoreCase("DECLARE")) {
            return 9;
        }
        if (string.equalsIgnoreCase("COMMIT")) {
            return 11;
        }
        if (string.equalsIgnoreCase("ROLLBACK")) {
            return 12;
        }
        if (string.equalsIgnoreCase("UPDATE") || string.equalsIgnoreCase("INSERT") || string.equalsIgnoreCase("DELETE")) {
            return 3;
        }
        if (string.equals("{")) {
            string = miniTokenizer.nextTokenText();
            if (string.equalsIgnoreCase("CALL")) {
                this.calledName = this.parseQualifiedName(miniTokenizer);
                if (this.calledName == null) {
                    errorLog.addEntry(new JSError(SemanticErrors.expectedProcedureName(miniTokenizer.nextTokenText())));
                    return -90;
                }
                this.parseArgumentList(errorLog, sQLOperation, miniTokenizer, "}", false);
                return -88;
            }
            if (string.equals("?") && miniTokenizer.nextTokenText().equals("=") && miniTokenizer.nextTokenText().equalsIgnoreCase("CALL")) {
                this.calledName = this.parseQualifiedName(miniTokenizer);
                if (this.calledName == null) {
                    errorLog.addEntry(new JSError(SemanticErrors.expectedFunctionName(miniTokenizer.nextTokenText())));
                    return -90;
                }
                this.parseArgumentList(errorLog, sQLOperation, miniTokenizer, "}", false);
                return -89;
            }
            return 1023;
        }
        if (string.equalsIgnoreCase("VALUE") || string.equalsIgnoreCase("VALUES")) {
            boolean bl = false;
            if (string.equalsIgnoreCase("VALUE")) {
                bl = true;
            }
            this.blankOut(sQLToken, sQLOperation);
            boolean bl2 = false;
            if (miniTokenizer.peekToken() != null && miniTokenizer.peekToken().tokenText().equals("(")) {
                this.blankOut(miniTokenizer.nextToken(), sQLOperation);
                bl2 = true;
            }
            if (!bl2) {
                bl = true;
            }
            this.calledName = this.parseQualifiedName(miniTokenizer);
            if (this.calledName == null) {
                errorLog.addEntry(new JSError(SemanticErrors.expectedFunctionName(miniTokenizer.nextTokenText())));
                return -90;
            }
            if (bl2) {
                this.parseArgumentList(errorLog, sQLOperation, miniTokenizer, ")", true);
            } else {
                this.parseArgumentList(errorLog, sQLOperation, miniTokenizer);
            }
            if (this.getPortable() && bl) {
                errorLog.addEntry(new Warning(SemanticErrors.functionNotInSQLJSyntax()));
            }
            return 5;
        }
        if (string.equalsIgnoreCase("CALL")) {
            this.blankOut(sQLToken, sQLOperation);
            this.calledName = this.parseQualifiedName(miniTokenizer);
            if (this.calledName == null) {
                errorLog.addEntry(new JSError(SemanticErrors.expectedProcedureName(miniTokenizer.nextTokenText())));
                return -90;
            }
            this.parseArgumentList(errorLog, sQLOperation, miniTokenizer);
            return 4;
        }
        if (string.equalsIgnoreCase("SET") && (sQLToken2 = miniTokenizer.peekToken()) != null && sQLToken2.tokenText().equalsIgnoreCase("TRANSACTION")) {
            return this.checkSetTransactionSyntax(miniTokenizer, errorLog, sQLOperation);
        }
        if (sQLToken.tokenType() == 2 && this.m_tp.isVendorKeyword(string)) {
            return 3;
        }
        if (this.m_tp.acceptNonVendorKeyword()) {
            errorLog.addEntry(new Warning("Unrecognized SQL statement: " + string));
            return 3;
        }
        return 1023;
    }

    private void setModes(int n2, SQLOperation sQLOperation) {
        if (n2 == 0) {
            return;
        }
        for (int i2 = 1; i2 <= sQLOperation.hostItemCount(); ++i2) {
            HostItem hostItem = sQLOperation.hostItem(i2);
            if (hostItem.getHostItemMode() != 0) continue;
            hostItem.setHostItemMode(n2);
        }
    }

    private void setINModes(SQLOperation sQLOperation) {
        this.setModes(1, sQLOperation);
    }

    private int checkSetTransactionSyntax(MiniTokenizer miniTokenizer, ErrorLog errorLog, SQLOperation sQLOperation) {
        int n2 = 3;
        int n3 = 0;
        miniTokenizer.nextToken();
        int n4 = this.checkReadSyntax(miniTokenizer, errorLog);
        if (n4 == PARSE_ERROR) {
            return 3;
        }
        if (n4 != PARSE_EMPTY) {
            n2 = n4;
            if (miniTokenizer.peekTokenText().equals(",")) {
                miniTokenizer.nextToken();
            }
        }
        if ((n4 = this.checkIsolationSyntax(miniTokenizer, errorLog)) == PARSE_ERROR) {
            return 3;
        }
        if (n4 != PARSE_EMPTY) {
            n3 = n4;
            if (miniTokenizer.peekTokenText().equals(",")) {
                miniTokenizer.nextToken();
            }
        }
        if (n2 == 3) {
            n4 = this.checkReadSyntax(miniTokenizer, errorLog);
            if (n4 == PARSE_ERROR) {
                return 3;
            }
            if (n4 != PARSE_EMPTY) {
                n2 = n4;
            }
        }
        if (!this.checkEndSyntax(miniTokenizer, errorLog)) {
            return 3;
        }
        if (n2 == 3 && n3 == 0) {
            this.transactionSyntaxWarning(errorLog);
            return 3;
        }
        sQLOperation.setDescriptor(new SetTransactionDescriptor(n2, n3));
        return 17;
    }

    private void transactionSyntaxWarning(ErrorLog errorLog) {
        this.transactionSyntaxWarning(errorLog, null);
    }

    private void transactionSyntaxWarning(ErrorLog errorLog, SQLToken sQLToken) {
        if (sQLToken == null) {
            errorLog.addEntry(new Warning(SemanticErrors.unrecognizedSetTransactionSyntax()));
        } else {
            errorLog.addEntry(new Warning(SemanticErrors.unrecognizedSetTransactionSyntax(sQLToken.tokenText())));
        }
    }

    private int checkReadSyntax(MiniTokenizer miniTokenizer, ErrorLog errorLog) {
        if (miniTokenizer.peekTokenText().equalsIgnoreCase("READ")) {
            miniTokenizer.nextToken();
            String string = miniTokenizer.nextTokenText();
            if (string.equalsIgnoreCase("ONLY")) {
                return 1;
            }
            if (string.equalsIgnoreCase("WRITE")) {
                return 2;
            }
            this.transactionSyntaxWarning(errorLog, miniTokenizer.lastToken());
            return PARSE_ERROR;
        }
        return PARSE_EMPTY;
    }

    private int checkIsolationSyntax(MiniTokenizer miniTokenizer, ErrorLog errorLog) {
        if (miniTokenizer.peekTokenText().equalsIgnoreCase("ISOLATION")) {
            miniTokenizer.nextToken();
            String string = miniTokenizer.nextTokenText();
            if (!string.equalsIgnoreCase("LEVEL")) {
                this.transactionSyntaxWarning(errorLog, miniTokenizer.lastToken());
                return PARSE_ERROR;
            }
            string = miniTokenizer.nextTokenText();
            if (string.equalsIgnoreCase("SERIALIZABLE")) {
                return 8;
            }
            if (string.equalsIgnoreCase("READ")) {
                string = miniTokenizer.nextTokenText();
                if (string.equalsIgnoreCase("COMMITTED")) {
                    return 2;
                }
                if (string.equalsIgnoreCase("UNCOMMITTED")) {
                    return 1;
                }
                this.transactionSyntaxWarning(errorLog, miniTokenizer.lastToken());
                return PARSE_ERROR;
            }
            if (string.equalsIgnoreCase("REPEATABLE") && (string = miniTokenizer.nextTokenText()).equalsIgnoreCase("READ")) {
                return 4;
            }
            this.transactionSyntaxWarning(errorLog, miniTokenizer.lastToken());
            return PARSE_ERROR;
        }
        return PARSE_EMPTY;
    }

    private boolean checkEndSyntax(MiniTokenizer miniTokenizer, ErrorLog errorLog) {
        SQLToken sQLToken = null;
        sQLToken = miniTokenizer.peekToken();
        if (sQLToken == null) {
            return true;
        }
        if (sQLToken.tokenText().equals(";")) {
            miniTokenizer.nextToken();
            sQLToken = miniTokenizer.peekToken();
            if (sQLToken == null) {
                return true;
            }
            this.transactionSyntaxWarning(errorLog, sQLToken);
            return false;
        }
        this.transactionSyntaxWarning(errorLog, sQLToken);
        return false;
    }

    @Override
    public void describeSQLOperation(ErrorLog errorLog, Connection connection, SQLOperation sQLOperation) {
        if (sQLOperation == null) {
            throw new IllegalArgumentException("SQLChecker.describeSQLOperation(): SQLOperation is null");
        }
        this.m_tp.setErrorLog(errorLog);
        this.m_jdbc_tp.setErrorLog(errorLog);
        if (sQLOperation.getOperationCode() == 1023) {
            sQLOperation.setOperationCode(this.categorize(errorLog, sQLOperation, this.m_tp));
        } else {
            errorLog.addEntry(new JSError(SemanticErrors.internalError("OfflineChecker")));
        }
        int n2 = sQLOperation.getOperationCode();
        boolean bl = this.checkUnknownModes(sQLOperation);
        if (n2 == 2) {
            JSClass jSClass = sQLOperation.getResultType();
            if (jSClass != null && jSClass != TypeProperties.Invalid_TYPE) {
                if (!this.m_tp.isCursorType(jSClass)) {
                    errorLog.addEntry(new JSError(SemanticErrors.returnTypeNotACursor(this.m_tp.printJavaType(jSClass))));
                } else {
                    this.checkTypeAccessibility(errorLog, jSClass);
                }
            }
            if (bl) {
                this.setINModes(sQLOperation);
            }
        } else if (n2 == 11 || n2 == 12 || n2 == 3) {
            if (bl) {
                this.setINModes(sQLOperation);
            }
        } else if (n2 == 9) {
            int n3 = this.getDefaultBlockMode();
            if (n3 == 0) {
                if (!this.connected_checking && bl) {
                    errorLog.addEntry(new JSError(SemanticErrors.needConnectionForBlock()));
                }
            } else {
                this.setModes(n3, sQLOperation);
            }
        } else if (n2 == 4 || n2 == -88 || n2 == 5 || n2 == -89) {
            if (sQLOperation.getResultType() != null && sQLOperation.getResultType() != TypeProperties.Invalid_TYPE) {
                JSClass jSClass = sQLOperation.getResultType();
                if (!JSClass.ResultSet_TYPE.hasAccessTo(jSClass)) {
                    errorLog.addEntry(new JSError(SemanticErrors.returnNotVisible(this.m_tp.printJavaType(jSClass))));
                }
                if (this.m_tp.isHostItemOutType(jSClass)) {
                    if (this.getPortable() && !this.m_jdbc_tp.isHostItemOutType(jSClass)) {
                        errorLog.addEntry(new Warning(SemanticErrors.returnNotJdbc(this.m_tp.printJavaType(jSClass))));
                    }
                } else if (jSClass.isPrimitive() || this.m_jdbc_tp != this.m_tp) {
                    errorLog.addEntry(new JSError(SemanticErrors.returnNotValid(this.m_tp.printJavaType(jSClass))));
                } else if (this.getPortable()) {
                    errorLog.addEntry(new Warning(SemanticErrors.returnNotJdbc(this.m_tp.printJavaType(jSClass))));
                }
            }
            if (n2 == -88) {
                n2 = sQLOperation.getResultType() == null ? 4 : 5;
                sQLOperation.setOperationCode(n2);
            }
            int n4 = n2 == 5 || n2 == -89 ? this.getDefaultFunctionMode() : this.getDefaultProcedureMode();
            this.checkModeConsistencyWithDefault(errorLog, sQLOperation, n4);
            if (!this.connected_checking && this.checkUnknownModes(sQLOperation)) {
                errorLog.addEntry(new JSError(SemanticErrors.needConnectionForProcedure()));
            }
            if (!this.connected_checking && (n2 != 4 && n2 != -89 || sQLOperation.getResultType() == null) && n2 == 5 && sQLOperation.getResultType() == null) {
                errorLog.addEntry(new JSError(SemanticErrors.needValueFromFunction()));
            }
            if (!(n2 != 4 && n2 != -89 || sQLOperation.getResultType() == null || this.m_tp.isCursorType(sQLOperation.getResultType()))) {
                errorLog.addEntry(new JSError(SemanticErrors.noValueFromProcedure()));
            }
        } else if (!bl || !this.connected_checking) {
            // empty if block
        }
        if (!this.connected_checking) {
            this.performParse(null, sQLOperation, errorLog);
        }
    }

    protected void performParse(Connection connection, SQLOperation sQLOperation, ErrorLog errorLog) {
        short[] sArray = new short[sQLOperation.hostItemCount()];
        String[] stringArray = new String[sQLOperation.hostItemCount()];
        for (int i2 = 0; i2 < sQLOperation.hostItemCount(); ++i2) {
            JSClass jSClass = sQLOperation.hostItem(i2 + 1).getHostItemType();
            try {
                sArray[i2] = this.m_tp.getCompatibleSQLTypeCode(jSClass);
                stringArray[i2] = this.m_tp.getCompatibleSQLTypeName(jSClass, sArray[i2]);
                continue;
            }
            catch (Exception exception) {
                sArray[i2] = 1111;
                stringArray[i2] = null;
            }
        }
        this.m_simple_checker.parse(errorLog, connection, sQLOperation, sArray);
    }

    private boolean checkUnknownModes(SQLOperation sQLOperation) {
        boolean bl = false;
        for (int i2 = 1; i2 <= sQLOperation.hostItemCount(); ++i2) {
            if (sQLOperation.hostItem(i2).getHostItemMode() != 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private Vector parseQualifiedName(MiniTokenizer miniTokenizer) {
        Vector<SQLToken> vector = new Vector<SQLToken>(5);
        SQLToken sQLToken = miniTokenizer.nextToken();
        while (sQLToken != null && sQLToken.tokenType() == 2) {
            vector.addElement(sQLToken);
            sQLToken = miniTokenizer.nextToken();
            if (sQLToken == null || !sQLToken.tokenText().equals(".")) break;
            vector.addElement(sQLToken);
            sQLToken = miniTokenizer.nextToken();
        }
        if (sQLToken != null) {
            miniTokenizer.pushToken(sQLToken);
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    private void parseArgumentList(ErrorLog errorLog, SQLOperation sQLOperation, MiniTokenizer miniTokenizer) {
        this.parseArgumentList(errorLog, sQLOperation, miniTokenizer, null, false);
    }

    private void parseArgumentList(ErrorLog errorLog, SQLOperation sQLOperation, MiniTokenizer miniTokenizer, String string, boolean bl) {
        this.argumentItems = new Vector();
        SQLToken sQLToken = miniTokenizer.nextToken();
        if (sQLToken == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        if (sQLToken.tokenText().equals("(")) {
            ++n2;
            boolean bl2 = true;
            sQLToken = miniTokenizer.nextToken();
            if (sQLToken == null) {
                errorLog.addEntry(new JSError(SemanticErrors.missingParenOnArgs()));
                return;
            }
            String string2 = sQLToken.tokenText();
            int n4 = sQLToken.tokenPosition();
            int n5 = 0;
            boolean bl3 = false;
            while (n2 > 0 && sQLToken != null && !string2.equals("")) {
                if (string2.equals("(")) {
                    ++n2;
                } else if (string2.equals(")")) {
                    --n2;
                } else if (string2.equals("?")) {
                    ++n5;
                    ++n3;
                } else if (!string2.equals(",")) {
                    bl3 = true;
                }
                int n6 = sQLToken.tokenPosition() - 1;
                sQLToken = miniTokenizer.nextToken();
                if (n2 == 1 && string2.equals(",") || n2 == 0 && string2.equals(")")) {
                    boolean bl4 = n5 == 1 && !bl3;
                    this.argumentItems.addElement(new ArgumentItem(n4, n6, n5, bl4, n3 - n5 + 1));
                    if (string2.equals(")")) break;
                    if (sQLToken != null) {
                        n4 = sQLToken.tokenPosition();
                    }
                    n5 = 0;
                    bl3 = false;
                }
                if (sQLToken == null) continue;
                string2 = sQLToken.tokenText();
            }
        }
        if (n2 > 0) {
            errorLog.addEntry(new JSError(SemanticErrors.missingParenOnArgs()));
        } else {
            if (sQLToken != null && sQLToken.tokenText().equals(";")) {
                errorLog.addEntry(new JSError(SemanticErrors.noSemicolonAfterArgs()));
                sQLToken = miniTokenizer.nextToken();
            }
            if (sQLToken != null) {
                if (string != null) {
                    if (!sQLToken.tokenText().equals(string)) {
                        errorLog.addEntry(new JSError(SemanticErrors.unexpectedTerminatingToken(string, sQLToken.tokenText())));
                    } else {
                        if (bl) {
                            this.blankOut(sQLToken, sQLOperation);
                        }
                        if ((sQLToken = miniTokenizer.nextToken()) != null) {
                            errorLog.addEntry(new JSError(SemanticErrors.noCodeAfterArgs(sQLToken.tokenText())));
                        }
                    }
                } else {
                    errorLog.addEntry(new JSError(SemanticErrors.noCodeAfterArgs(sQLToken.tokenText())));
                }
            } else if (string != null) {
                errorLog.addEntry(new JSError(SemanticErrors.missingTerminating(string)));
            }
        }
    }

    private void blankOut(Vector vector, SQLOperation sQLOperation) {
        if (vector.size() > 0) {
            String string = sQLOperation.getSQLString();
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                SQLToken sQLToken = (SQLToken)vector.elementAt(i2);
                int n2 = sQLToken.tokenPosition();
                int n3 = sQLToken.tokenText().length();
                string = string.substring(0, n2) + blanks.substring(0, n3) + string.substring(n2 + n3);
            }
            sQLOperation.setSQLString(string);
        }
    }

    private void blankOut(SQLToken sQLToken, SQLOperation sQLOperation) {
        String string = sQLOperation.getSQLString();
        int n2 = sQLToken.tokenPosition();
        int n3 = sQLToken.tokenText().length();
        string = string.substring(0, n2) + blanks.substring(0, n3) + string.substring(n2 + n3);
        sQLOperation.setSQLString(string);
    }

    private void checkModeConsistencyWithDefault(ErrorLog errorLog, SQLOperation sQLOperation, int n2) {
        int n3 = 0;
        if (this.argumentItems == null) {
            return;
        }
        Enumeration enumeration = this.argumentItems.elements();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            ArgumentItem argumentItem = (ArgumentItem)enumeration.nextElement();
            ++n4;
            for (int i2 = 1; i2 <= argumentItem.hostItemCount(); ++i2) {
                HostItem hostItem;
                int n5;
                if ((n5 = (hostItem = sQLOperation.hostItem(++n3)).getHostItemMode()) == 0) {
                    if (!argumentItem.isSolitary()) {
                        hostItem.setHostItemMode(1);
                        if (!this.getVerbose()) continue;
                        errorLog.addEntry(new Info(SemanticErrors.assumeInMode(n3, hostItem.getHostItemName())));
                        continue;
                    }
                    if (n2 == 0) continue;
                    hostItem.setHostItemMode(n2);
                    continue;
                }
                if (n5 != 4 && n5 != 2 || argumentItem.isSolitary()) continue;
                errorLog.addEntry(new JSError(SemanticErrors.outModeInvalid(n3, hostItem.getHostItemName())));
            }
        }
    }

    private void checkTypeAccessibility(ErrorLog errorLog, JSClass jSClass) {
        boolean bl = JSClass.NamedIterator_TYPE.isAssignableFrom(jSClass);
        boolean bl2 = jSClass.toString().equals("dummy*Iterator");
        JSMethod[] jSMethodArray = jSClass.getDeclaredMethods();
        for (int i2 = 0; i2 < jSMethodArray.length; ++i2) {
            String string = jSMethodArray[i2].getName();
            if (string == null || string.equals("close") || string.equals("next") || string.equals("getResultSet") || string.equals("isClosed") || string.equals("endFetch")) continue;
            int n2 = jSMethodArray[i2].getParameterTypes().length;
            JSClass jSClass2 = jSMethodArray[i2].getReturnType();
            if (n2 != 0 || JSClass.ResultSet_TYPE.hasAccessTo(jSClass2)) continue;
            if (!bl) {
                string = "#" + string.substring(6);
            }
            String string2 = bl2 ? SemanticErrors.inaccessibleJavaTypeForIntoItem(this.m_tp.printJavaType(jSClass2), string) : SemanticErrors.inaccessibleJavaTypeForColumn(this.m_tp.printJavaType(jSClass2), string);
            errorLog.addEntry(new JSError(string2));
        }
    }

    class ArgumentItem {
        private int m_start;
        private int m_end;
        private int m_host_item_count;
        private int m_first_host_item;
        private boolean m_is_solitary;

        ArgumentItem(int n2, int n3, int n4, boolean bl, int n5) {
            this.m_start = n2;
            this.m_end = n3;
            this.m_host_item_count = n4;
            this.m_is_solitary = bl;
            this.m_first_host_item = n4 == 0 ? 0 : n5;
        }

        int getStartPos() {
            return this.m_start;
        }

        int getEndPos() {
            return this.m_end;
        }

        int hostItemCount() {
            return this.m_host_item_count;
        }

        boolean isSolitary() {
            return this.m_is_solitary;
        }

        int getFirstHostItem() {
            return this.m_first_host_item;
        }
    }

    protected class MiniTokenizer {
        private Enumeration m_enum;
        private Vector m_pushback;
        private int m_pushed;
        private SQLToken m_last;

        MiniTokenizer(Enumeration enumeration) {
            this.m_enum = enumeration;
            this.m_pushback = new Vector(10);
            this.m_pushed = 0;
            this.m_last = null;
        }

        protected SQLToken nextToken() {
            if (this.m_pushed > 0) {
                --this.m_pushed;
                this.m_last = (SQLToken)this.m_pushback.elementAt(this.m_pushed);
                return this.m_last;
            }
            SQLToken sQLToken = null;
            while (this.m_enum.hasMoreElements() && (sQLToken = (SQLToken)this.m_enum.nextElement()) != null && sQLToken.tokenType() == 1) {
                sQLToken = null;
            }
            this.m_last = sQLToken;
            return sQLToken;
        }

        protected String nextTokenText() {
            SQLToken sQLToken = this.nextToken();
            if (sQLToken == null) {
                return "";
            }
            return sQLToken.tokenText();
        }

        protected SQLToken lastToken() {
            return this.m_last;
        }

        protected String peekTokenText() {
            SQLToken sQLToken = this.peekToken();
            if (sQLToken == null) {
                return "";
            }
            return sQLToken.tokenText();
        }

        protected void pushToken(SQLToken sQLToken) {
            if (this.m_pushed >= this.m_pushback.size()) {
                this.m_pushback.addElement(sQLToken);
            } else {
                this.m_pushback.setElementAt(sQLToken, this.m_pushed);
            }
            ++this.m_pushed;
        }

        protected SQLToken peekToken() {
            if (this.m_pushed > 0) {
                return (SQLToken)this.m_pushback.elementAt(this.m_pushed - 1);
            }
            SQLToken sQLToken = this.nextToken();
            if (sQLToken != null) {
                this.pushToken(sQLToken);
            }
            return sQLToken;
        }
    }
}

