/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.asf.IfxDataInputStream;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxFloat;
import com.gbasedbt.jdbc.IfxSmallFloat;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.lang.IfxToJavaType;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

abstract class IfxSQLInput
implements SQLInput {
    protected IfxConnection conn;
    ByteArrayInputStream a;
    IfxDataInputStream b;
    private Map c;
    protected boolean isNull = false;
    protected byte[] buf = null;
    protected int totalLength;
    protected int unreadLength;
    protected int currentPos = 0;
    private int d = 0;
    protected Trace trace = null;

    IfxSQLInput(IfxConnection ifxConnection, byte[] byArray, int n2, int n3) throws SQLException {
        this.a(ifxConnection);
        this.a = new ByteArrayInputStream(byArray, n2, n3);
        this.b = new IfxDataInputStream(this.a);
        if (ifxConnection != null) {
            this.b.setClientLocale(ifxConnection.getclLocale());
        }
        this.unreadLength = this.totalLength = n3;
        this.buf = byArray;
        this.d = n2;
    }

    void a(IfxConnection ifxConnection) throws SQLException {
        block8: {
            block9: {
                this.conn = ifxConnection;
                if (!TraceFlag.compiletrace) break block8;
                if (ifxConnection != null) break block9;
                System.out.println("IfxComplexInput() connection is null");
                if (!IfxSqliConnect.b5) break block8;
            }
            this.trace = ifxConnection.getTrace();
            if (this.trace != null) break block8;
            throw IfxErrMsg.getSQLException(-79716, ifxConnection);
        }
    }

    void a(Map map) {
        this.c = map;
    }

    byte[] a() throws SQLException {
        byte[] byArray = new byte[this.totalLength];
        System.arraycopy(this.buf, this.d, byArray, 0, this.totalLength);
        return byArray;
    }

    protected void skipBytes(int n2) throws SQLException {
        try {
            this.b.skipBytes(n2);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    protected int currentPosition() {
        return this.totalLength - this.a.available();
    }

    public int length() {
        return this.totalLength;
    }

    protected int available() {
        return this.a.available();
    }

    protected void reset() {
        this.a.reset();
        this.currentPos = 0;
    }

    protected void checkLength(int n2) throws SQLException {
        if (this.unreadLength < n2) {
            throw IfxErrMsg.getSQLException(-79772, this.conn);
        }
        this.unreadLength -= n2;
    }

    @Override
    public String readString() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readString().", this.conn);
    }

    @Override
    public boolean readBoolean() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBoolean().", this.conn);
    }

    @Override
    public byte readByte() throws SQLException {
        return (byte)this.readShort();
    }

    @Override
    public short readShort() throws SQLException {
        this.checkLength(2);
        this.isNull = false;
        try {
            short s2 = this.b.readShort();
            if (s2 == Short.MIN_VALUE) {
                this.isNull = true;
                s2 = 0;
            }
            this.currentPos += 2;
            return s2;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public int readInt() throws SQLException {
        this.checkLength(4);
        this.isNull = false;
        try {
            int n2 = this.b.readInt();
            if (n2 == Integer.MIN_VALUE) {
                this.isNull = true;
                n2 = 0;
            }
            this.currentPos += 4;
            return n2;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public long readLong() throws SQLException {
        this.checkLength(10);
        this.isNull = false;
        try {
            long l2 = this.b.readLongInt();
            if (l2 == Long.MIN_VALUE) {
                this.isNull = true;
                l2 = 0L;
            }
            this.currentPos += 10;
            return l2;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public long readLongBigint() throws SQLException {
        this.checkLength(8);
        this.isNull = false;
        try {
            long l2 = this.b.readLongBigint();
            if (l2 == Long.MIN_VALUE) {
                this.isNull = true;
                l2 = 0L;
            }
            this.currentPos += 8;
            return l2;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public float readFloat() throws SQLException {
        this.checkLength(4);
        byte[] byArray = new byte[4];
        this.isNull = true;
        try {
            this.a.read(byArray, 0, 4);
            this.currentPos += 4;
            this.isNull = IfxSmallFloat.a(byArray);
            if (this.isNull) {
                return 0.0f;
            }
            return IfxToJavaType.IfxToJavaReal(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public double readDouble() throws SQLException {
        this.checkLength(8);
        byte[] byArray = new byte[8];
        this.isNull = true;
        try {
            this.a.read(byArray, 0, 8);
            this.isNull = IfxFloat.a(byArray);
            if (this.isNull) {
                return 0.0;
            }
            return IfxToJavaType.IfxToJavaDouble(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBigDecimal().", this.conn);
    }

    @Override
    public byte[] readBytes() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBytes().", this.conn);
    }

    public byte[] readBytes(int n2) throws SQLException {
        byte[] byArray;
        if (this.unreadLength < n2) {
            n2 = this.unreadLength;
        }
        this.checkLength(n2);
        try {
            byArray = new byte[n2];
            this.b.readFully(byArray, 0, n2);
            this.currentPos += n2;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        return byArray;
    }

    @Override
    public Date readDate() throws SQLException {
        this.checkLength(4);
        try {
            Date date = this.b.readDate();
            this.currentPos += 4;
            if (date == null) {
                this.isNull = true;
                return null;
            }
            return date;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public Time readTime() throws SQLException {
        try {
            Timestamp timestamp = this.readTimestamp();
            if (timestamp == null) {
                this.isNull = true;
                return null;
            }
            return new Time(timestamp.getTime());
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readTimestamp().", this.conn);
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readCharacterStream().", this.conn);
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readAsciiStream().", this.conn);
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBinaryStream().", this.conn);
    }

    @Override
    public Object readObject() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readObject().", this.conn);
    }

    @Override
    public Ref readRef() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readRef().", this.conn);
    }

    @Override
    public Blob readBlob() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBlob().", this.conn);
    }

    @Override
    public Clob readClob() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readClob().", this.conn);
    }

    @Override
    public Array readArray() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readArray().", this.conn);
    }

    @Override
    public boolean wasNull() {
        return this.isNull;
    }
}

