/*
 * Decompiled with CFR 0.152.
 */
package sqlj.codegen;

import sqlj.codegen.CursorJSClass;
import sqlj.codegen.IntoGroup;
import sqlj.codegen.TempDecl;
import sqlj.codegen.TypedExpression;
import sqlj.codegen.engine.AssignmentStatement;
import sqlj.codegen.engine.ChainedExpression;
import sqlj.codegen.engine.IfStatement;
import sqlj.codegen.engine.ObjectExpression;
import sqlj.codegen.engine.StatementBlock;
import sqlj.codegen.engine.StatementGroup;
import sqlj.framework.JSClass;

class FetchIntoStmt
extends StatementBlock {
    private FetchIntoGroup m_intoGroup;
    private StatementGroup m_temps = new StatementGroup();

    public static boolean isFetchExpression(TypedExpression typedExpression) {
        JSClass jSClass = typedExpression.getJSClass();
        return JSClass.PositionedIterator_TYPE.isAssignableFrom(jSClass);
    }

    public FetchIntoStmt(TypedExpression typedExpression) {
        this.addStatement(this.m_temps);
        TempDecl tempDecl = typedExpression.declareTemps("iter", 1);
        this.addTempDecl(tempDecl);
        typedExpression = tempDecl.getRValExpr();
        this.m_intoGroup = new FetchIntoGroup(typedExpression, this);
        JSClass jSClass = typedExpression.getJSClass();
        if (!JSClass.PositionedIterator_TYPE.isAssignableFrom(jSClass)) {
            throw new IllegalArgumentException("cursorExpr is not of expected type");
        }
        ChainedExpression chainedExpression = new ChainedExpression(typedExpression);
        chainedExpression.addExpression(new ObjectExpression("next()"));
        StatementBlock statementBlock = new StatementBlock();
        statementBlock.addStatement(this.m_intoGroup);
        this.addStatement(new IfStatement(chainedExpression, statementBlock));
    }

    void addTempDecl(TempDecl tempDecl) {
        this.m_temps.addStatement(tempDecl);
    }

    public IntoGroup getIntoGroup() {
        return this.m_intoGroup;
    }

    private static class FetchIntoGroup
    extends StatementGroup
    implements IntoGroup {
        private TypedExpression m_iterator;
        private int m_count;
        private FetchIntoStmt m_tempLocation;

        public FetchIntoGroup(TypedExpression typedExpression, FetchIntoStmt fetchIntoStmt) {
            this.m_iterator = typedExpression;
            this.m_count = 1;
            this.m_tempLocation = fetchIntoStmt;
        }

        @Override
        public void addIntoVar(TypedExpression typedExpression) {
            TempDecl tempDecl = typedExpression.declareTemps(this.m_count + "", 4);
            this.m_tempLocation.addTempDecl(tempDecl);
            typedExpression = tempDecl.getLValExpr();
            ChainedExpression chainedExpression = new ChainedExpression(this.m_iterator);
            chainedExpression.addExpression(new ObjectExpression(CursorJSClass.getColumnAccessName(this.m_count++) + "()"));
            this.addStatement(new AssignmentStatement(typedExpression, chainedExpression));
        }
    }
}

